//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ C3D Class Library - C3D.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ Main Header File ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#ifndef C3D_H
#define C3D_H

#define D3D_OVERLOADS

#include <stdio.h>
#include <ddraw.h>
#include <d3d.h>

//////////////////////////////////////////////////////////////////////////////////
// Definied Types
//////////////////////////////////////////////////////////////////////////////////
#define RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }
#define SAFEDELETE(x) if(x != NULL) { delete x; x = NULL; }

class C3D_Vertex;

//////////////////////////////////////////////////////////////////////////////////
// C3D_Matrix class
//////////////////////////////////////////////////////////////////////////////////
class C3D_Matrix : public D3DMATRIX
{
public:
	C3D_Matrix(void);

	C3D_Matrix operator = (const C3D_Matrix&);
	C3D_Matrix operator + (const C3D_Matrix&);
	C3D_Matrix operator - (const C3D_Matrix&);

	void Zero(void);
	void Identity(void);
	void Translate(float x, float y, float z);
	void Scale(float x, float y, float z);
	void Scale(float scale);
	void RotateX(float x);
	void RotateY(float y);
	void RotateZ(float z);
	void Print(void);

	void SetView(D3DVECTOR, D3DVECTOR, D3DVECTOR, float);
	void SetProjection(float near, float far, float fov);
};

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector Class
//////////////////////////////////////////////////////////////////////////////////
class C3D_Vector : public D3DVECTOR
{
public:
	C3D_Vector(void);
	C3D_Vector(float);
	C3D_Vector(float, float, float);
	C3D_Vector(C3D_Vector*);

	C3D_Vector& operator = (const C3D_Vector&);
	C3D_Vector& operator = (const D3DVECTOR&);
	C3D_Vector& operator + (const C3D_Vector&);
	C3D_Vector& operator + (const C3D_Vertex&);
	C3D_Vector& operator - (const C3D_Vector&);

	void Normalize(void);
	void Normal(C3D_Vertex*, C3D_Vertex*, C3D_Vertex*);
	void CrossProduct(C3D_Vector*, C3D_Vector*);
	float DotProduct(C3D_Vector*, C3D_Vector*);

	void Locate(float, float, float);
	void Print(void);

	void SetX(float _x) { x = _x; }
	void SetY(float _y) { y = _y; }
	void SetZ(float _z) { z = _z; }

	float GetX() { return x; }
	float GetY() { return y; }
	float GetZ() { return z; }
};

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex Class
//////////////////////////////////////////////////////////////////////////////////
class C3D_Vertex : public D3DLVERTEX
{
public:
	C3D_Vertex(void);
	C3D_Vertex(float x, float y, float z);
	C3D_Vertex(float x, float y, float z, DWORD color, DWORD specular);
	C3D_Vertex(float x, float y, float z, DWORD color, DWORD specular, float tu, float tv);
	C3D_Vertex(C3D_Vertex* vertex);

	C3D_Vertex& operator = (const C3D_Vertex&);
	C3D_Vertex& operator + (const C3D_Vertex&);
	C3D_Vertex& operator + (const C3D_Vector&);
	C3D_Vertex& operator - (const C3D_Vertex&);

	void Locate(float x, float y, float z);
	void Transform(C3D_Matrix* matrix);
	void Print(void);

	void SetX(float _x) { x = _x; }
	void SetY(float _y) { y = _y; }
	void SetZ(float _z) { z = _z; }
	void SetU(float _tu) { tu = _tu; }
	void SetV(float _tv) { tv = _tv; }
	void SetColor(DWORD c) { color = c; }
	void SetSpecular(DWORD s) { specular = s; }

	float GetX() { return x; }
	float GetY() { return y; }
	float GetZ() { return z; }
	float GetU() { return tu; }
	float GetV() { return tv; }
	DWORD GetColor() { return color; }
	DWORD GetSpecular() { return specular; }
};

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh Class
//////////////////////////////////////////////////////////////////////////////////
class C3D_Mesh
{
public:
	C3D_Mesh(void);
	~C3D_Mesh(void);

	void CreateCube(float w, float h, float d);
	void CreateSphere(void);
	void CreateTerrain(void);

	void SetPosition(float x, float y, float z);
	void SetHeading(float x, float y, float z);

	void SetRoll(float roll) { m_Roll = roll; }
	void SetPitch(float pitch) { m_Pitch = pitch; }
	void SetYaw(float yaw) { m_Yaw = yaw; }

public:
	C3D_Vertex m_Position;
	C3D_Vertex m_Heading;
	C3D_Matrix m_Transform;

	float m_Roll;
	float m_Pitch;
	float m_Yaw;

	int m_VertexCount;
	int m_IndexCount;
	WORD* m_Indices;
	C3D_Vertex* m_Vertices;
};

#endif