//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ C3D Class Library - C3D.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ C3D_Vector Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "C3D.h"
#include <math.h>

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector::C3D_Vector(void)
{
	x = y = z = 0.0f;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector::C3D_Vector(float f)
{
	x = y = z = f;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector::C3D_Vector(float _x, float _y, float _z)
{
	x = _x;
	y = _y;
	z = _z;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector copy constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector::C3D_Vector(C3D_Vector* v)
{
	x = v->x;
	y = v->y;
	z = v->z;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector = operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector &C3D_Vector::operator = (const C3D_Vector &vector)
{
	x = vector.x;
	y = vector.y;
	z = vector.z;

	return *this;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector = operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector &C3D_Vector::operator = (const D3DVECTOR &vector)
{
	x = vector.x;
	y = vector.y;
	z = vector.z;

	return *this;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector + operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector &C3D_Vector::operator + (const C3D_Vector &vector)
{
	return C3D_Vector(x + vector.x, y + vector.y, z + vector.z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector + operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector &C3D_Vector::operator + (const C3D_Vertex &vertex)
{
	return C3D_Vector(x + vertex.x, y + vertex.y, z + vertex.z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector - operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vector &C3D_Vector::operator - (const C3D_Vector &vector)
{
	return C3D_Vector(x - vector.x, y - vector.y, z - vector.z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector Normalize
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vector::Normalize(void)
{
	float d = sqrt(DotProduct(this, this));
	x = x/d;
	y = y/d;
	z = z/d;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector Normal
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vector::Normal(C3D_Vertex* a, C3D_Vertex* b, C3D_Vertex* c)
{
	C3D_Vector v1, v2;

	v1.x = b->x - a->x; v1.y = b->y - a->y; v1.z = b->z - a->z;
	v2.x = c->x - a->x; v2.y = c->y - a->y; v2.z = c->z - a->z;
	CrossProduct(&v1, &v2);
	Normalize();
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector CrossProduct
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vector::CrossProduct(C3D_Vector* a, C3D_Vector* b)
{
	x = a->y * b->z - a->z * b->y;
	y = a->z * b->x - a->x * b->z;
	z = a->x * b->y - a->y * b->x;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector DotProduct
//////////////////////////////////////////////////////////////////////////////////
float C3D_Vector::DotProduct(C3D_Vector* a, C3D_Vector* b)
{
	return(a->x * b->x + a->y * b->y + a->z * b->z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector Locate
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vector::Locate(float _x, float _y, float _z)
{
	x = _x;
	y = _y;
	z = _z;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vector Print
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vector::Print(void)
{
	printf("x = %.5f, y = %.5f, z = %.5f\n", x, y, z);
}
