//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDX Class Library - CDX.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ Main Header File ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDX_H
#define CDX_H

#include <stdio.h>
#include <ddraw.h>
#include <d3d.h>

//////////////////////////////////////////////////////////////////////////////////
// Definied Types
//////////////////////////////////////////////////////////////////////////////////

#define SAFE_RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }
#define SAFE_DELETE(x) if(x != NULL) { delete x; x = NULL; }

#define CDXCREATE_FULLSCREEN   0x00000001L
#define CDXCREATE_NO_FPUSETUP  0x00000002L
#define CDXCREATE_ZBUFFER      0x00000004L
#define CDXCREATE_3D           0x00000008L
//////////////////////////////////////////////////////////////////////////////////////
// Globals
//////////////////////////////////////////////////////////////////////////////////

extern "C"
{
	// CDX Functions
	
	extern IDirectDrawPalette  *DDLoadPalette(IDirectDraw4 *pdd, LPCSTR szBitmap);
	extern IDirectDrawSurface4 *DDLoadBitmap(IDirectDraw4 *pdd, LPCSTR szBitmap, int dx, int dy);
	extern IDirectDrawSurface4 *DDLoadSizeBitmap(IDirectDraw4 * pdd, LPCSTR szBitmap, int *dx, int *dy);
	extern HRESULT              DDReLoadBitmap(IDirectDrawSurface4 *pdds, LPCSTR szBitmap);
	extern HRESULT              DDCopyBitmap(IDirectDrawSurface4 *pdds, HBITMAP hbm, int x, int y, int dx, int dy);
	extern DWORD                DDColorMatch(IDirectDrawSurface4 *pdds, COLORREF rgb);
	extern HRESULT              DDSetColorKey(IDirectDrawSurface4 *pdds, COLORREF rgb);

	extern void Clip(int *DestX, int *DestY, RECT *SrcRect, RECT *DestRect);
	extern void DDError(HRESULT hErr, HWND hWnd);
//	extern void DSError(HRESULT hErr, HWND hWnd);
}


//////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////

class CDXSurface;
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////add class ///////////////////////////////
////////////////////////////////////////////////////////////////////////////////
enum {
    OM_DUMMY,
    OM_CREATE,
    OM_PAINT,
    OM_KEYDOWN,
    OM_KEYPRESSED,
    OM_KEYUP,
    OM_TIMER,
    OM_DESTROY,
	OM_MOVE,
    OM_USER = 0x10000
};


// Message Class

class OBJECT;

struct MESSAGE {
    OBJECT     *ObjPtr;
    int        hMsg;
    long        lParam;
};

class  MESSAGEMNG {
  public:
    MESSAGEMNG();
    virtual ~MESSAGEMNG();

  public:
    static MESSAGE    *MessageQue;
    static int         Start;
    static int         Length;

    static void        Reset( void );

    static BOOL        SendMessage( OBJECT *ObjPtr, int hMsg, long lParam );
    static MESSAGE    *PopMessage( void );
    static void        Process( void );

    static inline int         GetLength( void ) { return( Length ); }
};


// Object Class

#define MAX_OBJECT 1024

class  OBJECT {//: public MESSAGEMNG {
  public:
    OBJECT( void );
	OBJECT(int index);
    virtual ~OBJECT();
   
  private:
    static OBJECT *ObjectList[ MAX_OBJECT ];
    static int      CurObjectID;
    static int      CurFindClassID;
    static int      CurFindPos;

  public:
    int        ClassID;
    int        ObjectID;
    int        DisplayLevel;

    static void       Reset( void );
    static void       Process( void );
    static void       DisplayAll( void );
    static void       DisplayFront( int BaseLevel );
    static void       DisplayBack( int BaseLevel );

    static BOOL       SendMessage( OBJECT *ObjPtr, int hMsg, long lParam );
    static void       SendMessage( int ClassID, int hMsg, long lParam );
	static void		  SendMessageIndex(int index,int hMsg,long lParam); 

    static OBJECT     *FindFirst( int ClassID );
    static OBJECT     *FindNext( void );

    void        SetDisplayLevel( int DisplayLevel );

  public:
    virtual int      ObjProc( int hMsg, long lParam );
};





//////////////////////////////////////////////////////////////////////////////////
// CDXScreen Class
//////////////////////////////////////////////////////////////////////////////////

class CDXScreen
{
public:
	CDXScreen(void);
	~CDXScreen(void);

	HRESULT Create(HWND hwnd, DWORD width, DWORD height, DWORD bpp, DWORD flags);
	HRESULT Restore(void);
	HRESULT Flip(void);

	LPDIRECTDRAW4 GetDD(void) { return m_DirectDraw; }
	LPDIRECT3D3 GetD3D(void) { return m_Direct3D; }
	LPDIRECT3DDEVICE3 GetDevice(void) { return m_Device; }
	LPDIRECT3DVIEWPORT3 GetViewport(void) { return m_Viewport; }
	
	BOOL LoadPalette(const char* szFilename);

	CDXSurface* GetFront(void) { return m_FrontBuffer; }
	CDXSurface* GetBack(void)  { return m_BackBuffer; }
	CDXSurface* GetDepth(void) { return m_DepthBuffer; }

	int GetWidth(void) { return m_Width; }
	int GetHeight(void) { return m_Height; }
	int GetBpp(void) { return m_Bpp; }

public:
	void Initialise(void);
	void Finalise(void);

	HRESULT CreateDirectDraw(void);
	HRESULT CreateBuffers(void);
	HRESULT CreateZBuffer(void);
	HRESULT CreateDirect3D(void);
	HRESULT CreateDevice(void);
	HRESULT CreateViewport(void);

	LPDIRECTDRAW4 m_DirectDraw;
	LPDIRECT3D3 m_Direct3D;
	LPDIRECT3DDEVICE3 m_Device;
	LPDIRECT3DVIEWPORT3 m_Viewport;

	D3DDEVICEDESC m_DeviceDesc;
	DDPIXELFORMAT m_PixelFormat;
	DWORD m_MemoryType;

	CDXSurface* m_FrontBuffer;
	CDXSurface* m_BackBuffer;
	CDXSurface* m_DepthBuffer;
	/////////////////////////////////////////////
	LPDIRECTDRAWPALETTE m_lpDDPalette;

	////////////////////////////////////////

	HWND  m_Hwnd;
	DWORD m_Width;
	DWORD m_Height;
	DWORD m_Bpp;
	RECT  m_ScreenRect;
	RECT  m_ViewportRect;
	BOOL  m_IsFullScreen;
	BOOL  m_Is3D;
	BOOL  m_IsFPU;
};

//////////////////////////////////////////////////////////////////////////////////
// CDX_Surface Class
//////////////////////////////////////////////////////////////////////////////////

class CDXSurface
{
public:
	CDXSurface();
	~CDXSurface();

	void Initialise(void);
	void Finalise(void);

	HRESULT Create(CDXScreen*);
	HRESULT Create(CDXScreen*, int , int);

	HRESULT LoadBitmap(CDXScreen*, const char*);
 	HRESULT CopyBitmap(HBITMAP, int, int, int, int);
	HRESULT Restore(void);
	HRESULT Lock(void);
	HRESULT UnLock(void);
	HRESULT GetDC(void) { return m_Surface->GetDC(&m_DC); }
	HRESULT ReleaseDC(void) { return m_Surface->ReleaseDC(m_DC); }
	HRESULT Fill(DWORD);
	HRESULT SetColorKey(COLORREF);
	HRESULT SetFont(const char*, int, int, int Attributes = FW_NORMAL);
	HRESULT TextXY(int X, int Y, COLORREF, const char*);

	virtual HRESULT Draw(/*CDXSurface* Dest, */DWORD Flags);
	virtual HRESULT DrawFast(int X, int Y, /*CDXSurface* Dest,*/ DWORD Flags);
////////////////////////////////////////////////////////////////////////////
	virtual HRESULT DrawTrans(int X, int Y/*, CDXSurface* lpDDS*/);
	virtual HRESULT DrawClipped(int X, int Y,/* CDXSurface* lpDDS,*/ LPRECT ClipRect);
//	virtual HRESULT DrawWindowed(void/*CDXSurface* lpDDS*/);
	virtual HRESULT DrawScaled(int X, int Y, float Factor/*, CDXSurface* lpDDS*/);
	virtual HRESULT DrawHFlip(int X, int Y/*, CDXSurface* lpDDS*/);
	virtual HRESULT DrawVFlip(int X, int Y/*, CDXSurface* lpDDS*/);
	virtual void DrawRotated(int X, int Y, double Angle/*, CDXSurface* lpDDS*/);
/////////////////////////////////////////////////////////////////////////////////
	void PutPixel(int X, int Y, int Col);
	int  GetPixel(int X, int Y);


	void SetSrc(int, int, int, int);
	void SetDest(int, int, int, int);
	int  GetWidth(void)  { return m_Width; }
	int  GetHeight(void) { return m_Height; }
	LPDIRECTDRAWSURFACE4 GetSurface(void) { return m_Surface; }

public:
	LPDIRECTDRAWSURFACE4 m_Surface;
	DDSURFACEDESC2 m_Desc;
	DDSCAPS2 m_Caps;

	int  m_Width;
	int  m_Height;
	RECT m_SrcRect;
	RECT m_DestRect;

	HDC m_DC;
	HFONT m_Font;
	const char* m_Filename;
	////////////////////////////////////////
	///////////////// ӵ   ⺻ ִ  Ѵ٤////
	static LPDIRECTDRAWSURFACE4 m_SurBack;
};
//////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////add class//////////////////////
class CDXLayer : public CDXSurface
{
public:
  CDXLayer(CDXScreen *pScreen, char *szFilename);

	void ScrollUp(int Offset);
	void ScrollDown(int Offset);
	void ScrollLeft(int Offset);
	void ScrollRight(int Offset);
	void MoveTo(int XOffset, int YOffset);
	virtual HRESULT Draw(CDXSurface* lpDDS);

public:
	int m_XOffset;
	int m_YOffset;
};

//////////////////////////////////////////////////////////////////////////////////
// CDXTile Class
//////////////////////////////////////////////////////////////////////////////////
class CDXTile : public CDXSurface
{
public:
	CDXTile();
	CDXTile(CDXScreen *pScreen, const char* szFilename, int w, int h, int num);

	BOOL Create(CDXScreen *pScreen, const char* szFilename, int w, int h, int num);

public:
	int m_BlockWidth;
	int m_BlockHeight;
	int m_BlockNum;
};

//////////////////////////////////////////////////////////////////////////////////
// CDXMap Class
//////////////////////////////////////////////////////////////////////////////////
class CDXMap
{
public:
	CDXMap(CDXTile *pTiles, CDXScreen *pScreen);
  ~CDXMap();

	void Create(int Width, int Height, int Fill);
	BOOL Load(const char *szFilename);
	BOOL Save(const char *szFilename);
  void Clear(void);
	void Fill(int TileNum);
	void BltTile(CDXSurface* lpDDS, int xdest, int ydest, int w, int h, int xoff, int yoff);
	void BltTileTrans(CDXSurface* lpDDS, int xdest, int ydest, int w, int h, int xoff, int yoff);
	void Draw(CDXSurface* lpDDS);
	void DrawTrans(CDXSurface* lpDDS);
  void DrawClipped(CDXSurface* lpDDS, LPRECT ClipRect);
	void MoveTo(int PosX, int PosY);
	void ScrollUp(int Offset);
	void ScrollDown(int Offset);
	void ScrollLeft(int Offset);
	void ScrollRight(int Offset);
	void WrapScrollUp(int Offset);
	void WrapScrollDown(int Offset);
	void WrapScrollLeft(int Offset);
	void WrapScrollRight(int Offset);
	void ScreenTileSize(int Width, int Height);
	int  GetTile(int MapX, int MapY);
	void SetTile(int MapX, int MapY, int Tile);
	void LoadTiles(CDXTile *pTiles);

public:
	int m_PosX, m_PosY;
	int m_Width, m_Height;
	int m_TileWidth, m_TileHeight;
	int m_PixelWidth, m_PixelHeight;
	int SCREEN_TW, SCREEN_TH;
	int SCREEN_W, SCREEN_H;
	int SIZE;
	int *DATA;
  CDXScreen *Screen;
	CDXTile *Tiles;
};

//////////////////////////////////////////////////////////////////////////////////
// CDXSprite Class
//////////////////////////////////////////////////////////////////////////////////
class CDXSprite : public OBJECT
{
public:
	CDXSprite(void) : OBJECT(){}
	CDXSprite(CDXTile* pTile);
	///////////////////////////////
	CDXSprite(CDXTile *pTile,int index);

	////////////////////////////////////
	CDXSprite(CDXScreen *pScreen, const char* Filename, int w, int h, int num);
	virtual ~CDXSprite();

	BOOL Create(CDXTile* pTile);
	BOOL Create(CDXScreen *pScreen, const char* Filename, int w, int h, int num);

	void SetPos(int pX, int pY) { m_PosX = pX; m_PosY = pY; }
	void SetVel(int vX, int vY) { m_VelX = vX; m_VelY = vY; }
	void SetFrame(int Frame) { m_Frame = Frame; }
	void SetDelay(int Delay) { m_Delay = Delay; }
	void SetState(int State) { m_State = State; }
	void SetType(int Type) { m_Type = Type; }

	void Lock(void) { m_Tile->Lock(); }
	void UnLock(void) { m_Tile->UnLock(); }
	void ColorKey(int Col) { m_Tile->SetColorKey(Col); }
	void SelectFrame(void);
	BOOL SpriteHit(CDXSprite* pSprite);
	BOOL TileHit(CDXMap* pMap, int Tile);
	
	HRESULT Draw(/*CDXSurface* lpDDS,*/DWORD Flags);
	HRESULT DrawFast(/*CDXSurface* lpDDS,*/DWORD Flags);
	HRESULT DrawTrans(/*CDXSurface* lpDDS*/);
	HRESULT DrawClipped(/*CDXSurface* lpDDS, */LPRECT ClipRect);
	//HRESULT DrawWindowed(/*CDXSurface* lpDDS*/);
	HRESULT DrawScaled(float Factor/*, CDXSurface* lpDDS*/);
	void DrawRotated(float Angle/*, CDXSurface* lpDDS*/);
//	void DrawHFlip(/*CDXSurface* lpDDS*/void);
//	void DrawVFlip(/*CDXSurface* lpDDS*/void);
	/////////////////߰ ɹ Լ//////////////////////////
	void	Move( int X, int Y );
 //	virtual void        Put( void );
    virtual int         ObjProc( int hMsg, long lParam );



/////////////////////////////////////////////////////////


public:
	int m_PosX, m_PosY, m_PosZ;
	int m_VelX, m_VelY;
	int m_Frame;
	int m_Delay;
	int m_State;
	int m_Type;
	int m_Angle;
	BOOL m_Flipped;

	CDXTile* m_Tile;
	CDXSprite* m_Next;
	CDXSprite* m_Prev;
};

///////////////////////////////////////////////////////////////////////////////
typedef struct
{
	long offset;
	char name[13];
} FILEENTRY, *LPFILEENTRY;

//////////////////////////////////////////////////////////////////////////////////
// CDXResource Class
//////////////////////////////////////////////////////////////////////////////////
class CDXResource
{
public:
	CDXResource(void);
	~CDXResource(void);

	BOOL Open(const char *Filename);
	void Close(void);
	char* GetFile(const char *Filename);

public:
	LPFILEENTRY m_pFE;
	int m_Infile;
	int m_Outfile;
	int m_nFiles;
};



#endif
