//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDX Class Library - CDX.lib ]
// Source File:  [ CDXLayer Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.5 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXLayer::CDXLayer(CDXScreen *pScreen, char *szFilename)
{	
  m_Surface = DDLoadSizeBitmap(pScreen->m_DirectDraw, szFilename, &m_Width, &m_Height);
  
	m_Filename = szFilename;
//	Screen = pScreen;

	m_DestRect.top = 0;
	m_DestRect.left = 0;
	m_DestRect.bottom = m_Height;
	m_DestRect.right = m_Width;

	m_XOffset = 0;
	m_YOffset = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer ScrollUp
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollUp(int Offset)
{
  m_YOffset += Offset;
	if(m_YOffset > m_Height) m_YOffset -= m_Height;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer ScrollDown
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollDown(int Offset)
{
  m_YOffset -= Offset;
	if(m_YOffset < 0) m_YOffset = m_Height + m_YOffset;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer ScrollLeft
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollLeft(int Offset)
{
  m_XOffset += Offset;
	if(m_XOffset > m_Width) m_XOffset -= m_Width;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer ScrollRight
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollRight(int Offset)
{
  m_XOffset -= Offset;
	if(m_XOffset < 0) m_XOffset = m_Width + m_XOffset;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer MoveTo
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::MoveTo(int XOffset, int YOffset)
{
  m_XOffset = XOffset;
	m_YOffset = YOffset;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer Draw
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXLayer::Draw(CDXSurface* lpDDS)
{
	SetSrc(m_Height - m_YOffset, m_Width - m_XOffset, m_Height, m_Width);
	lpDDS->m_Surface->BltFast(0, 0, m_Surface, &m_SrcRect, DDBLTFAST_WAIT);

	SetSrc(m_Height - m_YOffset, 0, m_Height, m_Width - m_XOffset);
	lpDDS->m_Surface->BltFast(m_XOffset, 0, m_Surface, &m_SrcRect, DDBLTFAST_WAIT);

	SetSrc(0, m_Width - m_XOffset, m_Height - m_YOffset, m_Width);
	lpDDS->m_Surface->BltFast(0, m_YOffset, m_Surface, &m_SrcRect, DDBLTFAST_WAIT);

	SetSrc(0, 0, m_Height - m_YOffset, m_Width - m_XOffset);
	return lpDDS->m_Surface->BltFast(m_XOffset, m_YOffset, m_Surface, &m_SrcRect, DDBLTFAST_WAIT);
}
