//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDX Class Library - CDX.lib ]
// Source File:  [ CDXTile Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.5 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXTile Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXTile::CDXTile(CDXScreen *pScreen, const char* szFilename, int w, int h, int num)
{
	Create(pScreen, szFilename, w, h, num);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXTile Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXTile::CDXTile()
{
	m_DestRect.top = 0;
	m_DestRect.left = 0;
	m_DestRect.bottom = 0;
	m_DestRect.right = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXTile Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXTile::Create(CDXScreen *pScreen, const char* szFilename, int w, int h, int num)
{
	if(szFilename == NULL) return FALSE;

  m_Surface = DDLoadSizeBitmap(pScreen->m_DirectDraw, szFilename, &m_Width, &m_Height);
	if(m_Surface == NULL) return FALSE;

	m_Filename = szFilename;

//	Screen = pScreen;

  m_BlockWidth = w;
	m_BlockHeight = h;
	m_BlockNum = num;
	
	m_DestRect.top = 0;
	m_DestRect.left = 0;
	m_DestRect.bottom = m_Height;
	m_DestRect.right = m_Width;

	m_SrcRect.top = 0;
	m_SrcRect.left = 0;
	m_SrcRect.bottom = m_Height;
	m_SrcRect.right = m_Width;

	return TRUE;
}
