/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include <stdio.h>
#include <string.h>
#include "cdx.h"


// aBa aa
int OBJECT::CurObjectID = 0;
OBJECT *OBJECT::ObjectList[ MAX_OBJECT ] = { NULL, };

int OBJECT::CurFindClassID = 0;
int OBJECT::CurFindPos = 0;


/**********************
  OBJECT a
***********************/
OBJECT :: OBJECT( void ) //: MESSAGEMNG()
{
    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( ObjectList[i] == NULL ){
        ObjectID = i;
        ObjectList[i] = this;
        break;
      }
    }

    ClassID = 0;
    ObjectID = CurObjectID ++;

    DisplayLevel = 0;
}
OBJECT::OBJECT(int index)
{
	ObjectList[index] = this;
	ObjectID = index;
}

/**********************
  OBJECT ia
***********************/
OBJECT :: ~OBJECT()
{
    ObjectList[ ObjectID ] = NULL;
}


/***************************
  OBJECTi Uea.
****************************/
void OBJECT :: Reset( void )
{
    for( int i = 0; i < MAX_OBJECT; i ++ )
     if( ObjectList[i] != NULL ) delete ObjectList[i];
}


/*******************************
  AAi aBaA 孷ea.
********************************/
BOOL OBJECT :: SendMessage( OBJECT *ObjPtr, int hMsg,long lParam )
{
    switch( hMsg ){
      case OM_DUMMY   : ObjPtr->ObjProc( OM_DUMMY, lParam );
                        break;
      case OM_CREATE  : ObjPtr->ObjProc( OM_CREATE, (long)NULL );
                        break;
      case OM_TIMER   : ObjPtr->ObjProc( OM_TIMER, (long)NULL );
                        break;
      case OM_PAINT   : ObjPtr->ObjProc( OM_PAINT, (long)NULL );
                        break;
      case OM_DESTROY : ObjPtr->ObjProc( OM_DESTROY, lParam );
                        delete ObjPtr;
                        break;
	  case OM_MOVE    : ObjPtr->ObjProc( OM_MOVE, lParam );
						break;

  //    default         : return( MESSAGEMNG::SendMessage( ObjPtr, hMsg, lParam ) );
    }

    return( TRUE );
}


/***************************************************
  b ia aBa AAA Ai a.
****************************************************/
OBJECT *OBJECT :: FindFirst( int ClassID )
{
    CurFindClassID = ClassID;
    CurFindPos = 0;

    OBJECT **obj = ObjectList;

    while( CurFindPos++ < MAX_OBJECT ){
      if( *obj && (*obj)->ClassID == ClassID )
        return( *obj );

      obj ++;
    }

    return( NULL );
}


/***************************************************
  b ia aBa AAA Ai a.
****************************************************/
OBJECT *OBJECT :: FindNext( void )
{
    if( CurFindPos >= MAX_OBJECT ) return( NULL );

    int ClassID = CurFindClassID;

    OBJECT **obj = &ObjectList[ CurFindPos ];

    while( CurFindPos++ < MAX_OBJECT ){
      if( *obj && (*obj)->ClassID == ClassID )
        return( *obj );

      obj ++;
    }

    return( NULL );
}


/***************************************************
  b ia aBa AAA Ai a.
****************************************************/
void OBJECT :: SendMessage( int ClassID, int hMsg, long lParam )
{
    OBJECT **obj = ObjectList;

    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( *obj && (*obj)->ClassID == ClassID )
        SendMessage( *obj, hMsg, lParam );

      obj ++;
    }
}
void OBJECT::SendMessageIndex(int index,int hMsg,long lParam)
{
	//OBJECT **obj = ObjectList;
	if(ObjectList[index]) SendMessage(ObjectList[index],hMsg,lParam);
}
	

/***************************
  OBJECTi ១ea.
****************************/
void OBJECT :: Process( void )
{
    OBJECT **obj = ObjectList;

    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( *obj != NULL )
        OBJECT::SendMessage( *obj, OM_TIMER, 0 );

      obj ++;
    }
/*
    int ml = MESSAGEMNG::GetLength();
    if( ml <= 0 ) return;

    for( i = 0; i < ml; i ++ ){
      MESSAGE *msg = MESSAGEMNG::PopMessage();
      msg->ObjPtr->ObjProc( msg->hMsg, msg->lParam );
    }*/
}


/***************************
  OBJECT Ea Ѕi
****************************/
int OBJECT :: ObjProc( int hMsg, long lParam )
{
    return( 0 );
}


/*****************************
  aBa a AIi i
******************************/
void OBJECT :: SetDisplayLevel( int DisplayLevel )
{
    this->DisplayLevel = DisplayLevel;
}


//===============


struct DISPLAYOBJ {
    OBJECT     *ObjPtr;
    int         DisplayLevel;
};
static DISPLAYOBJ DisplayObjectList[ MAX_OBJECT ] = { NULL, };
static DisplayCount = 0;


/*****************************
  aBai 
  OM_PAINT Ai 孷ea.
******************************/
static int CmpObjOrder( const void *disp1, const void *disp2 )
{
    return( ((DISPLAYOBJ *)disp1)->DisplayLevel
          - ((DISPLAYOBJ *)disp2)->DisplayLevel );
}
static void DisplayObjects( void )
{
    DISPLAYOBJ *disp = DisplayObjectList;
    int count = DisplayCount;

    qsort( (void *)disp, count, sizeof(DISPLAYOBJ), CmpObjOrder );

    for( int i = 0; i < count; i ++ ){
      OBJECT::SendMessage( disp->ObjPtr, OM_PAINT, i );
      disp ++;
    }
}


/*****************************
  e aBai ea.
******************************/
void OBJECT :: DisplayAll( void )
{
/*	
    OBJECT **obj = ObjectList;
    DISPLAYOBJ *disp = DisplayObjectList;

    int count = 0;

    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( *obj ){
        disp->ObjPtr       = *obj;
        disp->DisplayLevel = (*obj)->DisplayLevel;

        disp ++;
        count ++;
      }
      obj ++;
    }

    DisplayCount = count;
    DisplayObjects();
*/	
	///////////////////////////////////// ׽Ʈ////////////////////
	  OBJECT **obj = ObjectList;

    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( *obj != NULL )  OBJECT::SendMessage( *obj, OM_PAINT, 0 );
	   //SendMessage( disp->ObjPtr, OM_PAINT, i );

      obj ++;
    }
	///////////////////////////////////////////////////////////////////////
}


/********************************
  aAI 0a aa {e
  aBaei a ea.
*********************************/
void OBJECT :: DisplayFront( int BaseLevel )
{
    OBJECT **obj = ObjectList;
    DISPLAYOBJ *disp = DisplayObjectList;

    int count = 0;

    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( *obj && (*obj)->DisplayLevel >= BaseLevel ){
        disp->ObjPtr       = *obj;
        disp->DisplayLevel = (*obj)->DisplayLevel;

        disp ++;
        count ++;
      }
      obj ++;
    }

    DisplayCount = count;
    DisplayObjects();
}


/********************************
  aAI 0a be
  aBaei a ea.
*********************************/
void OBJECT :: DisplayBack( int BaseLevel )
{
    OBJECT **obj = ObjectList;
    DISPLAYOBJ *disp = DisplayObjectList;

    int count = 0;

    for( int i = 0; i < MAX_OBJECT; i ++ ){
      if( *obj && (*obj)->DisplayLevel < BaseLevel ){
        disp->ObjPtr       = *obj;
        disp->DisplayLevel = (*obj)->DisplayLevel;

        disp ++;
        count ++;
      }
      obj ++;
    }

    DisplayCount = count;
    DisplayObjects();
}

