//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDI Class Library - CDI.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ Main Header File ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDI_H
#define CDI_H

#include <dinput.h>
#define RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }

//////////////////////////////////////////////////////////////////////////////////
// CDI_Input Class
//////////////////////////////////////////////////////////////////////////////////
class CDI_Input
{
public:
	CDI_Input(void);
	~CDI_Input(void);

	HRESULT Create(void *hinst);
	LPDIRECTINPUT GetDI(void) { return m_DirectInput; }

public:
	LPDIRECTINPUT m_DirectInput;
};

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device Class
//////////////////////////////////////////////////////////////////////////////////
class CDI_Device
{
public:
	CDI_Device(void);
	~CDI_Device(void);

	HRESULT Create(CDI_Input*, REFGUID);
	HRESULT SetDataFormat(LPCDIDATAFORMAT);
	HRESULT SetCooperativeLevel(void*, DWORD);
	HRESULT RunControlPanel(void*);
	HRESULT Acquire(void);
	HRESULT Unacquire(void);
	HRESULT SetRelative(void);
	HRESULT SetAbsolute(void);

public:
	LPDIRECTINPUTDEVICE2 m_Device;
	BOOL m_bActive;
};

//////////////////////////////////////////////////////////////////////////////////
// CDI_Keyboard Class
//////////////////////////////////////////////////////////////////////////////////
class CDI_Keyboard : public CDI_Device
{
public:
	CDI_Keyboard(void);
	~CDI_Keyboard(void);

	HRESULT Create(CDI_Input*, void*);
	void Update(void);

public:
	BYTE m_Keys[256];
};

//////////////////////////////////////////////////////////////////////////////////
// CDI_Mouse Class
//////////////////////////////////////////////////////////////////////////////////
class CDI_Mouse : public CDI_Device
{
public:
	CDI_Mouse(void);
	~CDI_Mouse(void);

	HRESULT Create(CDI_Input*, void*);
	void Update(void);

	LONG GetX(void) { return m_X; }
	LONG GetY(void) { return m_Y; }
	LONG GetZ(void) { return m_Z; }
	BYTE GetLB(void) { return m_Buttons[0]; }
	BYTE GetRB(void) { return m_Buttons[1]; }
	BYTE GetMB(void) { return m_Buttons[2]; }

public:
	LONG m_X, m_Y, m_Z;
	BYTE m_Buttons[4];
};

//////////////////////////////////////////////////////////////////////////////////
// CDI_Joystick Class
//////////////////////////////////////////////////////////////////////////////////
class CDI_Joystick : public CDI_Device
{
public:
	CDI_Joystick(void);
	~CDI_Joystick(void);

	HRESULT Create(CDI_Input*, void*);
	void Update(void);

	LONG GetX(void) { return m_X; }
	LONG GetY(void) { return m_Y; }
	LONG GetZ(void) { return m_Z; }
	BYTE GetB1(void) { return m_Buttons[0]; }
	BYTE GetB2(void) { return m_Buttons[1]; }

public:
	LONG m_X, m_Y, m_Z;
	BYTE m_Buttons[32];
};

#endif
