//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDI Class Library - CDI.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ CDI_Device Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDI.h"

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device Constructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Device::CDI_Device(void)
{
	m_Device = NULL;
	m_bActive = FALSE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device Destructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Device::~CDI_Device(void)
{
	m_Device->Unacquire();
	RELEASE(m_Device);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device Create
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::Create(CDI_Input* input, REFGUID guid)
{
	HRESULT rval;
	LPDIRECTINPUTDEVICE lpDID = NULL;

	// Create the device
	rval = input->GetDI()->CreateDevice(guid, &lpDID, NULL);
	if(rval == DI_OK) m_bActive = TRUE;

	rval = lpDID->QueryInterface(IID_IDirectInputDevice2, (LPVOID*)&m_Device);
	if(rval != DI_OK) return rval;

	RELEASE(lpDID);

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device SetDateFormat
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::SetDataFormat(LPCDIDATAFORMAT df)
{
	return m_Device->SetDataFormat(df);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device SetCooperativeLevel
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::SetCooperativeLevel(void* hwnd, DWORD flags)
{
	return m_Device->SetCooperativeLevel((HWND)hwnd, flags);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device RunControlPanel
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::RunControlPanel(void* hwnd)
{
	return m_Device->RunControlPanel((HWND)hwnd, 0);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device Acquire
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::Acquire(void)
{
	return m_Device->Acquire();
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device Unacquire
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::Unacquire(void)
{
	return m_Device->Unacquire();
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device SetAbsolute
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::SetAbsolute(void)
{
	DIPROPDWORD dipdw;

	dipdw.diph.dwSize = sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw.diph.dwObj = 0;
	dipdw.diph.dwHow = DIPH_DEVICE;
	dipdw.dwData = DIPROPAXISMODE_ABS;
	return m_Device->SetProperty(DIPROP_AXISMODE, &dipdw.diph);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Device SetRelative
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Device::SetRelative(void)
{
	DIPROPDWORD dipdw;

	dipdw.diph.dwSize = sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw.diph.dwObj = 0;
	dipdw.diph.dwHow = DIPH_DEVICE;
	dipdw.dwData = DIPROPAXISMODE_REL;
	return m_Device->SetProperty(DIPROP_AXISMODE, &dipdw.diph);
}
