//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDI Class Library - CDI.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ CDI_Joystick Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDI.h"

//////////////////////////////////////////////////////////////////////////////////
// CDI_Joystick Constructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Joystick::CDI_Joystick(void)
{
	m_Device = NULL;
	m_bActive = FALSE;
	m_X = m_Y = m_Z = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Joystick Destructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Joystick::~CDI_Joystick(void)
{
	m_Device->Unacquire();
	RELEASE(m_Device);
}

static LPDIRECTINPUTDEVICE lpDID = NULL;

//////////////////////////////////////////////////////////////////////////////////
// EnumJoystick
//////////////////////////////////////////////////////////////////////////////////
static BOOL FAR PASCAL EnumJoystick(LPCDIDEVICEINSTANCE pdinst, LPVOID pvRef)
{
	LPDIRECTINPUT pDI = (LPDIRECTINPUT)pvRef;

	if(pDI->CreateDevice(pdinst->guidInstance, &lpDID, NULL) != DI_OK)
		return DIENUM_CONTINUE;

	return DIENUM_STOP;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Joystick Create
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Joystick::Create(CDI_Input* input, void* hwnd)
{
	HRESULT rval;

	// Enumerate the joystick device
	rval = input->GetDI()->EnumDevices(DIDEVTYPE_JOYSTICK, EnumJoystick, input->GetDI(), DIEDFL_ATTACHEDONLY);
	if(lpDID != NULL && rval == DI_OK)
	{
		rval = lpDID->QueryInterface(IID_IDirectInputDevice2, (LPVOID*)&m_Device);
		if(rval != DI_OK) return rval;

		RELEASE(lpDID);

		m_Device->SetDataFormat(&c_dfDIJoystick);
		m_Device->SetCooperativeLevel((HWND)hwnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);

		// Set the X-axis range (-1000 to +1000)
		DIPROPRANGE diprg;
		diprg.diph.dwSize = sizeof(diprg);
		diprg.diph.dwHeaderSize = sizeof(diprg.diph);
		diprg.diph.dwObj = DIJOFS_X;
		diprg.diph.dwHow = DIPH_BYOFFSET;
		diprg.lMin = -1000;
		diprg.lMax = +1000;

		if(m_Device->SetProperty(DIPROP_RANGE, &diprg.diph) != DI_OK)
			return rval;

		// And again for Y-axis range
		diprg.diph.dwObj = DIJOFS_Y;

		if(m_Device->SetProperty(DIPROP_RANGE, &diprg.diph) != DI_OK)
			return rval;

		// Set X axis dead zone to 10%
		DIPROPDWORD dipdw;
		dipdw.diph.dwSize = sizeof(dipdw);
		dipdw.diph.dwHeaderSize = sizeof(dipdw.diph);
		dipdw.diph.dwObj = DIJOFS_X;
		dipdw.diph.dwHow = DIPH_BYOFFSET;
		dipdw.dwData = 1000;

		if(m_Device->SetProperty(DIPROP_DEADZONE, &dipdw.diph) != DI_OK)
			return rval;

		dipdw.diph.dwObj = DIJOFS_Y;

		// Set Y axis dead zone to 10%
		if(m_Device->SetProperty(DIPROP_DEADZONE, &dipdw.diph) != DI_OK)
			return rval;

		rval = m_Device->Acquire();
		if(rval != DI_OK) return rval;

		m_bActive = TRUE;
	}

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Joystick Update
//////////////////////////////////////////////////////////////////////////////////
void CDI_Joystick::Update(void)
{
	if(m_bActive)
	{
		DIJOYSTATE JoyState;

		m_Device->Poll();

		if(m_Device->GetDeviceState(sizeof(JoyState), &JoyState) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			m_Device->Acquire();

		m_X = JoyState.lX;
		m_Y = JoyState.lY;
		m_Z = JoyState.lZ;

		for(int i = 0; i < 32; i++)
			m_Buttons[i] = JoyState.rgbButtons[i];
	}
}
