//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDI Class Library - CDI.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ CDI_Mouse Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDI.h"

//////////////////////////////////////////////////////////////////////////////////
// CDI_Mouse Constructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Mouse::CDI_Mouse(void)
{
	m_Device = NULL;
	m_bActive = FALSE;
	m_X = m_Y = m_Z = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Mouse Destructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Mouse::~CDI_Mouse(void)
{
	m_Device->Unacquire();
	RELEASE(m_Device);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Mouse Create
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Mouse::Create(CDI_Input* input, void* hwnd)
{
	HRESULT rval;
	LPDIRECTINPUTDEVICE lpDID = NULL;

	// Create the mouse device
	rval = input->GetDI()->CreateDevice(GUID_SysMouse, &lpDID, NULL);
	if(rval == DI_OK)
	{
		rval = lpDID->QueryInterface(IID_IDirectInputDevice2, (LPVOID*)&m_Device);
		if(rval != DI_OK) return rval;

		RELEASE(lpDID);

		m_Device->SetDataFormat(&c_dfDIMouse);
		m_Device->SetCooperativeLevel((HWND)hwnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND);

		rval = m_Device->Acquire();
		if(rval != DI_OK) return rval;

		m_bActive = TRUE;
	}

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Mouse Update
//////////////////////////////////////////////////////////////////////////////////
void CDI_Mouse::Update(void)
{
	if(m_bActive)
	{
		DIMOUSESTATE MouseState;

		if(m_Device->GetDeviceState(sizeof(MouseState), &MouseState) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			m_Device->Acquire();

		m_X = MouseState.lX;
		m_X = MouseState.lY;
		m_Z = MouseState.lZ;

		for(int i = 0; i < 4; i++)
			m_Buttons[i] = MouseState.rgbButtons[i];
	}
}
