/*
	PHYSICS Simulation
	using PIC(Particle In Cell) model

	Coder: Kim Seong Wan (輺)
	Email: kaswan@hitel.net
	Make: C compiler -> Watcom C/C++
		  Assembler -> Turbo Assembler

		  TASM /ml GRP.ASM
		  WCL386 -5r PIC.C GRP.OBJ

	:  α׷   ڵ ߷忡 ȣۿ
	ϴ  ù̼ϴ ̴ϴ.
	ڿ ڵ鰣 ߷ 	ϴ  ù̼
	̹    Ǿ   ڼ N  
	N*N   ؾ ϹǷ   ڼ 
	  ˴ϴ.
	׷,  α׷   PIC(Particle In Cell)
	Ҹ  ڵ  ߷ ȣۿ   ʰ
	   ɰ   ڵ   ڴ
	 е ϰ, ̸  ڻ ߷ ټ
	Ǫ м ռ  մϴ. ׷  ڿ ġ
	߷  ڰ ġϴ  ߷ ټ  ٷ  
	ֽϴ.
	   ڼ  귮 ϱ޼ þ
	 ʴ´ٴ .
	,  е  ߷ټ ϴ  Ǫ
	ȯ ̿ϱ  Ի귮    ڷ  
	ٴ .
	 2 ڼ 10,000 ̻, ڼ 64 * 64  
	óմϴ.
	 α׷ , ڼ 5,000̰ ڼ 32 * 32 Դϴ.
	 Ų ý Ƽ2 266Mhz ε..
	ʴ Ӽ 밭 1.8 Դϴ. ׷ϱ 1ʿ 2
	ä  .
*/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <time.h>
#include <math.h>

#define MAX 5000	//  ڼ
#define MAX_X 32	//  ڼ
#define MAX_Y 32	//  ڼ
#define DT 0.02		// Ÿ ŸӰ ( ġؼ )
#define PI 3.1415926535 //  

#define BASE 50		//  е   ( е 1 ) 

//    ּ
unsigned char * video = (unsigned char *)0xA0000;
unsigned char * page;

//е ߷ ټ
int density[MAX_X][MAX_Y];
int potential[MAX_X][MAX_Y];

// Ǫ м ռ  
float dens_i[MAX_X][MAX_Y];
float dens[MAX_Y][MAX_X];
float poten_i[MAX_X][MAX_Y];
float poten[MAX_Y][MAX_X];

//ڵ ġǥ, ӵ, ӵ
float x[MAX], y[MAX];
float vx[MAX], vy[MAX];
float ax[MAX], ay[MAX];

unsigned char gray;  // ȷƮ ÿ
unsigned int frame = 0, StartTime, EndTime;  // ʴ Ӽ 

extern void SetMode(int); //  ѿ ǵ ȭ  Լ

// ⺻ ׷ Լ
void PutPixel(int x, int y, unsigned char color)
{
	unsigned int offset;

	offset = x + y * 320;
	*(page + offset) = color;
}

void Hline(int x1, int x2, int y, unsigned char color)
{
	int i;

	for (i = x1; i <= x2; i++) PutPixel(i, y, color);
}

void Vline(int x, int y1, int y2, unsigned char color)
{
	int j;

	for (j = y1; j <= y2; j++) PutPixel(x, j, color);
}

void DrawBox(int x1, int y1, int x2, int y2, unsigned char color)
{
	Hline(x1, x2, y1, color);
	Hline(x1, x2, y2, color);
	Vline(x1, y1, y2, color);
	Vline(x2, y1, y2, color);
}

void FillBox(int x1, int y1, int x2, int y2, unsigned char color)
{
	int j;

	for(j = y1; j <= y2; j++)
		Hline(x1, x2, j, color);
}

// PIC ߷ ù̼
void Simulation(void)
{
	int a;
	int i, j, k, l, m, n;
	int color;
	unsigned char key;

	StartTime = clock();
	while(1)
	{

		frame++;

		//е 0  ʱȭ
		memset(density, 0, MAX_X * MAX_Y * 4);

		//е 
		for(i = 0; i < MAX; i++)
		{
			if ( x[i] >= MAX_X ) x[i] -= MAX_X;
			if ( y[i] >= MAX_Y ) y[i] -= MAX_Y;
			if ( x[i] < 0 ) x[i] += MAX_X - 1;
			if ( y[i] < 0 ) y[i] += MAX_Y - 1;

			density[ (int) x[i] ][ (int) y[i] ] += 1;
		}

		// е Ǫ м
		//
		for(i = 0; i < MAX_X; i++)
		{
			for(k = 0; k < MAX_Y; k++)
			{
				dens_i[i][k] = 0;
				for(j = 0; j < MAX_Y; j++)
				{
					dens_i[i][k] += density[i][j] * sin(PI * k * j / MAX_Y);
				}
				dens_i[i][k] *= 2;
				dens_i[i][k] /= MAX_Y;
			}
		}

		for(k = 0; k < MAX_Y; k++)
		{
			for(l = 0; l < MAX_X; l++)
			{
				dens[k][l] = 0;
				for(i = 0; i < MAX_X; i++)
				{
					dens[k][l] += dens_i[i][k] * sin(PI * l * i / MAX_X);
				}
				dens[k][l] *= 2;
				dens[k][l] /= MAX_X;
			}
		}



		// Ǫ м е  ߷ټ Ǫ ռ
		//
		for(k = 0; k < MAX_Y; k++)
		{
			for(l = 0; l < MAX_X; l++)
			{
				poten[k][l] = dens[k][l] / ( 4 - 2 * cos(PI * k / MAX_Y) - 2 * cos(PI * l / MAX_Y) );
			}
		}

		for(k = 0; k < MAX_Y; k++)
		{
			for(i = 0; i < MAX_X; i++)
			{
				poten_i[i][k] = 0;
				for(l = 0; l < MAX_X; l++)
				{
					poten_i[i][k] += poten[k][l] * sin(PI * l * i / MAX_X);
				}
			}
		}

		for(i = 0; i < MAX_X; i++)
		{
			for(j = 0; j < MAX_Y; j++)
			{
				potential[i][j] = 0;
				for(k = 0; k < MAX_Y; k++)
				{
					potential[i][j] += poten_i[i][k] * sin(PI * k * j / MAX_Y);
				}
			}
		}

		// ߷ ټȷ  ߷ ؼ  ġؼ
		// Ǫ  (   Ϸ  )
		for(a = 0; a < MAX; a++)
		{
			i = (int)x[a];
			j = (int)y[a];

			k = i - 1;
			l = i + 1;
			m = j - 1;
			n = j + 1;

			if( k < 0 ) k = k + (MAX_X - 1);
			if( l >= MAX_X ) l = l - (MAX_X - 1);
			if( m < 0 ) m = m + (MAX_Y - 1);
			if( n >= MAX_Y ) n = n - (MAX_Y - 1);

			ax[a] = -(potential[k][j] - potential[l][j]) / 2;
			ay[a] = -(potential[i][m] - potential[i][n]) / 2;

			vx[a] += ax[a] * DT;
			vy[a] += ay[a] * DT;

			x[a] += vx[a] * DT;
			y[a] += vy[a] * DT;
		}

		memset(page, 0l, 64000l);  //  

		drawBox(0,0, 319,199, 255);
		drawBox(160 - MAX_X/2, 100-MAX_Y/2, 160+MAX_X/2, 100+MAX_Y/2, 255);

		// е  ǥ
		for(i=0; i<MAX_X; i++)
		{
			for (j=0; j<MAX_Y; j++)
			{
				color = density[i][j];
				if(color > 0)
				{
					if(color > 255) color = 255;
					PutPixel(160 - MAX_X/2 + i, 100 - MAX_Y/2 + j, (unsigned char) color + BASE);
				}
			}
		}

		memcpy(video, page, 64000l); //    

		if(kbhit()) break;

	}
	EndTime = clock();
}

int main(void)
{
	int i;

	//   ޸Ҵ
	page = (unsigned char *) malloc(64000l);
	if ( page == NULL)
	{
		SetMode(0x03);
		printf("memory allocation Error!\n");
		exit(1);
	}
	memset(page, 0, 64000l);

	SetMode(0x13); //  320 * 200  256 ȭ

	// е  ȸ  ǥϱ  ȷƮ 
	gray = 0;
	outp(0x3c8, 0);
	for ( i = 0; i< 256; i++)
	{
		outp(0x3c9, gray >> 2);
		outp(0x3c9, gray >> 2);
		outp(0x3c9, gray >> 2);
		gray++;
	}

		//  ڵ ġ 
	srand(clock());
	for ( i = 0; i < MAX; i++)
	{
		x[i] = (rand() * (MAX_X/4) / 32767) + MAX_X/2 - MAX_X/8;
		y[i] = (rand() * (MAX_Y/4) / 32767) + MAX_Y/2 - MAX_Y/8;

		density[ (int) x[i] ][ (int) y[i] ] += 1;
	}

	Simulation(); // ù̼ 

	free(page);

	getch();
	SetMode(0x03);  // ȭ ؽƮ ..

	printf("Frame Rates : %f fps\n", frame/((EndTime - StartTime)/18.2) );

	return 0;
}
