#ifndef _SRKEYBOARD_
#define _SRKEYBOARD_

typedef unsigned char byte;
typedef unsigned int bool;
typedef unsigned long dword;
typedef unsigned short word;

extern byte scan[128],asci[128],press_key;

#define _ESC       0x01  // (Esc)
#define _1         0x02  // 1
#define _2         0x03  // 2
#define _3         0x04  // 3
#define _4         0x05  // 4
#define _5         0x06  // 5
#define _6         0x07  // 6
#define _7         0x08  // 7
#define _8         0x09  // 8
#define _9         0x0A  // 9
#define _0         0x0B  // 0
#define _MINUS     0x0C  // -
#define _EQUAL     0x0D  // =     
#define _BKSPC     0x0E  // (Back Space)     
#define _TAB       0x0F  // (Tab)
#define _Q         0x10  // Q
#define _W         0x11  // W
#define _E         0x12  // E
#define _R         0x13  // R
#define _T         0x14  // T
#define _Y         0x15  // Y
#define _U         0x16  // U
#define _I         0x17  // I
#define _O         0x18  // O
#define _P         0x19  // P
#define _LPAREN    0x1A  // [
#define _RPAREN    0x1B  // ]
#define _ENTER     0x1C  // (Enter)
#define _CTRL      0x1D  // (Ctrl)
#define _A         0x1E  // A
#define _S         0x1F  // S
#define _D         0x20  // D
#define _F         0x21  // F
#define _G         0x22  // G
#define _H         0x23  // H
#define _J         0x24  // J
#define _K         0x25  // K
#define _L         0x26  // L
#define _SCOLON    0x27  // ;
#define _QUTATO    0x28  // "
#define _SUTATO    0x29  // `
#define _LSHIFT    0x2A  // (Left Shift)
#define _RSLASH    0x2B  // (\) 
#define _Z         0x2C  // Z
#define _X         0x2D  // X
#define _C         0x2E  // C
#define _V         0x2F  // V
#define _B         0x30  // B
#define _N         0x31  // N
#define _M         0x32  // M
#define _COMMA     0x33  // ,
#define _PERIOD    0x34  // .
#define _SLASH     0x35  // /
#define _RSHIFT    0x36  // (Right Shift)
#define _STAR      0x37  // *
#define _ALT       0x38  // (Alt)
#define _SPBAR     0x39  // (Space Bar)
#define _CAP       0x3A  // (Caps Look)
#define _F1        0x3B  // (F1)
#define _F2        0x3C  // (F2)
#define _F3        0x3D  // (F3)
#define _F4        0x3E  // (F4)
#define _F5        0x3F  // (F5)
#define _F6        0x40  // (F6)
#define _F7        0x41  // (F7)
#define _F8        0x42  // (F8)
#define _F9        0x43  // (F9)
#define _F10       0x44  // (F10)
#define _NUM       0x45  // (Num Look)
#define _SCR       0x46  // (Scroll Lock)
#define _HOME      0x47  // (Home)
#define _UPKEY     0x48  // (Up Arrow)
#define _PGUP      0x49  // (Page Up)
#define _PADMINUS  0x4A  // Key Pad Minus
#define _LTKEY     0x4B  // (Left Arrow)
#define _PAD_5     0x4C  // Pad 5
#define _RTKEY     0x4D  // (Right Arrow)
#define _PLUS      0x4E  // +
#define _END       0x4F  // (End)
#define _DNKEY     0x50  // (Down Arrow)
#define _PGDN      0x51  // (Page Up)
#define _INS       0x52  // (Insert)
#define _DEL       0x53  // (Delete)

void InstallKeyboardInterrupt();
void UnInstallKeyboardInterrupt();
byte Getch();
byte IsDownKey(char);
void InitKey();
byte KeyDown(byte,char);
void SaveKeyBuffer(byte *,char);
void InitKeyBuffer(byte *);

#endif
