// This program is one of my first VC4/DirectX 5 applications
// it is modified from Andre's code that accompanied his DirectX 
// discussion... (it's nearly a complete rip)
// This might not look like much, but one thing is for sure.
// I'm sold on DirectX
//
// ... oh, by the way... this is a cheesy tile based graphics demo program..
//
// LISTING 1.0 - DIRECT X 5.0 GAME CONSOLE ////////////////////////////////////

// INCLUDES ///////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN // make sure certain headers are included correctly

#include <windows.h> // include the standard windows stuff
#include <windowsx.h> // include the 32 bit stuff
#include <mmsystem.h> // include the multi media stuff
// note you need winmm.lib also
#include <ddraw.h> // include direct draw components

#include <stdlib.h> // include all the good stuff
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <float.h>
#include "ddutil.h"         // DDLoadPalette, DDCopyBitmap
#include "resource.h"

// DEFINES ////////////////////////////////////////////////////////////////////

#define WINDOW_CLASS_NAME "WINDOW_CLASS" // this is the name of the window class

// defines for screen parameters

#define SCREEN_WIDTH 640 // the width of the viewing surface
#define SCREEN_HEIGHT 480 // the height of the viewing surface
#define SCREEN_BPP 16 // the bits per pixel

#define NUMTEXTURES 12

#define CELL_X_SIZE 64
#define CELL_Y_SIZE 64

#define TILE_X_NUM 32
#define TILE_Y_NUM 32

#define TILE_X_NUM_SHIFT 5
#define TILE_Y_NUM_SHIFT 5

#define TOTAL_TILES  (TILE_X_NUM*TILE_Y_NUM)

#define X_BOUND    ((TILE_X_NUM)*CELL_X_SIZE)
#define Y_BOUND    ((TILE_Y_NUM)*CELL_Y_SIZE)

// TYPES /////////////////////////////////////////////////////////////////////

typedef unsigned char UCHAR;

// MACROS /////////////////////////////////////////////////////////////////////

// these query the keyboard in real-time

#define KEY_DOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define KEY_UP(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 0 : 1)

// PROTOTYPES ////////////////////////////////////////////////////////////////

int DD_Init(HWND hwnd);
int DD_Shutdown(void);
int Set_Pal_Entry(int index, int red, int green, int blue);

void Game_Init(void);
void Game_Main(void);
void Game_Shutdown(void);

// DIRECTDRAW GLOBALS ////////////////////////////////////////////////////////

LPDIRECTDRAW lpdd = NULL; // dd object
LPDIRECTDRAWSURFACE lpddsprimary = NULL; // dd primary surface
LPDIRECTDRAWSURFACE lpddsback    = NULL; // dd back buffer
LPDIRECTDRAWSURFACE lpddstextures[12] = {NULL,NULL,NULL,NULL,NULL,NULL,
                                         NULL,NULL,NULL,NULL,NULL,NULL};
LPDIRECTDRAWPALETTE lpddpal = NULL; // a pointer to the created dd palette
PALETTEENTRY color_palette[256]; // holds the shadow palette entries
DDSURFACEDESC ddsd; // a direct draw surface description struct
DDSCAPS ddscaps; // a direct draw surface capabilities struct
HRESULT ddrval; // result back from dd calls
HWND main_window_handle = NULL; // used to store the window handle
UCHAR *video_buffer = NULL; // pointer to video ram
UCHAR *double_buffer = NULL; // pointer to double buffer
int lpitch; // the linear pitch
DWORD last_frame_time;

// GAME GLOBALS GO HERE ///////////////////////////////////////////////////// 

// Name of our bitmap resource.
char szBitmap1[] = "TILE1";
char szBitmap2[] = "TILE2";
char szBitmap3[] = "TILE3";
char szBitmap4[] = "TILE4";
char szBitmap5[] = "TILE5";
char szBitmap6[] = "TILE6";
char szBitmap7[] = "TILE7";
char szBitmap8[] = "TILE8";
char szBitmap9[] = "TILE9";
char szBitmap10[] = "TILE10";
char szBitmap11[] = "TILE11";
char szBitmap12[] = "TILE12";

// think of this array as something you would construct a model
// train set on...

char terrain_texture[] =

     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,11,0,11,0,0,11,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,
       0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,
       0,0,1,0,0,0,0,1,0,0,11,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,
       0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,
       0,0,1,11,0,0,0,1,0,0,0,0,0,0,11,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,
       0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,
       0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,1,0,0,11,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,1,0,0,0,0,0,0,11,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,
       0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,
       0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
       0,0,0,0,2,3,4,5,2,3,4,0,5,6,7,8,9,10,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
       0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,
       0,0,0,1,0,0,0,1,0,0,0,0,11,0,11,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,
       0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,
      
     };

// DIRECT X FUNCTIONS /////////////////////////////////////////////////////////

int DD_Init(HWND hwnd)
{
	// this function is responsible for initializing direct draw, it creates a
	// primary surface 
    
	HDC hdc;
	int index; // looping index

	// now that the windows portion is complete, start up direct draw
	if (DirectDrawCreate(NULL,&lpdd,NULL)!=DD_OK)
	{
		// shutdown any other dd objects and kill window
		DD_Shutdown();
		return(0);
	} // end if

	// now set the coop level to exclusive and set for full screen and mode x
	if (lpdd->SetCooperativeLevel(hwnd, DDSCL_ALLOWREBOOT | DDSCL_EXCLUSIVE |
	DDSCL_FULLSCREEN | DDSCL_ALLOWMODEX)!=DD_OK)
	{
		// shutdown any other dd objects and kill window
		DD_Shutdown();
		return(0);
	} // end if

	// now set the display mode
	if (lpdd->SetDisplayMode(SCREEN_WIDTH,SCREEN_HEIGHT,SCREEN_BPP)!=DD_OK)
	{
		// shutdown any other dd objects and kill window
		DD_Shutdown();
		return(0);
	} // end if
    
     // Create the primary surface with 1 back buffer
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
			  DDSCAPS_FLIP |
			  DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    ddrval = lpdd->CreateSurface( &ddsd, &lpddsprimary, NULL );
    if( ddrval != DD_OK )
    {
		DD_Shutdown();
		return(0);
   }

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = lpddsprimary->GetAttachedSurface(&ddscaps, &lpddsback);
    if( ddrval != DD_OK )
    {
		DD_Shutdown();
		return(0);
    }

  
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwHeight = 64;
	ddsd.dwWidth = 64;

	for (index=0; index<NUMTEXTURES; index++)
		if (lpdd->CreateSurface(&ddsd,&lpddstextures[index],NULL)!=DD_OK)
		{
			// shutdown any other dd objects and kill window
			DD_Shutdown();
			return(0);
		} // end if

    // print some stuff

	if (lpddsprimary->GetDC(&hdc) == DD_OK)
	{
		SetBkColor( hdc, RGB( 0, 0, 255 ) );
		SetTextColor( hdc, RGB( 255, 255, 0 ) );
		TextOut( hdc, 0, 0, "Welcome Aboard!", 15 );
		lpddsprimary->ReleaseDC(hdc);
	}   

	// return success if we got this far
	return(1);

} // end DD_Init

///////////////////////////////////////////////////////////////////////////////

int DD_Shutdown(void)
{
// this function tests for dd components that have been created and releases
// them back to the operating system
int index;

	// test if the dd object exists
	if (lpdd)
	{
		// test if there is a primary surface
		if(lpddsprimary)
		{
			// release the memory and set pointer to NULL
			lpddsprimary->Release();
			lpddsprimary = NULL;
		} // end if

        for (index = 0; index<NUMTEXTURES; index++)
			if(lpddstextures[index])
			{
				// release the memory and set pointer to NULL
				lpddstextures[index]->Release();
				lpddstextures[index] = NULL;
			} // end if

		// now release the dd object itself
		lpdd->Release();
		lpdd = NULL;

		// return success
		return(1);

	} // end if
	else
		return(0);

} // end DD_Shutdown

//////////////////////////////////////////////////////////////////////////////

int Set_Pal_Entry(int index, int red, int green, int blue)
{
// this function sets a palette entry with the sent color

PALETTEENTRY color; // used to build up color

    // set RGB value in structure
    color.peRed = (BYTE)red;
    color.peGreen = (BYTE)green;
    color.peBlue = (BYTE)blue;
    color.peFlags = PC_NOCOLLAPSE;

	// set the color palette entry
	lpddpal->SetEntries(0,index,1,&color);

	// make copy in shadow palette
	memcpy(&color_palette[index],
	&color,
	sizeof(PALETTEENTRY));

	// return success
	return(1);

} // end Set_Pal_Entry

// WINDOWS CALLBACK FUNCTION ////////////////////////////////////////////////// 

LRESULT CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
// this is the main message handler of the system

HDC hdc; // handle to graphics context
PAINTSTRUCT ps; // used to hold the paint info

	// what is the message?

	switch(msg)
	{ 
		case WM_CREATE:
		{
			// do windows inits here
			return(0);
		} break;

		case WM_PAINT:
		{
			// this message occurs when your window needs repainting
			hdc = BeginPaint(hwnd,&ps); 
			EndPaint(hdc,&ps);

			return(0);
		} break;

		case WM_DESTROY:
		{
			// this message is sent when your window is destroyed
			PostQuitMessage(0);
			return(0);
		} break;

		default:break;

	} // end switch

	// let windows process any messages that we didn't take care of 
	return (DefWindowProc(hwnd, msg, wparam, lparam));

} // end WinProc

// WINMAIN ////////////////////////////////////////////////////////////////////

int WINAPI WinMain( HINSTANCE hinstance,
HINSTANCE hprevinstance,
LPSTR lpcmdline,
int ncmdshow)
{
WNDCLASSEX winclass; // this holds the windows class info
HWND hwnd; // this holds the handle of our new window
MSG msg; // this holds a generic message


	// first fill in the window class stucture

	winclass.cbSize = sizeof(WNDCLASSEX);
	winclass.style = CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	winclass.lpfnWndProc = WindowProc;
	winclass.cbClsExtra = 0;
	winclass.cbWndExtra = 0;
	winclass.hInstance = hinstance;
	winclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	winclass.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	winclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	winclass.hbrBackground = GetStockObject(BLACK_BRUSH);
	winclass.lpszMenuName = NULL;
	winclass.lpszClassName = WINDOW_CLASS_NAME;

	// register the window class
	if (!RegisterClassEx(&winclass))
		return(0);

	// create the window
	if (!(hwnd = CreateWindowEx(WS_EX_TOPMOST,
								WINDOW_CLASS_NAME, // class
								"Jim's directx tasklist marque", // title
								WS_VISIBLE | WS_POPUP,
								0,0, // x,y
								GetSystemMetrics(SM_CXSCREEN),
								GetSystemMetrics(SM_CYSCREEN), 
								NULL, // parent
								NULL, // menu
								hinstance, // instance
								NULL))) // creation parms
		return(0);

	// hide the mouse cursor
	ShowCursor(0);

	// save the window handle
	main_window_handle = hwnd;

	// initialize direct draw
	if (!DD_Init(hwnd))
	{
		DestroyWindow(hwnd);
		return(0);
	} // end if

	// initialize game
	Game_Init();

	// enter main event loop
	while(1)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{ 
			// test if this is a quit
			if (msg.message == WM_QUIT)
			break;

			// translate any accelerator keys
			TranslateMessage(&msg);

			// send the message to the window proc
			DispatchMessage(&msg);
		} // end if
		else
		{
		// do asynchronous processing here

		// call main logic module
		Game_Main();


		} // end else

	} // end while

    // shut down direct draw
	DD_Shutdown();

	// shutdown game
	Game_Shutdown();

	// return to Windows
	return(msg.wParam);

} // end WinMain

// HERE ARE OUR GAME CONSOLE FUNCTIONS ///////////////////////////////////////////////////////

void Game_Init(void)
{
// do any initialization here

    HBITMAP hbm;
	HRESULT smelly;

    // Load our bitmap resource.
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap1, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[0], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap2, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[1], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap3, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[2], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap4, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[3], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap5, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[4], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap6, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[5], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap7, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[6], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap8, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[7], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap9, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[8], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap10, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[9], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap11, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[10], hbm, 0, 0,   64, 64);
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap12, IMAGE_BITMAP, 64, 64, LR_CREATEDIBSECTION);
    smelly = DDCopyBitmap(lpddstextures[11], hbm, 0, 0,   64, 64);
 
    DeleteObject(hbm);

    if (smelly!=DD_OK)
	{
         PostQuitMessage(0);
    }
 
	// get a starting time for this program

	last_frame_time = GetTickCount();

} // end Game_Init

/////////////////////////////////////////////////////////////////////////////////////////////

void Game_Shutdown(void)
{
// cleanup and release all resources here
} // end Game_Shutdown

/////////////////////////////////////////////////////////////////////////////////////////////

// All the tile drawing stuff is done in here.
// This isn't the best algorithm for drawing tiles, because
// it's checking every dang tile to see if it needs to be clipped
// along the right hand side of the screen...
//
// but anyway, here goes...

void Game_Main(void)
{
// process your game logic and draw next frame

// right now, it's just a cheesy clipping tile engine!

	static int px = SCREEN_WIDTH, // upperleft corner of screen
	           py = SCREEN_HEIGHT; 
	DWORD new_frame_time;
	int movementfactor;

	LPDIRECTDRAWSURFACE pdds; // an alias we'll use to the
	                          // tile to be used in BltFast!
    RECT rcRect;              /// used for clipping tiles
	HRESULT             ddrval;
    HDC hdc;
	int start_left, start_top;
	int start_right, start_bottom;
    int start_x_cell, start_y_cell;
	int render_it_x,render_it_y;
	int clip_right, clip_bottom;
    int which_cell,cell_x_save;
	int num_x_tiles, num_y_tiles;
	int x_offset, y_offset;
    int orig_left_clip,orig_top_clip;

    // record starting time of frame. I don't really use this
	// but it could be used to let your current framerate dictate
	// how much to move in response to keystrokes...
	// It's a timing paradigm that WILL make for some choppy
	// play on slow machines, but at the same time will have 
	// for example. 2 people who are running this, one on a
	// P200 and one on a P100, who start it up at the same time,
	// seeing the same image 30 seconds later... more or less...
    new_frame_time = GetTickCount();

	movementfactor = new_frame_time - last_frame_time;

	// get input, note how keyboard is accessed with constants "VK_"
	// these are defined in "winuser.h" are basically the scan codes
	// for letters just use capital ASCII codes

	if (KEY_DOWN(VK_ESCAPE))
		PostMessage(main_window_handle,WM_CLOSE,0,0); // this is how you exit you game

	// which way is player moving
	if (KEY_DOWN(VK_RIGHT))
	if ((px+=4)>(X_BOUND)) px=X_BOUND;

	if (KEY_DOWN(VK_LEFT))
	if ((px-=4)<SCREEN_WIDTH) px=SCREEN_WIDTH;

	if (KEY_DOWN(VK_UP))
	if ((py-=4)<SCREEN_HEIGHT) py=SCREEN_HEIGHT;

	if (KEY_DOWN(VK_DOWN))
	if ((py+=4)>=Y_BOUND) py=Y_BOUND-1;

	// my muddleheaded setup for the tile engine

	start_left = px-SCREEN_WIDTH;
	start_top = py-SCREEN_HEIGHT;

	start_x_cell = start_left / CELL_X_SIZE;
	start_y_cell = start_top / CELL_Y_SIZE;

	orig_left_clip = rcRect.left = start_left%CELL_X_SIZE;
	orig_top_clip = rcRect.top = start_top%CELL_Y_SIZE;

    start_right = (start_left+CELL_X_SIZE)%CELL_X_SIZE;
	start_bottom = (start_top+CELL_Y_SIZE)%CELL_Y_SIZE;

	if (start_right<=start_left)
		rcRect.right = CELL_X_SIZE;
	else
		rcRect.right = start_right;

	if (start_bottom<=start_top)
		rcRect.bottom = CELL_Y_SIZE;
	else
		rcRect.bottom = start_bottom;

	// get starting texture to draw with

	cell_x_save = start_x_cell + (start_y_cell<<TILE_Y_NUM_SHIFT);

	which_cell = cell_x_save;

	x_offset = 0;
	y_offset = 0;

	num_x_tiles = ((SCREEN_WIDTH+start_left)/ CELL_X_SIZE) + 1;
	num_y_tiles = ((SCREEN_HEIGHT+start_top)/ CELL_Y_SIZE) + 1;

// loop thru entire scene left to right, top to bottom

	for (render_it_y = 0; render_it_y<num_y_tiles; render_it_y++)
	{
		x_offset = 0;

		// get original start left clip for each x loop

        rcRect.left = orig_left_clip;

		// assume, for now, that we've got the whole tile
		// to work with horizontally

        rcRect.right = CELL_X_SIZE;

		// draw tiles left to right

		for (render_it_x = 0; render_it_x<num_x_tiles; render_it_x++)
		{
			pdds = lpddstextures[terrain_texture[which_cell]];
             
			ddrval = lpddsback->BltFast( x_offset, y_offset, pdds, &rcRect, DDBLTFAST_WAIT );
 
			// the following will only evaluate to a value other
			// than 64 once for every row of tiles

			x_offset+=CELL_X_SIZE-rcRect.left;

			++which_cell;

	        rcRect.left = 0;
	        rcRect.right = CELL_X_SIZE;

			// determine where to kick out of the loop
			// or just clip the right hand side of the rect

			clip_right = SCREEN_WIDTH - x_offset;

			if ((clip_right)<0)
				break;

			if ((clip_right)<64)
				if ((clip_right)==0)
			    {
				    ++which_cell;
				    break;
			    }
				else
					rcRect.right = clip_right;
			// sync time (optional)
		} // end for render_it_x

		// this will only evaluate to a value other than 64
		// once...

		y_offset+=CELL_Y_SIZE-rcRect.top;

		cell_x_save += TILE_X_NUM;
        which_cell = cell_x_save;

		rcRect.top = 0;
	    rcRect.bottom = CELL_Y_SIZE;

		// clip tiles w/ respect to Y screen boundary

		clip_bottom = SCREEN_HEIGHT - y_offset;

		if ((clip_bottom)<CELL_Y_SIZE)
			if ((clip_bottom)<=0)
			    break;
		    else
				rcRect.bottom = SCREEN_HEIGHT-y_offset;

			
    } // end for render_it_y

	// print a message on the backbuffer

	if (lpddsback->GetDC(&hdc) == DD_OK)
	{
		SetBkColor( hdc, RGB( 0, 0, 255 ) );
		SetTextColor( hdc, RGB( 255, 255, 0 ) );
		TextOut( hdc, 0, 0, "Keys: LEFT, RIGHT, UP, DOWN, .. and ESC", 39 );
		lpddsback->ReleaseDC(hdc);
	}   

	// flip back buffer to primary buffer
    lpddsprimary->Flip(NULL,DDFLIP_WAIT);

	last_frame_time = new_frame_time;

// return and let windows have some time

} // end Game_Main
