// gamedefs.h source file...
// since I hacked my one big main source file up, I just threw some
// defines in here, some are only used by one cpp source, some by both..
// whatever...


#define SCREEN_BPP 16 // the bits per pixel

#define NUMTEXTURES 12 // world textures
#define NUMCLOUDS   10 // floating "normal" clouds
#define NUMPLAYERFRAMES 8 // number of frames for the ship
// tile size (you can change these, but make sure the world [in tiles]
// is larger than your viewport)

#define CELL_X_SIZE 32
#define CELL_Y_SIZE 32

// number of tiles horizontally and vertically representing the 
// world map (only SOME of these are on screen at any one time)

#define TILE_X_NUM 32
#define TILE_Y_NUM 32

// though I don't do things very efficiently here, I was thinking
// of those who like to use bitwize shifting, as opposed to 
// multiplication. (Multiplication is a series of additions on
// a computer... shifting is faster)

#define TILE_X_NUM_SHIFT 5
#define TILE_Y_NUM_SHIFT 5

// The "area" of the gameworld in tiles

#define TOTAL_TILES  (TILE_X_NUM*TILE_Y_NUM)

// the maximum coordinates for the lower right hand
// corner of the screen

#define X_BOUND    ((TILE_X_NUM)*CELL_X_SIZE)
#define Y_BOUND    ((TILE_Y_NUM)*CELL_Y_SIZE)

// the characters are clouds right now,
// they're bigger than tiles here

#define CLOUD_WIDTH 64
#define CLOUD_HEIGHT 64

#define SHIP_WIDTH 54
#define SHIP_HEIGHT 54

// Directional defines for character motion

#define MOVE_LEFT    1
#define MOVE_RIGHT   2
#define MOVE_UP      4
#define MOVE_DOWN    8

// number of slices we're going to cut a 360 degree pie into

#define NUM_ANGLES   361
