// polydraw.cpp
//
// intended to be included in tiled3.cpp's project 
//
// by James McCue http://members.xoom.com/JimMcCue/index.htm
//
// some additional code by or modified from code available at
// http://www.angelic-coders.com/
//
// Alot of the polygon stuff I have here isn't even necessary when
// you have directdraw compatible or 3d accelerated cards... because
// you can simply use Blt w/ a flag for rotation
//
#include <ddraw.h> // include direct draw components

#include <stdlib.h> // include all the good stuff
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <float.h>

#include "gamedefs.h"  // some global definitions
#include "typedefs.h"  // some types that are referenced
#include "shrdvars.h"  // some shared variables
#include "polydraw.h"  // function prototypes and globals

float sin_look[NUM_ANGLES];
float cos_look[NUM_ANGLES];

RGB16 myrgb16;

// Must have the surface locked, pass the surface description 
// that gets returned from the lock call
/*void PlotPixel(int x, int y, WORD pixel, DDSURFACEDESC *ddsd)
{
 WORD *pixels = (WORD *)ddsd->lpSurface;
 DWORD pitch = ddsd->dwWidth; 
 pixels[y*pitch + x] = pixel; 
}*/

/////////////Check out the funky modification suggested by Dhonn//////

//// I had used lPitch, but that didn't work on my comp, and using
/// dwWidth in the above, commented out, procedure... crashed other
/// people's comps...

void PlotPixel (int x, int y, WORD pixel)
{
	*((WORD *)(double_buffer + y * lpitch + (x<<1))) = pixel;
}

// this module locks the backbuffer surface and calls the lower level
// drawing routines

// of course, it locks the surface again on exit

void Draw_Ship(polygon_ptr poly, int midx, int midy)
{
	// this routine draws the ship
	// draw the ship

	Draw_Triangle((int)poly->vertices_local_rotated[0].x+midx, (int)poly->vertices_local_rotated[0].y+midy,
		(int)poly->vertices_local_rotated[1].x+midx, (int)poly->vertices_local_rotated[1].y+midy, 
		(int)poly->vertices_local_rotated[2].x+midx, (int)poly->vertices_local_rotated[2].y+midy,
                 0, 0, 0, SHIP_HEIGHT-1, SHIP_WIDTH-1, SHIP_HEIGHT-1, 1);

	Draw_Triangle((int)poly->vertices_local_rotated[0].x+midx, (int)poly->vertices_local_rotated[0].y+midy,
		(int)poly->vertices_local_rotated[2].x+midx, (int)poly->vertices_local_rotated[2].y+midy, 
		(int)poly->vertices_local_rotated[3].x+midx, (int)poly->vertices_local_rotated[3].y+midy,
                 0, 0, SHIP_WIDTH-1, SHIP_HEIGHT-1, SHIP_WIDTH-1, 0, 1);

} // end Draw_Ship

// This is the routine that rotates the points of the polygon representing
// the corners of the rectangular box that it's in

// I use 2 different types of local coordinates here:
//    vertices_local_original and
//    vertices_local_rotated ...
//
// I use 2 different sets of vertx points because I like 
// to keep the original unrotated objects in memory, since, if
// there aren't too many polys - they don't take up alot of space
// and can be useful.

void Rotate_Ship(polygon_ptr poly, int angle)
{
	int index;

	float si,cs,
		  rx,ry;

	// there's a little trigonometry going on here
	// your new x coordinate for a vertex is:
	//  oldx * cos(angle in radians) + oldy * sin(angle in radians)
	// and your new y coordinate for a vertex is:
	//  oldy * cos(angle in radians) + oldx * sin(angle in radians)

	si = sin_look[angle];
	cs = cos_look[angle];

	// loop through all 4 polygon vertices

	for (index=0; index<4; index++)
	{
		rx = poly->vertices_local_original[index].x *
			cs - poly->vertices_local_original[index].y * si;

		ry = poly->vertices_local_original[index].y *
			cs + poly->vertices_local_original[index].x * si;

		// put the info into vertices_local_rotated

		poly->vertices_local_rotated[index].x = rx;
		poly->vertices_local_rotated[index].y = ry;
	} // end for index
} // end Rotate_Ship

// Initialize sine and cosine tables so we don't have to
// call sin() and cos() functions while this program is running
// they'll be used not only for the rotation of points, but also
// for the flight of the ship

void Init_Rotation_and_Movement_Tables(void)
{
	int index;
    double converted_to_radians;

	for (index = 0; index<=360; index++)
	{
		converted_to_radians = (double)index*3.14159/(double)180;

		cos_look[index] = (float)cos(converted_to_radians);
		sin_look[index] = (float)sin(converted_to_radians);
	} // end for index
} // end for Init_Rotation_and_Movement_Tables

// I talk a lot about polygon graphics in my djgpp "tutorials"
// so I won't go into it alot here
void Draw_Triangle(int x1, int y1, int x2, int y2, int x3, int y3,
                 int t1x, int t1y, int t2x, int t2y, int t3x, int t3y, int text_shade)
{
	// this function draw a textured-triangle on the screen,
    // AND is set to use flat shading (thanks to a clut palette
    // we've set up...

    int     right_1,                // distance from top to middle of triangle on y axis
	right_2;		// distance from middle to bottom triangle on y axis


    float width;           // the of the triangle (or a subdivision of it)
          
    int column;          // looping variables

    // the following floats are used for keeping track of where the
    // edges of the triange, and the texture being used are...

    float edge_y1,edge_y2;
    float edge_u1,edge_u2,edge_v1,edge_v2;

    // these are to store the incremental changes in the edges
    // of the triangle AND the area of a given texture where
    // pixels are being sampled from...

    float dx_u1,dx_u2,dx_v1,dx_v2,dx_y1,dx_y2;

    // current UxV coordinates in a given texture

    float u1,u2,u3,v1,v2,v3;

    // used in sorting texture coordinates

    int temp_x, temp_y;
    float temp_u, temp_v;
    int min_x, max_x;

    // assign the texture to a pointer

// lay out uv coordinates (step in a half step...)

    u1 = (float)(t1x+0.5);
    v1 = (float)(t1y+0.5);
    u2 = (float)(t2x+0.5);
    v2 = (float)(t2y+0.5);
    u3 = (float)(t3x+0.5);
    v3 = (float)(t3y+0.5);

// sort vertices by x values...

    if (x2<x1)	// sort p1,p2,p3 in ascending x order	if (x2<x1)
    {
        temp_x = x2;
        temp_y = y2;
        x2 	   = x1;
        y2     = y1;
        x1     = temp_x;
        y1     = temp_y;
        temp_u = u2;
        temp_v = v2;
        u2 = u1;
        v2 = v1;
        u1 = temp_u;
        v1 = temp_v;

    } // end if

    // now we know that p1 and p2 are in order

    if (x3<x1)
    {
        temp_x = x3;
        temp_y = y3;
        x3 	   = x1;
        y3     = y1;
        x1     = temp_x;
        y1     = temp_y;
        temp_u = u3;
        temp_v = v3;
        u3 = u1;
        v3 = v1;
        u1 = temp_u;
        v1 = temp_v;


    } // end if

    // finally test x3 against x2

    if (x3<x2)
    {
        temp_x = x3;
        temp_y = y3;
        x3     = x2;
        y3     = y2;
        x2     = temp_x;
        y2     = temp_y;
        temp_u = u3;
        temp_v = v3;
        u3     = u2;
        v3     = v2;
        u2     = temp_u;
        v2     = temp_v;

    } // end if


    width = (float)(x3-x1);
    if(!((int)width)) return; // this might be redundant, but we won't draw
                       // vertical lines

    // compute the change in y, u, and z for the longest side of the
    // triangle (with respect to x)

    dx_y1=(float)(y3-y1)/width;
    dx_u1=(float)(u3-u1)/width;
    dx_v1=(float)(v3-v1)/width;

    // setup starting coords (world and UV)

    edge_y1=(float)y1;
    edge_u1=u1;
    edge_v1=v1;


    right_1 = x2;       // point where the triangle may be split horizontally
                        // to make 2 triangles...

    right_2 = x3;       // the rightmost point of the triangle


    width = (float)(x2-x1);

    if ((int)width) // then draw left pointing triangle
    {
        dx_y2=(float)(y2-y1)/width;  // change in y
        dx_u2=(float)(u2-u1)/width;  // change in u (texture space)
        dx_v2=(float)(v2-v1)/width;  // change in v (texture space)

        edge_y2=edge_y1;  // if we're starting with the left side
        edge_u2=edge_u1;  // of the triangle, we're starting with the
        edge_v2=edge_v1;  // same point!

        // compute starting texture coordinates

        // perform x clipping

        if (x1<0)
        {
            if (x2<0) // if the second point is ALSO off
            {                       // the left hand side of the screen
                edge_y1+=dx_y1 * (float)(-x1+x2);   // this adjust for it...
                edge_y2+=dx_y2 * (float)(-x1+x2);
                edge_u1+=dx_u1 * (float)(-x1+x2);
                edge_u2+=dx_u2 * (float)(-x1+x2);
                edge_v1+=dx_v1 * (float)(-x1+x2);
                edge_v2+=dx_v2 * (float)(-x1+x2);
            }
            else
            {
                edge_y1+=dx_y1 * (float)(-x1);
                edge_y2+=dx_y2 * (float)(-x1);
                edge_u1+=dx_u1 * (float)(-x1);
                edge_u2+=dx_u2 * (float)(-x1);
                edge_v1+=dx_v1 * (float)(-x1);
                edge_v2+=dx_v2 * (float)(-x1);
            }
            min_x = 0;
        }
        else
            min_x=x1;

        if (right_1>=iScreenWidth)
            max_x=iScreenWidth-1;
        else
            max_x=right_1;

        // draw a vertical - textured - strip

        for (temp_x=min_x; temp_x<max_x; temp_x++)
        {
            // start off working texture coordinates for current row


            column = temp_x; // leftover from planar stuff...

            Vert_Scan_Text (column, (int)edge_y1, (int)edge_y2, (int)edge_u1,
                                  (int)edge_u2, (int)edge_v1, (int)edge_v2, text_shade);


            // step along 2 edges, both in screen coordinates
            // AND texture coordinates

            edge_y1+=dx_y1;
            edge_y2+=dx_y2;
            edge_u1+=dx_u1;
            edge_u2+=dx_u2;
            edge_v1+=dx_v1;
            edge_v2+=dx_v2;

        } // end for

    } // end drawing left side of triangle
    else
    {   // since we didn't start with a left pointing triangle
        edge_y2=(float)y2;    // we initialize the second edges to
        edge_u2=u2;    // point #2
        edge_v2=v2;
    }

    width = (float)(x3-x2);

    if ((int)width)
    {
        // get changes in y, u, and v with respect to x

        dx_y2=(float)(y3-y2)/width;
        dx_u2=(float)(u3-u2)/width;
        dx_v2=(float)(v3-v2)/width;

        // perform x clipping

        if (x2<0)
        {
            if (x3<0) return;

            edge_y1+=dx_y1 * (float)(-x2);
            edge_y2+=dx_y2 * (float)(-x2);
            edge_u1+=dx_u1 * (float)(-x2);
            edge_u2+=dx_u2 * (float)(-x2);
            edge_v1+=dx_v1 * (float)(-x2);
            edge_v2+=dx_v2 * (float)(-x2);

            min_x = 0;
        }
        else
            min_x=x2;

        if (right_2>=iScreenWidth)
            max_x=iScreenWidth-1;
        else
            max_x=right_2;


        // draw the triangle

        for (temp_x=min_x; temp_x<=max_x; temp_x++)
        {
            column = temp_x;   // leftover from planar stuff

            // start off working texture coordinates for current column

            Vert_Scan_Text (column, (int)edge_y1, (int)edge_y2, (int)edge_u1,
                                  (int)edge_u2, (int)edge_v1, (int)edge_v2, text_shade);

            // move to the next steps in the top and bottom edges
            // of the triangle, and the u,v coords.. with respect to X

            edge_y1+=dx_y1;
            edge_y2+=dx_y2;
            edge_u1+=dx_u1;
            edge_u2+=dx_u2;
            edge_v1+=dx_v1;
            edge_v2+=dx_v2;
        } // end for

    } // end if draw right side of triangle
} // end Draw_Triangle

// this routine draws our textured lines, it uses vertical scan conversion
// because I'm a sick freak!

void Vert_Scan_Text(int column, int e_y1, int e_y2, int e_u1,
                                int e_u2, int e_v1, int e_v2, int text_shade)
{
    int pu1,pu2,pv1,pv2,py1,py2;

    int i;    // looping variable
    float linewidth; // used in the final drawing of a vertical strip

    long  uwidth,
          vwidth;

    long du,dv,u_curr,v_curr;	// the current u,v texture coordinates
    
    int     x_index,   // looping variables
    	    y_index;
    int vert_strip;          // looping variables

    WORD iUnMasked;

    // start off working texture coordinates for current row
    
    py1 = e_y1;
    py2 = e_y2;
    pu1 = e_u1;
    pu2 = e_u2;
    pv1 = e_v1;
    pv2 = e_v2;
    
    // sort edges...
    if(py2<py1)
    {
        i=py1;
        py1=py2;
        py2=i;
    
        i=pu1;
        pu1=pu2;
        pu2=i;
    
        i=pv1;
        pv1=pv2;
        pv2=i;
    }
    
    // assign starting UxV coordinates
    
    u_curr = pu1<<16;
    v_curr = pv1<<16;
    
    linewidth=(float)(py2-py1);
    uwidth=pu2-pu1;
    vwidth=pv2-pv1;
    
    // calculate du,dv with respect to y
    
    du=(long)((uwidth<<16)/(linewidth+1));
    dv=(long)((vwidth<<16)/(linewidth+1));
    
    // clip texture as needed
    
    if (py1<0)
    {
        u_curr += (long)(du * (float)(-py1));
        v_curr += (long)(dv * (float)(-py1));
    
        py1 = 0;
    }
    
    if (py2 >=iScreenHeight) 
		py2 = (iScreenHeight-1);
    
    // compute offset in the double buffer

    
    // render a verticle strip already!
    for (vert_strip=(int)py1; vert_strip <= (int)py2; vert_strip++)
    {
        // extract coordinates where a color will be copied
        // from in the texture...
    
        x_index = (int)(u_curr>>16);
        y_index = (int)(v_curr>>16);

        // extract pixel
        
        iUnMasked = SpriteRGB16[x_index + (y_index*SHIP_WIDTH)];
		
		if ( iUnMasked )
            PlotPixel(column, vert_strip, iUnMasked);	// draw graphics
         // move one line down in the video_buffer
    
        // move to the next next (u,v) coordinate for the
        // texture to be used in this strip
    
        u_curr+=du;
        v_curr+=dv;
    }
} // end Vert_Scan_Text

// code modified from code by Sam Christiansen  (schristi@cs.utexas.edu)

                
static BOOL locked = FALSE;
static LPVOID lockedSurf = NULL;
static int lockedWidth = 0;
static int lockedHeight = 0;


//Must run this proc to fill the RGB16 struct with the information needed to plot a pixel

// if you intent to use Make16bitRGBColor(), you have to call GetRGB16 once
// at the start of the program...

// I don't call this in the TILED3 project at all though

BOOL GetRGB16 ( LPDIRECTDRAWSURFACE Surface, RGB16 *rgb16)
{
    DDSURFACEDESC   ddsd;
    BYTE shiftcount;
    //get a surface description
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_PIXELFORMAT;
 
	if (Surface->GetSurfaceDesc ( &ddsd ) != DD_OK )
        return FALSE;

    //get red
    shiftcount = 0;


	char rc=0, gc=0, bc=0;

	for(int n = 1; n<65536; n<<=1) 
	{ 
        if(ddsd.ddpfPixelFormat.dwRBitMask & n) 
			++rc;
        if(ddsd.ddpfPixelFormat.dwGBitMask & n) 
			++gc;
        if(ddsd.ddpfPixelFormat.dwBBitMask & n) 
			++bc;
	}


    rgb16->dwRBitMask = ddsd.ddpfPixelFormat.dwRBitMask;
    rgb16->Position.rgbRed = gc + bc;

    rgb16->dwGBitMask = ddsd.ddpfPixelFormat.dwGBitMask;
    rgb16->Position.rgbGreen = bc;

    rgb16->dwBBitMask = ddsd.ddpfPixelFormat.dwBBitMask;
    rgb16->Position.rgbBlue = 0;

    return TRUE;
}//GetRBG16


// this routine makes a 16-bit color from sent RGB values,
// GetRGB16 must be called once  before you can begin using this routine
// as cards differ as to the distribution of bits in a 16-bit color

// USAGE:
//       WORD a16bitcolor = Make16bitRGBColor(255,0,0,&myrgb16);
//       PlotPixel (10, 10, a16bitcolor)
 
WORD Make16bitRGBColor(int r, int g, int b, RGB16 *rgb16)
{
    WORD Pixel;

    Pixel = (r << rgb16->Position.rgbRed) |
            (g << rgb16->Position.rgbGreen) |
            (b);// << rgb16->Position.rgbBlue);
    return(Pixel);
} // end Make16bitRGBColor


