extern RGB16 myrgb16;

// polydraw.h source file, function prototypes for polydraw.cpp

// routines for rotation and movement

void Init_Rotation_and_Movement_Tables(void);
void Rotate_Ship(polygon_ptr poly, int angle);
void Draw_Ship(polygon_ptr poly, int midx, int midy);

// textured polygon drawing routines

void Draw_Triangle(int x1, int y1, int x2, int y2, int x3, int y3,
                 int t1x, int t1y, int t2x, int t2y, int t3x, int t3y, int text_shade);

void Vert_Scan_Text(int column, int e_y1, int e_y2, int e_u1,
                                int e_u2, int e_v1, int e_v2, int text_shade);

// Must have the surface locked, pass the surface description 
// that gets returned from the lock call
void PlotPixel(int x, int y, WORD pixel);

// code from or modified from code original made by
// Sam Christiansen  (schristi@cs.utexas.edu)

#ifndef _PIXEL_H
#define _PIXEL_H

//Must run this proc to fill the RGB16 struct with the information needed to plot a pixel
BOOL GetRGB16 ( LPDIRECTDRAWSURFACE Surface, RGB16* rgb16);


// Must have the surface locked, pass the surface description 
// that gets returned from the lock call
WORD Make16bitRGBColor(int r, int g, int b, RGB16 *rgb16);

#endif