// DDFramw.cpp : implementation file
//

#include "stdafx.h"
#include "videoexample.h"
#include "DDFramw.h"
#include "standartmacros.h"
#include "dderrmsg.h"
#include "aboutbox.h"

#define XRES 512
#define YRES 384


#undef THIS_FILE
static char THIS_FILE[] = __FILE__;


/////////////////////////////////////////////////////////////////////////////
// CDDFramw

IMPLEMENT_DYNCREATE(CDDFramw, CFrameWnd)

CDDFramw::CDDFramw()
{
	// We want a clean start
	m_lpDD = 0;
	m_lpClipper = 0;
	m_lpDDSPrimaryBack = 0;
	m_lpDDSPrimary = 0;
	m_lpDS = 0;
	m_lpasMovie = 0;
	m_iTopAdd = GetSystemMetrics(SM_CYMENU)+GetSystemMetrics(SM_CYCAPTION)+GetSystemMetrics(SM_CYFRAME);
	m_iLeftAdd =  GetSystemMetrics(SM_CXFRAME);
	m_bBlow = FALSE;
}

CDDFramw::~CDDFramw()
{
}


BEGIN_MESSAGE_MAP(CDDFramw, CFrameWnd)
	//{{AFX_MSG_MAP(CDDFramw)
	ON_COMMAND(IDHELP, OnAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(CM_FULL, OnFull)
	ON_COMMAND(CM_SMALL, OnSmall)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDDFramw message handlers

void CDDFramw::UpdateFrame()
{
  RECT rcBackTarget={0,0,XRES,YRES};
  HRESULT ddrval;
  RECT rcWindow;
  // This you should do outside 
  GetWindowRect(&rcWindow);

  rcWindow.top    += m_iTopAdd;
  rcWindow.left   += m_iLeftAdd;
  rcWindow.bottom += m_iTopAdd;
  rcWindow.right  += m_iLeftAdd;

    
  ddrval = m_lpDDSPrimary->Blt(
                    &rcWindow,              // dest rect
                    m_lpDDSPrimaryBack,     // src surface
                    NULL,                   // src rect (all of it)
                    DDBLT_WAIT,
                    NULL);
 
   if (m_lpasMovie)
   {
	   // Now draw the new Video-Frame to the Backbuffer
	   if (m_bBlow)
	   {
		 m_lpasMovie->StretchBlitTo(&rcBackTarget,m_lpDDSPrimaryBack);
	   }
	   else
	   {
          m_lpasMovie->BlitTo(0,0,m_lpDDSPrimaryBack);
	   }
	   
   }
}

BOOL CDDFramw::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	dwDefaultStyle = WS_VISIBLE |    // so we dont have to call ShowWindow
                     WS_SYSMENU |    // so we get a icon in in our tray button
					 WS_CAPTION |
                     WS_POPUP;

	
	if (!CFrameWnd::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext))
    {
	  // Da war dann wohl ein interner Fehler
	  MessageBox("CWnd::Create fehlgeschlagen",NULL,MB_OK);
	  return FALSE;
    }
	try {
		// We want DirectSound
	    CreateSoundStuff();
        // And We want DirectDraw
	    CreateDrawStuff();
	}
	catch (exception &x)
	{
		// Give it all up
		DestroyDrawStuff();
		DestroySoundStuff();
		MessageBox(x.what(),NULL,MB_OK);
		return FALSE;
	}
	return TRUE;

}

void CDDFramw::CreateSoundStuff()
{
   if (DirectSoundCreate(NULL,&m_lpDS,NULL)!=DS_OK)
	   throw exception("Direct Sound creation failed");
   if (m_lpDS->SetCooperativeLevel(m_hWnd,DSSCL_NORMAL)!=DS_OK)
	   throw exception("Unable to set Cooperative Level");
}

void CDDFramw::CreateDrawStuff()
{
   HRESULT ddrval;
   DDSURFACEDESC ddsd;
   DDSD_STANDARTINIT(ddsd);	

   if ((ddrval=DirectDrawCreate(NULL,&m_lpDD,NULL))!=DD_OK)
      throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));

   SetWindowPos(NULL, 0, 0, XRES,YRES,SWP_SHOWWINDOW|SWP_NOZORDER);

  
   if ((ddrval=m_lpDD->SetCooperativeLevel(m_hWnd,DDSCL_NORMAL))!=DD_OK)
       throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));
  
        //
        //  window case, create the primary surface
        //  and create a backbuffer 
        //
   ddsd.dwFlags = DDSD_CAPS;
   ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
   ddsd.dwFlags = DDSD_CAPS;
   

   if ((ddrval = m_lpDD->CreateSurface(&ddsd, &m_lpDDSPrimary, NULL ))!=DD_OK)
      throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));

   
   ddsd.dwFlags = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
   ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
   ddsd.dwHeight = YRES;
   ddsd.dwWidth = XRES;
   if ((ddrval = m_lpDD->CreateSurface(&ddsd, &m_lpDDSPrimaryBack, NULL ))!=DD_OK)
      throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));
   
        //
        // now create a DirectDrawClipper object.
        //
   if ((ddrval = m_lpDD->CreateClipper(0, &m_lpClipper, NULL))!=DD_OK)
      throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));
   
   if ((ddrval = m_lpClipper->SetHWnd(0,m_hWnd))!=DD_OK)
      throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));

   if ((ddrval = m_lpDDSPrimary->SetClipper(m_lpClipper))!=DD_OK)
      throw exception(DDErrCodeToString(ddrval,__FILE__,__LINE__));

}

void CDDFramw::DestroySoundStuff()
{
   if (m_lpDS)
   {
     m_lpDS->Release();
	 m_lpDS = 0;
   }
}

void CDDFramw::DestroyDrawStuff()
{
	if (!m_lpDD) 
		return; // Everything is released ...
	if (m_lpClipper)
	   m_lpClipper->Release();
	if (m_lpDDSPrimaryBack)
	   m_lpDDSPrimaryBack->Release();
	if (m_lpDDSPrimary)
	   m_lpDDSPrimary->Release();
	m_lpDD->Release();
	m_lpDD = 0;

}

BOOL CDDFramw::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	if (m_lpasMovie)
	{
		m_lpasMovie->Stop();
		delete m_lpasMovie;
	}
	DestroyDrawStuff();	
	DestroySoundStuff();
	return CFrameWnd::DestroyWindow();
}

void CDDFramw::OnAbout() 
{
	// TODO: Add your command handler code here
	CAboutBox(this).DoModal();
}

void CDDFramw::OnFileOpen() 
{
	// TODO: Add your command handler code here
	BOOL bWithSound=TRUE;
	CFileDialog fdOpenFile(TRUE,"*.avi",NULL,OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST, "Video - Files (*.avi)|*.avi", this);
	if (fdOpenFile.DoModal()==IDOK)
	{
		CString strHelp = fdOpenFile.GetPathName();
		LPSTR szHelp= strHelp.GetBuffer(10);
		if (m_lpasMovie)
		{
			m_lpasMovie->Stop();
			delete m_lpasMovie;
			m_lpasMovie = 0;
		}
		try {
			m_lpasMovie = new CAviSurfaceWithSound(szHelp,m_lpDD,m_lpDS,TRUE);
		}
		catch (exception &)
		{
			bWithSound = FALSE;
			try {
			   m_lpasMovie = new CAviSurface(szHelp,m_lpDD,TRUE);
		    }
		    catch (exception &x)
		    {
			  MessageBox(x.what(),NULL,MB_OK);
			  return;
		    }
		}
/*		if (!bWithSound)
			MessageBox("AVI has no Sound","Info",MB_OK);*/
		m_lpasMovie->Start();
	}
}

void CDDFramw::OnFull() 
{
	// TODO: Add your command handler code here
	m_bBlow = TRUE;
	
}

void CDDFramw::OnSmall() 
{
	// TODO: Add your command handler code here
	m_bBlow = FALSE;
	
}
