#include "stdafx.h"
#include "avisurface.h"
#include "standartmacros.h"
#include "dderrmsg.h"

CAviSurface::CAviSurface(char *lpszFilename,LPDIRECTDRAW lpDDraw,BOOL bLoop)
{
	AVIFileInit();  
	m_bLoop = bLoop;               
	m_lIndex = 0;
	m_lpAviSurface = 0;
	m_pasMovie = 0;
	ZeroMemory(&m_asiMovie,sizeof(m_asiMovie));
	m_lIndex = m_lFrames = 0;
	m_hicDecompressor = 0;
	m_lpInput=m_lpOutput = 0;
	if (AVIStreamOpenFromFile(&m_pasMovie,lpszFilename,streamtypeVIDEO,
		0,OF_READ,NULL)) {
		AVIFileExit();
#ifdef _DEBUG
		afxDump << "File " << __FILE__ << " Line: " << __LINE__
			      << " unable to  open Avi-File" << lpszFilename <<"\n";
#endif
		throw exception("AVI-File not found");
	}
	m_dwColorKeyFlagFast = DDBLTFAST_NOCOLORKEY;
	m_dwColorKeyFlag = 0;
	if (!Init(lpDDraw))	{
		Close();
		throw exception("AVI Init failed");
	}
	InitializeCriticalSection(&m_csAccessBuffer);
}

CAviSurface::~CAviSurface()
{
	DeleteCriticalSection(&m_csAccessBuffer);
	Close();
	AVIFileExit();
}

BOOL CAviSurface::Init(LPDIRECTDRAW lpDDraw)
{
	LONG lFmtLenght;
	DDSURFACEDESC ddsd;
	int ddrval;
	
	AVIStreamFormatSize(m_pasMovie,0,&lFmtLenght);
	m_lpScrFmt = (LPBITMAPINFOHEADER)malloc(lFmtLenght);
	m_lpb4hTargetFmt = (LPBITMAPV4HEADER)malloc(max(lFmtLenght,
		    sizeof(BITMAPV4HEADER)));
	ZeroMemory(m_lpb4hTargetFmt,sizeof(BITMAPV4HEADER));
	AVIStreamReadFormat(m_pasMovie,0,m_lpScrFmt,&lFmtLenght);
	m_lFrames = AVIStreamLength(m_pasMovie);
	AVIStreamInfo(m_pasMovie,&m_asiMovie,sizeof(AVISTREAMINFO));
	
	DDSD_STANDARTINIT(ddsd);
	ddsd.dwWidth = m_lpScrFmt->biWidth;
    ddsd.dwHeight  = m_lpScrFmt->biHeight;
	ddsd.dwFlags = DDSD_WIDTH|DDSD_HEIGHT|DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE|DDSCAPS_SYSTEMMEMORY;
    
    ddrval=lpDDraw->CreateSurface(&ddsd,&m_lpAviSurface,0);
	 
	if (ddrval!=DD_OK) {
#ifdef _DEBUG
		afxDump << DDErrCodeToString(ddrval,__FILE__,__LINE__);
#endif
		return FALSE;
	}

	m_lpAviSurface->GetSurfaceDesc(&ddsd);

	memcpy(m_lpb4hTargetFmt,m_lpScrFmt,lFmtLenght);

	m_lpb4hTargetFmt->bV4Size = max(lFmtLenght,sizeof(BITMAPV4HEADER));
	m_lpb4hTargetFmt->bV4BitCount = ddsd.ddpfPixelFormat.dwRGBBitCount;
	m_lpb4hTargetFmt->bV4V4Compression = BI_BITFIELDS;
    if (m_lpb4hTargetFmt->bV4BitCount==24)
		 m_lpb4hTargetFmt->bV4V4Compression = BI_RGB;

    m_lpb4hTargetFmt->bV4ClrUsed = 0;

	m_lpb4hTargetFmt->bV4RedMask   = ddsd.ddpfPixelFormat.dwRBitMask;
    m_lpb4hTargetFmt->bV4GreenMask = ddsd.ddpfPixelFormat.dwGBitMask;
    m_lpb4hTargetFmt->bV4BlueMask  = ddsd.ddpfPixelFormat.dwBBitMask;
    m_lpb4hTargetFmt->bV4AlphaMask = ddsd.ddpfPixelFormat.dwRGBAlphaBitMask;
	m_lpb4hTargetFmt->bV4SizeImage = 
		   ((m_lpb4hTargetFmt->bV4Width +3)&0xFFFFFFFC) *
		     m_lpb4hTargetFmt->bV4Height *
			   (m_lpb4hTargetFmt->bV4BitCount>>3);
   
	m_lLength = m_lpScrFmt->biWidth *
		        m_lpScrFmt->biHeight *
				(m_lpScrFmt->biBitCount >> 3);

	if (m_asiMovie.dwSuggestedBufferSize)
		 m_lLength = (LONG)m_asiMovie.dwSuggestedBufferSize;
	
	m_hicDecompressor = ICDecompressOpen(ICTYPE_VIDEO,
		      m_asiMovie.fccHandler,m_lpScrFmt,
			        (LPBITMAPINFOHEADER)m_lpb4hTargetFmt);

	m_lpInput = (BYTE *)calloc(m_lLength,1);
	ZeroMemory(m_lpInput,m_lLength);
	m_lpOutput = (BYTE *)calloc(m_lpb4hTargetFmt->bV4SizeImage,1);
	ZeroMemory(m_lpOutput,m_lpb4hTargetFmt->bV4SizeImage);
	
	if (!m_hicDecompressor)	{
#ifdef _DEBUG
		afxDump << "File: " << __FILE__ << "Line: " << 
			__LINE__ <<": Unable to create decompressor\n";
#endif
		return FALSE;
	}
	m_lLinePitch = m_lpb4hTargetFmt->bV4Width *
		     		   (m_lpb4hTargetFmt->bV4BitCount>>3);
	ICDecompressBegin(m_hicDecompressor,m_lpScrFmt,
		          (LPBITMAPINFOHEADER)m_lpb4hTargetFmt);
    m_dwFps = m_asiMovie.dwRate/m_asiMovie.dwScale;

	m_iTimeTick = (1000*m_asiMovie.dwScale + 
		              (m_asiMovie.dwRate>>1)) /m_asiMovie.dwRate;

	m_rcSrc.left= 0;
	m_rcSrc.top = 0;
	m_rcSrc.right = m_lpb4hTargetFmt->bV4Width;
	m_rcSrc.bottom = m_lpb4hTargetFmt->bV4Height;

	return TRUE;
}

void CAviSurface::Close()
{
	if (m_hicDecompressor)	{
	  ICDecompressEnd(m_hicDecompressor);
	  ICClose(m_hicDecompressor);
	}
	if (m_lpAviSurface)
       m_lpAviSurface->Release();
	if (m_lpScrFmt)       free(m_lpScrFmt);
	if (m_lpb4hTargetFmt) free(m_lpb4hTargetFmt);
	if (m_lpInput)        free(m_lpInput);
	if (m_lpOutput)       free(m_lpOutput);
	AVIStreamRelease(m_pasMovie);
}

HRESULT CAviSurface::GetNextFrame()
{
	if (!m_bRunning) 
		return -1;
	m_lIndex++;
	if ((m_lIndex==m_lFrames)&&m_bLoop)
		m_lIndex = 0;
	ReadFrame(m_lIndex);
	return 0; 
}

HRESULT CAviSurface::BlitTo(int x,int y,LPDIRECTDRAWSURFACE lpddsTarget)
{ 
	HRESULT ddrval;
	if ((ddrval = DrawBuffer())!=DD_OK)
		return ddrval;
	return lpddsTarget->BltFast(x,y,m_lpAviSurface,&m_rcSrc,
		                     m_dwColorKeyFlagFast|DDBLTFAST_WAIT);
}


HRESULT CAviSurface::StretchBlitTo(RECT *rcTarget,LPDIRECTDRAWSURFACE lpddsTarget)
{
	HRESULT ddrval;
	if ((ddrval = DrawBuffer())!=DD_OK)
		return ddrval;
    return  lpddsTarget->Blt(rcTarget,m_lpAviSurface,&m_rcSrc,
		      m_dwColorKeyFlag|DDBLT_WAIT,NULL);
}

void CALLBACK GetFrameTimeProc(UINT, UINT, DWORD dwAviSurface, DWORD, DWORD)
{
	((CAviSurface *)dwAviSurface)->GetNextFrame();
}

BOOL CAviSurface::Start()
{
	m_iTimerID = timeSetEvent(m_iTimeTick,5,GetFrameTimeProc,
		(ULONG)this,TIME_PERIODIC);
	m_bRunning = (m_iTimerID!=0);
	CAviSurface::ReadFrame(0);
	return m_bRunning;
}

BOOL CAviSurface::Stop()
{
	m_bRunning=FALSE;
	timeKillEvent(m_iTimerID);
	return TRUE;
}

HRESULT CAviSurface::DrawBuffer(void)
{
    DDSURFACEDESC ddsd;
	HRESULT ddrval;
	ddsd.dwSize = sizeof(ddsd);
	
	ddrval = m_lpAviSurface->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);
	LPBYTE lpbSRC = m_lpOutput + m_lLinePitch * (m_lpb4hTargetFmt->bV4Height-1);
	LPBYTE lpDest =(LPBYTE)ddsd.lpSurface;
	if( ddrval == DD_OK ) {
		EnterCriticalSection(&m_csAccessBuffer);
		for(int y=0; y<(int)m_lpb4hTargetFmt->bV4Height;y++ ) {
			memcpy(lpDest, lpbSRC, m_lLinePitch);
			lpDest += ddsd.lPitch;
			lpbSRC -= m_lLinePitch;
		}
		LeaveCriticalSection(&m_csAccessBuffer);
		ddrval = m_lpAviSurface->Unlock(NULL);
	}
	return ddrval;
}

HRESULT CAviSurface::ReadFrame(LONG iFrame)
{
	if (!m_bRunning) 
		return 0;
	if (iFrame<m_lFrames) {
	  AVIStreamRead(m_pasMovie, iFrame, 1, m_lpInput, m_lLength, NULL, NULL);
	  EnterCriticalSection(&m_csAccessBuffer);	
	  ICDecompress(m_hicDecompressor, 0, m_lpScrFmt, m_lpInput, 
		  (LPBITMAPINFOHEADER)m_lpb4hTargetFmt, m_lpOutput);
	  LeaveCriticalSection(&m_csAccessBuffer);
	}
	return DD_OK;
}

HRESULT CAviSurface::SetColorKey(DWORD dwColorKey)
{
	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue = dwColorKey;
	ddck.dwColorSpaceHighValue = dwColorKey;
	m_dwColorKeyFlagFast = DDBLTFAST_SRCCOLORKEY;
	m_dwColorKeyFlag = DDBLT_KEYSRC;
	return m_lpAviSurface->SetColorKey(DDCKEY_SRCBLT,&ddck);
}

CAviSurfaceWithSound::CAviSurfaceWithSound(char *lpszFilename,
			      LPDIRECTDRAW lpDDraw,LPDIRECTSOUND lpDS,BOOL bLoop)
		:CAviSurface(lpszFilename,lpDDraw,bLoop)
{
	ZeroMemory(&m_pasSound,sizeof(m_pasSound));

	m_lpSoundScrFmt = 0;
	m_lpdsbTon =0;
	
	if (AVIStreamOpenFromFile(&m_pasSound,lpszFilename,streamtypeAUDIO,
		0,OF_READ,NULL)) {
	    AVIFileExit();
#ifdef _DEBUG
		afxDump << "File " << __FILE__ << "Line: " << __LINE__
			      << " Unable to open Soundstream in Avi-File" << 
				    lpszFilename << "\n";
#endif
		throw exception("Soundstream in AVI-File not found");
	}
	m_iSoundFramesAhead = 0;

	if (!InitSound(lpDS)) {
		exception("InitSound failed for AVI-File");
	}
}

CAviSurfaceWithSound::~CAviSurfaceWithSound() 
{
	CloseSound();
}

HRESULT CAviSurfaceWithSound::GetFrameSound()
{
	DWORD dwSize1,dwSize2;
	BYTE *Data1,*Data2;
	HRESULT dsrval;

	dsrval = m_lpdsbTon->Lock(m_dwLoadPos*m_dwLoadSize,
		                m_dwLoadSize,&Data1,&dwSize1,&Data2,&dwSize2,0);
    if (dsrval!=DS_OK)
       		return dsrval;
	AVIStreamRead(m_pasSound,m_lIndex*m_dwLoadSize>>1,
		                m_dwLoadSize>>1,Data1,m_dwLoadSize,NULL,NULL);
	dsrval=m_lpdsbTon->Unlock(Data1,dwSize1,Data2,dwSize2);
	m_dwLoadPos++;
	m_dwLoadPos%=m_dwFps;
	return dsrval; 
}

HRESULT CAviSurfaceWithSound::ReadFrame(LONG iFrame)
{
	if (iFrame - m_iSoundFramesAhead < 0)
		return 0;
	return CAviSurface::ReadFrame(iFrame - m_iSoundFramesAhead);
}

HRESULT CAviSurfaceWithSound::GetNextFrame()
{
	if (!m_bRunning)
		return -1;
	GetFrameSound(); 
	m_lIndex++;
	if (m_lIndex==m_lFrames) {
		timeKillEvent(m_iTimerID);
		Sleep(m_iTimeTick); // Wait for the Sound be played
		m_lpdsbTon->Stop();
		if (m_bLoop) {
          m_iTimerID = timeSetEvent(m_iTimeTick,5,GetFrameTimeProc,
			                                 (ULONG)this,TIME_PERIODIC);
          m_lIndex = 0;
		  m_dwLoadPos = 0;
		  m_lpdsbTon->SetCurrentPosition(0);
		  GetFrameSound(); 
		  m_lpdsbTon->Play(0,0,DSBPLAY_LOOPING);
		}
	}
	return ReadFrame(m_lIndex);
}

BOOL CAviSurfaceWithSound::InitSound(LPDIRECTSOUND lpDS)
{
	LONG lFmtLenght;
	DSBUFFERDESC dsbd;

	AVIStreamFormatSize(m_pasSound,0,&lFmtLenght);
	m_lpSoundScrFmt = (WAVEFORMATEX *)malloc(lFmtLenght);
	
	AVIStreamReadFormat(m_pasSound,0,m_lpSoundScrFmt,&lFmtLenght);
	
//	m_lFrames = AVIStreamLength(m_pasSound);

	AVIStreamInfo(m_pasSound,&m_asiSound,sizeof(AVISTREAMINFO));

	m_dwLoadSize = (m_lpSoundScrFmt->nAvgBytesPerSec + m_dwFps - 1 ) / m_dwFps;

	dsbd.dwSize = sizeof(dsbd);
    dsbd.dwFlags = 0;
    dsbd.dwBufferBytes = m_dwLoadSize * m_dwFps;

    dsbd.dwReserved = 0;
    dsbd.lpwfxFormat = m_lpSoundScrFmt;
	m_lpdsbTon = 0;
	if (lpDS->CreateSoundBuffer(&dsbd,&m_lpdsbTon,NULL)!=DS_OK) {
		CloseSound();
		return FALSE;
	}
	m_dwLoadPos = 0;

	return TRUE;
}

void CAviSurfaceWithSound::CloseSound()
{
    if (m_lpSoundScrFmt) free(m_lpSoundScrFmt);
	if (m_lpdsbTon)
	   m_lpdsbTon->Release();
}

BOOL CAviSurfaceWithSound::Start()
{
	GetFrameSound();
	if (!CAviSurface::Start())
		return FALSE;
	m_iSoundFramesAhead = m_asiSound.dwInitialFrames/m_asiSound.dwScale;
	return (m_lpdsbTon->Play(0,0,DSBPLAY_LOOPING)==DS_OK);
}

BOOL CAviSurfaceWithSound::Stop() 
{
	Sleep(30);
	m_lpdsbTon->Stop();
	return CAviSurface::Stop();
}

