#ifndef __AVISURFACE_H
#define __AVISURFACE_H
#include <vfw.h>

class CAviSurface 
{
protected:
	HRESULT DrawBuffer(void);
	BOOL m_bRunning;                     // Video is playing
	LONG m_lIndex,						 // actual Frame - Index
		m_lFrames;                       // Video-Frames in AVI-File
	BOOL m_bLoop;                        // Looping of Video on? 
	DWORD m_dwFps;                       // Freames per Second
	int m_iTimerID;				         // TimerID of timeEvents
	int m_iTimeTick;                     // Time between two frames 
private:
	RECT m_rcSrc;
	CRITICAL_SECTION    m_csAccessBuffer;
	LPDIRECTDRAWSURFACE m_lpAviSurface;  // The surface we draw to
	PAVISTREAM m_pasMovie;               // the Handle to the AVI-Videostream
	AVISTREAMINFO m_asiMovie;            // The Video-Information
	LPBYTE m_lpInput,					 // Decompressor Input -Buffer
		   m_lpOutput;                   // Decompressor Output-Buffer
	HIC  m_hicDecompressor;			     // Handle to the AVI-Decompressor
	LONG m_lLength,						 // Input-Bufferlength
		 m_lLinePitch;                   // Bitmap-Linepitch
	LPBITMAPINFOHEADER m_lpScrFmt;       // Format of VideoInput
	LPBITMAPV4HEADER m_lpb4hTargetFmt;   // Format of Surface
	DWORD m_dwColorKeyFlag,              // Flag for Colorkeying in Blt
		  m_dwColorKeyFlagFast;          // Flag for Colorkeying in BltFast 

public:
	CAviSurface(char *lpszFilename,LPDIRECTDRAW lpDDraw,BOOL bLoop=FALSE);
//  Konstruktor 
//  Input:    lpszFilename - AVI-Filename
//  lpDDraw:  DirectDraw-Interface
//  bLoop:    Endless playing
//  Throws exception if error occurs
	virtual ~CAviSurface();
//  close AVI-File

	HRESULT SetColorKey(DWORD dwColorKey);
//  Set a Keycolor (no Keyspace)

	HRESULT BlitTo(int x,int y,LPDIRECTDRAWSURFACE lpddsTarget);
//  Draws Videosurface to (left,upper) = (x,y)

	HRESULT StretchBlitTo(RECT *rcTarget,LPDIRECTDRAWSURFACE lpddsTarget);
//  Draws Videosurface to Targetrectangle

	virtual BOOL Start(); 
// Starts Video-Playback (starts the timer to count the frames up)

	virtual BOOL Stop(); 
// Stops the timer

protected:
	virtual HRESULT ReadFrame(LONG iFrame);
// Draws Frame with index iFrame to Surface
	virtual HRESULT GetNextFrame();
// Counts index up,

private:
	BOOL Init(LPDIRECTDRAW lpDDraw);
// Initalising (called from inside the Constructor, only to split things a bit)
	void Close();
// Freeing all things (called from, the Destructor, or befor the Cunstruktor throws an exception)

	friend void CALLBACK GetFrameTimeProc(UINT uID,UINT uMsg,
			DWORD dwUser,DWORD dw1,DWORD dw2);
// friend to answer the timeEvents
};


class CAviSurfaceWithSound: public CAviSurface
{
private:
	PAVISTREAM m_pasSound;           // Handle to Soundstream in AVI-File
	AVISTREAMINFO m_asiSound;        // Formatinformation of Soundstream
	WAVEFORMATEX *m_lpSoundScrFmt;   // Fromat of Sampledata
	LPDIRECTSOUNDBUFFER m_lpdsbTon;  // The streaming Soundbuffer
    DWORD m_dwLoadPos,               // Loadpos in streaming Buffer
		  m_dwLoadSize;              // Samples to load per frame
	int m_iSoundFramesAhead;         // Frames of sound to load befor Videoplayback starts
	                                 // (I belive the way I set this value is currently buggy
									 //  cos I am not really sure about the AVISTREAMINFO.dwInitialFrames
	                                 //  value)
public:
	CAviSurfaceWithSound(char *lpszFilename,LPDIRECTDRAW lpDDraw,LPDIRECTSOUND lpDS,BOOL bLoop=FALSE);
//  Opens all required stuff 
//  Throws an exception, if an error occurs while loading  - 
//	maybe a silent handlig of nonexisting sound would be better

	~CAviSurfaceWithSound();
//  Frees all the stuff

	virtual BOOL Start(); 
//  Starts the soundplay and the videoplayback

	virtual BOOL Stop(); 
//  Stops the soundplay and the videoplayback

protected:
	virtual HRESULT ReadFrame(LONG iFrame);
// Overrides the Funtion of CAviSurface, to adjust the iFrame-Value to the soundskew defined by 
// m_iSoundFramesAhead 

	HRESULT GetFrameSound();
// Loads the next portion of sound into the Directsoundbuffer

	virtual HRESULT GetNextFrame();
// Overrides the Function of CAviSurface - Loads the Sound then calls CAviSurface::GetNextFrame()

private:
	BOOL InitSound(LPDIRECTSOUND lpDS);
// called ba the Constructor 
	void CloseSound();
// called by the Destructor, or when construction fails
};

#pragma comment(lib,"vfw32.lib")

#endif
