#include "Craft.hpp"
#include <math.h>

// SCBullet methods

BOOL SCBullet::CheckBound()
{
	if (GetX() + GetWidth() < 0 ||
		GetX() > STATUS_X ||
		GetY() + GetHeight() < CLIP_RECT.top ||
		GetY() > CLIP_RECT.bottom)
		return TRUE;
	else return FALSE;
};

// SCOurNormalBullet methods

SCOurNormalBullet::SCOurNormalBullet(SCOurPlane* pPlane, int pX, int pY, double pVelX, double pVelY)
{
	Create();

	itsOwner = pPlane;

	SetX(pX), SetY(pY);
	SetVelX(pVelX),	SetVelY(pVelY);
};

const int OURNORMALBULLET_DAMAGE = 2;
const int OURNORMALBULLET_SURFACE_NUMBER = 0;

void SCOurNormalBullet::Create()
{
	SetID(SI_OURNORMALBULLET);

	itsDamage = OURNORMALBULLET_DAMAGE;
	SetSurface(&(Game->GetSFOurBullet()[OURNORMALBULLET_SURFACE_NUMBER]));
	SetShadowSurface(&(Game->GetSFOurBulletShadow()[OURNORMALBULLET_SURFACE_NUMBER]));
};

// SCOurGuidedBullet methods

SCOurGuidedBullet::SCOurGuidedBullet(SCOurPlane* pPlane, int pX, int pY)
{
	Create();

	itsOwner = pPlane;

	SetX(pX), SetY(pY);
};

const int OURGUIDEDBULLET_DAMAGE = 1;
const int OURGUIDEDBULLET_SURFACE_NUMBER = 2;
const int OURGUIDEDBULLET_SPEED = 7;

void SCOurGuidedBullet::Create()
{
	SetID(SI_OURGUIDEDBULLET);

	itsDamage = OURGUIDEDBULLET_DAMAGE;
	SetSurface(&(Game->GetSFOurBullet()[OURGUIDEDBULLET_SURFACE_NUMBER]));
	SetShadowSurface(&(Game->GetSFOurBulletShadow()[OURGUIDEDBULLET_SURFACE_NUMBER]));

	SetVelX(0);
	SetVelY(-OURGUIDEDBULLET_SPEED);

	if (Game->GetEnemyList()->GetCount() == 0)
		SetTarget(NULL);
	else
	{
		int targetNumber = random(Game->GetEnemyList()->GetCount());

		SCObject* Node;
		int i;

		for (i = 0, Node = Game->GetEnemyList()->GetFirst(); i < targetNumber; Node = Node->GetNext(), i++);
		SetTarget(((SCEnemyPlane *)Node));
	};
};

void SCOurGuidedBullet::Move()
{
	if (itsTarget == NULL)
	{
		SCSprite::Move();
		return;
	};

	double deltaX, deltaY, distance;

	deltaX = itsTarget->GetX() + itsTarget->GetWidth() / 2 - 
		GetX() - GetWidth() / 2; 
	deltaY = itsTarget->GetY() + itsTarget->GetHeight() / 2 -
		GetY() - GetHeight() / 2;

	distance = sqrt(deltaX * deltaX + deltaY * deltaY);

	SetVelX(deltaX / distance * (double)OURGUIDEDBULLET_SPEED);
	SetVelY(deltaY / distance * (double)OURGUIDEDBULLET_SPEED);

	SCSprite::Move();
};

// SCOurSideBullet methods

const int OURSIDEBULLET_SPEED = 5;

SCOurSideBullet::SCOurSideBullet(SCOurPlane* pPlane, DIRECTION pDirection)
{
	Create();

	itsOwner = pPlane;

	SetY(itsOwner->GetY() + (itsOwner->GetHeight() - GetHeight()) / 2);

	if (pDirection == D_LEFT)
	{
		SetVelX(-OURSIDEBULLET_SPEED);
		SetX(itsOwner->GetX() - GetWidth());
	};
	if (pDirection == D_RIGHT)
	{
		SetVelX(OURSIDEBULLET_SPEED);
		SetX(itsOwner->GetX() + itsOwner->GetWidth());
	};
	SetVelY(0);
};

const int OURSIDEBULLET_DAMAGE = 1;
const int OURSIDEBULLET_SURFACE_NUMBER = 3;

void SCOurSideBullet::Create()
{
	SetID(SI_OURSIDEBULLET);

	itsDamage = OURSIDEBULLET_DAMAGE;
	SetSurface(&(Game->GetSFOurBullet()[OURSIDEBULLET_SURFACE_NUMBER]));
	SetShadowSurface(&(Game->GetSFOurBulletShadow()[OURSIDEBULLET_SURFACE_NUMBER]));
};

void SCOurSideBullet::Draw()
{
	if (GetVelX() < 0) SCBitmap::Draw();
	else GetSurface()->DrawHFlip(GetX(), GetY(), GetBack());
};

// SCEnemyNormalBullet methods

SCEnemyNormalBullet::SCEnemyNormalBullet(SCEnemyPlane* pPlane, ACESurface* pSurface, ACESurface* pShadowSurface, int pX, int pY, double pVelX, double pVelY, int pDamage)
{
	Create();

	SetSurface(pSurface);
	SetShadowSurface(pShadowSurface);

	SetX(pX), SetY(pY);

	SetVelX(pVelX);
	SetVelY(pVelY);

	itsDamage = pDamage;
};

// SCEnemyAimedBullet methods

SCEnemyAimedBullet::SCEnemyAimedBullet(SCEnemyPlane* pPlane, ACESurface* pSurface, ACESurface* pShadowSurface, int pX, int pY, double pVel, int pDamage)
{
	Create();

	SetSurface(pSurface);
	SetShadowSurface(pShadowSurface);

	SetX(pX), SetY(pY);

	int deltaX, deltaY;
	double distance;
	SCOurPlane* target;

	target = &(Game->GetPlayer()[random(Game->GetPlayerCount())]);

	deltaX = target->GetX() + target->GetWidth() / 2 -
		GetX() - GetWidth() / 2;
	deltaY = target->GetY() + target->GetHeight() / 2 -
		GetY() - GetHeight() / 2;
	distance = sqrt(deltaX * deltaX + deltaY * deltaY);

	SetVelX(deltaX / distance * pVel);
	SetVelY(deltaY / distance * pVel);

	itsDamage = pDamage;
};