#ifndef BULLET_H
#define BULLET_H

// SCBullet : Bullet Object

class SCBullet : public SCSprite
{
public :
	// Constructor & Destructor
	SCBullet() { SetID(SI_BULLET); itsDamage = 0; };
	virtual ~SCBullet() { };

	// Other methods
	BOOL CheckBound();
	int GetDamage() { return itsDamage; };
	BOOL Update() { Move(); return (!CheckBound()); };

protected :
	// Member datas
	int itsDamage;
};

// SCOurBullet : OurBullet Object

class SCOurBullet : public SCBullet
{
public :
	// Constructor & Destructor
	SCOurBullet() { SetID(SI_OURBULLET); itsOwner = NULL; };
	virtual ~SCOurBullet() { itsOwner = NULL; };

	// Getter methods
	SCOurPlane* GetOwner() { return itsOwner; };

protected :
	// Member datas
	SCOurPlane* itsOwner;
};

// SCOurNormalBullet : OurNormalBullet Object

class SCOurNormalBullet : public SCOurBullet
{
public :
	// Constructor & Destructor
	SCOurNormalBullet() { Create(); };
	void Create();
	SCOurNormalBullet(SCOurPlane* pPlane, int pX, int pY, double pVelX, double pVelY);
	~SCOurNormalBullet() { };
};

// SCOurGuidedBullet : OurGuidedBullet Object

class SCOurGuidedBullet : public SCOurBullet
{
public :
	// Constructor & Destructor
	SCOurGuidedBullet() { Create(); };
	void Create();
	SCOurGuidedBullet(SCOurPlane* pPlane, int pX, int pY);
	~SCOurGuidedBullet() { SetTarget(NULL); };

	// Getter methods
	SCEnemyPlane* GetTarget() { return itsTarget; };

	// Setter methods
	void SetTarget(SCEnemyPlane* pTarget) { itsTarget = pTarget; };

	// Other methods
	void Move();

protected :
	// Member datas
	SCEnemyPlane* itsTarget;
};

// SCOurSideBullet : OurSideBullet Object

class SCOurSideBullet : public SCOurBullet
{
public :
	// Constructor & Destructor
	SCOurSideBullet() { Create(); };
	void Create();
	SCOurSideBullet(SCOurPlane* pPlane, DIRECTION pDirection);
	~SCOurSideBullet() { };

	// Other methods
	void Draw();
};

// SCEnemyBullet : EnemyBullet Object

class SCEnemyBullet : public SCBullet
{
public :
	// Constructor & Destructor
	SCEnemyBullet() { SetID(SI_ENEMYBULLET); };
	virtual ~SCEnemyBullet() { };
};

// SCEnemyNormalBullet : EnemyNormalBullet Object

class SCEnemyNormalBullet : public SCEnemyBullet
{
public :
	// Constructor & Destructor
	SCEnemyNormalBullet() { Create(); };
	void Create() { SetID(SI_ENEMYNORMALBULLET); };
	SCEnemyNormalBullet(SCEnemyPlane* pPlane, ACESurface* pSurface, ACESurface* pShadowSurface, int pX, int pY, double pVelX, double pVelY, int pDamage);
	~SCEnemyNormalBullet() { };
};

// SCEnemyAimedBullet : EnemyAimedBullet Object

class SCEnemyAimedBullet : public SCEnemyBullet
{
public :
	// Constructor & Destructor
	SCEnemyAimedBullet() { Create(); };
	void Create() { SetID(SI_ENEMYAIMEDBULLET); };
	SCEnemyAimedBullet(SCEnemyPlane* pPlane, ACESurface* pSurface, ACESurface* pShadowSurface, int pX, int pY, double pVel, int pDamage);
	~SCEnemyAimedBullet() { };
};

#endif