#include "Craft.hpp"

// SCBitmap methods

BOOL SCBitmap::CheckHit(SCBitmap* pTarget)
{
	if (((GetX() + GetWidth() < pTarget->GetX()) ||
		 (GetX() > pTarget->GetX() + pTarget->GetWidth())) ||
		((GetY() + GetHeight() < pTarget->GetY()) ||
		 (GetY() > pTarget->GetY() + pTarget->GetHeight())))
		return FALSE;

	return TRUE;
};

// SCScroll methods

SCScroll::SCScroll(int pSpeed, ACESurface* pSurface)
{
	Create();

	SetSurface(pSurface);

	SetX(0);
	SetY(-GetHeight() + SCREEN_HEIGHT);

	SetSpeed(pSpeed);
};

void SCScroll::Draw()
{
	GetSurface()->DrawClipFast(GetX(), GetY(), GetBack());
	GetSurface()->DrawClipFast(GetX(), GetY() + GetHeight(), GetBack());
};

BOOL SCScroll::Update()
{
	SetY(GetY() + itsSpeed);

	if (GetY() > 0) SetY(GetY() - GetHeight());

	return TRUE;
};

// SCBomb methods

SCBomb::SCBomb(SCOurPlane* pPlayer)
{
	Create();

	SetX(pPlayer->GetX() + (pPlayer->GetWidth() - GetWidth()) / 2);
	SetY(pPlayer->GetY() + pPlayer->GetHeight());

	itsOwner = pPlayer;
};

const int BOMB_SPEED = 3;

void SCBomb::Create()
{
	SetID(SI_BOMB);
	SetSurface(Game->GetSFBomb());
	SetShadowSurface(Game->GetSFBombShadow());
	itsExplodeSurface = &(Game->GetSFBombExplode()[0]);
	SetVelX(0);
	SetVelY(BOMB_SPEED);

	itsOwner = NULL;

	itsCounter = 0;
};

const int BOMB_DAMAGE = 10;

void SCBomb::Bomb()
{
	Game->SoundBuffer()[SB_BOMBEXPLODE].Play();
	SetSurface(itsExplodeSurface);

	SCObject* Node;
	SCObject* Save;

	for (Node = Game->GetEnemyList()->GetFirst(); Node != Game->GetEnemyList()->GetLink(); Node = Save)
	{
		Save = Node->GetNext();

		((SCEnemyPlane *)Node)->Damage(itsOwner, BOMB_DAMAGE);
	};

	Game->GetEnemyBulletList()->DeleteAll();
};

const int BOMB_LIFE_TIME = 20;
const int BOMB_BOMB_TIME = 5;
const int BOMB_BRIGHT_COLOR = 232;

void SCBomb::Draw()
{
	if (itsCounter <= BOMB_LIFE_TIME) SCBitmap::Draw();
	else if (itsCounter == BOMB_LIFE_TIME + BOMB_BOMB_TIME) GetBack()->Fill(BOMB_BRIGHT_COLOR);
	else 
	{
		GetSurface()->Draw(GetX() - GetWidth(), GetY() - GetHeight(), GetBack());
		GetSurface()->DrawHFlip(GetX(), GetY() - GetHeight(), GetBack());
		GetSurface()->DrawVFlip(GetX() - GetWidth(), GetY(), GetBack());
		GetSurface()->DrawHVFlip(GetX(), GetY(), GetBack());
	};
};

BOOL SCBomb::Update()
{
	if (itsCounter > BOMB_LIFE_TIME + BOMB_BOMB_TIME) return FALSE;
	if (itsCounter > BOMB_LIFE_TIME && itsCounter < BOMB_LIFE_TIME + BOMB_BOMB_TIME)
		SetSurface(GetExplodeSurface() + itsCounter - BOMB_LIFE_TIME);
	if (itsCounter == BOMB_LIFE_TIME) Bomb();
	if (itsCounter < BOMB_LIFE_TIME) Move();

	itsCounter++;

	return TRUE;
};

// SCItem methods

const double ITEM_SPEED = 0.5;

void SCItem::Create()
{
	SetID(SI_ITEM);

	SetVelX(0);
	SetVelY(ITEM_SPEED);

	SetSurface(Game->GetSFBox());
	SetShadowSurface(Game->GetSFBoxShadow());

	SetX(10 + random(STATUS_X - 40));
	SetY(-GetHeight());

	itsbStatus = FALSE;
	itsItemID = II_ENERGY;
};

const int BOX_SCORE = 5;

BOOL SCItem::InterAct()
{
	if (itsbStatus == TRUE)
	{
		for (int i = 0; i < Game->GetPlayerCount(); i++)
			if (CheckHit(&(Game->GetPlayer()[i])) == TRUE)
			{
				Game->GetPlayer()[i].GainItem(itsItemID);
				return FALSE;
			};
	}
	else
	{		
		SCObject* Node = NULL;
		SCObject* Save = NULL;

		for (Node = Game->GetOurBulletList()->GetFirst();
			 Node != Game->GetOurBulletList()->GetLink();
			 Node = Save)
		{
			Save = Node->GetNext();

			if (CheckHit((SCBitmap *)Node) == TRUE)
			{
				((SCOurBullet *)Node)->GetOwner()->AddScore(BOX_SCORE);
				Game->GetOurBulletList()->Delete(Node);
				itsbStatus = TRUE;
				Game->ItemBuffer()->Play();
				SetSurface(&(Game->GetSFItem()[(int)itsItemID]));
				SetShadowSurface(&(Game->GetSFItemShadow()[(int)itsItemID]));
			};
		};
	};
	
	return TRUE;
}

// SCCoin methods

const double COIN_SPEED = 0.5;

void SCCoin::Create()
{
	SetID(SI_COIN);

	SetVelX(0);
	SetVelY(COIN_SPEED);

	SetSurface(Game->GetSFCoin());
	SetShadowSurface(Game->GetSFCoinShadow());
};

BOOL SCCoin::InterAct()
{
	for (int i = 0; i < Game->GetPlayerCount(); i++)
		if (CheckHit(&(Game->GetPlayer()[i])) == TRUE)
		{
			Game->GetPlayer()[i].GainCoin();
			return FALSE;
		};

	return TRUE;
};