// Class.hpp

#ifndef CLASS_H
#define CLASS_H

// Declare Class or Structure
//  Ŭ Ʈ տ SC λ縦 ٿ.

class SCObject;
class SCList;
class SCBitmap;
class SCScroll;
class SCSprite;
class SCBomb;
class SCItem;
class SCCoin;
class SCPlane;
class SCOurPlane;
class SCEnemyPlane;
struct SCEnemyPlaneType;
class SCEnemyPlaneMoveType1;
class SCEnemyPlaneMoveType2;
class SCEnemyPlaneMoveType3;
class SCBullet;
class SCOurBullet;
class SCOurNormalBullet;
class SCOurGuidedBullet;
class SCOurSideBullet;
class SCEnemyBullet;
class SCEnemyNormalBullet;
class SCEnemyAimedBullet;

class SCGame;
class SCStage;
class SCMenu;
class SCScriptCompiler;
struct SCScriptData;

// SCObject : Base Class

class SCObject
{
public :
	// Constructor & Destructor
	SCObject() { SetID(SI_OBJECT); SetPrev(NULL); SetNext(NULL); SetX(0); SetY(0); };
	virtual ~SCObject() { SetPrev(NULL); SetNext(NULL); };

	// Getter methods
	double GetX() { return itsX; };
	double GetY() { return itsY; };
	SCID GetID() { return itsID; };
	SCObject* GetPrev() { return itsPrev; };
	SCObject* GetNext() { return itsNext; };

	// Setter methods
	void SetX(double pX) { itsX = pX; };
	void SetY(double pY) { itsY = pY; };
	void SetID(SCID pID) { itsID = pID; };
	void SetPrev(SCObject* pObject) { itsPrev = pObject; };
	void SetNext(SCObject* pObject) { itsNext = pObject; };

	// Other methods
	virtual void Draw() { };
	virtual void DrawShadow() { };
	virtual BOOL InterAct() { return TRUE; };
	virtual BOOL Update() { return TRUE; };

protected :
	// Member datas
	double itsX, itsY;
	SCID itsID; // Object ID

	SCObject* itsPrev; // For Linked List
	SCObject* itsNext; // For Linked List
};

// SCList : Linked List for SCObject Class

class SCList
{
public :
	// Constructor & Destructor
	SCList() { itsCount = 0; GetLink()->SetNext(GetLink()); GetLink()->SetPrev(GetLink()); };
	~SCList() { DeleteAll(); };

	// Getter methods
	SCObject* GetLink() { return &itsLink; };
	SCObject* GetFirst() { return GetLink()->GetNext(); };
	int GetCount() { return itsCount; };

	// Other methods
	void Add(SCObject* pObject);
	void Delete(SCObject* pObject);
	void DeleteAll();
	void Draw();
	void DrawShadow();
	void InterAct();
	void Update();

private :
	// Member datas
	int itsCount;
	SCObject itsLink;
};

// SCBitmap : Bitmap Object (Move method X)

class SCBitmap : public SCObject
{
public :
	// Constructor & Destructor
	SCBitmap() { SetID(SI_BITMAP); SetSurface(NULL); };
	virtual ~SCBitmap() { SetSurface(NULL); };

	// Getter methods
	ACESurface* GetSurface() { return itsSurface; };
	ACEScreen* GetScreen() { return GetSurface()->Screen; };
	ACESurface* GetBack() { return GetScreen()->GetBack(); };
	int GetWidth() { return itsSurface->m_PixelWidth; };
	int GetHeight() { return itsSurface->m_PixelHeight; };

	// Setter methods
	void SetSurface(ACESurface* pSurface) { itsSurface = pSurface; };

	// Other methods
	BOOL CheckHit(SCBitmap* pTarget);
	virtual void Draw() { GetSurface()->Draw(GetX(), GetY(), GetBack()); };

protected :
	// Member datas
	ACESurface* itsSurface;
};

// SCScroll : Background Scroll Object

class SCScroll : public SCBitmap
{
public :
	// Constructor & Destructor
	SCScroll() { Create(); };
	SCScroll(int pSpeed, ACESurface* pSurface);
	void Create() { SetID(SI_SCROLL); itsSpeed= 0; };
	~SCScroll() { };

	// Setter methods
	void SetSpeed(int pSpeed) { itsSpeed = pSpeed; };

	// Other methods
	void Draw();
	BOOL Update();

private :
	// Member datas
	int itsSpeed;
};

// SCSprite : Sprite Object (Move methods O)

const int SHADOW_DEPTH = 10;

class SCSprite : public SCBitmap
{
public :
	// Constructor & Destructor
	SCSprite() { SetID(SI_SPRITE); SetVelX(0); SetVelY(0); SetShadowSurface(NULL); };
	virtual ~SCSprite() { SetShadowSurface(NULL); };

	// Getter methods
	double GetVelX() { return itsVelX; };
	double GetVelY() { return itsVelY; };
	ACESurface* GetShadowSurface() { return itsShadowSurface; };

	// Setter methods
	void SetVelX(double pVelX) { itsVelX = pVelX; };
	void SetVelY(double pVelY) { itsVelY = pVelY; };
	void SetShadowSurface(ACESurface* pSurface) { itsShadowSurface = pSurface; };

	// Other methods
	virtual BOOL CheckBound() { return TRUE; };
	void DrawShadow() { GetShadowSurface()->Draw(GetX(), GetY() + SHADOW_DEPTH, GetBack()); };
	virtual void Move() { SetX(GetX() + GetVelX()); SetY(GetY() + GetVelY()); };

protected :
	// Member datas
	double itsVelX, itsVelY;
	ACESurface* itsShadowSurface;
};

// SCBomb : Bomb Object

class SCBomb : public SCSprite
{
public :
	// Constructor & Destructor
	SCBomb() { Create(); };
	SCBomb(SCOurPlane* pPlayer);
	void Create();
	~SCBomb() { itsExplodeSurface = NULL; itsOwner = NULL; };

	// Getter methods
	ACESurface* GetExplodeSurface() { return itsExplodeSurface; };

	// Other methods
	void Bomb();
	void Draw();
	BOOL Update();

private :
	// Member datas
	int itsCounter;
	ACESurface* itsExplodeSurface;
	SCOurPlane* itsOwner;
};

// SCItem : Item Object

class SCItem : public SCSprite
{
public :
	// Constructor & Destructor
	SCItem() { Create(); };
	SCItem(ITEMID pID) { Create(); itsItemID = pID; };
	void Create();
	~SCItem() { };

	// Other methods
	BOOL CheckBound() { return ((GetY() > SCREEN_HEIGHT) ? TRUE : FALSE); };
	BOOL InterAct();
	BOOL Update() { Move(); return (!CheckBound()); };

private :
	// Member datas
	ITEMID itsItemID;
	BOOL itsbStatus;
};

// SCCoin : Coin Object

class SCCoin : public SCSprite
{
public :
	// Constructor & Destructor
	SCCoin() { Create(); };
	SCCoin(int pX, int pY) { Create(); SetX(pX); SetY(pY); };
	void Create();
	~SCCoin() { };

	// Other methods
	BOOL CheckBound() { return ((GetY() > SCREEN_HEIGHT) ? TRUE : FALSE); };
	BOOL InterAct();
	BOOL Update() { Move(); return (!CheckBound()); };
};

#endif