#include "Craft.hpp"

SCEnemyPlane::SCEnemyPlane()
{
	SetID(SI_ENEMYPLANE);

	SetExplodeSurface(&(Game->GetSFEnemyExplode()[0]));

	itsbAir = TRUE;
	itsbCoin = TRUE;

	itsCounter = 0;
	itsShootType = EST_NOSHOOT;
};

void SCEnemyPlane::Create(ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir, BOOL pbCoin)
{
	SetSurface(pSurface);
	SetShadowSurface(pShadowSurface);
	SetContactSurface(pContactSurface);
	SetX(piX), SetY(piY);
	if (piY <= 0) SetY(-GetHeight());

	itsbAir = pbAir, itsbCoin = pbCoin;

	itsShootType = pShootType;
	itsEnergy = pEnergy;
};

SCEnemyPlane::~SCEnemyPlane()
{
	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = Game->GetOurBulletList()->GetFirst(); Node != Game->GetOurBulletList()->GetLink(); Node = Save)
	{
		Save = Node->GetNext();

		if (Node->GetID() == SI_OURGUIDEDBULLET)
			if (((SCOurGuidedBullet *)Node)->GetTarget() == this)
				((SCOurGuidedBullet *)Node)->SetTarget(NULL);
	};
};

BOOL SCEnemyPlane::CheckBound()
{
	if (GetX() + GetWidth() < 0 ||
		GetX() > STATUS_X ||
		GetY() + GetHeight() < CLIP_RECT.top ||
		GetY() > CLIP_RECT.bottom)
		return TRUE;
	else return FALSE;
};

const int ENEMY_SCORE = 10;

void SCEnemyPlane::Damage(SCOurPlane* pOwner, int pDamage)
{
	if (itsState == PS_BOMB) return;

	itsEnergy -= pDamage;
	itsState = PS_CONTACT;

	if (itsEnergy < 0)
	{
		itsState = PS_BOMB;
		pOwner->AddScore(ENEMY_SCORE);
		Game->EnemyHitBuffer()->Play();
		if (itsbCoin == TRUE)
			Game->GetCoinList()->Add(
				new SCCoin(
					GetX() + (GetWidth() - Game->GetSFCoin()->m_PixelWidth) / 2,
					GetY() + (GetHeight() - Game->GetSFCoin()->m_PixelHeight) / 2
				)
			);
		itsBombTime = 0;
		SetSurface(GetExplodeSurface());
	};
};

void SCEnemyPlane::Draw()
{
	switch (itsState)
	{
	case PS_NORMAL :
		SCBitmap::Draw();
		break;
	case PS_CONTACT :
		GetContactSurface()->Draw(GetX(), GetY(), GetBack());
		break;
	case PS_BOMB :
		GetSurface()->Draw(GetX(), GetY(), GetBack());
		break;
	};
};

void SCEnemyPlane::DrawShadow()
{
	if (itsbAir == FALSE) return;

	if (itsState == PS_NORMAL || itsState == PS_CONTACT)
		SCSprite::DrawShadow();
};

BOOL SCEnemyPlane::InterAct()
{
	if (itsState == PS_BOMB) return TRUE;

	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = Game->GetOurBulletList()->GetFirst(); Node != Game->GetOurBulletList()->GetLink(); Node = Save)
	{
		Save = Node->GetNext();

		if (CheckHit((SCBitmap *)Node) == TRUE)
		{
			Damage(((SCOurBullet *)Node)->GetOwner(), ((SCBullet *)Node)->GetDamage());
			Game->GetOurBulletList()->Delete(Node);
		};
	};

	return TRUE;
};

const int ENEMYPLANE_BOMB_TIME = 5;

BOOL SCEnemyPlane::Update()
{
	switch (itsState)
	{
	case PS_CONTACT :
		itsState = PS_NORMAL;
	case PS_NORMAL :
		Move();
		if (CheckBound() == TRUE) return FALSE;
		itsCounter++;
		if (ShootTimer() == TRUE) Shoot();
		break;
	case PS_BOMB :
		itsBombTime++;
		SetSurface(GetExplodeSurface() + itsBombTime);
		if (itsBombTime >= ENEMYPLANE_BOMB_TIME) return FALSE;
		break;
	};

	return TRUE;
};