#include "Craft.hpp"
#include <math.h>

// SCEnemyPlaneMoveType1 methods

SCEnemyPlaneMoveType1::SCEnemyPlaneMoveType1(SCEnemyPlaneType* pType)
{
	Create(
		&Game->GetSFEnemy()[pType->nSurface],
		&Game->GetSFEnemyShadow()[pType->nSurface],
		&Game->GetSFEnemyContact()[pType->nSurface],
		pType->movePoint[2 * 0 + 0], pType->movePoint[2 * 0 + 1],
		pType->movePoint[2 * 1 + 0], pType->movePoint[2 * 1 + 1],
		pType->moveVel[0],
		pType->ShootType,
		pType->energy,
		pType->bAir,
		pType->bCoin
	);
};

void SCEnemyPlaneMoveType1::Create
 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, int pfX, int pfY, double pVel, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir, BOOL pbCoin)
{
	Create();

	SCEnemyPlane::Create(pSurface, pShadowSurface, pContactSurface, piX, piY, pShootType, pEnergy, pbAir, pbCoin);

	double distance;
	int deltaX, deltaY;

	if (pShootType == EST_5) Game->SoundBuffer()[SB_BATTLE].Play();

	deltaX = pfX - piX, deltaY = pfY - piY;
	distance = sqrt(deltaX * deltaX + deltaY * deltaY);

	SetVelX(pVel * deltaX / distance);
	SetVelY(pVel * deltaY / distance);
};

// SCEnemyPlaneMoveType2 methods

SCEnemyPlaneMoveType2::SCEnemyPlaneMoveType2(SCEnemyPlaneType* pType)
{
	Create(
		&Game->GetSFEnemy()[pType->nSurface],
		&Game->GetSFEnemyShadow()[pType->nSurface],
		&Game->GetSFEnemyContact()[pType->nSurface],
		pType->movePoint,
		pType->moveVel,
		pType->cMovePoint,
		pType->ShootType,
		pType->energy,
		pType->bAir,
		pType->bCoin
	);
};

void SCEnemyPlaneMoveType2::Create
 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int* pMovePoint, double* pMovePointVel, int pMovePointCount, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir, BOOL pbCoin)
{
	Create();

	SCEnemyPlane::Create(pSurface, pShadowSurface, pContactSurface, pMovePoint[0], pMovePoint[1], pShootType, pEnergy, pbAir, pbCoin);

	itsMovePoint = pMovePoint;
	itsMovePointVel = pMovePointVel;
	itsMovePointCount = pMovePointCount;

	RecaculateVel();
};

BOOL SCEnemyPlaneMoveType2::Update()
{
	if (itsCurrentMovePoint >= itsMovePointCount) return FALSE;

	return SCEnemyPlane::Update();
};

void SCEnemyPlaneMoveType2::Move()
{
	if (abs(GetX() - itsMovePoint[(itsCurrentMovePoint + 1) * 2 + 0]) <= 4 &&
		abs(GetY() - itsMovePoint[(itsCurrentMovePoint + 1) * 2 + 1]) <= 4)
	{
		itsCurrentMovePoint++;
		RecaculateVel();
	};

	SCSprite::Move();
};

void SCEnemyPlaneMoveType2::RecaculateVel()
{
	if (itsCurrentMovePoint >= itsMovePointCount) return;

	double distance;
	int deltaX, deltaY;

	deltaX = itsMovePoint[(itsCurrentMovePoint + 1) * 2 + 0] - GetX();
	deltaY = itsMovePoint[(itsCurrentMovePoint + 1) * 2 + 1] - GetY();
	distance = sqrt(deltaX * deltaX + deltaY * deltaY);

	if (distance != 0)
	{
		SetVelX(itsMovePointVel[itsCurrentMovePoint] * deltaX / distance);
		SetVelY(itsMovePointVel[itsCurrentMovePoint] * deltaY / distance);
	};
};

// SCEnemyPlaneMoveType3 methods

void SCEnemyPlaneMoveType3::Create()
{
	SetID(SI_ENEMYPLANEMOVETYPE3);
	itsTarget = &(Game->GetPlayer()[random(Game->GetPlayerCount())]);
};

SCEnemyPlaneMoveType3::SCEnemyPlaneMoveType3(SCEnemyPlaneType* pType)
{
	Create(
		&Game->GetSFEnemy()[pType->nSurface],
		&Game->GetSFEnemyShadow()[pType->nSurface],
		&Game->GetSFEnemyContact()[pType->nSurface],
		pType->movePoint[2 * 0 + 0], pType->movePoint[2 * 0 + 1],
		pType->moveVel[0],
		pType->ShootType,
		pType->energy,
		pType->bAir,
		pType->bCoin
	);
};

void SCEnemyPlaneMoveType3::Create
 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, double pVel, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir, BOOL pbCoin)
{
	Create();

	SCEnemyPlane::Create(pSurface, pShadowSurface, pContactSurface, piX, piY, pShootType, pEnergy, pbAir, pbCoin);

	SetVelX(pVel);
};

void SCEnemyPlaneMoveType3::Move()
{
	if (itsTarget->GetState() == PS_DEAD)
	{
		SCSprite::Move();
		return;
	};

	double distance;
	int deltaX, deltaY;

	deltaX = itsTarget->GetX() + itsTarget->GetWidth() / 2 -
		GetX() - GetWidth() / 2;
	deltaY = itsTarget->GetY() + itsTarget->GetHeight() / 2 -
		GetY() - GetHeight() / 2;

	distance = sqrt(deltaX * deltaX + deltaY * deltaY);

	itsX += itsVelX * deltaX / distance;
	itsY += itsVelX * deltaY / distance;
};