#include "Craft.hpp"
#include <math.h>

const double pi = 3.1415926535;

double DegToRad(double pDeg)
{
	return pDeg * pi / 180;
};

void SCEnemyPlane::Shoot()
{
	int i;

	switch (itsShootType)
	{
	case EST_1 : // Vulture
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[0],
			&Game->GetSFEnemyBulletShadow()[0],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[0].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0,
			3,
			1));
		break;

	case EST_2 : // DropShip
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[1],
			&Game->GetSFEnemyBulletShadow()[1],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[1].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0,
			1,
			2));
		break;

	case EST_3 : // Wraith
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[2],
			&Game->GetSFEnemyBulletShadow()[2],
			GetX() + GetWidth() / 2 - Game->GetSFEnemyBullet()[2].m_PixelWidth * 1.5,
			GetY() + GetHeight() / 2,
			0,
			4,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[2],
			&Game->GetSFEnemyBulletShadow()[2],
			GetX() + GetWidth() / 2 + Game->GetSFEnemyBullet()[2].m_PixelWidth / 2,
			GetY() + GetHeight() / 2,
			0,
			4,
			1));
		break;

	case EST_4 : // Sceince Bessel
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[3],
			&Game->GetSFEnemyBulletShadow()[3],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[3].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0,
			5,
			1));
		break;

	case EST_5 : // Battle Cruizer
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[5],
			&Game->GetSFEnemyBulletShadow()[5],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[5].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0,
			4,
			3));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[4],
			&Game->GetSFEnemyBulletShadow()[4],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[5].m_PixelWidth) / 2 - Game->GetSFEnemyBullet()[4].m_PixelWidth * 2,
			GetY() + GetHeight() / 2,
			0,
			5,
			2));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[4],
			&Game->GetSFEnemyBulletShadow()[4],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[5].m_PixelWidth) / 2 - Game->GetSFEnemyBullet()[4].m_PixelWidth * 4,
			GetY() + GetHeight() / 2,
			0,
			5,
			2));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[4],
			&Game->GetSFEnemyBulletShadow()[4],
			GetX() + GetWidth() / 2 + Game->GetSFEnemyBullet()[5].m_PixelWidth / 2 + Game->GetSFEnemyBullet()[4].m_PixelWidth,
			GetY() + GetHeight() / 2,
			0,
			5,
			2));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[4],
			&Game->GetSFEnemyBulletShadow()[4],
			GetX() + GetWidth() / 2 + Game->GetSFEnemyBullet()[5].m_PixelWidth / 2 + Game->GetSFEnemyBullet()[4].m_PixelWidth * 3,
			GetY() + GetHeight() / 2,
			0,
			5,
			2));
		break;

	case EST_6 : // Drone
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[6],
			&Game->GetSFEnemyBulletShadow()[6],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[6].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0,
			1,
			1));
		break;

	case EST_7 : // OverLoad
		Game->GetEnemyBulletList()->Add(new SCEnemyAimedBullet(this,
			&Game->GetSFEnemyBullet()[7],
			&Game->GetSFEnemyBulletShadow()[7],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[7].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[7].m_PixelHeight) / 2,
			5,
			1));
		break;

	case EST_8 : // Mutalisk
		Game->GetEnemyBulletList()->Add(new SCEnemyAimedBullet(this,
			&Game->GetSFEnemyBullet()[8],
			&Game->GetSFEnemyBulletShadow()[8],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[8].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			4,
			1));
		break;

	case EST_9 : // Queen
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[9],
			&Game->GetSFEnemyBulletShadow()[9],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[9].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			-0.5,
			1,
			2));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[9],
			&Game->GetSFEnemyBulletShadow()[9],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[9].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0.5,
			1,
			2));
		break;

	case EST_10 : // Guardian
		Game->GetEnemyBulletList()->Add(new SCEnemyAimedBullet(this,
			&Game->GetSFEnemyBullet()[10],
			&Game->GetSFEnemyBulletShadow()[10],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[10].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			6,
			2));
		break;

	case EST_11 : // Scout
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[11],
			&Game->GetSFEnemyBulletShadow()[11],
			GetX() + GetWidth() / 2 - Game->GetSFEnemyBullet()[11].m_PixelWidth * 1.5,
			GetY() + GetHeight() / 2,
			0,
			4,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[11],
			&Game->GetSFEnemyBulletShadow()[11],
			GetX() + GetWidth() / 2 + Game->GetSFEnemyBullet()[11].m_PixelWidth / 2,
			GetY() + GetHeight() / 2,
			0,
			4,
			1));
		break;

	case EST_12 : // Avitor
		Game->GetEnemyBulletList()->Add(new SCEnemyAimedBullet(this,
			&Game->GetSFEnemyBullet()[12],
			&Game->GetSFEnemyBulletShadow()[12],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[12].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			1,
			3));
		break;

	case EST_13 : // Archon
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[13],
			&Game->GetSFEnemyBulletShadow()[13],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[12].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			0,
			3,
			7));
		break;

	case EST_14 : // Carrier
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			0,
			-4,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			-4 / sqrt(2),
			-4 / sqrt(2),
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			-4,
			0,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			-4 / sqrt(2),
			+4 / sqrt(2),
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			0,
			4,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			4 / sqrt(2),
			4 / sqrt(2),
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			4,
			0,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[14],
			&Game->GetSFEnemyBulletShadow()[14],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[14].m_PixelWidth) / 2,
			GetY() + (GetHeight() - Game->GetSFEnemyBullet()[14].m_PixelHeight) / 2,
			4 / sqrt(2),
			-4 / sqrt(2),
			1));
		break;

	case EST_15 : // Missile Turret
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[15],
			&Game->GetSFEnemyBulletShadow()[15],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[15].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			3,
			3,
			1));
		break;

	case EST_16 : // Cannon
		Game->GetEnemyBulletList()->Add(new SCEnemyAimedBullet(this,
			&Game->GetSFEnemyBullet()[16],
			&Game->GetSFEnemyBulletShadow()[16],
			GetX() + (GetWidth() - Game->GetSFEnemyBullet()[16].m_PixelWidth) / 2,
			GetY() + GetHeight() / 2,
			4,
			1));
		break;

	case EST_17 : // Ion Cannon
		for (i = 0 + 15; i < 180; i += 15)
			Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
				&Game->GetSFEnemyBullet()[16],
				&Game->GetSFEnemyBulletShadow()[16],
				GetX() + (GetWidth() - Game->GetSFEnemyBullet()[16].m_PixelWidth) / 2,
				GetY() + GetHeight() / 2,
				3 * cos(DegToRad(i)),
				3 * sin(DegToRad(i)),
				2));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[11],
			&Game->GetSFEnemyBulletShadow()[11],
			GetX() + GetWidth() / 2 - Game->GetSFEnemyBullet()[11].m_PixelWidth * 1.5,
			GetY() + GetHeight() / 2,
			0,
			4,
			1));
		Game->GetEnemyBulletList()->Add(new SCEnemyNormalBullet(this,
			&Game->GetSFEnemyBullet()[11],
			&Game->GetSFEnemyBulletShadow()[11],
			GetX() + GetWidth() / 2 + Game->GetSFEnemyBullet()[11].m_PixelWidth / 2,
			GetY() + GetHeight() / 2,
			0,
			4,
			1));
		Game->GetEnemyList()->Add(
			new SCEnemyPlaneMoveType1(
				&Game->GetSFEnemy()[3],
				&Game->GetSFEnemyShadow()[3],
				&Game->GetSFEnemyContact()[3],
				GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[6].m_PixelWidth) / 2,
				GetY() + GetHeight() / 2,
				GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[6].m_PixelWidth) / 2 - 5,
				GetY() + GetHeight() / 2 + 1,
				1,
				EST_4,
				2,
				TRUE,
				FALSE
			)
		);
		Game->GetEnemyList()->Add(
			new SCEnemyPlaneMoveType1(
				&Game->GetSFEnemy()[3],
				&Game->GetSFEnemyShadow()[3],
				&Game->GetSFEnemyContact()[3],
				GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[6].m_PixelWidth) / 2,
				GetY() + GetHeight() / 2,
				GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[6].m_PixelWidth) / 2 + 5,
				GetY() + GetHeight() / 2 + 1,
				1,
				EST_4,
				2,
				TRUE,
				FALSE
			)
		);
		break;

	case EST_18 : // Overmind
		Game->GetEnemyList()->Add(
			new SCEnemyPlaneMoveType3(
				&Game->GetSFEnemy()[6],
				&Game->GetSFEnemyShadow()[6],
				&Game->GetSFEnemyContact()[6],
				GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[6].m_PixelWidth) / 2,
				GetY() + GetHeight() / 2,
				2,
				EST_NOSHOOT,
				1,
				TRUE,
				TRUE
			)
		);
		if (random(3) == 0)
		{
			Game->GetEnemyList()->Add(
				new SCEnemyPlaneMoveType1(
					&Game->GetSFEnemy()[7],
					&Game->GetSFEnemyShadow()[7],
					&Game->GetSFEnemyContact()[7],
					GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[7].m_PixelWidth) / 2,
					GetY() + GetHeight() / 2,
					GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[7].m_PixelWidth) / 2,
					SCREEN_HEIGHT + 20,
					2,
					EST_7,
					5,
					TRUE,
					FALSE
				)
			);
		};
		break;

	case EST_19 : // Temple
		Game->GetEnemyList()->Add(
			new SCEnemyPlaneMoveType3(
				&Game->GetSFEnemy()[11],
				&Game->GetSFEnemyShadow()[11],
				&Game->GetSFEnemyContact()[11],
				GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[11].m_PixelWidth) / 2,
				GetY() + GetHeight() / 2,
				1,
				EST_NOSHOOT,
				3,
				TRUE,
				TRUE
			)
		);
		if (random(3) == 0)
		{
			Game->GetEnemyList()->Add(
				new SCEnemyPlaneMoveType1(
					&Game->GetSFEnemy()[14],
					&Game->GetSFEnemyShadow()[14],
					&Game->GetSFEnemyContact()[14],
					GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[14].m_PixelWidth) / 2,
					GetY() + GetHeight() / 2,
					GetX() + (GetWidth() / 2 - Game->GetSFEnemy()[14].m_PixelWidth) / 2 - 20,
					GetY() + GetHeight() / 2 + 5,
					0.5,
					EST_13,
					5,
					TRUE,
					FALSE
				)
			);
		};
		break;
	};
};

BOOL SCEnemyPlane::ShootTimer()
{
	int i = 0;

	switch (itsShootType)
	{
	case EST_1 : // Vulture
		if (itsCounter % 60 == 4) return TRUE;
		else return FALSE;

	case EST_2 : // Dropship
		if (itsCounter % 80 == 10) return TRUE;
		else return FALSE;

	case EST_3 : // Wraith
		if (itsCounter % 60 == 20) return TRUE;
		else return FALSE;

	case EST_4 : // Science Bessel
		if (itsCounter % 60 == 0) return TRUE;
		for (i = 0; i < Game->GetPlayerCount(); i++)
			if (abs(Game->GetPlayer()[i].GetX() - GetX()) <= 10 &&
				itsCounter % 4 == 1) return TRUE;
		return FALSE;

	case EST_5 : // Battle Cruizer
		if ((GetY() >= 100 && GetY() <= 150) &&
			(itsCounter % 10 == 0)) return TRUE;
		else return FALSE;

	case EST_6 : // Drone
		if (itsCounter % 40 == 0) return TRUE;
		else return FALSE;

	case EST_7 : // Overload
		if (itsCounter % 150 < 20 && itsCounter % 4 == 0) return TRUE;
		else return FALSE;

	case EST_8 : // Mutalisk
		if (itsCounter % 50 == 0) return TRUE;
		else return FALSE;

	case EST_9 : // Queen
		if (itsCounter % 60 == 0) return TRUE;
		else return FALSE;

	case EST_10 : // Guardian
		if (itsCounter % 50 < 6 && itsCounter % 2 == 0) return TRUE;
		else return FALSE;

	case EST_11 : // Scout
		if (itsCounter % 10 == 0) return TRUE;
		else return FALSE;

	case EST_12 : // Avitor
		if (itsCounter % 80 == 0) return TRUE;
		else return FALSE;

	case EST_13 : // Archon
		if (itsCounter % 90 == 0) return TRUE;
		else return FALSE;

	case EST_14 : // Carrier
		if (itsCounter % 80 == 0) return TRUE;
		else return FALSE;

	case EST_15 : // Missile Turret
		if (itsCounter % 60 == 0) return TRUE;
		else return FALSE;

	case EST_16 : // Cannon
		if (itsCounter % 90 == 0) return TRUE;
		else return FALSE;

	case EST_17 : // Ion Cannon
		if (itsCounter % 80 == 0) return TRUE;
		else return FALSE;

	case EST_18 : // Overmind
		if (itsCounter % 80 == 0) return TRUE;
		else return FALSE;

	case EST_19 : // Temple
		if (itsCounter % 100 == 0) return TRUE;
		else return FALSE;
	};

	return FALSE;
};