#include "Craft.hpp"

const char* SFPlayerFileName[] = {
	"PLAYER1.PIC", "PLAYER2.PIC", "PLAYER3.PIC", "PLAYER4.PIC", "PLAYER5.PIC", "PLAYER6.PIC"
};

const char* SFPlayerExplodeFileName[] = {
	"BIGBLOW1.PIC", "BIGBLOW2.PIC",	"BIGBLOW3.PIC",	"BIGBLOW4.PIC",	"BIGBLOW5.PIC"
};

const char* SFBombFileName = "BOMB.PIC";

const char* SFBombExplodeFileName[] = {
	"BIGBLOW1.PIC",	"BIGBLOW2.PIC",	"BIGBLOW3.PIC",	"BIGBLOW4.PIC",	"BIGBLOW5.PIC"
};

const char* SFItemFileName[] = {
	"ITEM1.PIC", "ITEM2.PIC", "ITEM3.PIC", "ITEM4.PIC",	"ITEM5.PIC",
	"ITEM6.PIC"
};

const char* SFCoinFileName = "COIN.PIC";

const char* SFBoxFileName = "BOX.PIC";

const char* SFOurBulletFileName[] = {
	"BULLET01.PIC",	"BULLET02.PIC",	"BULLET03.PIC",	"BULLET04.PIC",	"BULLET05.PIC",
	"BULLET06.PIC"
};

const char* SFStatusFileName = "STATUS.PIC";

SCGame::SCGame(HWND hWnd, HINSTANCE hInstance)
{
//	CoInitialize(NULL);

	itsScreen = new ACEScreen(hWnd, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);
	Screen()->LoadPalette("BAE.PIC", TRUE);
	Screen()->GetFront()->Fill(0);
	Screen()->GetBack()->Fill(0);

	itsInput.Create(hInstance, hWnd);
	
	itsSound = new ACESound();
	itsSound->Create(hWnd);

	itsMusic = new ACEMusic(hWnd);
//	itsMusic->Create();

//	itsResource = NULL;

	itsStage = NULL, itsMenu = NULL;
	itsScriptCompiler = new SCScriptCompiler();

	itsPlayer = NULL;

	itsbFps = FALSE;
	itsPlayerCount = 0;
	itsState = GS_MENU;

	randomize();

	LoadBitmap();
	LoadSound();
};

SCGame::~SCGame()
{
	ReleaseBitmap();
	ReleaseSound();

	delete itsStage;			itsStage = NULL;
	delete itsMenu;				itsMenu = NULL;
	delete itsScriptCompiler;	itsScriptCompiler = NULL;
	delete[] itsPlayer;			itsPlayer = NULL;

	delete itsMusic;
	delete itsScreen;

//	CoUninitialize();
};

SCList* SCGame::GetOurBulletList() { return GetStage()->itsOurBulletList; };
SCList* SCGame::GetEnemyList() { return GetStage()->itsEnemyList; };
SCList* SCGame::GetEnemyBulletList() { return GetStage()->itsEnemyBulletList; };
SCList* SCGame::GetItemList() { return GetStage()->itsItemList; };
SCList* SCGame::GetCoinList() { return GetStage()->itsScrollList; };
SCList* SCGame::GetScrollList() { return GetStage()->itsCoinList; };

ACESurface* SCGame::GetSFEnemy() { return GetStage()->itsSFEnemy; };
ACESurface* SCGame::GetSFEnemyExplode() { return GetStage()->itsSFEnemyExplode; };
ACESurface* SCGame::GetSFEnemyShadow() { return GetStage()->itsSFEnemyShadow; };
ACESurface* SCGame::GetSFEnemyContact() { return GetStage()->itsSFEnemyContact; };
ACESurface* SCGame::GetSFEnemyBullet() { return GetStage()->itsSFEnemyBullet; };
ACESurface* SCGame::GetSFEnemyBulletShadow() { return GetStage()->itsSFEnemyBulletShadow; };
ACESurface* SCGame::GetSFScroll() { return GetStage()->itsSFScroll; };

void SCGame::SetPlayerCount(int pPlayerCount)
{
	itsPlayerCount = pPlayerCount;

	itsPlayer = new SCOurPlane[pPlayerCount];

	for (int i = 0; i < GetPlayerCount(); i++)
		itsPlayer[i].Create(i);
};

void SCGame::SetState(GAMESTATE pState)
{
	if (pState == GetState()) return;

	switch (GetState())
	{
	case GS_MENU :
		delete itsMenu; itsMenu = NULL;
		itsState = pState;
		if (pState == GS_GAME) CreateStage("STAGE1.SRT");
		break;
	case GS_GAME :
		itsState = pState;
		if (pState == GS_MENU)
		{
			delete itsStage; itsStage = NULL;
			CreateMenu();
		};
		break;
	case GS_END :
		delete itsMenu; itsMenu = NULL;
		itsState = pState;
		break;
	};
};

void SCGame::CreateStage(const char *pScriptFileName) { itsStage = new SCStage(this, pScriptFileName); };
void SCGame::CreateMenu() { itsMenu = new SCMenu(this); };

void SCGame::Restore()
{
	itsScreen->Restore();

	for (int i = 0; i < 3; i++)	itsSFPlayer[i].Restore();
	for (i = 0; i < 5; i++)	itsSFPlayerExplode[i].Restore();
	itsSFBomb->Restore();
	for (i = 0; i < 5; i++)	itsSFBombExplode[i].Restore();
	for (i = 0; i < 6; i++)	itsSFItem[i].Restore();
	itsSFBox->Restore();
	for (i = 0; i < 6; i++)	itsSFOurBullet[i].Restore();

	switch (GetState())
	{
	case GS_GAME : GetStage()->Restore(); break;
	case GS_MENU : itsMenu->Restore(); break;
	};
};

void SCGame::Suspend()
{
	switch (GetState())
	{
	case GS_GAME : GetStage()->Suspend(); break;
	case GS_MENU : itsMenu->Suspend(); break;
	};
};

void SCGame::Update()
{
	switch (GetState())
	{
	case GS_GAME :
		if (GetStage()->UpdateFrame() == FALSE) SetState(GS_MENU);
		break;
	case GS_MENU :
		GAMESTATE nextState;
		nextState = itsMenu->Update();
		if (nextState != GS_MENU) SetState(nextState);
		break;
	};
};

void SCGame::LoadBitmap()
{
	Screen()->GetFront()->GetDC();
	Screen()->GetFront()->SetFont();
	Screen()->GetFront()->TextXY(SCREEN_WIDTH / 2 - 80 + 3, SCREEN_HEIGHT / 2 - 20 + 3, RGB(50, 50, 50), "LOADING IMAGES...");
	Screen()->GetFront()->TextXY(SCREEN_WIDTH / 2 - 80, SCREEN_HEIGHT / 2 - 20, RGB(255, 255, 255), "LOADING IMAGES...");
	Screen()->GetFront()->ReleaseDC();

	itsSFPlayer = new ACESurface[6];
	itsSFPlayerExplode = new ACESurface[5];
	itsSFPlayerShadow = new ACESurface[6];
	itsSFPlayerContact = new ACESurface[6];
	itsSFBombExplode = new ACESurface[5];
	itsSFItem = new ACESurface[6];
	itsSFItemShadow = new ACESurface[6];
	itsSFOurBullet = new ACESurface[6];
	itsSFOurBulletShadow = new ACESurface[6];

	int i;

	for (i = 0; i < 6; i++)
	{
		itsSFPlayer[i].Create(itsScreen, SFPlayerFileName[i], TRUE);
		itsSFPlayer[i].ColorKey(0);

		itsSFPlayerShadow[i].Create(itsScreen, SFPlayerFileName[i], TRUE);
		itsSFPlayerShadow[i].Fill(0);
		itsSFPlayer[i].DrawShadow(0, 0, BLACK_COLOR, &itsSFPlayerShadow[i]);
		itsSFPlayerShadow[i].ColorKey(0);

		itsSFPlayerContact[i].Create(itsScreen, SFPlayerFileName[i], TRUE);
		itsSFPlayerContact[i].Fill(0);
		itsSFPlayer[i].DrawCharacter(0, 0, WHITE_COLOR, &itsSFPlayerContact[i]);
		itsSFPlayerContact[i].ColorKey(0);
	};

	for (i = 0; i < 5; i++)
	{
		itsSFPlayerExplode[i].Create(itsScreen, SFPlayerExplodeFileName[i], TRUE);
		itsSFPlayerExplode[i].ColorKey(0);
	};

	itsSFBomb = new ACESurface(itsScreen, SFBombFileName, TRUE);
	itsSFBomb->ColorKey(0);

	itsSFBombShadow = new ACESurface(itsScreen, SFBombFileName, TRUE);
	itsSFBombShadow->Fill(0);
	itsSFBomb->DrawShadow(0, 0, BLACK_COLOR, itsSFBombShadow);
	itsSFBombShadow->ColorKey(0);

	itsSFCoin = new ACESurface(itsScreen, SFCoinFileName, TRUE);
	itsSFCoin->ColorKey(0);

	itsSFCoinShadow = new ACESurface(itsScreen, SFCoinFileName, TRUE);
	itsSFCoinShadow->Fill(0);
	itsSFCoin->DrawShadow(0, 0, BLACK_COLOR, itsSFCoinShadow);
	itsSFCoinShadow->ColorKey(0);

	for (i = 0; i < 5; i++)
	{
		itsSFBombExplode[i].Create(itsScreen, SFBombExplodeFileName[i], TRUE);
		itsSFBombExplode[i].ColorKey(0);
	};

	for (i = 0; i < 6; i++)
	{
		itsSFItem[i].Create(itsScreen, SFItemFileName[i], TRUE);
		itsSFItem[i].ColorKey(0);

		itsSFItemShadow[i].Create(itsScreen, SFItemFileName[i], TRUE);
		itsSFItemShadow[i].Fill(0);
		itsSFItem[i].DrawShadow(0, 0, BLACK_COLOR, &itsSFItemShadow[i]);
		itsSFItemShadow[i].ColorKey(0);
	};

	itsSFBox = new ACESurface(itsScreen, SFBoxFileName, TRUE);
	itsSFBox->ColorKey(0);

	itsSFBoxShadow = new ACESurface(itsScreen, SFBoxFileName, TRUE);
	itsSFBoxShadow->Fill(0);
	itsSFBox->DrawShadow(0, 0, BLACK_COLOR, itsSFBoxShadow);
	itsSFBoxShadow->ColorKey(0);

	for (i = 0; i < 6; i++)
	{
		itsSFOurBullet[i].Create(itsScreen, SFOurBulletFileName[i], TRUE);
		itsSFOurBullet[i].ColorKey(0);

		itsSFOurBulletShadow[i].Create(itsScreen, SFOurBulletFileName[i], TRUE);
		itsSFOurBulletShadow[i].Fill(0);
		itsSFOurBullet[i].DrawShadow(0, 0, BLACK_COLOR, &itsSFOurBulletShadow[i]);
		itsSFOurBulletShadow[i].ColorKey(0);
	};

	itsSFStatus = new ACESurface(itsScreen, SFStatusFileName, TRUE);
	itsSFStatus->ColorKey(0);

	Screen()->GetFront()->Fill(0);
};

void SCGame::LoadSound()
{
	Screen()->GetFront()->GetDC();
	Screen()->GetFront()->SetFont();
	Screen()->GetFront()->TextXY(SCREEN_WIDTH / 2 - 80 + 3, SCREEN_HEIGHT / 2 - 20 + 3, RGB(50, 50, 50), "LOADING SOUNDS...");
	Screen()->GetFront()->TextXY(SCREEN_WIDTH / 2 - 80, SCREEN_HEIGHT / 2 - 20, RGB(255, 255, 255), "LOADING SOUNDS...");
	Screen()->GetFront()->ReleaseDC();

	itsSoundBuffer = new ACESoundBuffer[7];
	itsSoundBuffer[SB_BUTTON].Load(itsSound, "Button.snd", 1, TRUE);
	itsSoundBuffer[SB_ERROR].Load(itsSound, "Error.snd", 1, TRUE);
	itsSoundBuffer[SB_BOMBEXPLODE].Load(itsSound, "Bombexplode.snd", 1, TRUE);
	itsSoundBuffer[SB_WIN].Load(itsSound, "Win.snd", 1, TRUE);
	itsSoundBuffer[SB_LOSE].Load(itsSound, "Lose.snd", 1, TRUE);
	itsSoundBuffer[SB_BATTLE].Load(itsSound, "Battle.snd", 1, TRUE);
	itsSoundBuffer[SB_SCV].Load(itsSound, "Scv.snd", 1, TRUE);

	itsOurNormalShootBuffer = new ACESoundBuffer;
	itsOurNormalShootBuffer->Load(itsSound, "Ournormalshoot.snd", 2, TRUE);

	itsOurGuidedShootBuffer = new ACESoundBuffer;
	itsOurGuidedShootBuffer->Load(itsSound, "Ourguidedshoot.snd", 2, TRUE);

	itsEnemyHitBuffer = new ACESoundBuffer;
	itsEnemyHitBuffer->Load(itsSound, "Enemyexplode.snd", 2, TRUE);

	itsItemBuffer = new ACESoundBuffer;
	itsItemBuffer->Load(itsSound, "Item.snd", 2, TRUE);

	itsOurHitBuffer = new ACESoundBuffer;
	itsOurHitBuffer->Load(itsSound, "Ourhit.snd", 2, TRUE);

	Screen()->GetFront()->Fill(0);
};

void SCGame::ReleaseBitmap()
{
	delete[] itsSFPlayer;			itsSFPlayer = NULL;
	delete[] itsSFPlayerExplode;	itsSFPlayerExplode = NULL;
	delete[] itsSFPlayerShadow;		itsSFPlayerShadow = NULL;
	delete[] itsSFPlayerContact;	itsSFPlayerContact = NULL;
	delete itsSFBomb;				itsSFBomb = NULL;
	delete itsSFBombShadow;			itsSFBombShadow = NULL;
	delete[] itsSFBombExplode;		itsSFBombExplode = NULL;
	delete[] itsSFItem;				itsSFItem = NULL;
	delete[] itsSFItemShadow;		itsSFItemShadow = NULL;
	delete itsSFBox;				itsSFBox = NULL;
	delete itsSFBoxShadow;			itsSFBoxShadow = NULL;
	delete itsSFCoin;				itsSFCoin = NULL;
	delete itsSFCoinShadow;			itsSFCoinShadow = NULL;
	delete[] itsSFOurBullet;		itsSFOurBullet = NULL;
	delete[] itsSFOurBulletShadow;	itsSFOurBulletShadow = NULL;
	delete itsSFStatus;				itsSFStatus = NULL;
};

void SCGame::ReleaseSound()
{
/*	delete[] itsSoundBuffer;
	itsSoundBuffer = NULL;
	delete itsOurNormalShootBuffer;
	itsOurNormalShootBuffer = NULL;*/
};