#ifndef GAME_H
#define GAME_H

// SCGame : Game Object

class SCGame
{
public :
	// Friend Classes
	friend class SCStage;

	// Constructor & Destructor
	SCGame(HWND hWnd, HINSTANCE hInstance);
	~SCGame();

	// Getter methods
	ACEScreen* Screen() { return itsScreen; };
	ACEInput* Input() { return &itsInput; };
	ACEMusic* Music() { return itsMusic; };
//	ACEResource* Resource() { return itsResource; };

	SCStage* GetStage() { return itsStage; };

	SCOurPlane* GetPlayer() { return itsPlayer; };
	SCList* GetOurBulletList();
	SCList* GetEnemyList();
	SCList* GetEnemyBulletList();
	SCList* GetItemList();
	SCList* GetCoinList();
	SCList* GetScrollList();

	ACESurface* GetSFPlayer() { return itsSFPlayer; };
	ACESurface* GetSFPlayerExplode() { return itsSFPlayerExplode; };
	ACESurface* GetSFPlayerShadow() { return itsSFPlayerShadow; };
	ACESurface* GetSFPlayerContact() { return itsSFPlayerContact; };
	ACESurface* GetSFEnemy();
	ACESurface* GetSFEnemyExplode();
	ACESurface* GetSFEnemyShadow();
	ACESurface* GetSFEnemyContact();
	ACESurface* GetSFEnemyBullet();
	ACESurface* GetSFEnemyBulletShadow();
	ACESurface* GetSFBomb() { return itsSFBomb; };
	ACESurface* GetSFBombExplode() { return itsSFBombExplode; };
	ACESurface* GetSFBombShadow() { return itsSFBombShadow; };
	ACESurface* GetSFItem() { return itsSFItem; };
	ACESurface* GetSFItemShadow() { return itsSFItemShadow; };
	ACESurface* GetSFBox() { return itsSFBox; };
	ACESurface* GetSFBoxShadow() { return itsSFBoxShadow; };
	ACESurface* GetSFCoin() { return itsSFCoin; };
	ACESurface* GetSFCoinShadow() { return itsSFCoinShadow; };
	ACESurface* GetSFOurBullet() { return itsSFOurBullet; };
	ACESurface* GetSFOurBulletShadow() { return itsSFOurBulletShadow; };
	ACESurface* GetSFScroll();
	ACESurface* GetSFStatus() { return itsSFStatus; };

	ACESoundBuffer* SoundBuffer() { return itsSoundBuffer; };
	ACESoundBuffer* OurNormalShootBuffer() { return itsOurNormalShootBuffer; };
	ACESoundBuffer* OurGuidedShootBuffer() { return itsOurGuidedShootBuffer; };
	ACESoundBuffer* EnemyHitBuffer() { return itsEnemyHitBuffer; };
	ACESoundBuffer* ItemBuffer() { return itsItemBuffer; };
	ACESoundBuffer* OurHitBuffer() { return itsOurHitBuffer; };

	int GetPlayerCount() { return itsPlayerCount; };
	GAMESTATE GetState() { return itsState; };	

	// Setter methods
	void SetPlayerCount(int pPlayerCount);
	void SetState(GAMESTATE pState);

	// Initialize methods
	void CreateStage(const char *pScriptFileName);
	void CreateMenu();

	// Other methods
	void Restore();
	void Suspend();
	void Update();

private :
	// Private methods
	void LoadBitmap();
	void LoadSound();

	void ReleaseBitmap();
	void ReleaseSound();

private :
	ACEScreen* itsScreen;
	ACEInput itsInput;
	ACESound* itsSound;
	ACEMusic* itsMusic;
//	ACEResource* itsResource;

	SCStage* itsStage;
	SCMenu* itsMenu;
	SCScriptCompiler* itsScriptCompiler;

	SCOurPlane* itsPlayer;
	
	ACESurface* itsSFPlayer;
	ACESurface* itsSFPlayerExplode;
	ACESurface* itsSFPlayerShadow;
	ACESurface* itsSFPlayerContact;
	ACESurface* itsSFBomb;
	ACESurface* itsSFBombExplode;
	ACESurface* itsSFBombShadow;
	ACESurface* itsSFItem;
	ACESurface* itsSFItemShadow;
	ACESurface* itsSFBox;
	ACESurface* itsSFBoxShadow;
	ACESurface* itsSFCoin;
	ACESurface* itsSFCoinShadow;
	ACESurface* itsSFOurBullet;
	ACESurface* itsSFOurBulletShadow;
	ACESurface* itsSFStatus;

	ACESoundBuffer* itsSoundBuffer;
	ACESoundBuffer* itsOurNormalShootBuffer;
	ACESoundBuffer* itsOurGuidedShootBuffer;
	ACESoundBuffer* itsEnemyHitBuffer;
	ACESoundBuffer* itsItemBuffer;
	ACESoundBuffer* itsOurHitBuffer;

	BOOL itsbFps;
	BOOL itsbFrameSkip;

	int itsPlayerCount;

	GAMESTATE itsState;
};

// SCScriptData : ScriptData Struct

struct SCScriptData
{
	unsigned long int nFrame;
	SCRIPTACT act;
	int data;
};

// SCStage : Stage Object

class SCStage
{
public :
	// Friend Classes
	friend class SCGame;
	friend class SCScriptCompiler;

	// Constructor & Destructor
	SCStage(SCGame* pGame, const char *pScriptFileName);
	~SCStage();

	// Getter methods
	ACEScreen* Screen() { return itsGame->Screen(); };
	ACEInput* Input() { return itsGame->Input(); };
	ACEMusic* Music() { return itsGame->Music(); };
//	ACEResource* Resource() { return itsGame->Resource(); };

	SCOurPlane* GetPlayer() { return itsGame->itsPlayer; };

	// Other methods
	void Restore();
	void Suspend() { };
	BOOL UpdateFrame();

private :
	// Private methods
	void CreateObject();

	void AppearEnemy(SCEnemyPlaneType* pType);
	void AppearObject();
	void InterActObject();
	void RunScript(SCRIPTACT pAct, int pData);
	void UpdateInput();
	BOOL UpdateObject();
	void UpdateScreen();

	void GameOver();
	void StageClear();

	void ReleaseBitmap();
	void ReleaseObject();

public :
	// Member datas
	SCGame* itsGame;

	SCList* itsOurBulletList;
	SCList* itsEnemyList;
	SCList* itsEnemyBulletList;
	SCList* itsItemList;
	SCList* itsScrollList;
	SCList* itsCoinList;

	ACESurface* itsSFEnemy;
	ACESurface* itsSFEnemyExplode;
	ACESurface* itsSFEnemyShadow;
	ACESurface* itsSFEnemyContact;
	ACESurface* itsSFEnemyBullet;
	ACESurface* itsSFEnemyBulletShadow;
	ACESurface* itsSFScroll;

	BOOL itsbEnd;

	unsigned long int itsFrameCount;
	char* itsName;
	int itsNumber;

	SCEnemyPlaneType* itsEnemyPlaneType;
	SCScriptData* itsScriptData;
	int itscScriptData;
	int itsScriptPosition;
};

// SCMenu : Menu Object

class SCMenu
{
public :
	// Contructor & Destructor
	SCMenu(SCGame* pGame);
	~SCMenu();

	// Getter methods
	ACEScreen* Screen() { return itsGame->Screen(); };
	ACEInput* Input() { return itsGame->Input(); };
	ACEMusic* Music() { return itsGame->Music(); };

	// Other methods
	void Restore();
	void Suspend();
	GAMESTATE Update();

private :
	// Private methods
	GAMESTATE Process();

private :
	// Member datas
	SCGame* itsGame;

	ACESurface* itsSFBackGround;

	int itsBarPosition;
	char* itsMenuText[24];
	int itsMenuTextCount;
};

#endif