#include "Craft.hpp"

void SCList::Add(SCObject* pObject)
{
	pObject->SetNext(GetLink()->GetNext());
	pObject->SetPrev(GetLink());
	
	GetLink()->GetNext()->SetPrev(pObject);
	GetLink()->SetNext(pObject);

	itsCount++;
};

void SCList::Delete(SCObject* pObject)
{
	if (GetLink()->GetNext() == GetLink()) return;

	itsCount--;

	pObject->GetPrev()->SetNext(pObject->GetNext());
	pObject->GetNext()->SetPrev(pObject->GetPrev());

	delete pObject;
	pObject = NULL;
}

void SCList::DeleteAll()
{
	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = GetFirst(); Node != GetLink(); Node = Save)
	{
		Save = Node->GetNext();

		Delete(Node);
	};
};

void SCList::Draw()
{
	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = GetFirst(); Node != GetLink(); Node = Save)
	{
		Save = Node->GetNext();
		
		Node->Draw();
	}
}

void SCList::DrawShadow()
{
	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = GetFirst(); Node != GetLink(); Node = Save)
	{
		Save = Node->GetNext();
		
		Node->DrawShadow();
	}
}

void SCList::InterAct()
{
	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = GetFirst(); Node != GetLink(); Node = Save)
	{
		Save = Node->GetNext();

		if (Node->InterAct() == FALSE) Delete(Node);
	}
}

void SCList::Update()
{
	SCObject* Node = NULL;
	SCObject* Save = NULL;

	for (Node = GetFirst(); Node != GetLink(); Node = Save)
	{
		Save = Node->GetNext();

		if (Node->Update() == FALSE) Delete(Node);
	}
}