#include "Craft.hpp"

long PASCAL WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL InitApp(HINSTANCE hInstance, int iCmdShow);
void CloseApp();
void InitGame(HWND hWnd, HINSTANCE hInstance);
void ReleaseGame();

SCGame* Game = NULL;
HFILE debugFile;
BOOL bActive = TRUE;

BOOL InitApp(HINSTANCE hInstance, int iCmdShow)
{
	static char szAppName[] = "Sigma Craft";
	HWND hWnd;
	WNDCLASS wndclass;

	wndclass.style = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc = WndProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = hInstance;
	wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = NULL;
	wndclass.lpszMenuName = szAppName;
	wndclass.lpszClassName = szAppName;
    
	RegisterClass(&wndclass);

	hWnd = CreateWindowEx(WS_EX_TOPMOST,
		szAppName,
		szAppName,
		WS_POPUP,
		0,
		0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInstance,
		NULL);

	if (!hWnd) return FALSE;

    ShowWindow(hWnd, iCmdShow);
    UpdateWindow(hWnd);

	_lcreat("debug.log", 0);
	debugFile = _lopen("debug.log", OF_WRITE);

	InitGame(hWnd, hInstance);

	return TRUE;
};

void InitGame(HWND hWnd, HINSTANCE hInstance)
{
	Game = new SCGame(hWnd, hInstance);
	Game->CreateMenu();
};

void CloseApp()
{
	ReleaseGame();
	_lclose(debugFile);
};

void ReleaseGame()
{
	delete Game;	Game = NULL;
};

int PASCAL
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int iCmdShow)
{
	MSG msg;

	if (InitApp(hInstance, iCmdShow) != TRUE) return FALSE;

	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if (bActive) Game->Update();
		else WaitMessage();
	};
	
	return msg.wParam;
}

long PASCAL
WndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch (iMsg)
	{
	case WM_ACTIVATEAPP:
		bActive = wParam;
		if (bActive)
		{
			if (Game != NULL) Game->Restore();
		}
		else
		{
			if (Game != NULL) Game->Suspend();
		};
		break;

	case WM_SETCURSOR:
		SetCursor(NULL);
		break;

	case WM_KEYDOWN:
		switch(wParam)
		{
			case VK_ESCAPE:
				if (Game->GetState() == GS_GAME) Game->SetState(GS_MENU);
				else PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;
		}
		break;

	case WM_DESTROY :
		CloseApp();
		PostQuitMessage(0);
		break;
	};

	return DefWindowProc(hWnd, iMsg, wParam, lParam);
}