#include "Craft.hpp"

const int MENU_TEXT_X = 400;
const int MENU_TEXT_Y = 100;

SCMenu::SCMenu(SCGame* pGame)
{
	itsGame = pGame;

	itsSFBackGround = new ACESurface(Screen(), "STARWAR.PIC", TRUE);
	Screen()->GetBack()->ChangeFont("Arial Bold Italic", 10, 20);

	itsBarPosition = 0;

	itsMenuText[0] = "1 Player Game";
	itsMenuText[1] = "2 Player Game";
	itsMenuText[2] = "Quit Game";

	itsMenuTextCount = 3;
	Music()->Play("MENU.MUS", TRUE);
};

SCMenu::~SCMenu()
{
	PALETTEENTRY pe[256];

	Screen()->GetPalette(0, 256, pe);
	Screen()->FadeOut(3);

	delete itsSFBackGround; itsSFBackGround = NULL;

	Screen()->GetBack()->Fill(0);
	Screen()->GetFront()->Fill(0);

	Screen()->SetPalette(0, 256, pe);

	itsGame = NULL;
};

GAMESTATE SCMenu::Process()
{
	switch (itsBarPosition)
	{
	case 0 :
	case 1 :
		Screen()->FadeOut(3);
		Screen()->GetBack()->Fill(0);
		Screen()->GetFront()->Fill(0);
		Screen()->LoadPalette("BAE.PIC", TRUE);

		itsGame->SetPlayerCount(itsBarPosition + 1);
		return GS_GAME;
	case 2 :
		PostMessage(Screen()->m_hWnd, WM_CLOSE, 0, 0);
		return GS_END;
	}
	return GS_MENU;
};

void SCMenu::Restore()
{
	itsSFBackGround->Restore();
	Music()->Resume();
};

void SCMenu::Suspend()
{
	Music()->Pause();
};

GAMESTATE SCMenu::Update()
{
	Input()->Update();
	if (Input()->SqKeys[DIK_UP])
	{
		itsBarPosition--;
		if (itsBarPosition < 0) itsBarPosition = itsMenuTextCount - 1;
		itsGame->SoundBuffer()[SB_BUTTON].Play();
	};
	if (Input()->SqKeys[DIK_DOWN])
	{
		itsBarPosition++;
		if (itsBarPosition >= itsMenuTextCount) itsBarPosition = 0;
		itsGame->SoundBuffer()[SB_BUTTON].Play();
	};
	if (Input()->SqKeys[DIK_RETURN])
	{
		Music()->Stop();
		itsGame->SoundBuffer()[SB_BUTTON].Play();
		return Process();
	};

	itsSFBackGround->DrawFast(0, 0, Screen()->GetBack());
	Screen()->GetBack()->GetDC();
	Screen()->GetBack()->SetFont();
	for (int i = 0; i < itsMenuTextCount; i++)
	{
		Screen()->GetBack()->TextXY(MENU_TEXT_X + 2, MENU_TEXT_Y + 30 * i + 2, RGB(0, 0, 0), itsMenuText[i]);
		if (i == itsBarPosition)
			Screen()->GetBack()->TextXY(MENU_TEXT_X, MENU_TEXT_Y + 30 * i, RGB(255, 0, 0), itsMenuText[i]);
		else Screen()->GetBack()->TextXY(MENU_TEXT_X, MENU_TEXT_Y + 30 * i, RGB(255, 255, 255), itsMenuText[i]);
	};
	Screen()->GetBack()->ReleaseDC();
	Screen()->Flip();

	return GS_MENU;
};