#ifndef PLANE_H
#define PLANE_H

// SCPlane : Plane Object

class SCPlane : public SCSprite
{
public :
	// Constructor & Destructor
	SCPlane() { SetID(SI_PLANE); itsState = PS_NORMAL; SetExplodeSurface(NULL); SetContactSurface(NULL); itsBombTime = 0; itsEnergy = 0; };
	virtual ~SCPlane() { SetExplodeSurface(NULL); };

	// Getter methods
	ACESurface* GetExplodeSurface() { return itsExplodeSurface; };
	ACESurface* GetContactSurface() { return itsContactSurface; };
	PLANESTATE GetState() { return itsState; };

	// Setter methods
	void SetExplodeSurface(ACESurface* pSurface) { itsExplodeSurface = pSurface; };
	void SetContactSurface(ACESurface* pSurface) { itsContactSurface = pSurface; };

	// Other methods
	virtual void Shoot() = 0;

protected :
	// Member datas
	ACESurface* itsExplodeSurface;
	ACESurface* itsContactSurface;
	PLANESTATE itsState;
	int itsEnergy;
	int itsBombTime;
};

// SCOurPlane : OurPlane Object

class SCOurPlane : public SCPlane
{
public :
	// Constructor & Destructor
	SCOurPlane();
	void Create(int pPlayerNumber);
	~SCOurPlane() { delete itsBomb; itsBomb = NULL; };

	// Getter methods
	SCBomb* GetBomb() { return itsBomb; };
	int GetNormalBulletLevel() { return itsNormalBulletLevel; };
	int GetGuidedBulletLevel() { return itsGuidedBulletLevel; };
	SCID GetCurrentBullet() { return itsCurrentBullet; };

	// Setter methods
	void SetbDropBomb(BOOL pbDropBomb) { itsbDropBomb = pbDropBomb; };
	void SetbShoot(BOOL pbShoot) { itsbShoot = pbShoot; };
	void SetFrame(int pFrame) { itsFrame = pFrame; };
	void AddScore(int pAdd) { itsScore += pAdd; };
	void SetCurrentBullet(SCID pCurrentBullet) { itsCurrentBullet = pCurrentBullet; };

	// Other methods

	BOOL CheckBound();
	void Damage(int pDamage);

	void Draw();
	void DrawShadow();
	void DrawStatus();

	void GainCoin();
	void GainItem(ITEMID pItemID);

	BOOL InterAct();
	void Move();
	void Shoot();
	BOOL Update();

private :
	// Private methods
	void DropBomb();
	BOOL NewLife();
	void ShootNormalBullet();
	void ShootGuidedBullet();
	void ShootSideBullet();

private :
	// Member datas
	BOOL itsbDropBomb;
	BOOL itsbInvincible;
	BOOL itsbShoot;

	SCBomb* itsBomb;
	int itsBombCount;

	int itsFrame;
	int itsLife;
	int itsPlayerNumber;
	int itsScore;

	int itsNormalBulletLevel,
		itsGuidedBulletLevel,
		itsSideBulletLevel;
	SCID itsCurrentBullet;
};

// SCEnemyPlane : EnemyPlane Object

class SCEnemyPlane : public SCPlane
{
public :
	// Constructor & Destructor
	SCEnemyPlane();
	void Create(ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir, BOOL pbCoin);
	virtual ~SCEnemyPlane();

	// Other methods
	BOOL CheckBound();
	void Damage(SCOurPlane* pOwner, int pDamage);

	void Draw();
	void DrawShadow();

	BOOL InterAct();
	void Shoot();
	BOOL Update();

private :
	// Private methods
	BOOL ShootTimer();

protected :
	// Member datas
	BOOL itsbAir;
	BOOL itsbCoin;

	int itsCounter;
	ENEMYSHOOTTYPE itsShootType;
};

// SCEnemyPlaneType : EnemyPlaneType Struct

struct SCEnemyPlaneType
{
	SCID ID;
	ENEMYSHOOTTYPE ShootType;
	int nSurface;
	int energy;
	int cMovePoint;
	int* movePoint;
	double* moveVel;
	BOOL bAir;
	BOOL bCoin;
};

// SCEnemyPlaneMoveType1 : EnemyPlaneMoveType1 Object

class SCEnemyPlaneMoveType1 : public SCEnemyPlane
{
public :
	// Constructor & Destructor
	SCEnemyPlaneMoveType1() { Create(); };
	void Create() { SetID(SI_ENEMYPLANEMOVETYPE1); };
	SCEnemyPlaneMoveType1(SCEnemyPlaneType* pType);
	SCEnemyPlaneMoveType1
	 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, int pfX, int pfY, double pVel, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir = TRUE, BOOL pbCoin = FALSE)
	{ Create(pSurface, pShadowSurface, pContactSurface, piX, piY, pfX, pfY, pVel, pShootType, pEnergy, pbAir, pbCoin); };
	void Create
	 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, int pfX, int pfY, double pVel, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir = TRUE, BOOL pbCoin = FALSE);
	~SCEnemyPlaneMoveType1() { };
};

// SCEnemyPlaneMoveType2 : EnemyPlaneMoveType2 Object

class SCEnemyPlaneMoveType2 : public SCEnemyPlane
{
public :
	// Constructor & Destructor
	SCEnemyPlaneMoveType2() { Create(); };
	void Create() { SetID(SI_ENEMYPLANEMOVETYPE2); itsCurrentMovePoint = 0; };
	SCEnemyPlaneMoveType2(SCEnemyPlaneType* pType);
	SCEnemyPlaneMoveType2
	 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int* pMovePoint, double* pMovePointVel, int pMovePointCount, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir = TRUE, BOOL pbCoin = FALSE)
	{ Create(pSurface, pShadowSurface, pContactSurface, pMovePoint, pMovePointVel, pMovePointCount, pShootType, pEnergy, pbAir, pbCoin); };
	void Create
	 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int* pMovePoint, double* pMovePointVel, int pMovePointCount, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir = TRUE, BOOL pbCoin = FALSE);
	~SCEnemyPlaneMoveType2() { };

	// Other methods
	void Move();
	BOOL Update();

private :
	// Private methods
	void RecaculateVel();

private :
	// Member datas
	int itsCurrentMovePoint;
	int itsMovePointCount;
	int* itsMovePoint;
	double* itsMovePointVel;
};

// SCEnemyPlaneMoveType3 : EnemyPlaneMoveType3 Object

class SCEnemyPlaneMoveType3 : public SCEnemyPlane
{
public :
	// Constructor & Destructor
	SCEnemyPlaneMoveType3() { Create(); };
	void Create();
	SCEnemyPlaneMoveType3(SCEnemyPlaneType* pType);
	SCEnemyPlaneMoveType3
	 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, double pVel, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir = TRUE, BOOL pbCoin = FALSE)
	{ Create(pSurface, pShadowSurface, pContactSurface, piX, piY, pVel, pShootType, pEnergy, pbAir, pbCoin); };
	void Create
	 (ACESurface* pSurface, ACESurface* pShadowSurface, ACESurface* pContactSurface, int piX, int piY, double pVel, ENEMYSHOOTTYPE pShootType, int pEnergy, BOOL pbAir = TRUE, BOOL pbCoin = FALSE);
	~SCEnemyPlaneMoveType3() { };

	// Other methods
	void Move();

private :
	// Member datas
	SCOurPlane* itsTarget;
};

#endif