#include "Craft.hpp"
#include <stdlib.h>
#include <string.h>

BOOL SCScriptCompiler::Compile(const char* FileName, SCStage* pStage)
{
	itsScriptFile = fopen(FileName, "rt");

	if (itsScriptFile == NULL) return FALSE;
	if (Identify() == FALSE) return FALSE;
	itsStage = pStage;

	if (CompileHeader() == FALSE) return FALSE;
	if (CompileResourceInfo() == FALSE) return FALSE;
	if (CompileTypeInfo() == FALSE) return FALSE;
	if (CompileScriptData() == FALSE) return FALSE;

	fclose(itsScriptFile);

	return TRUE;
};

char* SCScriptCompiler::GetOnePhrase()
{
	char* s = new char[];
	char c;
	int i = 0;

	while (1)
	{
		c = fgetc(itsScriptFile);
		if (c == '/')	SkipOneLine();
		else if (c != ',' && c != '\n' && c != ' ') break;
	};

	s[i] = c;
	i++;

	while (1)
	{
		c = fgetc(itsScriptFile);
		if (c == ',' || c == '\n' || c == EOF) break;
		else s[i] = c;
		i++;
	};
	s[i] = '\0';

	return s;
};

BOOL SCScriptCompiler::CompileHeader()
{
	if (stricmp(GetOnePhrase(), "Stage Number") != 0) return FALSE;

	itsStage->itsNumber = GetOneNumber();

	if (stricmp(GetOnePhrase(), "Stage Name") != 0) return FALSE;
	itsStage->itsName = GetOnePhrase();

	return TRUE;
};

BOOL SCScriptCompiler::CompileResourceInfo()
{
	if (stricmp(GetOnePhrase(), "Count") != 0) return FALSE;
	int n = GetOneNumber();

	itsStage->itsSFEnemy = new ACESurface[n];
	itsStage->itsSFEnemyShadow = new ACESurface[n];
	itsStage->itsSFEnemyContact = new ACESurface[n];

	for (int i = 0; i < n; i++)
	{
		itsStage->itsSFEnemy[i].Create(itsStage->Screen(), GetOnePhrase(), TRUE);
		itsStage->itsSFEnemy[i].ColorKey(0);

		itsStage->itsSFEnemyShadow[i].Create(itsStage->Screen(),
			itsStage->itsSFEnemy[i].m_PixelWidth,
			itsStage->itsSFEnemy[i].m_PixelHeight);
		itsStage->itsSFEnemyShadow[i].Fill(0);
		itsStage->itsSFEnemy[i].DrawShadow(0, 0, BLACK_COLOR, &itsStage->itsSFEnemyShadow[i]);
		itsStage->itsSFEnemyShadow[i].ColorKey(0);

		itsStage->itsSFEnemyContact[i].Create(itsStage->Screen(),
			itsStage->itsSFEnemy[i].m_PixelWidth,
			itsStage->itsSFEnemy[i].m_PixelHeight);
		itsStage->itsSFEnemyContact[i].Fill(0);
		itsStage->itsSFEnemy[i].DrawCharacter(0, 0, WHITE_COLOR, &itsStage->itsSFEnemyContact[i]);
		itsStage->itsSFEnemyContact[i].ColorKey(0);
	};

	if (stricmp(GetOnePhrase(), "Count") != 0) return FALSE;
	n = GetOneNumber();

	itsStage->itsSFEnemyBullet = new ACESurface[n];
	itsStage->itsSFEnemyBulletShadow = new ACESurface[n];

	for (i = 0; i < n; i++)
	{
		itsStage->itsSFEnemyBullet[i].Create(itsStage->Screen(), GetOnePhrase(), TRUE);
		itsStage->itsSFEnemyBullet[i].ColorKey(0);

		itsStage->itsSFEnemyBulletShadow[i].Create(itsStage->Screen(),
			itsStage->itsSFEnemyBullet[i].m_PixelWidth,
			itsStage->itsSFEnemyBullet[i].m_PixelHeight);
		itsStage->itsSFEnemyBulletShadow[i].Fill(0);
		itsStage->itsSFEnemyBullet[i].DrawShadow(0, 0, BLACK_COLOR, &itsStage->itsSFEnemyBulletShadow[i]);
		itsStage->itsSFEnemyBulletShadow[i].ColorKey(0);
	};

	if (stricmp(GetOnePhrase(), "Count") != 0) return FALSE;
	n = GetOneNumber();

	itsStage->itsSFEnemyExplode = new ACESurface[n];

	for (i = 0; i < n; i++)
	{
		itsStage->itsSFEnemyExplode[i].Create(itsStage->Screen(), GetOnePhrase(), TRUE);
		itsStage->itsSFEnemyExplode[i].ColorKey(0);
	};

	if (stricmp(GetOnePhrase(), "Count") != 0) return FALSE;
	n = GetOneNumber();

	itsStage->itsSFScroll = new ACESurface[n];

	for (i = 0; i < n; i++)
	{
		itsStage->itsSFScroll[i].Create(itsStage->Screen(), GetOnePhrase(), TRUE);
		itsStage->itsSFScroll[i].ColorKey(0);
	};

	return TRUE;
};

BOOL SCScriptCompiler::CompileTypeInfo()
{
	GetOnePhrase();

	if (stricmp(GetOnePhrase(), "Count") != 0) return FALSE;
	int n = GetOneNumber();

	itsStage->itsEnemyPlaneType = new SCEnemyPlaneType[n];
	SCEnemyPlaneType* typeInfo = itsStage->itsEnemyPlaneType;

	int i = 0, j = 0;

	for (i = 0; i < n; i++)
	{
		if (GetOneNumber() != i + 1) return FALSE;
		char* kind = GetOnePhrase();

		typeInfo[i].ShootType = (ENEMYSHOOTTYPE)GetOneNumber();
		typeInfo[i].nSurface = GetOneNumber() - 1;
		typeInfo[i].energy = GetOneNumber();

		if (stricmp(kind, "NORMAL") == 0)
		{
			typeInfo[i].ID = SI_ENEMYPLANEMOVETYPE1;
			typeInfo[i].cMovePoint = 0;
			typeInfo[i].movePoint = new int[2 * 2];
			typeInfo[i].moveVel = new double[1];
			for (j = 0; j < 4; j++)	typeInfo[i].movePoint[j] = GetOneNumber();
			typeInfo[i].moveVel[0] = GetOneNumber();
		};
		if (stricmp(kind, "TRACE") == 0)
		{
			typeInfo[i].ID = SI_ENEMYPLANEMOVETYPE2;
			int c = GetOneNumber();
			typeInfo[i].cMovePoint = c;
			typeInfo[i].movePoint = new int[c * 2];
			typeInfo[i].moveVel = new double[c - 1];
			for (j = 0; j < c * 2; j++)	typeInfo[i].movePoint[j] = GetOneNumber();
			for (j = 0; j < c - 1; j++)	typeInfo[i].moveVel[j] = GetOneNumber();
		};
		if (stricmp(kind, "GUIDED") == 0)
		{
			typeInfo[i].ID = SI_ENEMYPLANEMOVETYPE3;
			typeInfo[i].cMovePoint = 0;
			typeInfo[i].movePoint = new int[2];
			typeInfo[i].moveVel = new double[1];
			typeInfo[i].movePoint[0] = GetOneNumber();
			typeInfo[i].movePoint[1] = GetOneNumber();
			typeInfo[i].moveVel[0] = GetOneNumber();
		};

		kind = GetOnePhrase();
		if (stricmp(kind, "LAND") == 0) typeInfo[i].bAir = FALSE;
			else if (stricmp(kind, "AIR") == 0) typeInfo[i].bAir = TRUE;
				else return FALSE;

		typeInfo[i].bCoin = (BOOL)GetOneNumber();
	};

	return TRUE;
};

BOOL SCScriptCompiler::CompileScriptData()
{
	if (stricmp(GetOnePhrase(), "Count") != 0) return FALSE;
	int n = GetOneNumber();

	itsStage->itsScriptData = new SCScriptData[n];
	itsStage->itscScriptData = n;
	SCScriptData* data = itsStage->itsScriptData;

	for (int i = 0; i < n; i++)
	{
		data[i].nFrame = (unsigned long int)GetOneNumber();
		char* act = GetOnePhrase();

		if (stricmp(act, "ENEMY") == 0)
			data[i].act = SA_ENEMY;
		if (stricmp(act, "ITEM") == 0)
			data[i].act = SA_ITEM;
		if (stricmp(act, "END") == 0)
			data[i].act = SA_END;
		if (stricmp(act, "SCROLL") == 0)
			data[i].act = SA_SCROLL;

		data[i].data = GetOneNumber();
	};

	return TRUE;
};