#include "Craft.hpp"

SCStage::SCStage(SCGame* pGame, const char *pScriptFileName)
{
	itsGame = pGame;
	itsbEnd = FALSE;
	itsFrameCount = -300;
	itscScriptData = 0;
	itsScriptPosition = 0;

	Screen()->GetFront()->GetDC();
	Screen()->GetFront()->SetFont();
	Screen()->GetFront()->TextXY(SCREEN_WIDTH / 2 - 80 + 3, SCREEN_HEIGHT / 2 - 20 + 3, RGB(50, 50, 50), "INIT STAGE...");
	Screen()->GetFront()->TextXY(SCREEN_WIDTH / 2 - 80, SCREEN_HEIGHT / 2 - 20, RGB(255, 255, 255), "INIT STAGE...");
	Screen()->GetFront()->ReleaseDC();

	itsGame->itsScriptCompiler->Compile(pScriptFileName, this);
	CreateObject();
	Music()->Play("STAGE1.MUS", TRUE);

	Screen()->GetFront()->Fill(0);
};

SCStage::~SCStage()
{
	PALETTEENTRY pe[256];

	Music()->Stop();

	Screen()->GetPalette(0, 256, pe);
	Screen()->GreyScale();
	Sleep(2000);
	Screen()->FadeOut(6);

	ReleaseBitmap();
	ReleaseObject();

	Screen()->GetBack()->Fill(0);
	Screen()->GetFront()->Fill(0);

	Screen()->SetPalette(0, 256, pe);

	Sleep(2000);

	itsGame = NULL;
};

void SCStage::Restore()
{
	for (int i = 0; i < 19; i++)
		itsSFEnemy[i].Restore();
	for (i = 0; i < 5; i++)
		itsSFEnemyExplode[i].Restore();
	for (i = 0; i < 7; i++)
		itsSFEnemyBullet[i].Restore();
	for (i = 0; i < 3; i++)
		itsSFScroll[i].Restore();
};

const int STAGE_FPS = 40;

DWORD LastTime = 0;
DWORD CurTime = 0;
DWORD FpsTime = 0;
DWORD DeltaTime = 0;
DWORD FramesRendered = 0;
DWORD Fps = 0;

char str[12];

BOOL SCStage::UpdateFrame()
{
	CurTime = timeGetTime();
	DeltaTime = CurTime - LastTime;
	LastTime = CurTime;
	FpsTime += DeltaTime;
	FramesRendered++;
	if (FpsTime > 1000)
	{
		Fps = FramesRendered;
		FramesRendered = 0;
		FpsTime = 0;
	}
	wsprintf(str, "FPS: %d", Fps);

	if (itsFrameCount == 3) itsGame->SoundBuffer()[SB_SCV].Play();

	UpdateInput();
	AppearObject();
	if (UpdateObject() == FALSE) return FALSE;
	InterActObject();

	if (Screen()->FrameSkip(STAGE_FPS)) UpdateScreen();

	BOOL bCheck = FALSE;
	for (int i = 0; i < itsGame->GetPlayerCount(); i++)
		if (GetPlayer()[i].GetState() != PS_DEAD) bCheck = TRUE;
	if (bCheck == FALSE) 
	{
		GameOver();
		return FALSE;
	};
	if (itsbEnd == TRUE && itsEnemyList->GetCount() == 0)
	{
		StageClear();
		return FALSE;
	};

	itsFrameCount++;

	return TRUE;
};

void SCStage::CreateObject()
{
	itsOurBulletList = new SCList();
	itsEnemyList = new SCList();
	itsEnemyBulletList = new SCList();
	itsItemList = new SCList();
	itsScrollList = new SCList();
	itsScrollList->Add(new SCScroll(1, &itsSFScroll[0]));
	itsCoinList = new SCList();
};

void SCStage::AppearEnemy(SCEnemyPlaneType* pType)
{
	switch (pType->ID)
	{
	case SI_ENEMYPLANEMOVETYPE1 :
		itsEnemyList->Add(new SCEnemyPlaneMoveType1(pType));
		break;
	case SI_ENEMYPLANEMOVETYPE2 :
		itsEnemyList->Add(new SCEnemyPlaneMoveType2(pType));
		break;
	case SI_ENEMYPLANEMOVETYPE3 :
		itsEnemyList->Add(new SCEnemyPlaneMoveType3(pType));
		break;
	};
};

void SCStage::AppearObject()
{
	if (itsbEnd == TRUE) return;
	if (itsFrameCount == itsScriptData[itsScriptPosition].nFrame)
		while (itsFrameCount == itsScriptData[itsScriptPosition].nFrame)
		{
			RunScript(
				itsScriptData[itsScriptPosition].act,
				itsScriptData[itsScriptPosition].data
			);
			itsScriptPosition++;
			if (itsScriptPosition >= itscScriptData)
			{
				itsScriptPosition = 0;
				itsFrameCount = 0;
			};
		};
};

void SCStage::InterActObject()
{
	itsItemList->InterAct();
	itsEnemyList->InterAct();
	itsCoinList->InterAct();

	for (int i = 0; i < itsGame->GetPlayerCount(); i++)
		GetPlayer()[i].InterAct();
};

void SCStage::RunScript(SCRIPTACT pAct, int pData)
{
	switch (pAct)
	{
	case SA_ENEMY :
		AppearEnemy(&itsEnemyPlaneType[pData-1]);
		break;
	case SA_ITEM :
		itsItemList->Add(new SCItem((ITEMID)pData));
		break;
	case SA_END :
		itsbEnd = TRUE;
		break;
	case SA_SCROLL :
		((SCScroll *)(itsScrollList->GetFirst()))->SetSpeed(pData);
		break;
	};
};

const int OURPLANE_X_SPEED = 3;
const int OURPLANE_Y_SPEED = 4;

enum USEKEY {
	UK_UP = 0,
	UK_DOWN,
	UK_LEFT,
	UK_RIGHT,
	UK_FIRE,
	UK_DROPBOMB,
	UK_CHANGEBULLET
};

int playerKey[2][7] = {
	{ DIK_UP, DIK_DOWN, DIK_LEFT, DIK_RIGHT, DIK_RETURN, DIK_RSHIFT, DIK_RCONTROL },
	{ DIK_W, DIK_X, DIK_A, DIK_D, DIK_LCONTROL, DIK_LSHIFT, DIK_S}
};

void SCStage::UpdateInput()
{
	Input()->Update();

	if (Input()->SqKeys[DIK_F1])
		itsGame->itsbFps = (itsGame->itsbFps == TRUE) ? FALSE : TRUE;

	if (Input()->ImKeys[DIK_NUMPAD8]) Input()->ImKeys[DIK_UP] = Input()->ImKeys[DIK_NUMPAD8];
	if (Input()->ImKeys[DIK_NUMPAD2]) Input()->ImKeys[DIK_DOWN] = Input()->ImKeys[DIK_NUMPAD2];
	if (Input()->ImKeys[DIK_NUMPAD4]) Input()->ImKeys[DIK_LEFT] = Input()->ImKeys[DIK_NUMPAD4];
	if (Input()->ImKeys[DIK_NUMPAD6]) Input()->ImKeys[DIK_RIGHT] = Input()->ImKeys[DIK_NUMPAD6];
	if (Input()->ImKeys[DIK_NUMPADENTER]) Input()->ImKeys[DIK_RETURN] = Input()->ImKeys[DIK_NUMPADENTER];

	for (int i = 0; i < itsGame->GetPlayerCount(); i++)
	{
		if (GetPlayer()[i].GetState() == PS_DEAD) continue;

		if (Input()->ImKeys[playerKey[i][UK_UP]]) GetPlayer()[i].SetVelY(-OURPLANE_Y_SPEED);
		if (Input()->ImKeys[playerKey[i][UK_DOWN]])	GetPlayer()[i].SetVelY(OURPLANE_Y_SPEED / 2);

		if (Input()->ImKeys[playerKey[i][UK_LEFT]]) GetPlayer()[i].SetVelX(-OURPLANE_X_SPEED);
		if (Input()->ImKeys[playerKey[i][UK_RIGHT]]) GetPlayer()[i].SetVelX(OURPLANE_X_SPEED);
		if (GetPlayer()[i].GetVelX() == 0) GetPlayer()[i].SetFrame(1);
		else GetPlayer()[i].SetFrame((GetPlayer()[i].GetVelX() > 0) ? 2 : 0);

		if (Input()->SqKeys[playerKey[i][UK_FIRE]]) GetPlayer()[i].SetbShoot(TRUE);
		if (Input()->SqKeys[playerKey[i][UK_DROPBOMB]]) GetPlayer()[i].SetbDropBomb(TRUE);

		if (Input()->SqKeys[playerKey[i][UK_CHANGEBULLET]])
			switch (GetPlayer()[i].GetCurrentBullet())
			{
			case SI_OURNORMALBULLET :
				if (GetPlayer()[i].GetGuidedBulletLevel() != 0)
				{
					GetPlayer()[i].SetCurrentBullet(SI_OURGUIDEDBULLET);
					itsGame->SoundBuffer()[SB_BUTTON].Play();
				}
				else itsGame->SoundBuffer()[SB_ERROR].Play();
				break;
			case SI_OURGUIDEDBULLET :
				if (GetPlayer()[i].GetNormalBulletLevel() != 0)
				{
					GetPlayer()[i].SetCurrentBullet(SI_OURNORMALBULLET);
					itsGame->SoundBuffer()[SB_BUTTON].Play();
				}
				else itsGame->SoundBuffer()[SB_ERROR].Play();
				break;
			};
	};
};

BOOL SCStage::UpdateObject()
{
	itsScrollList->Update();
	itsItemList->Update();
	itsCoinList->Update();
	itsEnemyBulletList->Update();
	itsOurBulletList->Update();
	itsEnemyList->Update();

	for (int i = 0; i < itsGame->GetPlayerCount(); i++)
		GetPlayer()[i].Update();

	return TRUE;
};

void SCStage::UpdateScreen()
{
	itsScrollList->Draw();

	itsEnemyBulletList->DrawShadow();
	itsOurBulletList->DrawShadow();
	itsItemList->DrawShadow();
	itsCoinList->DrawShadow();
	itsEnemyList->DrawShadow();
	for (int i = 0; i < itsGame->GetPlayerCount(); i++)
		GetPlayer()[i].DrawShadow();

	for (i = 0; i < itsGame->GetPlayerCount(); i++)
		if (GetPlayer()[i].GetBomb() != NULL) GetPlayer()[i].GetBomb()->Draw();
	itsEnemyBulletList->Draw();
	itsOurBulletList->Draw();
	itsItemList->Draw();
	itsCoinList->Draw();
	itsEnemyList->Draw();
	for (i = 0; i < itsGame->GetPlayerCount(); i++)
		GetPlayer()[i].Draw();

	itsGame->GetSFStatus()->DrawFast(SCREEN_WIDTH - itsGame->GetSFStatus()->m_PixelWidth, 0, Screen()->GetBack());
	for (i = 0; i < itsGame->GetPlayerCount(); i++)
		GetPlayer()[i].DrawStatus();

	if (itsGame->itsbFps == TRUE)
	{
		Screen()->GetBack()->GetDC();
		Screen()->GetBack()->SetFont();
		Screen()->GetBack()->TextXY(5, 5, 255, str);
		Screen()->GetBack()->ReleaseDC();
	};

	Screen()->Flip();
};

void SCStage::GameOver()
{
	itsGame->SoundBuffer()[SB_LOSE].Play();

	Screen()->GetFront()->GetDC();
	Screen()->GetFront()->SetFont();
	Screen()->GetFront()->TextXY(STATUS_X / 2 + 3, SCREEN_HEIGHT / 2 + 3, RGB(10, 10, 10), "Game Over!!");
	Screen()->GetFront()->TextXY(STATUS_X / 2, SCREEN_HEIGHT / 2, RGB(255, 0, 0), "Game Over!!");
	Screen()->GetFront()->ReleaseDC();

	Sleep(2000);
};

void SCStage::StageClear()
{
	itsGame->SoundBuffer()[SB_WIN].Play();

	Screen()->GetFront()->GetDC();
	Screen()->GetFront()->SetFont();
	Screen()->GetFront()->TextXY(STATUS_X / 2 + 3, SCREEN_HEIGHT / 2 + 3, RGB(10, 10, 10), "Stage Clear!!");
	Screen()->GetFront()->TextXY(STATUS_X / 2, SCREEN_HEIGHT / 2, RGB(255, 0, 0), "Stage Clear!!");
	Screen()->GetFront()->ReleaseDC();

	Sleep(2000);
};

void SCStage::ReleaseBitmap()
{
	delete[] itsSFEnemy;				itsSFEnemy = NULL;
	delete[] itsSFEnemyExplode;			itsSFEnemyExplode = NULL;
	delete[] itsSFEnemyShadow;			itsSFEnemyShadow = NULL;
	delete[] itsSFEnemyContact;			itsSFEnemyContact = NULL;
	delete[] itsSFEnemyBullet;			itsSFEnemyBullet = NULL;
	delete[] itsSFEnemyBulletShadow;	itsSFEnemyBulletShadow = NULL;
	delete[] itsSFScroll;				itsSFScroll = NULL;
};

void SCStage::ReleaseObject()
{
	delete itsEnemyList;		itsEnemyList = NULL;
	delete itsOurBulletList;	itsOurBulletList = NULL;
	delete itsEnemyBulletList;	itsEnemyBulletList = NULL;
	delete itsItemList;			itsItemList = NULL;
    delete itsScrollList;		itsScrollList = NULL;
	delete itsCoinList;			itsCoinList = NULL;
	delete itsEnemyPlaneType;	itsEnemyPlaneType = NULL;
	delete itsScriptData;		itsScriptData = NULL;
};