// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR
// FITNESS FOR A PARTICULAR PURPOSE.
//
// Copyright  1996  Microsoft Corporation.  All Rights Reserved.
//

#define NAME "DDExample with AVI's"
#define TITLE "Direct Draw Example for 800x600 and smaller AVI's"

#define	SCREENX		800
#define	SCREENY		600
#define	BPP			24

// Link with WINMM.LIB and VFW32.LIB

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <ddraw.h>
#include <stdlib.h>
#include <stdarg.h>
#include <mmsystem.h>
#include <vfw.h>
#include <dsound.h>
#include <time.h>

#define	RELEASE(x) (x->Release())

CRITICAL_SECTION		critical_section;

CHAR szName[MAX_PATH];

#define WM_STARTAVI WM_USER+1

LPDIRECTDRAW            lpDD;           // DirectDraw object
LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
LPDIRECTDRAWSURFACE     lpDDSBack;      // DirectDraw back surface
LPDIRECTDRAWSURFACE     lpDDSSource = NULL; // DirectDraw source AVI surface
LPDIRECTDRAWPALETTE     lpDDPal;        // DirectDraw palette
PALETTEENTRY            ape[256];
DWORD                   dwWidth, dwHeight;
HWND				    hwnd;

// -- Multimedia/AVI globals
LPDIRECTSOUND		lpDS;
LPDIRECTSOUNDBUFFER	lpDSBuffer;
PAVISTREAM aviVideoStream;
LONG lFmtLength;
LPBITMAPINFOHEADER lpSrcFmt;
LPBITMAPINFOHEADER lpTarget;
LONG lLength;
AVISTREAMINFO si;
LPBYTE lpB, lpI;
LONG lIndex;
LONG lFrames;
HIC hic;
OPENFILENAME ofn;

DWORD		dwLinePitch;

// Ʈ.
PAVISTREAM aviSoundStream;

LPWAVEFORMATEX	lpSoundFormat;

DWORD		dwLoadPos;
DWORD		dwLoadSize;

DWORD		dwSoundFramesAhead;

DWORD		timerID;
DWORD		dwTimeTick;
DWORD		dwFPS;
DWORD		dwIndex;

char buffer[255];

void Sample(LPSTR szFileName);
void SampleInit (const LPBITMAPINFO bmpFmt);
void SampleDraw (const LPBYTE lpI);
int SampleRun ();
void SampleStream ();
void GetOpenAVIFile();
void DSInit();
void PlayAudioStream();
void CALLBACK GetFrameTimer(UINT, UINT, DWORD, DWORD, DWORD);
void PlayVideoStream(int frame);
void Error();
void AVIStop();

BOOL Stop_AVI;
/*
 * finiObjects
 *
 * finished with all objects we use; release them
 */
static void finiObjects( void )
{
    if( lpDD != NULL )
    {
        if( lpDDSSource != NULL )
        {
            lpDDSSource->Release();
            lpDDSSource = NULL;
        }
        if( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
        if( lpDDPal != NULL )
        {
            lpDDPal->Release();
            lpDDPal = NULL;
        }
        lpDD->Release();
        lpDD = NULL;
    }

	if( lpDSBuffer != NULL)
	{
		lpDSBuffer->Release();
		lpDSBuffer=NULL;
	}

	if(	lpDS != NULL)
	{
		lpDS->Release();
		lpDS=NULL;
	}
} /* finiObjects */

/*
 * restoreAll
 *
 * restore all lost objects
 */
HRESULT restoreAll( void )
{
    HRESULT     ddrval;

    ddrval = lpDDSPrimary->Restore();
    return ddrval;

} /* restoreAll */

long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
    switch( message )
    {
    case WM_STARTAVI:				
        SampleStream();
        break;

    case WM_KEYDOWN:
        switch( wParam )
        {
        case VK_ESCAPE:
        case VK_F12:
            PostMessage(hWnd, WM_DESTROY, 0, 0);
            break;
        }
        break;

    case WM_DESTROY:
		AVIStop();
        finiObjects();
        PostQuitMessage( 0 );
        break;
    }

    return DefWindowProc(hWnd, message, wParam, lParam);

} /* WindowProc */

/*
 * This function is called if the initialization function fails
 */
BOOL initFail( HWND hwnd )
{
    finiObjects();
    MessageBox( hwnd, "DirectDraw Init FAILED", TITLE, MB_OK );
    if (hwnd)
	    DestroyWindow( hwnd );
    return FALSE;

} /* initFail */

/*
 * doInit - do work required for every instance of the application:
 *                create the window, initialize data
 */
static BOOL doInit( HINSTANCE hInstance, int nCmdShow )
{
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
    DDSCAPS             ddscaps;
    HRESULT             ddrval;

    /*
     * set up and register window class
     */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName = NAME;
    wc.lpszClassName = NAME;
    RegisterClass( &wc );
    
    /*
     * create a window
     */
    hwnd = CreateWindowEx(
        0,
        NAME,
        TITLE,
        WS_POPUP,
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        hInstance,
        NULL );

    if( !hwnd )
    {
        return FALSE;
    }

    ShowWindow( hwnd, nCmdShow );
    UpdateWindow( hwnd );

    GetOpenAVIFile();	

	DSInit();
    if (SampleRun()) 
	{
        MessageBox( hwnd, "Video image outside maximum dimensions (320x240x8)!", TITLE, MB_OK );
        return FALSE;
    }
	
    /*
     * create the main DirectDraw object
     */
    ddrval = DirectDrawCreate( NULL, &lpDD, NULL );
    if( ddrval != DD_OK )
    {
        return initFail(hwnd);
    }

    // Get exclusive mode
    ddrval = lpDD->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
    if( ddrval != DD_OK )
    {
        return initFail(hwnd);
    }

    // Set the video mode to 800*600*8
    ddrval = lpDD->SetDisplayMode(SCREENX, SCREENY, 8);
    if( ddrval != DD_OK )
    {
        return initFail(hwnd);
    }

    // Create the primary surface with 1 back buffer
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                          DDSCAPS_FLIP |
                          DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    ddrval = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
    if( ddrval != DD_OK )
    {
        return initFail(hwnd);
    }

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);
    if( ddrval != DD_OK )
    {
        return initFail(hwnd);
    }

    // Create a Direct Draw Palette and associate it with the front buffer
    lpDD->CreatePalette(DDPCAPS_8BIT, ape, &lpDDPal, NULL);

    if (lpDDPal)
        lpDDSPrimary->SetPalette( lpDDPal );	

	PostMessage(hwnd, WM_STARTAVI, 0, 0);

	return TRUE;
} /* doInit */

/*
 * WinMain - initialization, message loop
 */
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                        LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    OSVERSIONINFO osv;

    osv.dwOSVersionInfoSize = sizeof OSVERSIONINFO;
    GetVersionEx(&osv);

    if (osv.dwMajorVersion != 4 && osv.dwMinorVersion != 0) {
        MessageBox(GetDesktopWindow(), "Samples is designed for Windows 95!", NAME, MB_ICONHAND);
        return 0;
        }

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;

    if( !doInit( hInstance, nCmdShow ) )
    {
        return FALSE;
    }

    while( GetMessage( &msg, NULL, 0, 0 ) )
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return msg.wParam;

} /* WinMain */


void GetPaletteFromDIB( LPBITMAPINFO lpbmi)
{
    int                 i;  // loop index, number of colors in color table

    // get pointer to BITMAPINFO
    if (lpbmi)
        {
        // store RGB triples 
        // into palette
        for (i = 0; i < 256; i++)
            {
            ape[i].peRed = lpbmi->bmiColors[i].rgbRed;
            ape[i].peGreen = lpbmi->bmiColors[i].rgbGreen;
            ape[i].peBlue = lpbmi->bmiColors[i].rgbBlue;
            ape[i].peFlags = 0;
            }
        }
}

void SampleInit (const LPBITMAPINFO bmpFmt)

{   // SampleInit //

	    //Let's set the palette.
		GetPaletteFromDIB(bmpFmt);
		dwWidth  = bmpFmt->bmiHeader.biWidth;
		dwHeight = bmpFmt->bmiHeader.biHeight-1;
		lpDDPal->SetEntries(0, 0, 256, ape);

		DDSURFACEDESC       ddsd;
        HRESULT             ddrval;
   
		ddsd.dwSize = sizeof( ddsd );
        ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
        ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
        ddsd.dwHeight = dwHeight;
        ddsd.dwWidth = dwWidth;
        ddrval = lpDD->CreateSurface( &ddsd, &lpDDSSource, NULL );
        if( ddrval != DD_OK )
            {
            initFail(NULL);
            }

}   // SampleInit //

void SampleDraw (const LPBYTE pbBits)

{   // SampleDraw //
	HRESULT ddrval;
    DDSURFACEDESC ddsd;
    BYTE *src, *dst;
	int y;

    if (pbBits)
		{
		ddsd.dwSize = sizeof(ddsd);
		ddrval = lpDDSSource->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);
		if( ddrval == DD_OK )
			{
				src = (BYTE *)pbBits + dwWidth * dwHeight;

				dst = (BYTE *)ddsd.lpSurface;
				for( y=0; y<(int)dwHeight;y++ )
				{
					memcpy(dst, src, dwWidth);
					dst += ddsd.lPitch;
					src -= dwWidth;
				}
				lpDDSSource->Unlock(NULL);
			}
		}

	RECT rc;
	RECT rcSrc;
	SetRect(&rc,0,0, dwWidth, dwHeight);
	SetRect(&rcSrc,0,0,dwWidth,dwHeight);
	lpDDSBack->Blt(&rc, lpDDSSource, &rcSrc, DDBLT_WAIT, NULL);

	// Flip the surfaces
	while( 1 )
       {
       ddrval = lpDDSPrimary->Flip( NULL, 0 );
       if( ddrval == DD_OK )
          {
          break;
          }
       if( ddrval == DDERR_SURFACELOST )
          {
          ddrval = restoreAll();
          if( ddrval != DD_OK )
              {
              break;
              }
          }
       if( ddrval != DDERR_WASSTILLDRAWING )
          {
              break;
          }
       }
}   // SampleDraw //

//
// Display the open dialog box to retrieve the user-selected AVI
//
void GetOpenAVIFile()

{	// GetOpenAVIFile //

	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner         = GetDesktopWindow();
	ofn.lpstrFilter       = NULL;
	ofn.lpstrFilter       = "Video (*.avi)\0*.AVI\0All Files (*.*)\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nFilterIndex      = 1;
	ofn.lpstrFile         = (LPSTR)szName;
	ofn.nMaxFile          = 128;
	ofn.lpstrInitialDir   = NULL;
	ofn.lpstrTitle        = NULL;
	ofn.lpstrFileTitle    = NULL;
	ofn.lpstrDefExt       = NULL;
	ofn.Flags             = OFN_FILEMUSTEXIST | OFN_READONLY | OFN_PATHMUSTEXIST;
	GetOpenFileName((LPOPENFILENAME)&ofn);

}	// GetOpenAVIFile //

int SampleRun ()
{   
	// SampleRun //	
    AVIFileInit();

    AVIStreamOpenFromFile(&aviVideoStream,		//pas ڵ..
        ofn.lpstrFile,
        streamtypeVIDEO,
        0,
        OF_READ,
        NULL);	

    AVIStreamFormatSize(aviVideoStream, 0, &lFmtLength);	//    Ѵ.

    lpSrcFmt = (LPBITMAPINFOHEADER)calloc(1, lFmtLength);  //lpSrcFmt LP BITMAPINFOHEADER .
    lpTarget = (LPBITMAPINFOHEADER)calloc(1, lFmtLength+(sizeof(RGBQUAD)*256));  //lpSrcFmt LPBITMAPINFOHEADER .

    AVIStreamReadFormat(aviVideoStream, 0, lpSrcFmt, &lFmtLength);	

    if ((lpSrcFmt->biWidth > SCREENX) || (lpSrcFmt->biHeight > SCREENY))

        {   // Image dimensions outside of maximum limit

            AVIStreamRelease(aviVideoStream);
            AVIFileExit();
            return -1;

        }   // Image dimensions outside of maximum limit

    lFrames = AVIStreamLength(aviVideoStream);

	//Ʈ  ٽ  .
    memcpy(lpTarget, lpSrcFmt, lFmtLength);
    lpTarget->biBitCount = 8;
    lpTarget->biCompression = BI_RGB;
    lpTarget->biSizeImage = lpTarget->biHeight * lpTarget->biWidth * (lpTarget->biBitCount >> 3);
	dwLinePitch=lpTarget->biWidth * (lpTarget->biBitCount >> 3);

    AVIStreamInfo(aviVideoStream, &si, sizeof(AVISTREAMINFO));  // AVISTREAMINFO si;	

    lLength = (ULONG)lpTarget->biSizeImage;

    if (si.dwSuggestedBufferSize)
        if ((LONG)si.dwSuggestedBufferSize < lLength) //   ũⰡ ũ ǻ   Ѵ.
            lLength = (LONG)si.dwSuggestedBufferSize;	

	//ʴ   Ѵ.
	dwTimeTick=(1000 * si.dwScale + (si.dwRate >> 1)) / si.dwRate;	
	dwFPS=si.dwRate / si.dwScale;
	//dwTimeTick= 1000 / dwFPS;
	//wsprintf(buffer, "%d", dwFPS);
	//Error();

	double	fps=(double)si.dwRate / (double)si.dwScale;

    lpB = (LPBYTE)calloc(1, lLength);
    lpI = (LPBYTE)calloc(1, lpTarget->biSizeImage);

    hic = ICDecompressOpen(ICTYPE_VIDEO, si.fccHandler, lpSrcFmt, lpTarget);

    lpSrcFmt = (LPBITMAPINFOHEADER)realloc(lpSrcFmt, lFmtLength+(sizeof(RGBQUAD)*256));

    ICDecompressGetPalette(hic, lpSrcFmt, lpTarget);	

	// ߰ κ.
	// audio stream	
	if(AVIStreamOpenFromFile(&aviSoundStream, ofn.lpstrFile, streamtypeAUDIO, 0,
					OF_READ , NULL) != 0)
	{
		wsprintf(buffer, "234234");
		Error();
	}
	
	if(AVIStreamFormatSize(aviSoundStream, 0, &lFmtLength)!=0)
	{
		wsprintf(buffer, "234235");
		Error();
	}	

	lpSoundFormat=(LPWAVEFORMATEX)calloc(1, lFmtLength);
	ZeroMemory(lpSoundFormat, sizeof(WAVEFORMATEX));

	if(AVIStreamReadFormat(aviSoundStream, 0, lpSoundFormat, &lFmtLength))
	{
		wsprintf(buffer, "4532452");
		Error();
	}

	if(AVIStreamInfo(aviSoundStream, &si, sizeof(AVISTREAMINFO)))
	{
		wsprintf(buffer, "4532453");
		Error();
	}

	dwSoundFramesAhead=si.dwInitialFrames / si.dwScale;	
	//dwLoadSize=DWORD((lpSoundFormat->nAvgBytesPerSec + dwFPS - 1) /fps);	
	dwLoadSize=DWORD((lpSoundFormat->nAvgBytesPerSec) / dwFPS);

	wsprintf(buffer, "%d", dwLoadSize);
	Error();

    //Create The DirectSound Buffer
	DSBUFFERDESC	dsbd;
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));

	dsbd.dwSize	=	sizeof(DSBUFFERDESC);
	dsbd.dwFlags =	DSBCAPS_CTRLDEFAULT;
	dsbd.dwBufferBytes=dwLoadSize * dwFPS;
	dsbd.dwReserved=0;
	dsbd.lpwfxFormat=(LPWAVEFORMATEX)lpSoundFormat;

	//MessageBeep(UINT(-1));

	if(lpDS != NULL)
	{
		lpDS->CreateSoundBuffer(&dsbd, &lpDSBuffer, NULL);				
	}
	else
	{
		wsprintf(buffer, "234236");
		Error();
	}

    return 0;
}   // SampleRun //

void SampleStream ()

{   // SampleStream //
	//TIMECAPS	caps;

	InitializeCriticalSection(&critical_section);

	PlayAudioStream();
	PlayVideoStream(0);

	lpDSBuffer->Play(0, 0, DSBPLAY_LOOPING);		

	SampleInit((LPBITMAPINFO)lpTarget);	

	//timeGetDevCaps(&caps, sizeof(caps));

	//timeBeginPeriod(caps.wPeriodMin);

	timerID=timeSetEvent(dwTimeTick, 5, GetFrameTimer, NULL, TIME_PERIODIC);	

	Stop_AVI=FALSE;
/*
    for (lIndex = 0; lIndex < lFrames; ++lIndex)

        {	// Extract individual frame!			

			GetFrameTimer();
            AVIStreamRead(aviVideoStream, lIndex, 1, lpB, lLength, NULL, NULL);
            ICDecompress(hic, 0, lpSrcFmt, lpB, lpTarget, lpI);
            SampleDraw(lpI);

			if(GetAsyncKeyState(VK_ESCAPE) < 0)
			{
				ICClose(hic);
				AVIStreamRelease(aviVideoStream);
				AVIFileExit();
				PostMessage(hwnd, WM_KEYDOWN, VK_ESCAPE, 0);
			}
        }	// Extract individual frame!

    ICClose(hic);
    AVIStreamRelease(aviVideoStream);
    AVIFileExit();
	PostMessage(hwnd, WM_KEYDOWN, VK_ESCAPE, 0);
		*/		
}   // SampleStream //
/*
void DirectDrawDrawDib(char *pbFormattedDIB, LPBITMAPINFO lpbmpDestFmt)
{
    HRESULT   ddrval;
    char *pbBits;
	static BOOL bFirst = TRUE;

	if (bFirst)
	    { 
		bFirst = FALSE;

		//Let's set the palette, since this is our first frame
		lpDDPal->SetEntries(0, 0, 256, ape);

	}

	pbBits = pbFormattedDIB;

    DDSURFACEDESC ddsd;
    BYTE *src, *dst;
	int y;

    if (pbBits)
		{
		ddsd.dwSize = sizeof(ddsd);
		ddrval = lpDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);
		if( ddrval == DD_OK )
			{
				src = (BYTE *)pbBits + lpbmpDestFmt->bmiHeader.biWidth * 50;
				dst = (BYTE *)ddsd.lpSurface;
				for( y=0; y<45;y++ )
 				{
					memcpy(dst, src, 150);
					dst += ddsd.lPitch;
					src -= lpbmpDestFmt->bmiHeader.biWidth;
				}
				lpDDSBack->Unlock(NULL);
			}
		}

	// Flip the surfaces
	while( 1 )
       {
       ddrval = lpDDSPrimary->Flip( NULL, 0 );
       if( ddrval == DD_OK )
          {
          break;
          }
       if( ddrval == DDERR_SURFACELOST )
          {
          ddrval = restoreAll();
          if( ddrval != DD_OK )
              {
              break;
              }
          }
       if( ddrval != DDERR_WASSTILLDRAWING )
          {
              break;
          }
       }
}
*/
void	DSInit()
{
	HRESULT	hr;

	if(DirectSoundCreate(NULL, &lpDS, NULL) != DS_OK)
	{
		wsprintf(buffer, "234237");
		Error();
	}

	if(hr=(lpDS->SetCooperativeLevel(hwnd, DSSCL_NORMAL))!=DS_OK)
	{
		switch(hr)
		{
		case DSERR_ALLOCATED:
			wsprintf(buffer, "234237");
			Error();
			break;
		case DSERR_INVALIDPARAM :
			wsprintf(buffer, "234238");
			Error();
			break;
		case DSERR_UNINITIALIZED:		
			wsprintf(buffer, "234239");
			Error();
			break;
		case DSERR_UNSUPPORTED:
			wsprintf(buffer, "234230");
			Error();
			break;
		}	
		wsprintf(buffer, "%d", hr);
		Error();
	}
}
	
void PlayAudioStream()
{
	LPVOID	data1, data2;
	DWORD	size1, size2;
	HRESULT hr;

	hr=lpDSBuffer->Lock(dwLoadPos * dwLoadSize, dwLoadSize, &data1, &size1,
		&data2, &size2, 0);
	
	if(hr==DSERR_BUFFERLOST)	
	{
		lpDSBuffer->Restore();	
		wsprintf(buffer, "351532524");
		Error();
	}		

	if(data2 != NULL)
	{
		wsprintf(buffer, "23423424");
		Error();
	}

	//if(AVIStreamRead(aviSoundStream, dwIndex * dwLoadSize >> 1, dwLoadSize >> 1,
	//	data1, dwLoadSize, NULL, NULL))
	if(AVIStreamRead(aviSoundStream, dwIndex * dwLoadSize , dwLoadSize,
		data1, dwLoadSize, NULL, NULL))
	{
		wsprintf(buffer, "351532523");
		Error();
	}

	lpDSBuffer->Unlock(data1, size1, data2, size2);

	dwLoadPos++;
	dwLoadPos %= dwFPS;
}

void PlayVideoStream(int frame)
{
	frame -= dwSoundFramesAhead;

	//output video stream	
	if((0 > frame) || ((DWORD)frame > (DWORD)lFrames))
		return;	

	AVIStreamRead(aviVideoStream, frame, 1, lpB, lLength, NULL, NULL);

	EnterCriticalSection(&critical_section);
	ICDecompress(hic, 0, lpSrcFmt, lpB, (LPBITMAPINFOHEADER)lpTarget,
		lpI);
	LeaveCriticalSection(&critical_section);
}

void AVIStop()
{
	if(Stop_AVI)
		return;

	if( 0 != timerID)
	{
		lpDSBuffer->Stop();

		RELEASE(lpDSBuffer);
		lpDSBuffer=NULL;

		timeKillEvent(timerID);
		Sleep(dwTimeTick);

		timerID=0;
	}

	DeleteCriticalSection(&critical_section);

	AVIStreamRelease(aviVideoStream);
	AVIStreamRelease(aviSoundStream);

	ICDecompressEnd(hic);
	ICClose(hic);

	AVIFileExit();

	if(NULL != lpSrcFmt) free(lpSrcFmt);
	if(NULL != lpTarget) free(lpTarget);

	if(NULL != lpDDSSource) free(lpDDSSource);
	if(NULL != lpI) free(lpI);
	if(NULL != lpB) free(lpB);

	if(NULL != lpSoundFormat) free(lpSoundFormat);
	
	dwIndex=0;
	dwLoadPos=0;
	Stop_AVI=TRUE;
}

void CALLBACK GetFrameTimer(UINT, UINT, DWORD, DWORD, DWORD)
{
	static BOOL	bBusy;

	if(bBusy)
	{
		wsprintf(buffer, "4234125");
		Error();
	}
	else
		bBusy=TRUE;

	dwIndex++;

	if((DWORD)lFrames <= dwIndex)
	{
		AVIStop();
		return;
	}

	PlayAudioStream();	
	PlayVideoStream(dwIndex);
	

	DDSURFACEDESC	ddsd;
	memset(&ddsd, 0, sizeof(DDSURFACEDESC));
	
	ddsd.dwSize=sizeof(DDSURFACEDESC);
	lpDDSPrimary->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);

	LPBYTE	_lpSource=lpI + dwLinePitch * (lpTarget->biHeight -1);
	LPBYTE	_lpDest=(LPBYTE)ddsd.lpSurface;

	EnterCriticalSection(&critical_section);
	for(int i=0; i<(int)lpTarget->biHeight; i++)
	{
		memcpy(_lpDest, _lpSource, dwLinePitch);

		_lpDest+=ddsd.lPitch;
		_lpSource-=dwLinePitch;
	}
	LeaveCriticalSection(&critical_section);

	lpDDSPrimary->Unlock(&ddsd);	

	bBusy=FALSE;
}

void Error()
{
	if(lpDD)
		lpDD->FlipToGDISurface();	
	MessageBox(NULL, buffer, NAME, MB_OK);
}

