unit MainUnit;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   SubUnit1, ExtCtrls;

type
   TBasic = class(TForm)
      Timer1    : TTimer;

      procedure FormCreate(Sender: TObject);
      procedure FormDestroy(Sender: TObject);
      procedure FormKeyDown(Sender: TObject; var Key: Word;
                            Shift: TShiftState);
      procedure HandleMessage(var Msg : TMsg; var Handled : boolean);
      procedure IdleHandler(Sender : TObject; var Done : boolean);
      procedure Timer1Timer(Sender: TObject);

   private
      FCurrentColorSet : integer;

   public
      Bump             : TBump;

      procedure UpdateScreen(is_commandable : boolean);
   end;

var
   Basic : TBasic;

implementation

{$R *.DFM}

procedure TBasic.FormCreate(Sender: TObject);
begin

   Width  := SOURCE_X_WIDE;
   Height := SOURCE_Y_WIDE+24;
{
   Width  := Screen.Width;
   Height := Screen.Height;
}
   Color  := clBlack;
   Cursor := crNone;

   Bump   := TBump.Create('test.raw');

   FCurrentColorSet      := 0;

   Application.OnMessage := HandleMessage;
   Application.OnIdle    := IdleHandler;
end;

procedure TBasic.FormDestroy(Sender: TObject);
begin
   Application.OnMessage := nil;
   Application.OnIdle    := nil;
   Bump.Free;
end;

procedure TBasic.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if Key = VK_ESCAPE then Close;
end;

procedure TBasic.HandleMessage(var Msg : TMsg; var Handled : boolean);
begin
   UpdateScreen(TRUE);
end;

procedure TBasic.IdleHandler(Sender : TObject; var Done : boolean);
begin
   UpdateScreen(TRUE);
   Done := FALSE;
end;

procedure TBasic.UpdateScreen(is_commandable : boolean);
begin
   Bump.DoAction;
end;

procedure TBasic.Timer1Timer(Sender: TObject);
begin
   if Assigned(Bump) then begin
      FCurrentColorSet := Succ(FCurrentColorSet mod MAX_SECTION);
      Bump.UpdatePalette(FCurrentColorSet);
   end;
end;

end.
