#include    <windows.h>
#include    <shellapi.h>
#include    <mmsystem.h>
#include    <stdio.h>
#include    <malloc.h>
#include    "resource.h"

enum WM {
    WM_LOAD_BMP = WM_USER, WM_LOAD_PCX, WM_REDRAW, WM_LOAD, WM_LOAD_OK,
    WM_SET_PALETTE,
} ;

enum MENU {
    MENU_LOAD, MENU_EXIT
} ;

int Min(int a, int b) { return a > b ? b : a; }
int Max(int a, int b) { return a < b ? b : a; }

#define BPP 3

#if (BPP!=1) && (BPP!=2) && (BPP!=3)
# error define the BPP
#endif

#define RGB16(R, G, B) ((((unsigned char)(R)>>3)<<10)+(((unsigned char)(G)>>3)<<5)+(((unsigned char)(B)>>3)<<0))

#define FORMAT  "BMP & PCX image files\0*.bmp;*.pcx\0BMP File (*.bmp)\0*.bmp\0PCX File (*.pcx)\0*.pcx\0All Files\0*.*\0\0"

    long PASCAL
    WinProc(HWND hwnd, UINT message, WPARAM wParam,LPARAM lParam)

{
    static  BITMAPINFO  *bi;
    static  char    *vram = NULL;
    static  int     width = -1, height, bpl;
    static  struct {
        int     width, height;
        char    *data;
    }   image = {-1, -1, NULL};

    switch(message)
    {
        case WM_CREATE :
        {
            HMENU   menu, file;

            menu = CreateMenu();
            file = CreateMenu();

            InsertMenu(menu, 0, MF_POPUP, (DWORD)file, "&File");

            AppendMenu(file, MFT_STRING, MENU_LOAD, "&Open");
            AppendMenu(file, MFT_STRING, MENU_EXIT, "E&xit");

            SetMenu(hwnd, menu);

            #if (BPP>1)
            bi = (BITMAPINFO*) malloc(sizeof(BITMAPINFO));
            #else
            bi = (BITMAPINFO*) malloc(sizeof(BITMAPINFO) + \
                (BPP>2?0:sizeof(RGBQUAD)*256));
            #endif

            break;
        }

        case WM_COMMAND :
            switch(LOWORD(wParam))
            {
                case MENU_LOAD :
                {
                    OPENFILENAME    ofn;
                    char    filename[256] = "*.bmp;*.pcx";

                    ofn.lStructSize       = sizeof(ofn);
                    ofn.hwndOwner         = hwnd;
                    ofn.hInstance         = (HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE);
                    ofn.lpstrFilter       = FORMAT;
                    ofn.lpstrCustomFilter = NULL;
                    ofn.nFilterIndex      = 1;
                    ofn.lpstrFile         = filename;
                    ofn.nMaxFile          = 256;
                    ofn.lpstrFileTitle    = NULL;
                    ofn.lpstrInitialDir   = NULL;
                    ofn.lpstrTitle        = "File Open";
                    ofn.Flags             = OFN_FILEMUSTEXIST|OFN_EXPLORER|OFN_HIDEREADONLY;
                    ofn.lpstrDefExt       = NULL;

                    if (GetOpenFileName(&ofn) != FALSE)
                        SendMessage(hwnd, WM_LOAD, 0, (LPARAM)filename);

                    break;
                }

                case MENU_EXIT :
                    PostQuitMessage(1);
                    break;
            }
            break;

        case WM_GETMINMAXINFO :
        {
            MINMAXINFO  *info;
            RECT        rect;

            if (image.data != NULL)
            {
                info = (MINMAXINFO*) lParam;

                rect.left   = 0;
                rect.top    = 0;
                rect.right  = image.width+((GetWindowLong(hwnd, GWL_STYLE)&WS_VSCROLL)?13:0);
                rect.bottom = image.height+((GetWindowLong(hwnd, GWL_STYLE)&WS_HSCROLL)?13:0);

                AdjustWindowRect(&rect, GetWindowLong(hwnd, GWL_STYLE), TRUE);

                info->ptMaxTrackSize.x = rect.right-rect.left;
                info->ptMaxTrackSize.y = rect.bottom-rect.top;
            }

            break;
        }

        case WM_SIZE :
        {
            SCROLLINFO  si;
            RECT        rect;

            if (wParam == SIZE_MINIMIZED || bi == NULL || image.data == NULL ||
                (LOWORD(lParam) <= 0 && HIWORD(lParam) <= 0))
                break;

            if (image.width < LOWORD(lParam) || image.height < HIWORD(lParam))
            {
                GetWindowRect(hwnd, &rect);

                MoveWindow(hwnd, rect.left, rect.top,
                    rect.right-rect.left, rect.bottom-rect.top, TRUE);

                break;
            }

            if (image.width != LOWORD(lParam))
            {
                si.cbSize = sizeof(SCROLLINFO);
                si.fMask  = SIF_RANGE|SIF_PAGE|SIF_POS;
                si.nMin   = 0;
                si.nMax   = image.width-1;
                si.nPage  = LOWORD(lParam);
                si.nPos   = Max(0, Min(GetScrollPos(hwnd, SB_HORZ), si.nMax-si.nPage));

                if (EnableScrollBar(hwnd, SB_HORZ, ESB_ENABLE_BOTH) == TRUE)
                {
                    ShowScrollBar(hwnd, SB_HORZ, TRUE);
                    break;
                }

                SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);
            }   else
            {
                if (EnableScrollBar(hwnd, SB_HORZ, ESB_DISABLE_BOTH) == TRUE)
                {
                    SetScrollPos(hwnd, SB_HORZ, 0, TRUE);
                    ShowScrollBar(hwnd, SB_HORZ, FALSE);
                    break;
                }
            }

            if (image.height != HIWORD(lParam))
            {
                si.cbSize = sizeof(SCROLLINFO);
                si.fMask  = SIF_RANGE|SIF_PAGE|SIF_POS;
                si.nMin   = 0;
                si.nMax   = image.height-1;
                si.nPage  = HIWORD(lParam);
                si.nPos   = Max(0, Min(GetScrollPos(hwnd, SB_VERT), si.nMax-si.nPage));

                if (EnableScrollBar(hwnd, SB_VERT, ESB_ENABLE_BOTH) == TRUE)
                {
                    ShowScrollBar(hwnd, SB_VERT, TRUE);
                    break;
                }

                SetScrollInfo(hwnd, SB_VERT, &si, TRUE);
            }   else
            {
                if (EnableScrollBar(hwnd, SB_VERT, ESB_DISABLE_BOTH) == TRUE)
                {
                    SetScrollPos(hwnd, SB_VERT, 0, TRUE);
                    ShowScrollBar(hwnd, SB_VERT, FALSE);
                    break;
                }
            }

            width  = LOWORD(lParam);
            height = HIWORD(lParam);
            bpl    = ((width+3)&(~3)) * BPP;

            if (vram != NULL)
                free(vram);

            vram = malloc(bpl*height);

            memset(vram,  0, bpl*height);

            bi->bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
            bi->bmiHeader.biWidth       = (width+3)&(~3);
            bi->bmiHeader.biHeight      = -height;
            bi->bmiHeader.biPlanes      = 1;
            bi->bmiHeader.biCompression = BI_RGB;
            bi->bmiHeader.biSizeImage   = 0;
            bi->bmiHeader.biClrUsed     = 0;
            bi->bmiHeader.biBitCount    = 8*BPP;

            SendMessage(hwnd, WM_REDRAW, 0, 0);
            break;
        }

        case WM_HSCROLL :
            switch(LOWORD(wParam))
            {
                case SB_LINELEFT :
                    SetScrollPos(hwnd, SB_HORZ, Max(0, GetScrollPos(hwnd, SB_HORZ)-16), TRUE);
                    break;
                case SB_LINERIGHT :
                    SetScrollPos(hwnd, SB_HORZ, Min(image.width-width, GetScrollPos(hwnd, SB_HORZ)+16), TRUE);
                    break;
                case SB_THUMBTRACK :
                    SetScrollPos(hwnd, SB_HORZ, HIWORD(wParam), TRUE);
                    break;
            }

            SendMessage(hwnd, WM_REDRAW, 0, 0);

            break;

        case WM_VSCROLL :
            switch(LOWORD(wParam))
            {
                case SB_LINEUP:
                    SetScrollPos(hwnd, SB_VERT, Max(0, GetScrollPos(hwnd, SB_VERT)-16), TRUE);
                    break;
                case SB_LINEDOWN:
                    SetScrollPos(hwnd, SB_VERT, Min(image.height-height, GetScrollPos(hwnd, SB_VERT)+16), TRUE);
                    break;
                case SB_THUMBTRACK :
                    SetScrollPos(hwnd, SB_VERT, HIWORD(wParam), TRUE);
                    break;
            }

            SendMessage(hwnd, WM_REDRAW, 0, 0);

            break;

        case WM_REDRAW :
        {
            int     i, offset;

            if (image.data == NULL)
                break;

            offset = GetScrollPos(hwnd, SB_VERT)*image.width*BPP + \
                GetScrollPos(hwnd, SB_HORZ)*BPP;

            for(i=0; i<height; i++)
                memcpy(vram+i*bpl, image.data+offset+image.width*BPP*i, bpl);

            InvalidateRect(hwnd, NULL, FALSE);
            UpdateWindow(hwnd);
            break;
        }

        case WM_LOAD_PCX :
        {
            struct  {
                char    password, version, code, bpp;
                short   x1, y1, x2, y2, hres, vres;
                char    palette[16*3], vmode, nplanes;
                short   bpl, palinfo, shres, svres;
                char    dumy[54];
            }   header ;

            FILE   *fp;
            unsigned char    palette[4*256], buffer[1024*3];
            short   code;
            int     i, x;

            if ((fp=fopen((char*)lParam, "rb")) == NULL)
                break;

            fread(&header, 1, sizeof(header), fp);

            if (header.password != 10)
                break;

            #if (BPP==1)
            if (header.nplanes*header.bpp > 8)
            {
                MessageBox(hwnd, "Can't display", "Error", MB_OK);
                for(x=0; x<256; x++)
                {
                    palette[x*4+2] = (x%4)*256/3;
                    palette[x*4+1] = ((x/4)%8)*256/8;
                    palette[x*4+0] = ((x/32)%8)*256/8;
                }
            }
            #endif

            SetCursor(LoadCursor(NULL, IDC_WAIT));

            if (image.data != NULL)
                free(image.data);

            image.width  = header.x2-header.x1+1;
            image.height = header.y2-header.y1+1;
            image.data   = malloc(image.height*image.width*BPP);

            if (header.bpp*header.nplanes==8)
            {
                i = ftell(fp);
                fseek(fp, -3*256, SEEK_END);
                for(x=0; x<256; x++)
                {
                    palette[x*4+2] = fgetc(fp);
                    palette[x*4+1] = fgetc(fp);
                    palette[x*4+0] = fgetc(fp);
                }
                fseek(fp, i, SEEK_SET);
            }

            #if (BPP == 1)
            SendMessage(hwnd, WM_SET_PALETTE, 0, (LPARAM)palette);
            #endif

            for(i=0; i <= header.y2-header.y1; i++)
            {
                for(x=0; x<header.bpl*header.nplanes; )
                {
                    code = fgetc(fp);

                    if (code >= 0xc0)
                    {
                        memset(buffer+x, fgetc(fp), code&0x3f);
                        x += (unsigned char)code&0x3f;
                    }   else
                        buffer[x++] = (unsigned char)code;
                }

                for(x=0; x <= header.x2-header.x1; x++)
                {
                    switch(header.bpp*header.nplanes)
                    {
                        case 8 :
                            code = buffer[x];

                            #if (BPP==1)
                            image.data[image.width*i+x] = (unsigned char)code;
                            #endif

                            #if (BPP==2)
                            code = RGB16(palette[code*4+2], palette[code*4+1], palette[code*4]);
                            memcpy(image.data+(image.width*i+x)*BPP, &code, BPP);
                            #endif

                            #if (BPP==3)
                            memcpy(image.data+(image.width*i+x)*BPP, palette+code*4, 3);
                            #endif

                            break;

                        case 24 :
                            #if (BPP==1)
                            image.data[image.width*i+x] = \
                                (buffer[x]*4/256)+
                                (buffer[x+header.bpl]*8/256)*4+
                                (buffer[x+header.bpl*2]*8/256)*32;
                            #endif

                            #if (BPP==2)
                            code = RGB16(buffer[x], buffer[x+header.bpl], buffer[x+header.bpl*2]);
                            memcpy(image.data+(image.width*i+x)*BPP, &code, BPP);
                            #endif

                            #if (BPP==3)
                            image.data[(image.width*i+x)*BPP+2] = buffer[x];
                            image.data[(image.width*i+x)*BPP+1] = buffer[x+header.bpl];
                            image.data[(image.width*i+x)*BPP+0] = buffer[x+header.bpl*2];
                            #endif

                            break;
                    }
                }
            }

            fclose(fp);

            SetCursor(LoadCursor(NULL, IDC_ARROW));
            SendMessage(hwnd, WM_LOAD_OK, 0, lParam);

            break;
        }

        case WM_LOAD_BMP :
        {
            #pragma pack(2)

            struct {
                char    signature[2];
                long    size;
                short   reserved1, reserved2;
                long    offbits;
            }   header ;

            #pragma pack()

            struct {
                long    size, width, height;
                short   planes, bitcount;
                long    compression, sizecimage;
                long    xpelspermeter, ypelspermeter, clrused, clrimportant;
            }   info ;

            FILE    *fp;
            int     i, x;
            unsigned char    palette[4*256];
            short   code;

            fp = fopen((char*)lParam, "rb");

            if (fp == NULL)
                break;

            fread(&header, 1, sizeof(header), fp);

            if (memcmp(header.signature, "BM", 2) != 0)
                break;

            fread(&info, 1, sizeof(info), fp);

            #if (BPP == 1)
            if (info.bitcount > 8)
            {
                MessageBox(hwnd, "Can't display", "Warning", MB_OK);
                for(x=0; x<256; x++)
                {
                    palette[x*4+2] = (x%4)*256/3;
                    palette[x*4+1] = ((x/4)%8)*256/8;
                    palette[x*4+0] = ((x/32)%8)*256/8;
                }
            }
            #endif

            SetCursor(LoadCursor(NULL, IDC_WAIT));

            if (info.bitcount <= 8)
                fread(palette, 4, (info.clrused==0?(1<<info.bitcount):info.clrused), fp);

            #if (BPP == 1)
            SendMessage(hwnd, WM_SET_PALETTE, 0, (LPARAM)palette);
            #endif

            fseek(fp, header.offbits, SEEK_SET);

            if (image.data != NULL)
                free(image.data);

            image.width  = info.width;
            image.height = info.height;
            image.data  = malloc(image.height*image.width*BPP);

            for(i=info.height-1; i >= 0; i--)
            {
                for(x=0; x<info.width; x++)
                {
                    switch(info.bitcount)
                    {
                        case 8 :
                            code = (unsigned char)fgetc(fp);

                            #if (BPP==1)
                            image.data[image.width*i+x] = (unsigned char)code;
                            #endif

                            #if (BPP==2)
                            code = RGB16(palette[code*4+2], palette[code*4+1], palette[code*4]);
                            memcpy(image.data+(image.width*i+x)*BPP, &code, BPP);
                            #endif

                            #if (BPP==3)
                            memcpy(image.data+(image.width*i+x)*BPP, palette+code*4, 3);
                            #endif
                            break;

                        case 24 :
                            fread(palette, 3, 1, fp);

                            #if (BPP==1)
                            image.data[image.width*i+x] = \
                                (palette[2]*4/256)+ \
                                (palette[1]*8/256)*4 + \
                                (palette[1]*8/256)*32;
                            #endif

                            #if (BPP==2)
                            code = RGB16(palette[2], palette[1], palette[0]);
                            memcpy(image.data+(image.width*i+x)*BPP, &code, BPP);
                            #endif

                            #if (BPP==3)
                            memcpy(image.data+(image.width*i+x)*BPP, palette, 3);
                            #endif

                            break;
                    }
                }

                fseek(fp, (4-((info.width*info.bitcount/8)&3))&3, SEEK_CUR);
            }

            fclose(fp);

            SetCursor(LoadCursor(NULL, IDC_ARROW));
            SendMessage(hwnd, WM_LOAD_OK, 0, lParam);

            break;
        }

        case WM_LOAD_OK :
        {
            RECT    rect;
            char    title[40], *filename;
            int     i;

            filename = (char*)lParam;

            for(i=strlen(filename)-1; i >= 0 && filename[i] != '\\' && filename[i] != '/' &&
                filename[i] != 0; i--) ;

            sprintf(title, "View [%s]", filename+i+1);

            SetWindowText(hwnd, title);

            GetClientRect(hwnd, &rect);

            PostMessage(hwnd, WM_SIZE, 0, (rect.right-rect.left)+
                ((rect.bottom-rect.top)<<16));

            break;
        }

        case WM_SET_PALETTE :
        {
            int     i;
            unsigned char    *palette;

            palette = (unsigned char*) lParam;

            for(i=0; i<256; i++, palette+=4)
            {
                bi->bmiColors[i].rgbBlue  = (unsigned char) palette[0];
                bi->bmiColors[i].rgbGreen = (unsigned char) palette[1];
                bi->bmiColors[i].rgbRed   = (unsigned char) palette[2];
            }

            break;
        }

        case WM_PAINT :
        {
            PAINTSTRUCT ps;

            BeginPaint(hwnd, &ps);

            SetDIBitsToDevice(ps.hdc,
                ps.rcPaint.left, 0,
                width, height,
                ps.rcPaint.left, height,
                height,
                height,
                vram,
                bi,
                DIB_RGB_COLORS);

            EndPaint(hwnd, &ps);

            break;
        }

        case WM_DROPFILES :
        {
            char    filename[128];

            DragQueryFileA((HDROP) wParam, 0, filename, sizeof(filename));

            SendMessage(hwnd, WM_LOAD, 0, (LPARAM)filename);

            return 0;
        }

        case WM_LOAD :
        {
            char    *filename;

            filename = (char*)lParam;

            if (_stricmp(filename+strlen(filename)-3, "bmp") == 0)
                SendMessage(hwnd, WM_LOAD_BMP, 0, (LPARAM)filename);

            if (_stricmp(filename+strlen(filename)-3, "pcx") == 0)
                SendMessage(hwnd, WM_LOAD_PCX, 0, (LPARAM)filename);

            break;
        }

        case WM_DESTROY :
            if (vram != NULL)
                free(vram);

            if (image.data != NULL)
                free(image.data);

            PostQuitMessage(0);
            break;

        default :
            return DefWindowProc(hwnd, message, wParam, lParam);
    }

    return 0;
}

    int PASCAL
    WinMain(HINSTANCE instance, HINSTANCE previnsy, LPSTR lpszArgs, int winmode)

{
    WNDCLASS    wcl;
    MSG         msg;
    HWND        hwnd;

    wcl.style         = 0;
    wcl.lpfnWndProc   = WinProc;
    wcl.cbClsExtra    = 0;
    wcl.cbWndExtra    = 0;
    wcl.hInstance     = instance;
    wcl.hIcon         = LoadIcon(instance, MAKEINTATOM(VIEWER_ICON));
    wcl.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wcl.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
    wcl.lpszMenuName  = NULL;
    wcl.lpszClassName = "a monster called NOERROR";

    if (!RegisterClass(&wcl))
        PostQuitMessage(0);

    hwnd = CreateWindowEx(
        WS_EX_ACCEPTFILES,
        "a monster called NOERROR",
        "View",
        WS_OVERLAPPEDWINDOW|WS_VSCROLL|WS_HSCROLL,
        CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT,
        HWND_DESKTOP,
        NULL,
        instance, NULL);

    ShowWindow(hwnd, SW_RESTORE);
    UpdateWindow(hwnd);

    if (lpszArgs[0] != 0 && strlen(lpszArgs) > 3)
        PostMessage(hwnd, WM_LOAD, 0, (LPARAM)lpszArgs);

    while(1)
    {
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) !=0 )
        {
            if (GetMessage(&msg, NULL, 0, 0) == 0)
                break;

            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return  msg.wParam;
}
