//
//	ǰ: Tetris in Dungeon 98
//
//	۰ : ּ 
//

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <memory.h>
#include <process.h>
#include <CDX.h>
#include "resource.h"

#define LEVEL2SCORE 100		//  ʿ ġ.
#define LEVEL3SCORE 300
#define LEVEL4SCORE 600
#define LEVEL5SCORE 1200
#define LEVEL6SCORE 2000
#define LEVEL7SCORE 3000
#define LEVEL8SCORE 5000
#define LEVEL9SCORE 7000
#define LEVEL10SCORE 12000
#define LEVEL11SCORE 22000
#define LEVEL12SCORE 45000

#define MENU 111			// Ʈ μ ̵.
#define MENUSCROLLUP 121
#define CLEAR_SCREEN 131
#define DRAW_READY 141
#define DRAW_SCREEN 151
#define READY 161			
#define NINPUT 171
#define GAMEOVER 173
#define CONTINUE 175
#define DELETEMODE 181
#define BUILD 185
#define NEXT 191
#define CGAME 201
#define MOVELEFT 211
#define MOVERIGHT 221
#define ROTATE 231

#define BLOCKSIZE 15		//  Ʈũ
#define NUMBEROFBLOCK 4		//    ϴ 
#define BOARDHEIGHT 25		//  迭 
#define BOARDWIDTH 14		//  迭 
#define BOARDxSTART 107		//     ؼ ( )
#define BOARDySTART 92		//     ؼ	

#define READYSOUND 2748		//   ÷ ũ
#define LASER 2750			
#define NEXTSOUND 2850
#define BLOCKED 3000
#define LANDING 3003
#define EXPLO   3006
#define MAINLOAD 3008
#define TESTSOUND 3010
#define NOROTATE 3100
#define ROTATESND 3120
#define COUNTDOWN 3130
#define LEVELUP 3200

CDXScreen *pSc;				// ̷Ʈ ο  ʱȭ

///////////////////////////////////////////////////////////////////////////////
//							KText Class
///////////////////////////////////////////////////////////////////////////////

class KText {

public:
	KText();
		// 
	void PutFont(CDXSurface * lpDDSD,int xPos,int yPos,WORD color,char *pStr);
		//  Ʈ ڿ ȭ鿡 Ѹ
	BOOL PutFontFrame(CDXSurface* lpDDS,int xPos,int yPos,WORD COLOR,char *pStr, short left, short right);
		//  Ʈ ڿ ¿ ŬϿ Ѹ
	BOOL PutFontFrameVT(CDXSurface* lpDDS,int xPos,int yPos,WORD COLOR,char *pStr, short top, short bottom);
		//  Ʈ ڿ Ϸ ŬϿ Ѹ

private:
	char HAN[2350][32];	// Ʈ 迭
	char ENG[256][16];
	
	int ENGLISH_WIDTH ;		// Ʈ 		
	int HANGUL_WIDTH ;
	int SPACE_WIDTH ;

	enum FONT_FILE_TYPE			// Ʈ Ÿ
	{
		HANGUL_FNT,	
		ENGLISH_FNT,
	};
	
	int GetKsIndex(BYTE fstByte,BYTE sndByte);
		// ѱ ε 
	void Put_Eng(WORD *point,int nWidth,WORD color,char *pData);
		//  Ʈ ׷ǥ鿡 ´
	void Put_Han(WORD *point,int nWidth,WORD color,char *pData);
		// ѱ Ʈ ׷ǥ鿡 ´
	BOOL InitFont(char *pHan,char *pEng);
		// Ʈ ʱȭѴ
	BOOL LoadFont(char *pFile,WORD wType);
		// Ʈ ޸ 迭 оδ
	void SetFontWidth(int nHangul,int nEnglish,int nSpace);
		// Ʈ  Ѵ
};

KText::KText()
{
	ENGLISH_WIDTH = 0;
	HANGUL_WIDTH = 0;
	SPACE_WIDTH = 0;

	InitFont("DATA090","DATA091");
}

void KText::Put_Eng(WORD *point,int nWidth,WORD color,char *pData)
{
	for(int i=0;i<16;i++, color--)
	{
		if(*pData)
		{
			if(*pData & 0X80) *(point)   = color;
			if(*pData & 0X40) *(point+1) = color;
			if(*pData & 0X20) *(point+2) = color;
			if(*pData & 0X10) *(point+3) = color;
			if(*pData & 0X08) *(point+4) = color;
			if(*pData & 0X04) *(point+5) = color;
			if(*pData & 0X02) *(point+6) = color;
			if(*pData & 0X01) *(point+7) = color;
		}
		point += nWidth;
		pData++;
	}	
}

void KText::Put_Han(WORD *point,int nWidth,WORD color,char *pData)
{
	for(int i=0;i<16;i++, color--)
	{
		if(*pData)
		{
			if (*pData & 0X80) *(point)  =color;
			if (*pData & 0X40) *(point+1)=color;
			if (*pData & 0X20) *(point+2)=color;
			if (*pData & 0X10) *(point+3)=color;
			if (*pData & 0X08) *(point+4)=color;
			if (*pData & 0X04) *(point+5)=color;
			if (*pData & 0X02) *(point+6)=color;
			if (*pData & 0X01) *(point+7)=color;
		}
		pData++;
		if(*pData)
		{
			if (*pData & 0X80) *(point+8) =color;
			if (*pData & 0X40) *(point+9) =color;
			if (*pData & 0X20) *(point+10)=color;
			if (*pData & 0X10) *(point+11)=color;
			if (*pData & 0X08) *(point+12)=color;
			if (*pData & 0X04) *(point+13)=color;
			if (*pData & 0X02) *(point+14)=color;
			if (*pData & 0X01) *(point+15)=color;
		}
		point += nWidth;
		pData++;
	}
}

BOOL KText::LoadFont(char *pFile,WORD wType)
{
	FILE *fp;
	fp = fopen(pFile,"rb");
	if(fp==NULL) return FALSE;

	if(wType == ENGLISH_FNT)
	{
		fread(ENG, 4096, 1, fp);
	} else
	{
		fread(HAN,75200, 1, fp);
	}
	fclose(fp);
	return TRUE;
}

void KText::SetFontWidth(int nHangul,int nEnglish,int nSpace)
{
	HANGUL_WIDTH  = nHangul;
	ENGLISH_WIDTH = nEnglish;
	SPACE_WIDTH   = nSpace;
}

BOOL KText::InitFont(char *pHan,char *pEng)
{
	BOOL ret = FALSE;

	if(pHan)
	{
		ret = LoadFont(pHan,HANGUL_FNT);
		if(!ret) return FALSE;
		SetFontWidth(16,ENGLISH_WIDTH,8);
	}

	if(pEng)
	{
		ret = LoadFont(pEng,ENGLISH_FNT);
		SetFontWidth(HANGUL_WIDTH,8,8);
	}
	return ret;
}

int KText::GetKsIndex(BYTE fstByte,BYTE sndByte)
{
	return ( (int)fstByte  - 0xb0) * 94 + (int)sndByte - 0xa1;
}

void KText::PutFont(CDXSurface *lpDDS,int xPos,int yPos,WORD color,char *pStr)
{
	BYTE fstByte;
	WORD *ptr;
	
	if(lpDDS->Lock() !=DD_OK) return;
		
	ptr = (WORD *)lpDDS->m_DDSD.lpSurface + (yPos * pSc->m_dwPixelWidth) + xPos;
	while(*pStr) {

		fstByte = *pStr++;

		if(fstByte & 0x80)   
		{
			Put_Han(ptr, pSc->m_dwPixelWidth ,color,HAN[GetKsIndex(fstByte,*pStr++)]);
			ptr  += HANGUL_WIDTH;
			xPos += HANGUL_WIDTH;
		} 
		else
		{
			if(fstByte != ' ') 
			{
				Put_Eng(ptr, pSc->m_dwPixelWidth ,color,*(ENG+fstByte));
				ptr += ENGLISH_WIDTH;
				xPos+= ENGLISH_WIDTH;
			} else 
			{
				ptr  += SPACE_WIDTH;
				xPos += SPACE_WIDTH;
			}
		}
	}
	lpDDS->UnLock();
	return;
}

BOOL KText::PutFontFrame(CDXSurface* lpDDS,int xPos,int yPos,WORD COLOR,char *pStr, short left, short right)
{
	BYTE fstByte;
	WORD *PTR;
	int i;
	
	if(lpDDS->Lock() !=DD_OK) return FALSE;
	
	PTR = (WORD *)lpDDS->m_DDSD.lpSurface + (yPos * pSc->m_dwPixelWidth) + xPos;
	while(*pStr) {
		fstByte = *pStr++;
		if(fstByte & 0x80)   
		{
			char *pData = HAN[GetKsIndex(fstByte, *pStr++)];
			WORD color = COLOR;
			WORD *ptr;
			ptr = PTR;
			for(i=0;i<16;i++, color--)
			{
				if(*pData)
				{
					if ((*pData & 0X80) && (xPos > left) && (xPos < right))  *(ptr)  =color;
					if ((*pData & 0X40) && (xPos+1 > left) && (xPos+1 < right)) *(ptr+1)=color;
					if ((*pData & 0X20) && (xPos+2 > left) && (xPos+2 < right)) *(ptr+2)=color;
					if ((*pData & 0X10) && (xPos+3 > left) && (xPos+3 < right)) *(ptr+3)=color;
					if ((*pData & 0X08) && (xPos+4 > left) && (xPos+4 < right)) *(ptr+4)=color;
					if ((*pData & 0X04) && (xPos+5 > left) && (xPos+5 < right)) *(ptr+5)=color;
					if ((*pData & 0X02) && (xPos+6 > left) && (xPos+6 < right)) *(ptr+6)=color;
					if ((*pData & 0X01) && (xPos+7 > left) && (xPos+7 < right)) *(ptr+7)=color;
				}
				pData++;
				if(*pData)
				{
					if ((*pData & 0X80) && (xPos+8 > left) && (xPos+8 < right)) *(ptr+8) =color;
					if ((*pData & 0X40) && (xPos+9 > left) && (xPos+9 < right)) *(ptr+9) =color;
					if ((*pData & 0X20) && (xPos+10 > left) && (xPos+10 < right)) *(ptr+10)=color;
					if ((*pData & 0X10) && (xPos+11 > left) && (xPos+11 < right)) *(ptr+11)=color;
					if ((*pData & 0X08) && (xPos+12 > left) && (xPos+12 < right)) *(ptr+12)=color;
					if ((*pData & 0X04) && (xPos+13 > left) && (xPos+13 < right)) *(ptr+13)=color;
					if ((*pData & 0X02) && (xPos+14 > left) && (xPos+14 < right)) *(ptr+14)=color;
					if ((*pData & 0X01) && (xPos+15 > left) && (xPos+15 < right)) *(ptr+15)=color;
				}
				ptr += pSc->m_dwPixelWidth;
				pData++;
			}
			PTR  += HANGUL_WIDTH;
			xPos += HANGUL_WIDTH;
		} 
		else
		{
			if(fstByte != ' ') 
			{
				WORD color = COLOR;
				WORD *ptr;
				ptr = PTR;
				char *pData = *(ENG+fstByte);
				for(i=0;i<16;i++, color--)
				{
					if(*pData)
					{
						if((*pData & 0X80) && (xPos > left) && (xPos < right)) *(ptr)   = color;
						if((*pData & 0X40) && (xPos+1 > left) && (xPos+1 < right)) *(ptr+1) = color;
						if((*pData & 0X20) && (xPos+2 > left) && (xPos+2 < right)) *(ptr+2) = color;
						if((*pData & 0X10) && (xPos+3 > left) && (xPos+3 < right)) *(ptr+3) = color;
						if((*pData & 0X08) && (xPos+4 > left) && (xPos+4 < right)) *(ptr+4) = color;
						if((*pData & 0X04) && (xPos+5 > left) && (xPos+5 < right)) *(ptr+5) = color;
						if((*pData & 0X02) && (xPos+6 > left) && (xPos+6 < right)) *(ptr+6) = color;
						if((*pData & 0X01) && (xPos+7 > left) && (xPos+7 < right)) *(ptr+7) = color;
					}
					ptr += pSc->m_dwPixelWidth;
					pData++;
				}	
				PTR += ENGLISH_WIDTH;
				xPos+= ENGLISH_WIDTH;
			} else
			{
			PTR  += SPACE_WIDTH;
			xPos += SPACE_WIDTH;
			}
		}
	}
	lpDDS->UnLock();
	return TRUE;
}

BOOL KText::PutFontFrameVT(CDXSurface* lpDDS,int xPos,int yPos,WORD COLOR,char *pStr, short top, short bottom)
{
	BYTE fstByte;
	WORD *PTR;
	int i;
	
	if(lpDDS->Lock() !=DD_OK) return FALSE;
	PTR = (WORD *)lpDDS->m_DDSD.lpSurface + (yPos * pSc->m_dwPixelWidth) + xPos;
	
	while(*pStr) {
		fstByte = *pStr++;
		if(fstByte & 0x80)
		{
			char *pData = HAN[GetKsIndex(fstByte, *pStr++)];
			WORD color = COLOR;
			WORD *ptr;
			ptr = PTR;
			for(i=0;i<16;i++, color--)
			{
				if((*pData) && (yPos > top) && (yPos + i < bottom))
				{
					if (*pData & 0X80) *(ptr)  =color;
					if (*pData & 0X40) *(ptr+1)=color;
					if (*pData & 0X20) *(ptr+2)=color;
					if (*pData & 0X10) *(ptr+3)=color;
					if (*pData & 0X08) *(ptr+4)=color;
					if (*pData & 0X04) *(ptr+5)=color;
					if (*pData & 0X02) *(ptr+6)=color;
					if (*pData & 0X01) *(ptr+7)=color;
				}
				pData++;
				if((*pData) && (yPos > top) && (yPos + i < bottom))
				{
					if (*pData & 0X80) *(ptr+8) =color;
					if (*pData & 0X40) *(ptr+9) =color;
					if (*pData & 0X20) *(ptr+10)=color;
					if (*pData & 0X10) *(ptr+11)=color;
					if (*pData & 0X08) *(ptr+12)=color;
					if (*pData & 0X04) *(ptr+13)=color;
					if (*pData & 0X02) *(ptr+14)=color;
					if (*pData & 0X01) *(ptr+15)=color;
				}
				ptr += pSc->m_dwPixelWidth;
				pData++;
			}

			PTR  += HANGUL_WIDTH;
			xPos += HANGUL_WIDTH;
		} 
		else
		{
			if(fstByte != ' ') 
			{
				WORD color = COLOR;
				WORD *ptr;
				ptr = PTR;
				char *pData = *(ENG+fstByte);
				for(i=0;i<16;i++, color--)
				{
					if((*pData) && (yPos > top) && (yPos + i < bottom))
					{
						if (*pData & 0X80) *(ptr)   = color;
						if (*pData & 0X40) *(ptr+1) = color;
						if (*pData & 0X20) *(ptr+2) = color;
						if (*pData & 0X10) *(ptr+3) = color;
						if (*pData & 0X08) *(ptr+4) = color;
						if (*pData & 0X04) *(ptr+5) = color;
						if (*pData & 0X02) *(ptr+6) = color;
						if (*pData & 0X01) *(ptr+7) = color;
					}
					ptr += pSc->m_dwPixelWidth;
					pData++;
				}	
				PTR += ENGLISH_WIDTH;
				xPos+= ENGLISH_WIDTH;
			} else
			{
			PTR  += SPACE_WIDTH;
			xPos += SPACE_WIDTH;
			}
		}
	}
	lpDDS->UnLock();
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
//							Main 
///////////////////////////////////////////////////////////////////////////////

HWND hWindow;				//   ڵ
HINSTANCE hInstance;		
RECT  rcwin;				//   ȭ 簢 ü

CDXSurface *pFc;			// ũ ǥ (pFc*  ũ (640 x 480))
CDXSurface *pFc2;									  
CDXSurface *pFc3;
CDXSurface *pFc4;
CDXSurface *pFc5;			
CDXSurface *pBlockS[7][4];	//   ׷ǥ 迭 (7 4)
CDXSurface *pBlockE[5];		//     - 5
CDXSurface *temp1;			//  ǥú ̵   Ʈ
CDXSurface *temp2;
CDXSurface *temp3;
CDXSurface *temp4;
CDXSurface *temp5;
CDXSurface *temp6;
CDXSprite *pBlockR[7];		// 7   ȸ Ʈ
CDXSprite *pTitleB;			// ŸƲ  ϸƮ Ʈ
CDXSprite *pSign;			//  Ϸ̳Ʈ Ʈ
CDXSprite *p1Pmenu;			// 6 ޴ Ʈ
CDXSprite *p2Pmenu;
CDXSprite *pVsmenu;
CDXSprite *pStmenu;
CDXSprite *pOrmenu;
CDXSprite *pOpmenu;
CDXSprite *pEXPLO;			// δ ()Ʈ
CDXSprite *pBlockEE;		//   Ʈ
CDXMusic * pMusic;			// ̵  Ŭ
CDXSound * pSound;			// ̷Ʈ Ŭ ʱȭ
CDXSoundBuffer * pSBuffer[9];	// ̷Ʈ  9
KText *pKText;				//  ؽƮ ü 

UINT TimerId;

BOOL bGame = FALSE;			//  ߺ 
BOOL bSPEEDYDOWN = FALSE;	//  ͺٿ  ON/ OFF ÷
BOOL bKILL = FALSE;			// Ƽ    ÷ (  ϰ)
BOOL bActive = TRUE;		//  â ȯ  Ȱȭ  ÷
BOOL bMusic = TRUE;			// ̵   ON/ OFF ÷
BOOL bSound = TRUE;			// ̷Ʈ    ÷
BOOL bIntro = FALSE;		// Ʈδ ũ  ÷
BOOL bSignAct = FALSE;		//  Ϸ̳Ʈ ų ϴ ÷
BOOL bIsErr = FALSE;		// ޸  üũ ÷
BOOL bStatus = FALSE;		// ׸α  /    ÷
BOOL bPageCounter = TRUE;	//  ø 0 1 ϴ ÷
							// Ǯũ ȭڸ  0ȭ鿡 ǥ!!
short DeleteY[BOARDHEIGHT];	//  °  Ǿ ϴ 迭
						
BYTE BITGRIGHT = 11;		// 565 / 555 忡   Ʈ 
BYTE BITGLEFT = 6;			//                            Ʈ
BYTE RBitPos = 10;			//			              Ʈ ġ
BYTE GREENDEEP = 0;			//                        Ʈ  
WORD WHITE_COLOR = 0x7FFF;	//						  ÷
WORD TEXT_COLORy = 0x7FE0;	//						 Ȳ ÷
WORD TEXT_COLORb = 0x631F;	//						 ϴû ÷
WORD TEXT_COLORg = 0x63F8;	//						 λ ÷

BYTE CurFrame11 = 1;		// 6    ȭ  
BYTE CurFrame12 = 1;
BYTE CurFrame13 = 1;
BYTE CurFrame14 = 1;
BYTE CurFrame15 = 1;			
BYTE CurFrame16 = 1;

short Ypos1 = 481;			// ٸ޴ Ʈ ġ ( : ȭ ϴ )
short Ypos2 = 535;			// Ʒٸ޴  "
short Ypos9 = 491;			// Ʈδ  Y ǥ ġ  / ߿ HISCORE ġ
short xPos1 = 620;			//  11   xPos* =   Xǥ ġ
short xPos2 = 626;
short xPos3 = 632;
short xPos4 = 638;
short xPos5 = 644;
short xPos6 = 650;
short xPos7 = 656;
short xPos8 = 662;
short xPos9 = 668;
short xPos10 = 674;
short xPos11 = 680;
short xPos12 = 320;
short MLx=113, MLy=30;		// Ʈ ġ / Ƽ ޼ ũ Xǥ 
short iCounter[9]			//  ̵  μ  ܰ ī
		= {1, 1, 1, 1, 1, 1, 1, 1, 1};		
short iLevelUP = 0;			//  ö󰡴µ Ʈ  ī
short ADDDot;				// δ   ϰ  
WORD Lx = 16;				// ŸƲ ƮƮ   
WORD Ly = 481;
WORD Lx2 = 16 + 189;
WORD Ly2 = 481 + 47;
BYTE Wide = 15;				// ޴ ũѰ /  ׸ Ÿ̹ī

char HiLevel[4][11];		// ְ 1~ 4 , ġ , ̸ 迭
char HiExp[4][10];			//  4 11  10 ( /  )
char HiName[4][10];

BOOL tempMusic ;			// ̵ ON/OFF
int tempVolume ;			//   
short tempFps ;				// ȭ  ӵ
short tempRotate ;			//  Ʈ е
short tempTurbo ;			// ͺٿ ӵ
short tempLevel ;			//  ۽ ⺻     ӽ  
short tempLaser ;			//   ӽ 

short CurLASER = 9;			//   
BYTE CurCtrl = READY;		// α׷  μ ñ
short CurLEVEL = 1;			//  ۽ 
int CurVOLUME = 0;			//   
short CurFPS = 20;			//    (FPS)
short CurROTATE = 1;		//   ȸ ̵ е(Ʈ)
short CurTURBO = 2;			//   ͺٿ   Ÿ
short CurPosition[NUMBEROFBLOCK][2];	// ̿ εǴ   ġ
short CurDelayTime = 300;	//  1Ʈ   Ÿ
short BXPosition;			//   Ʈ 
short BYPosition;		
short DXPosition;			// Ʈ  Ʈ 
short DYPosition;		
short CurBlock;				//  õ  
short NextBlock;			//    
short LastLine;				//   ϴ  
short DelLines = 0;			// ѹ   
short CurDirection;			//   ϰ ִ 
short TempDirection;		//  ȸ Ǵ ӽ 
short yST;					//   ο  ̵˻ ÷
BYTE Board[BOARDHEIGHT][BOARDWIDTH];	//    迭

char LevelStr[12] = "";	//  Ʈ
char InputName[9];			// ְ ̸Է¿ Ʈ 
short Level1 ;				// ÷̾   
unsigned long Exp1 = 0;		// ÷̾  ġ()

char * text1 = "ּ. ״ ΰ.";	//  Ʈ
char * text2 = ": ѹα.  : .  94' ΰ .  95'Ǳб ǻͰа.  21C' ְ ӵ̳.";
char * text3 = " ڶ ѱ̴.  ѱ ӻ    ׳ ּ  ̴.";
char * text4 = " ڶ Ǳ̴.   Ǳб ̸  ʴ´.";
char * text5 = " 뼱̽  Ѵ.  ԰  ٸ,      ̴.";
char * text6 = "̾, Ѵ. ^^;";
char * text7 = "߱ ݿ ϰ  ֽ Բ  縦 帳ϴ.  մϴ.";
char * text8 = "  Ű  ʹ ۱ մϴ.";
char * text9 = "Ȳ 츮 ӻ  ƳⰡ ̷ Ʊ.";
char * text10 = ", Ѻ ֽʽÿ.  Ӵٿ  ڽϴ.  ֽʽÿ.(Ʒ)";
char * text11 = "`RED BLOOD' /ȭ : , ӵ : ּ,  : FEW.";

BOOL MusicLoad(char * Filename);
	// ̵ ޸𸮿 Ѵ
void DrawBoardFI();
	// ̻ 100 ̻   ġ  ̵Ѵ
void DrawHISCORE(void);
	// ְ ȭ ʿ νũѾ Ų
void ReadSystemData(void);
	// Ͽ  ý  ̽ھ оδ
void GetLevel(int level);
	//    , Ÿ Ѵ
int GetSoundPos(void);
	//  ġ  дװ Ѵ
void DetectArray(void);
	//    迭 νŲ
void NextBlockSet(void);
	//   Ҽ ֵ غѴ
void PlayMusic (char* mus);
	//   ̵ о ÷Ѵ
void PlaySound(int pan, int flag);
	//  ÷׿  ȿ о̰ų ÷Ѵ
void AnimatThread(PVOID pvoid);
	// ŸƲȭ̳ Ÿ  10 FPS ӵ  ϴ Ƽƾ
void BlockControlThread(PVOID pvoid);
	//  ¿ ̵ Ʈϴ Ƽ ƾ
void BlockScrollThread(PVOID pvoid);
	// ð   ѵƮ Ʒ ߸ Ƽƾ
void mosaic(UINT size, CDXSurface *pSuf, CDXSurface *pBack );
	//  ǥ ũŲ
void Title_Fade(void);
	// ΰ ȭ ȭ鿡 Ʈ Ų
void Title_Mosaic(void);
	// ΰ̵   ͸ о鿩 ũ  غѴ
void Animate_Title(void);
	// ŸƲȭ ׸ ƾ
long CALLBACK PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	//  ޼ óƾ
BOOL InitApp(HINSTANCE hInst, int nCmdShow);
	//   ʱȭ ۾ 
void CALLBACK TimerProc (UINT iTimerID, UINT iMsg, DWORD User, DWORD dw1, DWORD dw2);
	// ȭ  Ÿ̸Ӹ ޾ ׷ȭ ϴ ٽ ƾ
void LightEffect_BOX(int X, int Y,int dx, int dy, CDXSurface* lpDDS);
	// ŸƲȭ ޴  ȿ ƾ
BOOL APIENTRY BoxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	// 1ư ߸ ȭ ν
BOOL APIENTRY BoxProc2(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	// 2ư߸  ȭ ν
BOOL APIENTRY BoxProc3(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	// ְ  ȭ ν
BOOL APIENTRY StatusBoxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	// ý  ν
void HLine(int y, int y2, CDXSurface * lpDDS, int iw);
	//   ׸ ƾ
void VLine(int x, int x2, CDXSurface * lpDDS, int iw);
	//   ׸ ƾ
void SoundInit(void);
	//  ȿ ˻ ʱȭ
void NewGame(void);
	// ο  ۽   迭 ʱȭ
void MagicLight(int x, int y, CDXSurface* lpDDS);
	// Ʈ  ƾ
void White(CDXSurface * pSuf);
	//  ǥ ä Լ
void DrawPR(void);
	//  ũ ϴ ƾ
void CompareBlock(short StartY);
	//     ˻ϴ ƾ
void ReadyToStart(void);
	//    غ    ε
void MakeBlockRandom(int data);
	//  ڻ  ȿ ߿ Ƿ 100 ̻  
BOOL FadeInSurface(short Num, int x, int y, CDXSurface * lpDDS, CDXSurface * lpBack);
	//  ǥ ȭ ̵()Ű ƾ
void WriteHiScore(void);
	// ̽ھ ȭ鿡  Ѹ ƾ
BOOL InitTimer();
	//  ӵ Ÿ̸Ӹ Ѵ
void DrawNextFrame(void);
	//   ׸. 
void Fade_IN(CDXSurface *pSuf, CDXSurface *pBack);
	// ȭ  ̵Ѵ.
void Fade_OUT(CDXSurface *pSuf, CDXSurface *pBack);
	// ȭ  ̵ƿѴ.

BOOL InitTimer()
{
	TIMECAPS caps;
	timeGetDevCaps ( &caps, sizeof(caps));
	timeBeginPeriod(caps.wPeriodMin);
	TimerId = timeSetEvent (1000 / CurFPS , caps.wPeriodMin, TimerProc, 0, (UINT)TIME_PERIODIC);
	return TRUE;
}

void MakeBlockRandom(int data)
{
	int i, j;
	do{
		i = rand() % BOARDHEIGHT;
		j = rand() % BOARDWIDTH;
	} while ((Board[i][j] < 1) || (Board[i][j] > 100));
	Board[i][j] = data;
	BXPosition = j;			// Ҹġ  ӽ÷ bx 
	PlaySound(GetSoundPos(), EXPLO);
}

void ReadSystemData()
{
	HANDLE hFile;
	DWORD nIn;
	int i, j, k;
	char buffer[122];				//27 * 4 + 14];
	char temp[6];

	hFile = CreateFile ("DATA001", GENERIC_READ , 
			0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) CloseHandle (hFile);	//  ȭ 
	ReadFile (hFile, buffer, 122, &nIn, NULL); //27=1st data *4 + 11(option data)
	CloseHandle (hFile);

	for( k = 0; k < 4; k ++)
	{
		for(i = 0;i < 10; i++)
			HiLevel[k][i] = buffer[(i*2) + (k * 27)];
		for(j = 15, i = 0; i < 8;i++)
		{
			HiName[k][i] = buffer[(k * 27) + j];
			j-=2;
		}
		HiExp[k][0] = buffer[20 + (k* 27)];
		HiExp[k][1] = buffer[22 + (k* 27)];
		HiExp[k][2] = buffer[24 + (k* 27)];
		HiExp[k][3] = buffer[26 + (k* 27)];
		HiExp[k][4] = buffer[25 + (k* 27)];
		HiExp[k][5] = buffer[23 + (k* 27)];
		HiExp[k][6] = buffer[21 + (k* 27)];
		HiExp[k][7] = buffer[19 + (k* 27)];
		HiExp[k][8] = buffer[17 + (k* 27)];
	}
	temp[0] = buffer[108];
	temp[1] = buffer[109];
	temp[2] = '\0';

	CurFPS = (short)atoi(temp);		
	if ((CurFPS > 70) || (CurFPS < 10)) CurFPS = 20;	

	temp[0] = buffer[110];
	temp[1] = '\0';
	CurLASER = (short)atoi(temp);
	if ((CurLASER != 9) && (CurLASER != 7) && (CurLASER != 5) &&
		(CurLASER != 3) && (CurLASER != 1)) CurLASER = 9;

	temp[0] = buffer[111];
	temp[1] = '\0';
	CurTURBO = (short)atoi(temp);

	temp[0] = buffer[112];
	temp[1] = '\0';
	CurROTATE = (short)atoi(temp);	

	if (buffer[113] =='1') bMusic=TRUE; else bMusic = FALSE;
	for(j = 114, i = 0; i < 5; i++, j++)
		temp[i] = buffer[j];
	temp[5] = '\0';
	CurVOLUME = atoi(temp) - 10000;	// -10000 ~ 0 is real volume value

	temp[0] = buffer[119];
	temp[1] = buffer[120];
	temp[2] = '\0';
	CurLEVEL = atoi(temp);

	// Bellow Lines are decodeing hiscore data in secret
	for(j = 0; j < 4; j++)
	for(i = 0; i < 10; i++)
	{
		if (HiLevel[j][i] == 'L') {HiLevel[j][i] ='1'; continue;}
		if (HiLevel[j][i] == 'e') {HiLevel[j][i] ='2'; continue;}
		if (HiLevel[j][i] == '2') {HiLevel[j][i] ='3'; continue;}
		if (HiLevel[j][i] == 'f') {HiLevel[j][i] ='4'; continue;}
		if (HiLevel[j][i] == 's') {HiLevel[j][i] ='5'; continue;}
		if (HiLevel[j][i] == 'A') {HiLevel[j][i] ='6'; continue;}
		if (HiLevel[j][i] == 'M') {HiLevel[j][i] ='7'; continue;}
		if (HiLevel[j][i] == 'W') {HiLevel[j][i] ='8'; continue;}
		if (HiLevel[j][i] == 'r') {HiLevel[j][i] ='9'; continue;}
		if (HiLevel[j][i] == 'N') {HiLevel[j][i] ='0'; continue;}
		if (HiLevel[j][i] == '7') {HiLevel[j][i] ='A'; continue;}
		if (HiLevel[j][i] == 'z') {HiLevel[j][i] ='B'; continue;}
		if (HiLevel[j][i] == 'D') {HiLevel[j][i] ='C'; continue;}
		if (HiLevel[j][i] == '1') {HiLevel[j][i] ='D'; continue;}
		if (HiLevel[j][i] == 'V') {HiLevel[j][i] ='E'; continue;}
		if (HiLevel[j][i] == 'k') {HiLevel[j][i] ='F'; continue;}
		if (HiLevel[j][i] == 'l') {HiLevel[j][i] ='G'; continue;}
		if (HiLevel[j][i] == 'p') {HiLevel[j][i] ='H'; continue;}
		if (HiLevel[j][i] == 'S') {HiLevel[j][i] ='I'; continue;}
		if (HiLevel[j][i] == '6') {HiLevel[j][i] ='J'; continue;}
		if (HiLevel[j][i] == 'T') {HiLevel[j][i] ='K'; continue;}
		if (HiLevel[j][i] == 'n') {HiLevel[j][i] ='L'; continue;}
		if (HiLevel[j][i] == 'U') {HiLevel[j][i] ='M'; continue;}
		if (HiLevel[j][i] == 'm') {HiLevel[j][i] ='N'; continue;}
		if (HiLevel[j][i] == 'i') {HiLevel[j][i] ='O'; continue;}
		if (HiLevel[j][i] == '9') {HiLevel[j][i] ='P'; continue;}
		if (HiLevel[j][i] == 'C') {HiLevel[j][i] ='Q'; continue;}
		if (HiLevel[j][i] == 'B') {HiLevel[j][i] ='R'; continue;}
		if (HiLevel[j][i] == '8') {HiLevel[j][i] ='S'; continue;}
		if (HiLevel[j][i] == 'g') {HiLevel[j][i] ='T'; continue;}
		if (HiLevel[j][i] == 'j') {HiLevel[j][i] ='U'; continue;}
		if (HiLevel[j][i] == 'O') {HiLevel[j][i] ='V'; continue;}
		if (HiLevel[j][i] == 'h') {HiLevel[j][i] ='W'; continue;}
		if (HiLevel[j][i] == 'q') {HiLevel[j][i] ='X'; continue;}
		if (HiLevel[j][i] == 'P') {HiLevel[j][i] ='Y'; continue;}
		if (HiLevel[j][i] == 'o') {HiLevel[j][i] ='Z'; continue;}
		if (HiLevel[j][i] == 'J') {HiLevel[j][i] ='a'; continue;}
		if (HiLevel[j][i] == '0') {HiLevel[j][i] ='b'; continue;}
		if (HiLevel[j][i] == 'K') {HiLevel[j][i] ='c'; continue;}
		if (HiLevel[j][i] == '3') {HiLevel[j][i] ='d'; continue;}
		if (HiLevel[j][i] == '4') {HiLevel[j][i] ='e'; continue;}
		if (HiLevel[j][i] == 'E') {HiLevel[j][i] ='f'; continue;}
		if (HiLevel[j][i] == 'Q') {HiLevel[j][i] ='g'; continue;}
		if (HiLevel[j][i] == '5') {HiLevel[j][i] ='h'; continue;}
		if (HiLevel[j][i] == 'R') {HiLevel[j][i] ='j'; continue;}
		if (HiLevel[j][i] == 't') {HiLevel[j][i] ='i'; continue;}
		if (HiLevel[j][i] == 'y') {HiLevel[j][i] ='k'; continue;}
		if (HiLevel[j][i] == 'Y') {HiLevel[j][i] ='l'; continue;}
		if (HiLevel[j][i] == 'd') {HiLevel[j][i] ='m'; continue;}
		if (HiLevel[j][i] == 'v') {HiLevel[j][i] ='n'; continue;}
		if (HiLevel[j][i] == 'X') {HiLevel[j][i] ='o'; continue;}
		if (HiLevel[j][i] == 'w') {HiLevel[j][i] ='p'; continue;}
		if (HiLevel[j][i] == 'u') {HiLevel[j][i] ='q'; continue;}
		if (HiLevel[j][i] == 'x') {HiLevel[j][i] ='r'; continue;}
		if (HiLevel[j][i] == 'b') {HiLevel[j][i] ='s'; continue;}
		if (HiLevel[j][i] == 'Z') {HiLevel[j][i] ='t'; continue;}
		if (HiLevel[j][i] == 'G') {HiLevel[j][i] ='u'; continue;}
		if (HiLevel[j][i] == 'H') {HiLevel[j][i] ='v'; continue;}
		if (HiLevel[j][i] == 'I') {HiLevel[j][i] ='w'; continue;}
		if (HiLevel[j][i] == 'c') {HiLevel[j][i] ='x'; continue;}
		if (HiLevel[j][i] == 'a') {HiLevel[j][i] ='y'; continue;}
		if (HiLevel[j][i] == 'F') {HiLevel[j][i] ='z'; continue;}
	}

	for(j = 0; j < 4; j++)
	for(i = 0; i < 9; i++)
	{
		if (HiExp[j][i] == 'L') {HiExp[j][i] ='1'; continue;}
		if (HiExp[j][i] == 'e') {HiExp[j][i] ='2'; continue;}
		if (HiExp[j][i] == '2') {HiExp[j][i] ='3'; continue;}
		if (HiExp[j][i] == 'f') {HiExp[j][i] ='4'; continue;}
		if (HiExp[j][i] == 's') {HiExp[j][i] ='5'; continue;}
		if (HiExp[j][i] == 'A') {HiExp[j][i] ='6'; continue;}
		if (HiExp[j][i] == 'M') {HiExp[j][i] ='7'; continue;}
		if (HiExp[j][i] == 'W') {HiExp[j][i] ='8'; continue;}
		if (HiExp[j][i] == 'r') {HiExp[j][i] ='9'; continue;}
		if (HiExp[j][i] == 'N') {HiExp[j][i] ='0'; continue;}
	}

	for(j = 0; j < 4; j++)
	for(i = 0; i < 8; i++)
	{
		if (HiName[j][i] == 'L') {HiName[j][i] ='1'; continue;}
		if (HiName[j][i] == 'e') {HiName[j][i] ='2'; continue;}
		if (HiName[j][i] == '2') {HiName[j][i] ='3'; continue;}
		if (HiName[j][i] == 'f') {HiName[j][i] ='4'; continue;}
		if (HiName[j][i] == 's') {HiName[j][i] ='5'; continue;}
		if (HiName[j][i] == 'A') {HiName[j][i] ='6'; continue;}
		if (HiName[j][i] == 'M') {HiName[j][i] ='7'; continue;}
		if (HiName[j][i] == 'W') {HiName[j][i] ='8'; continue;}
		if (HiName[j][i] == 'r') {HiName[j][i] ='9'; continue;}
		if (HiName[j][i] == 'N') {HiName[j][i] ='0'; continue;}
		if (HiName[j][i] == '7') {HiName[j][i] ='A'; continue;}
		if (HiName[j][i] == 'z') {HiName[j][i] ='B'; continue;}
		if (HiName[j][i] == 'D') {HiName[j][i] ='C'; continue;}
		if (HiName[j][i] == '1') {HiName[j][i] ='D'; continue;}
		if (HiName[j][i] == 'V') {HiName[j][i] ='E'; continue;}
		if (HiName[j][i] == 'k') {HiName[j][i] ='F'; continue;}
		if (HiName[j][i] == 'l') {HiName[j][i] ='G'; continue;}
		if (HiName[j][i] == 'p') {HiName[j][i] ='H'; continue;}
		if (HiName[j][i] == 'S') {HiName[j][i] ='I'; continue;}
		if (HiName[j][i] == '6') {HiName[j][i] ='J'; continue;}
		if (HiName[j][i] == 'T') {HiName[j][i] ='K'; continue;}
		if (HiName[j][i] == 'n') {HiName[j][i] ='L'; continue;}
		if (HiName[j][i] == 'U') {HiName[j][i] ='M'; continue;}
		if (HiName[j][i] == 'm') {HiName[j][i] ='N'; continue;}
		if (HiName[j][i] == 'i') {HiName[j][i] ='O'; continue;}
		if (HiName[j][i] == '9') {HiName[j][i] ='P'; continue;}
		if (HiName[j][i] == 'C') {HiName[j][i] ='Q'; continue;}
		if (HiName[j][i] == 'B') {HiName[j][i] ='R'; continue;}
		if (HiName[j][i] == '8') {HiName[j][i] ='S'; continue;}
		if (HiName[j][i] == 'g') {HiName[j][i] ='T'; continue;}
		if (HiName[j][i] == 'j') {HiName[j][i] ='U'; continue;}
		if (HiName[j][i] == 'O') {HiName[j][i] ='V'; continue;}
		if (HiName[j][i] == 'h') {HiName[j][i] ='W'; continue;}
		if (HiName[j][i] == 'q') {HiName[j][i] ='X'; continue;}
		if (HiName[j][i] == 'P') {HiName[j][i] ='Y'; continue;}
		if (HiName[j][i] == 'o') {HiName[j][i] ='Z'; continue;}
		if (HiName[j][i] == 'J') {HiName[j][i] ='a'; continue;}
		if (HiName[j][i] == '0') {HiName[j][i] ='b'; continue;}
		if (HiName[j][i] == 'K') {HiName[j][i] ='c'; continue;}
		if (HiName[j][i] == '3') {HiName[j][i] ='d'; continue;}
		if (HiName[j][i] == '4') {HiName[j][i] ='e'; continue;}
		if (HiName[j][i] == 'E') {HiName[j][i] ='f'; continue;}
		if (HiName[j][i] == 'Q') {HiName[j][i] ='g'; continue;}
		if (HiName[j][i] == '5') {HiName[j][i] ='h'; continue;}
		if (HiName[j][i] == 'R') {HiName[j][i] ='j'; continue;}
		if (HiName[j][i] == 't') {HiName[j][i] ='i'; continue;}
		if (HiName[j][i] == 'y') {HiName[j][i] ='k'; continue;}
		if (HiName[j][i] == 'Y') {HiName[j][i] ='l'; continue;}
		if (HiName[j][i] == 'd') {HiName[j][i] ='m'; continue;}
		if (HiName[j][i] == 'v') {HiName[j][i] ='n'; continue;}
		if (HiName[j][i] == 'X') {HiName[j][i] ='o'; continue;}
		if (HiName[j][i] == 'w') {HiName[j][i] ='p'; continue;}
		if (HiName[j][i] == 'u') {HiName[j][i] ='q'; continue;}
		if (HiName[j][i] == 'x') {HiName[j][i] ='r'; continue;}
		if (HiName[j][i] == 'b') {HiName[j][i] ='s'; continue;}
		if (HiName[j][i] == 'Z') {HiName[j][i] ='t'; continue;}
		if (HiName[j][i] == 'G') {HiName[j][i] ='u'; continue;}
		if (HiName[j][i] == 'H') {HiName[j][i] ='v'; continue;}
		if (HiName[j][i] == 'I') {HiName[j][i] ='w'; continue;}
		if (HiName[j][i] == 'c') {HiName[j][i] ='x'; continue;}
		if (HiName[j][i] == 'a') {HiName[j][i] ='y'; continue;}
		if (HiName[j][i] == 'F') {HiName[j][i] ='z'; continue;}
	}
}

void WriteHiScore()
{
	HANDLE hFile;
	DWORD nOut;
	int i, j, k;
	char buffer[108]; //27 * 4 ];
	
	memset(buffer, '\0', sizeof(buffer));

	for( k = 0; k < 4; k ++)
	{
		for(i = 0;i < 10; i++)
			buffer[(i*2) + (k * 27)] = HiLevel[k][i];
		
		for(j = 15, i = 0; i < 8;i++)
		{
			buffer[(k * 27) + j] = HiName[k][i];
			j-=2;
		}
		buffer[20 + (k* 27)] = HiExp[k][0];
		buffer[22 + (k* 27)] = HiExp[k][1];
		buffer[24 + (k* 27)] = HiExp[k][2];
		buffer[26 + (k* 27)] = HiExp[k][3];
		buffer[25 + (k* 27)] = HiExp[k][4];
		buffer[23 + (k* 27)] = HiExp[k][5];
		buffer[21 + (k* 27)] = HiExp[k][6];
		buffer[19 + (k* 27)] = HiExp[k][7];
		buffer[17 + (k* 27)] = HiExp[k][8];
	}
	// Bellow Lines are Encodeing hiscore data in secret
	for(i = 0; i < 108; i++)
	{
		if (buffer[i] == '1') {buffer[i] ='L'; continue;}
		if (buffer[i] == '2') {buffer[i] ='e'; continue;}
		if (buffer[i] == '3') {buffer[i] ='2'; continue;}
		if (buffer[i] == '4') {buffer[i] ='f'; continue;}
		if (buffer[i] == '5') {buffer[i] ='s'; continue;}
		if (buffer[i] == '6') {buffer[i] ='A'; continue;}
		if (buffer[i] == '7') {buffer[i] ='M'; continue;}
		if (buffer[i] == '8') {buffer[i] ='W'; continue;}
		if (buffer[i] == '9') {buffer[i] ='r'; continue;}
		if (buffer[i] == '0') {buffer[i] ='N'; continue;}
		if (buffer[i] == 'A') {buffer[i] ='7'; continue;}
		if (buffer[i] == 'B') {buffer[i] ='z'; continue;}
		if (buffer[i] == 'C') {buffer[i] ='D'; continue;}
		if (buffer[i] == 'D') {buffer[i] ='1'; continue;}
		if (buffer[i] == 'E') {buffer[i] ='V'; continue;}
		if (buffer[i] == 'F') {buffer[i] ='k'; continue;}
		if (buffer[i] == 'G') {buffer[i] ='l'; continue;}
		if (buffer[i] == 'H') {buffer[i] ='P'; continue;}
		if (buffer[i] == 'I') {buffer[i] ='S'; continue;}
		if (buffer[i] == 'J') {buffer[i] ='6'; continue;}
		if (buffer[i] == 'K') {buffer[i] ='T'; continue;}
		if (buffer[i] == 'L') {buffer[i] ='n'; continue;}
		if (buffer[i] == 'M') {buffer[i] ='U'; continue;}
		if (buffer[i] == 'N') {buffer[i] ='m'; continue;}
		if (buffer[i] == 'O') {buffer[i] ='i'; continue;}
		if (buffer[i] == 'P') {buffer[i] ='9'; continue;}
		if (buffer[i] == 'Q') {buffer[i] ='C'; continue;}
		if (buffer[i] == 'R') {buffer[i] ='B'; continue;}
		if (buffer[i] == 'S') {buffer[i] ='8'; continue;}
		if (buffer[i] == 'T') {buffer[i] ='g'; continue;}
		if (buffer[i] == 'U') {buffer[i] ='J'; continue;}
		if (buffer[i] == 'V') {buffer[i] ='O'; continue;}
		if (buffer[i] == 'W') {buffer[i] ='h'; continue;}
		if (buffer[i] == 'X') {buffer[i] ='q'; continue;}
		if (buffer[i] == 'Y') {buffer[i] ='P'; continue;}
		if (buffer[i] == 'Z') {buffer[i] ='o'; continue;}
		if (buffer[i] == 'a') {buffer[i] ='J'; continue;}
		if (buffer[i] == 'b') {buffer[i] ='0'; continue;}
		if (buffer[i] == 'c') {buffer[i] ='K'; continue;}
		if (buffer[i] == 'd') {buffer[i] ='3'; continue;}
		if (buffer[i] == 'e') {buffer[i] ='4'; continue;}
		if (buffer[i] == 'f') {buffer[i] ='E'; continue;}
		if (buffer[i] == 'g') {buffer[i] ='Q'; continue;}
		if (buffer[i] == 'h') {buffer[i] ='5'; continue;}
		if (buffer[i] == 'i') {buffer[i] ='R'; continue;}
		if (buffer[i] == 'j') {buffer[i] ='t'; continue;}
		if (buffer[i] == 'k') {buffer[i] ='y'; continue;}
		if (buffer[i] == 'l') {buffer[i] ='Y'; continue;}
		if (buffer[i] == 'm') {buffer[i] ='d'; continue;}
		if (buffer[i] == 'n') {buffer[i] ='v'; continue;}
		if (buffer[i] == 'o') {buffer[i] ='X'; continue;}
		if (buffer[i] == 'p') {buffer[i] ='w'; continue;}
		if (buffer[i] == 'q') {buffer[i] ='u'; continue;}
		if (buffer[i] == 'r') {buffer[i] ='x'; continue;}
		if (buffer[i] == 's') {buffer[i] ='b'; continue;}
		if (buffer[i] == 't') {buffer[i] ='Z'; continue;}
		if (buffer[i] == 'u') {buffer[i] ='G'; continue;}
		if (buffer[i] == 'v') {buffer[i] ='H'; continue;}
		if (buffer[i] == 'w') {buffer[i] ='I'; continue;}
		if (buffer[i] == 'x') {buffer[i] ='c'; continue;}
		if (buffer[i] == 'y') {buffer[i] ='a'; continue;}
		if (buffer[i] == 'z') {buffer[i] ='F'; continue;}
	}

	hFile = CreateFile ("DATA001", GENERIC_READ | GENERIC_WRITE , 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) CloseHandle (hFile);	//  ȭ 

	SetFilePointer (hFile, 0,  NULL, FILE_BEGIN); // File Descriptor Set Start
	WriteFile (hFile, buffer, sizeof(buffer), &nOut, NULL);//27=1st data *4 
	CloseHandle (hFile);
}

void NewGame()
{
	Exp1 = 0;
	GetLevel(CurLEVEL -1);		// level & exp init
	
	for (int i = 0; i < BOARDHEIGHT; i++)	// Board array init
		for (int j = 0; j < BOARDWIDTH; j++)
		Board[i][j] = 0;
	NextBlockSet();
}

void ReadyToStart()
{
	int i, j;
	
	delete  pFc4;		// No more use this (Title & logo & menu~)
	delete  pFc3;		// (& old BackGND & sign & Clear Screen SPR)
	delete  pFc2;
	delete  pFc;
	delete  pTitleB;
	delete  pSign;
	delete  p1Pmenu;
	delete  p2Pmenu;
	delete  pVsmenu;
	delete  pStmenu;
	delete  pOrmenu;
	delete  pOpmenu;

	PlaySound(0, MAINLOAD);
	Wide = 1;			// Laser Line Draw Time Set
	
	CurFrame11 = 1;		// Six Laser line Tickness
	CurFrame12 = 1;
	CurFrame13 = 1;
	CurFrame14 = 1;
	CurFrame15 = 1;
	CurFrame16 = 1;
	temp1 = new CDXSurface (pSc, "DATA002");		// load status of display panels
	temp2 = new CDXSurface (pSc, "DATA003");
	temp3 = new CDXSurface (pSc, "DATA004");
	temp4 = new CDXSurface (pSc, "DATA005");
	temp5 = new CDXSurface (pSc, "DATA006");
	temp6 = new CDXSurface (pSc, "DATA007");

	pBlockS[0][0] = new CDXSurface (pSc, "DATA009");	// seven static block load
	pBlockS[0][1] = new CDXSurface (pSc, "DATA010");
	pBlockS[0][2] = new CDXSurface (pSc, "DATA011");
	pBlockS[0][3] = new CDXSurface (pSc, "DATA012");
	pBlockS[1][0] = new CDXSurface (pSc, "DATA013");
	pBlockS[1][1] = new CDXSurface (pSc, "DATA014");
	pBlockS[1][2] = new CDXSurface (pSc, "DATA015");
	pBlockS[1][3] = new CDXSurface (pSc, "DATA016");
	pBlockS[2][0] = new CDXSurface (pSc, "DATA017");
	pBlockS[2][1] = new CDXSurface (pSc, "DATA018");
	pBlockS[2][2] = new CDXSurface (pSc, "DATA019");
	pBlockS[2][3] = new CDXSurface (pSc, "DATA020");
	pBlockS[3][0] = new CDXSurface (pSc, "DATA021");
	pBlockS[3][1] = new CDXSurface (pSc, "DATA022");
	pBlockS[3][2] = new CDXSurface (pSc, "DATA023");
	pBlockS[3][3] = new CDXSurface (pSc, "DATA024");
	pBlockS[4][0] = new CDXSurface (pSc, "DATA025");
	pBlockS[4][1] = new CDXSurface (pSc, "DATA026");
	pBlockS[4][2] = new CDXSurface (pSc, "DATA027");
	pBlockS[4][3] = new CDXSurface (pSc, "DATA028");
	pBlockS[5][0] = new CDXSurface (pSc, "DATA029");
	pBlockS[5][1] = new CDXSurface (pSc, "DATA030");
	pBlockS[5][2] = new CDXSurface (pSc, "DATA031");
	pBlockS[5][3] = new CDXSurface (pSc, "DATA032");
	pBlockS[6][0] = new CDXSurface (pSc, "DATA033");
	pBlockS[6][1] = new CDXSurface (pSc, "DATA034");
	pBlockS[6][2] = new CDXSurface (pSc, "DATA035");
	pBlockS[6][3] = new CDXSurface (pSc, "DATA036");

	pBlockE[0] = new CDXSurface (pSc, "DATA037");
	pBlockE[1] = new CDXSurface (pSc, "DATA038");
	pBlockE[2] = new CDXSurface (pSc, "DATA039");
	pBlockE[3] = new CDXSurface (pSc, "DATA040");
	pBlockE[4] = new CDXSurface (pSc, "DATA041");
	
	pBlockR[0] = new CDXSprite (pSc, "DATA042", 80, 70, 21); //seven block rotate spr load
	pBlockR[1] = new CDXSprite (pSc, "DATA043", 75, 70, 21);
	pBlockR[2] = new CDXSprite (pSc, "DATA044", 75, 75, 21);
	pBlockR[3] = new CDXSprite (pSc, "DATA045", 75, 75, 21);
	pBlockR[4] = new CDXSprite (pSc, "DATA046", 75, 80, 21);
	pBlockR[5] = new CDXSprite (pSc, "DATA047", 75, 80, 21);
	pBlockR[6] = new CDXSprite (pSc, "DATA048", 60, 60, 21);

	pEXPLO = new CDXSprite (pSc, "DATA049", 240, 45, 10);
	pEXPLO->ColorKey(0); 

	pBlockEE = new CDXSprite (pSc, "DATA050", 45, 45, 10);
	pBlockEE->ColorKey(0); 

	pSign = new CDXSprite (pSc, "DATA051", 40, 60, 5);	// hiscore icon.
	pSign->ColorKey(0);
	
	temp1->ColorKey(0); 
	temp2->ColorKey(0); 
	temp3->ColorKey(0);   
	temp4->ColorKey(0);  
	temp5->ColorKey(0);  
	temp6->ColorKey(0);  

	for ( i = 0; i < 7; i++)
	{								//Set color key zero.
		pBlockR[i]->ColorKey(0); 

		for ( j = 0; j < 4; j++)
			pBlockS[i][j]->ColorKey(0);
	}
	Ypos9 = 490;	// hiscore position 
	pMusic->Pause();
	NextBlock = rand() % 7;				// first block create
	CurCtrl=DRAW_SCREEN;		// Current Process pass to Draw Main Screen
}

void GetLevel(int level)
{
	unsigned long tempexp = Exp1;
	switch(CurLEVEL)
	{
	case 2:
		tempexp+=LEVEL2SCORE;
		break;
	case 3:
		tempexp+=LEVEL3SCORE;
		break;
	case 4:
		tempexp+=LEVEL4SCORE;
		break;
	case 5:
		tempexp+=LEVEL5SCORE;
		break;
	case 6:
		tempexp+=LEVEL6SCORE;
		break;
	case 7:
		tempexp+=LEVEL7SCORE;
		break;
	case 8:
		tempexp+=LEVEL8SCORE;
		break;
	case 9:
		tempexp+=LEVEL9SCORE;
		break;
	case 10:
		tempexp+=LEVEL10SCORE;
		break;
	case 11:
		tempexp+=LEVEL11SCORE;
		break;
	case 12:
		tempexp+=LEVEL12SCORE;
		break;
	}

	if (tempexp >= LEVEL12SCORE) 
	{
		if (level == 11) 
		{
			PlayMusic("DATA052");
			PlaySound(0, LEVELUP);
			iLevelUP = 1;
			Level1=12;	strcpy(LevelStr, ""); CurDelayTime = 0;
		}
	}
	else if (tempexp >= LEVEL11SCORE) 
	{
		if (level == 10) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA053");
			iLevelUP = 1;
			Level1=11; strcpy(LevelStr,"ǾƵ");CurDelayTime = 1;
		}
	}
	else if (tempexp >= LEVEL10SCORE) 
	{
		if (level == 9) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA054");
			iLevelUP = 1;
			Level1=10; strcpy(LevelStr,"õ󿵿");CurDelayTime = 2;
		}
	}
	else if (tempexp >= LEVEL9SCORE) 
	{
		if (level == 8) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA055");
			iLevelUP = 1;
			Level1=9; strcpy(LevelStr,"");CurDelayTime = 3;
		}
	}
	else if (tempexp >= LEVEL8SCORE) 
	{
		if (level == 7) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA056");
			iLevelUP = 1;
			Level1=8; strcpy(LevelStr, "");CurDelayTime = 4;
		}
	}
	else if (tempexp >= LEVEL7SCORE) 
	{
		if (level == 6) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA057");
			iLevelUP = 1;
			Level1=7; strcpy(LevelStr, "");CurDelayTime = 6;
		}
	}
	else if (tempexp >= LEVEL6SCORE) 
	{
		if (level == 5) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA058");
			iLevelUP = 1;
			Level1=6; strcpy(LevelStr, "渶⺴");CurDelayTime = 9;
		}
	}
	else if (tempexp >= LEVEL5SCORE) 
	{
		if (level == 4) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA059");
			iLevelUP = 1;
			Level1=5; strcpy(LevelStr,"");CurDelayTime = 12;
		}
	}
	else if (tempexp >= LEVEL4SCORE) 
	{
		if (level == 3) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA060");
			iLevelUP = 1;
			Level1=4; strcpy(LevelStr,"");CurDelayTime = 16;
		}
	}
	else if (tempexp >= LEVEL3SCORE) 
	{
		if (level == 2) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA061");
			iLevelUP = 1;
			Level1=3; strcpy(LevelStr,"");CurDelayTime = 20;
		}
	}
	else if (tempexp >= LEVEL2SCORE) 
	{
		if (level == 1) 
		{
			PlaySound(0, LEVELUP);
			PlayMusic("DATA062");
			iLevelUP = 1;		// Ʈ  
			Level1=2; strcpy(LevelStr,"");CurDelayTime = 30;
		}
	}	
	else if (tempexp < LEVEL2SCORE) 
	{
		if (level == 0) 
		{
			PlayMusic("DATA063");
			Level1=1; strcpy(LevelStr, "");CurDelayTime = 50;
		}
	}
}

void DetectArray()
{
	switch(CurBlock)
	{
	case 0:
 		switch (CurDirection)
		{
		case 0:
		case 2:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition;
			CurPosition[1][1] = BYPosition +1;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 1:
		case 3:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition +3;
			CurPosition[0][1] = BYPosition +2;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +2;
			break;
		}
		break;

	case 1:
		switch (CurDirection)
		{
		case 0:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;
		case 1:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +2;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 2:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition ;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;
		case 3:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition ;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +2;
			break;
		}
		break;

	case 2:
 		switch (CurDirection)
		{
		case 0:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition ;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition ;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 1:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +1;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +2;
			break;

		case 2:
			CurPosition[0][0] = BXPosition +2;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 3:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +2;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +3;
			CurPosition[3][1] = BYPosition +3;
			break;
		}
		break;

	case 3:
 		switch (CurDirection)
		{
		case 0:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 1:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +2;
			CurPosition[2][0] = BXPosition ;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +2;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +3;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 2:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition ;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 3:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +2;
			CurPosition[2][0] = BXPosition ;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +1;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +2;
			break;
		}
		break;
		
	case 4:
		switch (CurDirection)
		{
		case 0:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +2;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +1;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;
		case 1:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +2;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 2:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition ;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +3;
			CurPosition[3][1] = BYPosition +3;
			break;
		case 3:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition ;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +2;
			break;
		}
		break;

	case 5:
		switch (CurDirection)
		{
		case 0:
			CurPosition[0][0] = BXPosition +1;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +3;
			CurPosition[3][1] = BYPosition +3;
			break;
		case 1:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +2;
			CurPosition[3][0] = BXPosition ;
			CurPosition[0][1] = BYPosition +2;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;

		case 2:
			CurPosition[0][0] = BXPosition ;
			CurPosition[1][0] = BXPosition +1;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +1;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +1;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +3;
			break;
		case 3:
			CurPosition[0][0] = BXPosition +2;
			CurPosition[1][0] = BXPosition ;
			CurPosition[2][0] = BXPosition +1;
			CurPosition[3][0] = BXPosition +2;
			CurPosition[0][1] = BYPosition +1;
			CurPosition[1][1] = BYPosition +2;
			CurPosition[2][1] = BYPosition +2;
			CurPosition[3][1] = BYPosition +2;
			break;
		}
		break;

	case 6:
 		
		CurPosition[0][0] = BXPosition ;
		CurPosition[1][0] = BXPosition ;
		CurPosition[2][0] = BXPosition +1;
		CurPosition[3][0] = BXPosition +1;
		CurPosition[0][1] = BYPosition +1;
		CurPosition[1][1] = BYPosition +2;
		CurPosition[2][1] = BYPosition +1;
		CurPosition[3][1] = BYPosition +2;
		break;
	}
}

void SoundInit()
{
	pSound = new CDXSound();
	pMusic = new CDXMusic(hWindow);
	
	if (DirectSoundCreate(NULL, &(pSound->m_lpDS), NULL) != DS_OK) 
	{
		bSound = FALSE;
	} 

	if (pSound->m_lpDS) pSound->m_lpDS->Release();
	
	if (bSound == TRUE) pSound->Create(hWindow);
	if (bSound == TRUE) 
	{
		pSBuffer[0] = new CDXSoundBuffer();
		if (pSBuffer[0]->Load(pSound, "DATA064", 1) == FALSE) bSound = FALSE;
	}
}

void mosaic(UINT size, CDXSurface *pSuf, CDXSurface *pBack )
{
	WORD *ptr;			// Target Pixel pointer (Write)
	WORD *Srptr;		// Source Pixel pointer (Read)
	WORD pixel;			
	if (pSuf->Lock() !=DD_OK) return;
	Srptr = (WORD*)pSuf->m_DDSD.lpSurface;
	if (pBack->Lock()  !=DD_OK) return ;
	ptr = (WORD*)pBack->m_DDSD.lpSurface;

	for(int y = 0; y < pSuf->m_PixelHeight; y+=size)
	{
		for( int x = 0, c = 0; x < pSuf->m_PixelWidth; x+=size)
		{
			pixel = *Srptr;
			for(UINT i = 0; i<size; i++)
			{
				if ((x+ (int)i) < (int)pSuf->m_PixelWidth)
				for (UINT h = 0; h<size; h++)
				{
					if ( (y+(int)h) < pSuf->m_PixelHeight )
						*(ptr + (h * pSuf->m_PixelWidth)) = pixel;
				}
				if (c < pSuf->m_PixelWidth )
				{
					ptr++; 
					c++;
				}
			}
			Srptr += size;
			
		}
	Srptr = (WORD*)pSuf->m_DDSD.lpSurface + ((y+size) * pSuf->m_PixelWidth);
	ptr = (WORD*)pBack->m_DDSD.lpSurface + ((y+size) * pSuf->m_PixelWidth);
	}
	pSuf->UnLock();
	pBack->UnLock();
	pSc->Flip(); bPageCounter = !bPageCounter;
}

void NextBlockSet(void)
{
	int i;

	bSignAct=FALSE;
	GetLevel(Level1);
	yST=0;
	DXPosition = 240;
	DYPosition = 10;
	for (i=0;i < BOARDHEIGHT;i++)
		DeleteY[i] = 0;
	DelLines=0;
	CurBlock = NextBlock;
	NextBlock = rand() % 7;
	if (NextBlock == 0) 
	{
		if ((rand() % 2) == 0) NextBlock = 0;
		else NextBlock = rand() % 7;	//    󵵼 ߱ 
	}
	pBlockR[CurBlock]->m_Frame = 1; //rotate sprite frame set
	CurCtrl = NEXT;
	CurDirection=3;
	BXPosition = 7;		
	if ((CurBlock ==0) || (CurBlock ==2)) BYPosition = -2; else BYPosition = -1;
	iCounter[1] = 0;
	DetectArray();		// Put Current Posiotn to Array 
	
	if ((Board[CurPosition[0][1]][CurPosition[0][0]] > 0) ||
		(Board[CurPosition[1][1]][CurPosition[1][0]] > 0) ||
		(Board[CurPosition[2][1]][CurPosition[2][0]] > 0) ||
		(Board[CurPosition[3][1]][CurPosition[3][0]] > 0))
	{
			CurCtrl = GAMEOVER;
			for (i = 2; i<8;i++)
				iCounter[i] = 0;
	}
		else PlaySound(3000, NEXTSOUND);
}

void LightEffect_BOX(int X, int Y,int dx, int dy, CDXSurface* lpDDS)
{
	int i, xx, yy, ys, xs, m;
	WORD *ptr;
	WORD pixel, r, g, b;
	m = 30 << GREENDEEP;

	for (i = 20; i>0; i--)
	{
		ys = Y - i;
		xs = X - i;
		
		if (lpDDS->Lock() !=DD_OK) return ;
		ptr = (WORD*)lpDDS->m_DDSD.lpSurface;

		if (ys > 0) ptr += (ys * pSc->m_dwPixelWidth);

		for(yy =ys; yy < dy + i ; yy++)
		{
			if ((yy < (int)pSc->m_dwPixelHeight) && (yy > -1))
			{
				
				if (xs > 0) ptr += xs;
				for(xx = xs; xx < dx + i ; xx++)
				{

					if ((xx < (int)pSc->m_dwPixelWidth) && (xx > -1))
					{
						if ((xx == xs) || (xx > (dx+i-2)) || (yy == ys) || (yy > (dy + i -2)))
							// if box's column is start of end, draw sign!
						{
							pixel = *ptr;	
							r = pixel >> RBitPos;
							g = pixel << BITGLEFT;  // pick up color element
							g >>= BITGRIGHT;
							b = pixel << 11;
							b >>=11;

							if (r < 26)	r+=(21 - i); // add brightness at element of color
							if (r >26) r = 26;
							if (b < 26) b+=(21 - i);
							if (b> 26) b = 26;	
							if (g < m)	g+= (22 - i) << GREENDEEP;
							if ((g << GREENDEEP) > m) g = m;
							
							r <<= RBitPos;		// Bit position, Move Back.
							g <<= 5;  
													
							*ptr = (r | g | b); //	Write calculated pixel to target pixel
						}
						ptr++;
					}
				}
				if((pSc->m_dwPixelWidth-(dx+i)) > 0)   
					ptr += (pSc->m_dwPixelWidth-(dx+i));
			}
		}
		lpDDS->UnLock();
	}
}

void White(CDXSurface * pSuf)
{	
	WORD *ptr;
	int x, y;
	
	if (pSuf->Lock() !=DD_OK) return ;
	ptr = (WORD*)pSuf->m_DDSD.lpSurface;

	for(y=0; y < (int)pSuf->m_DDSD.dwHeight; y++)
	for(x=0; x < (int)pSuf->m_DDSD.dwWidth; x++)
	{
		*ptr = WHITE_COLOR;
		ptr++; 
	}
	pSuf->UnLock();
}

BOOL MusicLoad(char * Filename)
{
	if(Filename == NULL) return FALSE;
	char buffer[256];

	sprintf(buffer, "open %s type sequencer alias MUSIC", Filename);

	if (mciSendString("close all", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}

	if (mciSendString(buffer, NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}
	return TRUE;
}

void PlayMusic(char* mus)
{
	pMusic->Stop();
	MusicLoad(mus);
	if (bMusic)	pMusic->Restart();	
}

void PlaySound(int pan, int flag)
{
	if (bSound)
	{
		if (flag == READYSOUND)
		{
			pSBuffer[0]->SetVolume(CurVOLUME);
			pSBuffer[0]->Play(pan);
		}

		if (flag == LASER)
		{
			pSBuffer[0]->SetVolume(CurVOLUME);
			pSBuffer[0]->Play(pan);
		}

		if (flag == MAINLOAD)
		{
			delete pSBuffer[0];
			pSBuffer[0] = new CDXSoundBuffer();
			pSBuffer[0]->Load(pSound, "DATA065", 2);
			pSBuffer[1] = new CDXSoundBuffer();
			pSBuffer[1]->Load(pSound, "DATA066", 2);
			pSBuffer[2] = new CDXSoundBuffer();
			pSBuffer[2]->Load(pSound, "DATA067", 2);
			pSBuffer[3] = new CDXSoundBuffer();
			pSBuffer[3]->Load(pSound, "DATA068", 2);
			pSBuffer[4] = new CDXSoundBuffer();
			pSBuffer[4]->Load(pSound, "DATA069", 2);
			pSBuffer[5] = new CDXSoundBuffer();
			pSBuffer[5]->Load(pSound, "DATA070", 2);
			pSBuffer[6] = new CDXSoundBuffer();
			pSBuffer[6]->Load(pSound, "DATA071", 2);
			pSBuffer[7] = new CDXSoundBuffer();
			pSBuffer[7]->Load(pSound, "DATA072", 2);
			pSBuffer[8] = new CDXSoundBuffer();
			pSBuffer[8]->Load(pSound, "DATA073", 2);
		}

		if (flag == COUNTDOWN)
		{
			pSBuffer[7]->SetVolume(CurVOLUME);
			pSBuffer[7]->Play(pan);
		}

		if (flag == LEVELUP)
		{
			pSBuffer[8]->SetVolume(CurVOLUME);
			pSBuffer[8]->Play(pan);
		}

		if (flag == TESTSOUND)
		{
			pSBuffer[0]->SetVolume(CurVOLUME);
			pSBuffer[0]->Play(pan);
		}

		if (flag == BLOCKED)
		{
			pSBuffer[1]->SetVolume(CurVOLUME);
			pSBuffer[1]->Play(pan);
		}

		if (flag == NOROTATE)
		{
			pSBuffer[5]->SetVolume(CurVOLUME);
			pSBuffer[5]->Play(pan);
		}

		if (flag == ROTATESND)
		{
			pSBuffer[4]->SetVolume(CurVOLUME);
			pSBuffer[4]->Play(pan);
		}


		if (flag == LANDING)
		{
			pSBuffer[2]->SetVolume(CurVOLUME);
			pSBuffer[2]->Play(pan);
		}

		if (flag == EXPLO)
		{
			
			pSBuffer[2]->Stop();
			pSBuffer[3]->SetVolume(CurVOLUME);
			pSBuffer[3]->Play(pan);
		}

		if (flag == NEXTSOUND)
		{
			pSBuffer[6]->SetVolume(CurVOLUME);
			pSBuffer[6]->Play(pan);
		}
	}
}

void Title_Fade()
{
	pFc = new CDXSurface(pSc, "DATA074");
	CDXSurface * pBack = pSc->GetBack();
	WORD *ptr;
	WORD *Srptr;
	WORD pixel, r, g, b;
	short i, m;
	int x, y, tsize;
	tsize = 63 * pFc->m_PixelWidth;
	PlaySound(0, READYSOUND);
	White(pBack);

	for(i = 31; i > 0 ; i--)
	{
		if (pFc->Lock() !=DD_OK) return ;
		Srptr = (WORD*)pFc->m_DDSD.lpSurface + tsize;	
		if (pBack->Lock() !=DD_OK) return ;
		ptr = (WORD*)pBack->m_DDSD.lpSurface + tsize;
									//  +=tsize : empty part clip
		m = i << GREENDEEP; // precalucate Green Deep for 565 Mode
		
		for(y=126; y < pFc->m_PixelHeight; y++)
		{
			ptr +=111;			// empty part clip
			Srptr +=111;
			for(x=222; x < pFc->m_PixelWidth; x++)
			{
				pixel = *Srptr;

				r = pixel >> RBitPos;		// Pick up element of color
				g = pixel << BITGLEFT;
				g >>= BITGRIGHT;
				b = pixel << 11;
				b >>= 11;

				if (r < i) r = i; 			// Fade !!
				if (g < m ) g = m;
				if (b < i ) b = i; 

				r <<= RBitPos;				// Turn Back BitPos
				g <<= 5;

				*ptr = (r | g | b);			// Write Pixel
				ptr++; 
				Srptr++;
			}
			ptr +=111;					// empty part clip
			Srptr +=111;
		}
		pBack->UnLock();
		pFc->UnLock();
		pSc->Flip();bPageCounter = !bPageCounter;
	}
}

void Title_Mosaic(short SysGap)
{
	UINT i;
	
	pFc4 = new CDXSurface(pSc, "DATA075" );
	pFc3 = new CDXSurface(pSc, "DATA076" );  // Crean cave "Source
	CDXSurface *pFcBuf2 = new CDXSurface(pSc, "DATA076" );  // Temp cave.
	pFc2 = new CDXSurface(pSc, "DATA077");
	pFc2->ColorKey(0);
	pFc4->ColorKey(0);
	
	pTitleB = new CDXSprite (pSc, "DATA078", 296, 156, 12);
	pTitleB->ColorKey(0);
	pTitleB->SetPos(135, 229);
	pTitleB->SetFrame(1);
	pSign = new CDXSprite (pSc, "DATA079", 136, 78, 8);
	pSign->ColorKey(0);
	pSign->SetPos (500, 230);
	pSign->SetFrame(1);
	p1Pmenu = new CDXSprite (pSc, "DATA080", 189, 47, 3);
	p2Pmenu = new CDXSprite (pSc, "DATA081", 190, 47, 3);
	pVsmenu = new CDXSprite (pSc, "DATA082", 138, 47, 3);
	pStmenu = new CDXSprite (pSc, "DATA083", 189, 47, 3);
	pOrmenu = new CDXSprite (pSc, "DATA084", 189, 47, 3);
	pOpmenu = new CDXSprite (pSc, "DATA085", 166, 47, 3);

	p1Pmenu->ColorKey(255);
	p2Pmenu->ColorKey(255);
	pVsmenu->ColorKey(255);
	pStmenu->ColorKey(255);
	pOrmenu->ColorKey(255);
	pOpmenu->ColorKey(255);
	p1Pmenu->SetFrame(2);	// At first selected 1p panel.
	p2Pmenu->SetFrame(1);
	pVsmenu->SetFrame(1);
	pStmenu->SetFrame(1);
	pOrmenu->SetFrame(1);
	pOpmenu->SetFrame(1);
	p1Pmenu->SetPos(16, Ypos1);
	p2Pmenu->SetPos(16, Ypos2);
	pVsmenu->SetPos(233, Ypos1);
	pStmenu->SetPos(233, Ypos2);
	pOrmenu->SetPos(427, Ypos1);
	pOpmenu->SetPos(451, Ypos2);

	pFc5 = new CDXSurface (pSc, "DATA087");

	if ( !pFc5 ) 
	{
		bActive = FALSE;
		if (bPageCounter == FALSE)
		{
			pSc->Flip();
			bPageCounter = TRUE;
		}
		FARPROC lpBoxProc = MakeProcInstance(
			(FARPROC)BoxProc, hInstance);
		DialogBox(hInstance, MAKEINTRESOURCE
			(IDD_DIALOG6), hWindow, lpBoxProc);
		FreeProcInstance (lpBoxProc);
		bActive = TRUE;
		bIsErr = TRUE;
	}
		
	pFc2->DrawTrans(0, 0, pFcBuf2);
	pTitleB->DrawTrans(pFcBuf2);
	pSign->DrawTrans(pFcBuf2);

	
	for ( i = 1 ; i < 100 ; i+=SysGap)
		mosaic(i, pFc, pSc->GetBack());
		
	for ( i = 100 ; i > 0 ; i-=SysGap)
		mosaic(i, pFcBuf2, pSc->GetBack());

	pFc3->Draw(pSc->GetBack());
	pFc2->DrawTrans(0, 0, pSc->GetBack());
	pTitleB->DrawTrans(pSc->GetBack());
	pSign->DrawTrans(pSc->GetBack());
	pSc->Flip();bPageCounter = !bPageCounter;
}

void AnimatThread(PVOID pvoid)
{
	while (bKILL == FALSE)
	{
		Sleep(100L );
	
		if (bActive) // if Non Active Window, Stop Adding frame!
		{
			if (CurCtrl < DRAW_SCREEN)
			{	//if (CurCtrl == MENU) || MENUSCROLLUP) 			
				pTitleB->m_Frame++;
				if (pTitleB->m_Frame > 11) pTitleB->m_Frame = 1;
				if (bSignAct) 
				{						// Sign Eluminate when bSignAct, True
					pSign->m_Frame++;
					if (pSign->m_Frame > 7) 
					{
						pSign->m_Frame = 1;
						bSignAct = FALSE;  //  End Eluminate.
					}
				}
			}

			if (CurCtrl == DELETEMODE)
				if(pEXPLO->m_Frame < 9) 
				{
					Sleep(20L);
					pEXPLO->m_Frame++;
				}
		
			if (bIsErr == TRUE) PostMessage(hWindow, WM_CLOSE, 0, 0);

			if ((CurCtrl == MENU) || (CurCtrl == MENUSCROLLUP))
				if (!bSignAct) 		// sign eluminate random start
				{
					if (rand() > 30000 ) bSignAct = TRUE;
				}
		} 
	}
	_endthread();
}

void BlockScrollThread(PVOID pvoid)
{		
	while (bKILL == FALSE)
	{
		Sleep(1L );

		if ((bActive) && (!bSPEEDYDOWN) && (CurCtrl == CGAME))// if Non Active Window, Stop Adding frame!
		{
			Sleep((long)CurDelayTime);	// Block Down Speed as level
			DYPosition++;	// Block 1 Dot down scroll
						
			if ((DYPosition % BLOCKSIZE) == ((BOARDySTART -5 ) % BLOCKSIZE))
			{
				CurPosition[0][1]++;		// ypos ++ in Array
				CurPosition[1][1]++;
				CurPosition[2][1]++;
				CurPosition[3][1]++;
				BYPosition++;
				yST = 0;	// block moving with fit lines...
			} else yST = 1;	// block moving with two lines...
				
			if (CurPosition[3][1] < BOARDHEIGHT-1)
			{
				if ((Board[CurPosition[0][1] +1][CurPosition[0][0]] > 0) ||
					 (Board[CurPosition[1][1] +1][CurPosition[1][0]] > 0) ||
					  (Board[CurPosition[2][1] +1][CurPosition[2][0]] > 0) ||
					   (Board[CurPosition[3][1] +1][CurPosition[3][0]] > 0)) 
					if (CurCtrl != DELETEMODE) 
					{
						PlaySound(GetSoundPos(), LANDING);
						Sleep(800L);	// if fit lines wait a minute
						while((CurCtrl == MOVELEFT) || (CurCtrl == MOVERIGHT))Sleep(10L);	// ̴µ 
						if ((CurPosition[3][1] > BOARDHEIGHT-2) ||	//   ˻
							(Board[CurPosition[0][1] +1][CurPosition[0][0]] > 0) ||
							(Board[CurPosition[1][1] +1][CurPosition[1][0]] > 0) ||
							(Board[CurPosition[2][1] +1][CurPosition[2][0]] > 0) ||
							(Board[CurPosition[3][1] +1][CurPosition[3][0]] > 0)) 
							if (CurCtrl != DELETEMODE) CurCtrl = BUILD;
					}
			} else if (CurCtrl != DELETEMODE) 
					{
						PlaySound(GetSoundPos(), LANDING);
						Sleep(800L);	// if fit lines wait a minute
						while((CurCtrl == MOVELEFT) || (CurCtrl == MOVERIGHT))Sleep(10L);
						if (CurCtrl != DELETEMODE) CurCtrl = BUILD;
					}
		}	// bActive
		
		if ((bActive) && (bSPEEDYDOWN) && (CurCtrl == CGAME))// if Non Active Window, Stop Adding frame!
		{
			Sleep((long)CurTURBO);	//  Ӵٿ ͺ忡 .		
			DYPosition++;	// Block 1 Dot down scroll
			if ((DYPosition % BLOCKSIZE) == ((BOARDySTART -5 ) % BLOCKSIZE))
			{				
				CurPosition[0][1]++;		// ypos ++ in Array
				CurPosition[1][1]++;
				CurPosition[2][1]++;
				CurPosition[3][1]++;
				BYPosition++;
				yST = 0;	// block moving with fit lines...
			} else yST = 1;	// block moving with two lines...				

			if (CurPosition[3][1] < BOARDHEIGHT-1)
			{
				if ((Board[CurPosition[0][1] +1][CurPosition[0][0]] > 0) ||
					(Board[CurPosition[1][1] +1][CurPosition[1][0]] > 0) ||
					(Board[CurPosition[2][1] +1][CurPosition[2][0]] > 0) ||
					(Board[CurPosition[3][1] +1][CurPosition[3][0]] > 0)) 
						{CurCtrl = BUILD;PlaySound(GetSoundPos(), LANDING);}
				} else  {CurCtrl = BUILD;PlaySound(GetSoundPos(), LANDING);}

		}	// bActive

	}
	_endthread();
}

void BlockControlThread(PVOID pvoid)
{
	while (bKILL == FALSE)
	{
		Sleep(1L );
		if (bActive) // if Non Active Window, Stop Adding frame!
		{
			if (CurCtrl == MOVELEFT)
			{
				if ((DXPosition % BLOCKSIZE) == ((BOARDxSTART +1) % BLOCKSIZE))
				{
					DXPosition--; 
									
					BXPosition--;
					CurPosition[0][0]--;		// xpos -- in Array
					CurPosition[1][0]--;
					CurPosition[2][0]--;
					CurPosition[3][0]--;
					CurCtrl = CGAME;
				} else 
				{
					DXPosition--;
					Sleep((long)(4 - CurROTATE));
				}
			}

			if (CurCtrl == MOVERIGHT)
			{
				if ((DXPosition % BLOCKSIZE) == ((BOARDxSTART -1 ) % BLOCKSIZE))
				{
					DXPosition++;
					BXPosition++;
					CurPosition[0][0]++;		// xpos ++ in Array
					CurPosition[1][0]++;
					CurPosition[2][0]++;
					CurPosition[3][0]++;
					CurCtrl = CGAME;
				} else 
				{
					DXPosition++;
					Sleep((long)(4 - CurROTATE));
				}
			}
		}	// bActive 
	}
	_endthread();
}

void Animate_Title()
{
	pFc3->Draw(pSc->GetBack());		//pFc3 = CAVE.BMP

	if (bIntro) pFc4->DrawClipped(100, Ypos9, pSc->GetBack(), &rcwin);		
	if ((bIntro) && (Ypos9 > 100))  //Staff Scroll up
	{
		Ypos9--;
		Ypos2--;
		Ly--;
		Ly2--;
		pStmenu->SetPos(233, Ypos2);
	}
	if (!bIntro)
	{	// if No Scroll up Staff, Draw Title Animation and other Menues
		pFc2->DrawTrans(0, 0,pSc->GetBack() );   // pFc2 = title_top fiexed part
		pSign->DrawTrans(pSc->GetBack());		
		pTitleB->DrawTrans(pSc->GetBack());
		p1Pmenu->DrawClipped(pSc->GetBack(), &rcwin);	
		p2Pmenu->DrawClipped(pSc->GetBack(), &rcwin);
		pVsmenu->DrawClipped(pSc->GetBack(), &rcwin);
		pOrmenu->DrawClipped(pSc->GetBack(), &rcwin);
		pOpmenu->DrawClipped(pSc->GetBack(), &rcwin);
	}

	pStmenu->DrawClipped(pSc->GetBack(), &rcwin); // always staff menu draw
	LightEffect_BOX(Lx, Ly,Lx2, Ly2, pSc->GetBack());

	if (CurCtrl == CLEAR_SCREEN)
	{
		Fade_OUT(pFc3, pSc->GetBack());

		ReadyToStart();
		Sleep(1000);

		Fade_IN(pFc5, pSc->GetBack());
		
		pFc5->Draw(pSc->GetBack());  // New Bright cave BackGND draw.
	}
	pSc->Flip();bPageCounter = !bPageCounter;
}

int GetSoundPos()
{
	int pan;
	switch(BXPosition)
	{
	case -1:
	case 0:
	case 1:
		pan = -9000;
		break;
	case 2:
	case 3:
		pan = -7000;
		break;
	case 4:
	case 5:
		pan = -5000;
		break;

	case 6:
	case 7:
		pan = -3000;
		break;

	case 8:
	case 9:
		pan = 0;
		break;
		
	case 10:
	case 11:
		pan = 2000;
		break;

	case 12:
	case 13:
		pan = 4000;
		break;

	case 14:
	case 15:
		pan = 6000;
		break;
	case 16:
	case 17:
		pan = 8000;
		break;
	}
	return pan;
}

long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_USER:
			if (bActive) DrawNextFrame();
			break;

		case WM_CREATE:
			if (bGame == FALSE)
			{
				SetPriorityClass( GetCurrentProcess()
					, THREAD_PRIORITY_NORMAL ); 
				SetThreadPriority( (HANDLE)_beginthread (AnimatThread, 0, NULL)
					,THREAD_PRIORITY_HIGHEST );
				SetThreadPriority( (HANDLE)_beginthread (BlockScrollThread, 0, NULL)
					,THREAD_PRIORITY_HIGHEST);
				SetThreadPriority( (HANDLE)_beginthread (BlockControlThread, 0, NULL)
					,THREAD_PRIORITY_HIGHEST );
				bGame = TRUE;
			}
			return 0;

		case WM_ACTIVATEAPP:
			bActive = wParam;
			break;

		case WM_DESTROY:
			bKILL = TRUE;
			TIMECAPS caps;
			timeGetDevCaps ( &caps, sizeof(caps));
			timeEndPeriod(caps.wPeriodMin);
			timeKillEvent(TimerId);
			PostQuitMessage(0);
			break;
	
		case WM_KEYDOWN:

			switch(CurCtrl)		//  BUILD state of process
			{
			case MENU:			//  in menu state, process key down.
			case MENUSCROLLUP:
				switch(wParam)
				{					
					case VK_ESCAPE:
						if(bIntro)
						{
							bIntro=FALSE; 
							Ypos2=423;
							Ypos9=481;
							Ly=423;
							Ly2=423+47;

							pStmenu->SetPos(233, Ypos2);
							CurCtrl = MENU;
							PlayMusic("DATA088");
						} else
						{
							bActive = FALSE;
							if (bPageCounter == FALSE) 
							{
								pSc->Flip();
								bPageCounter = TRUE;
							}	
							
							bStatus = TRUE;	// ϵ 
							FARPROC lpBoxProc = MakeProcInstance(
								(FARPROC)StatusBoxProc, hInstance);
							DialogBox(hInstance, MAKEINTRESOURCE
								(IDD_DIALOG5), hWnd, lpBoxProc);
							FreeProcInstance (lpBoxProc);
							bActive = TRUE;
							if (bStatus == TRUE) 
								SendMessage(hWindow, WM_DESTROY, 0, 0);
						}
						break;

					case VK_LEFT:		// Move Left at MENU !!
						if (bIntro) break;
						if (pVsmenu->m_Frame == 2)
						{
							pVsmenu->m_Frame = 1;
							p1Pmenu->m_Frame = 2;
							Lx = 16;
							Lx2 = 16 + 189;
						} 
						if (pStmenu->m_Frame ==2)
						{
							pStmenu->m_Frame = 1;
							p2Pmenu->m_Frame = 2;
							Lx = 16;
							Lx2 = 16 + 190;
						} 
						if (pOrmenu->m_Frame ==2)
						{
							pOrmenu->m_Frame = 1;
							pVsmenu->m_Frame = 2;
							Lx = 233;
							Lx2 = 233 + 138;
						} 
						if (pOpmenu->m_Frame ==2)
						{
							pOpmenu->m_Frame = 1;
							pStmenu->m_Frame = 2;
							Lx = 233;
							Lx2 = 233 + 189;
						}
						break;

					case VK_RIGHT:
						if (bIntro) break;
						
						if (pVsmenu->m_Frame ==2)
						{
							pVsmenu->m_Frame = 1;
							pOrmenu->m_Frame = 2;
							Lx = 427;
							Lx2 = 427 + 189;
						} 
						if (pStmenu->m_Frame ==2)
						{
							pStmenu->m_Frame = 1;
							pOpmenu->m_Frame = 2;
							Lx = 451;
							Lx2 = 451 + 166;
						}
						if (p1Pmenu->m_Frame == 2)
						{
							p1Pmenu->m_Frame = 1;
							pVsmenu->m_Frame = 2;
							Lx = 233;
							Lx2 = 233 + 138;
						} 
						if (p2Pmenu->m_Frame ==2)
						{
							p2Pmenu->m_Frame = 1;
							pStmenu->m_Frame = 2;
							Lx = 233;
							Lx2 = 233 + 189;
						} 
						break;

					case VK_DOWN:
						if (bIntro) break;
						if (p1Pmenu->m_Frame == 2)
						{
							p1Pmenu->m_Frame = 1;
							p2Pmenu->m_Frame = 2;
							Ly += 54;
							Ly2 += 54;
							Lx2 = 16 + 190;
						} 
						if (pVsmenu->m_Frame==2)
						{
							pVsmenu->m_Frame = 1;
							pStmenu->m_Frame = 2;
							Ly += 54;
							Ly2 += 54;
							Lx2 = 233 + 189;
						} 
						if (pOrmenu->m_Frame ==2)
						{
							pOrmenu->m_Frame = 1;
							pOpmenu->m_Frame = 2;
							Ly += 54;
							Ly2 += 54;
							Lx = 451;
							Lx2 = 451 + 166;
						} 
						break;

					case VK_UP:
						if (bIntro) break;
						if (p2Pmenu->m_Frame == 2)
						{
							p2Pmenu->m_Frame = 1;
							p1Pmenu->m_Frame = 2;
							Ly -= 54;
							Ly2 -= 54;
							Lx2 = 16 + 189;
						} 
						if (pStmenu->m_Frame ==2)
						{
							pStmenu->m_Frame = 1;
							pVsmenu->m_Frame = 2;
							Ly -= 54;
							Ly2 -= 54;
							Lx2 = 233 + 138;
						} 
						if (pOpmenu->m_Frame ==2)
						{
							pOpmenu->m_Frame = 1;
							pOrmenu->m_Frame = 2;
							Ly -= 54;
							Ly2 -= 54;
							Lx = 427;
							Lx2 = 427 + 189;
						} 
						break;

					case VK_RETURN:  // MENU Selected !!
					case VK_SPACE:
						
						if ((bIntro) || (CurCtrl==MENUSCROLLUP)) break;

						if (pStmenu->m_Frame ==2)
						{					// Staff Scroll Start!			
							bIntro = TRUE;
							PlayMusic("DATA089");
							break;
						}

						bActive = FALSE;		// Screen Update STOP !

						if (p1Pmenu->m_Frame ==2)
						{
							if (bPageCounter == FALSE)
							{
								pSc->Flip();
								bPageCounter = TRUE;
							}
							FARPROC lpBoxProc = MakeProcInstance(
								(FARPROC)BoxProc, hInstance);
							DialogBox(hInstance, MAKEINTRESOURCE
								(IDD_DIALOG1), hWnd, lpBoxProc);
							FreeProcInstance (lpBoxProc);
							bActive = TRUE;		// Screen Update Resume !
						}

						if (p2Pmenu->m_Frame ==2)
						{
							if (bPageCounter == FALSE) 
							{
								pSc->Flip();
								bPageCounter = TRUE;
							}
							FARPROC lpBoxProc = MakeProcInstance(
								(FARPROC)BoxProc, hInstance);
							DialogBox(hInstance, MAKEINTRESOURCE
								(IDD_DIALOG2), hWnd, lpBoxProc);
							FreeProcInstance (lpBoxProc);
							bActive = TRUE;
						}

						if (pVsmenu->m_Frame ==2)
						{
							if (bPageCounter == FALSE) 
							{
								pSc->Flip();
								bPageCounter = TRUE;
							}
							FARPROC lpBoxProc = MakeProcInstance(
								(FARPROC)BoxProc, hInstance);
							DialogBox(hInstance, MAKEINTRESOURCE
								(IDD_DIALOG3), hWnd, lpBoxProc);
							FreeProcInstance (lpBoxProc);
							bActive = TRUE;
						}
							
						if (pOrmenu->m_Frame ==2)		// Old Tetris Game Start !!
						{
							bActive = TRUE;
							CurCtrl = CLEAR_SCREEN;
						}
						
						if (pOpmenu->m_Frame ==2)
						{
							if (bPageCounter == FALSE) 
							{
								pSc->Flip();
								bPageCounter = TRUE;
							}
							bStatus = TRUE;	// ϵ 

							FARPROC lpBoxProc = MakeProcInstance(
								(FARPROC)StatusBoxProc, hInstance);
							DialogBox(hInstance, MAKEINTRESOURCE
								(IDD_DIALOG5), hWnd, lpBoxProc);
							FreeProcInstance (lpBoxProc);
							bActive = TRUE;

							if (bStatus == TRUE) 
								SendMessage(hWindow, WM_DESTROY, 0, 0);
						}
				}
				break;		// Until this Line, Process Key input in MENU Mode !!

			case CGAME:		// kojun game playing...

				switch(wParam)
				{			
				case VK_F1:
					{
						bActive = FALSE;
						if (bPageCounter == FALSE) 
						{
							pSc->Flip();
							bPageCounter = TRUE;
						}
						
						FARPROC lpBoxProc = MakeProcInstance(
							(FARPROC)BoxProc, hInstance);
						DialogBox(hInstance, MAKEINTRESOURCE
							(IDD_DIALOG10), hWnd, lpBoxProc);
						FreeProcInstance (lpBoxProc);
						bActive = TRUE;
					}
					break;

				case VK_ESCAPE:
					{
						bActive = FALSE;
						if (bPageCounter == FALSE) 
						{
							pSc->Flip();
							bPageCounter = TRUE;
						}	
						FARPROC lpBoxProc = MakeProcInstance(
							(FARPROC)StatusBoxProc, hInstance);
						DialogBox(hInstance, MAKEINTRESOURCE
							(IDD_DIALOG5), hWnd, lpBoxProc);
						FreeProcInstance (lpBoxProc);
						bActive = TRUE;
						if (bStatus == TRUE) 
							SendMessage(hWindow, WM_DESTROY, 0, 0);
					}
					break;
					
				case VK_LEFT:
					
					if ((CurPosition[0][0] == 0) || (CurPosition[1][0] == 0) ||	// left wall check
						(CurPosition[2][0] == 0) || (CurPosition[3][0] == 0) ||	
						(Board[CurPosition[0][1]][CurPosition[0][0]-1] > 0) ||	// left block check
						(Board[CurPosition[1][1]][CurPosition[1][0]-1] > 0) ||
						(Board[CurPosition[2][1]][CurPosition[2][0]-1] > 0) ||
						(Board[CurPosition[3][1]][CurPosition[3][0]-1] > 0) ||
						(Board[CurPosition[0][1]+yST][CurPosition[0][0]-1] > 0) ||	// left and 1 block bellow block check
						(Board[CurPosition[1][1]+yST][CurPosition[1][0]-1] > 0) ||
						(Board[CurPosition[2][1]+yST][CurPosition[2][0]-1] > 0) ||
						(Board[CurPosition[3][1]+yST][CurPosition[3][0]-1] > 0))
					{
						PlaySound(GetSoundPos(), BLOCKED); // Wall Left !! Play sound BEEP!
					} else	CurCtrl = MOVELEFT;
					break;
				
				case VK_RIGHT:
					if ((CurPosition[0][0] == BOARDWIDTH-1) || (CurPosition[1][0] == BOARDWIDTH-1) ||	// Right wall check
						(CurPosition[2][0] == BOARDWIDTH-1) || (CurPosition[3][0] == BOARDWIDTH-1) ||	
						(Board[CurPosition[0][1]][CurPosition[0][0]+1] > 0) ||	// Right block check
						(Board[CurPosition[1][1]][CurPosition[1][0]+1] > 0) ||
						(Board[CurPosition[2][1]][CurPosition[2][0]+1] > 0) ||
						(Board[CurPosition[3][1]][CurPosition[3][0]+1] > 0) ||
						(Board[CurPosition[0][1]+yST][CurPosition[0][0]+1] > 0) ||	// left and 1 block bellow block check
						(Board[CurPosition[1][1]+yST][CurPosition[1][0]+1] > 0) ||
						(Board[CurPosition[2][1]+yST][CurPosition[2][0]+1] > 0) ||
						(Board[CurPosition[3][1]+yST][CurPosition[3][0]+1] > 0))
					{
						PlaySound(GetSoundPos(), BLOCKED);   // Wall Right !! Play sound BEEEEEEEEEP!
					} else	CurCtrl = MOVERIGHT;
					break;

				case VK_UP:
					TempDirection = CurDirection;
					CurDirection++;
					if (CurDirection > 3) CurDirection = 0;
						DetectArray();
						
					if ((CurPosition[0][0] > BOARDWIDTH -1 ) ||  // case block over wall after rotate
						(CurPosition[1][0] > BOARDWIDTH -1) ||
						(CurPosition[2][0] > BOARDWIDTH -1) ||
						(CurPosition[3][0] > BOARDWIDTH -1) ||
						(CurPosition[0][0] < 0) ||
						(CurPosition[1][0] < 0) ||
						(CurPosition[2][0] < 0) ||
						(CurPosition[3][0] < 0) ||
						(CurPosition[0][1] < 0) ||
						(CurPosition[1][1] < 0) ||
						(CurPosition[2][1] < 0) ||
						(CurPosition[3][1] < 0) ||
						(CurPosition[0][1] > BOARDHEIGHT-1) ||
						(CurPosition[1][1] > BOARDHEIGHT-1) ||
						(CurPosition[2][1] > BOARDHEIGHT-1) ||
						(CurPosition[3][1] > BOARDHEIGHT-1))				
					{
						PlaySound(GetSoundPos(), NOROTATE);  // That was Blocked !! BEEP !!
						CurDirection = TempDirection;	// backup original direction.
						DetectArray();		// restore original position
					} else if ((Board[CurPosition[0][1]][CurPosition[0][0]] > 0) ||	// Check block test through preview rotate
						(Board[CurPosition[1][1]][CurPosition[1][0]] > 0) ||
						(Board[CurPosition[2][1]][CurPosition[2][0]] > 0) ||
						(Board[CurPosition[3][1]][CurPosition[3][0]] > 0))
					{
						PlaySound(GetSoundPos(), NOROTATE);  // That was Blocked !! BEEP !!
						CurDirection = TempDirection;	// backup original direction.
						DetectArray();		// restore original position
					} else
					{
						CurCtrl = ROTATE;
						pBlockR[CurBlock]->m_Frame = TempDirection * 5;	
						PlaySound(GetSoundPos(), ROTATESND);
					}
					break;

				case VK_DOWN:
					if (CurCtrl ==CGAME) bSPEEDYDOWN = TRUE;  // HIGH SPEED DOWN MODE ON !
					break;
				} // case CGAME case switch if no NEXT loop
				break; // CGAME break;

			case CONTINUE:		// kojun game playing...

				switch(wParam)
				{			
				//case VK_Y:
				case VK_RETURN:
				case VK_SPACE:
					NewGame();
					break;

				case VK_ESCAPE:
					{
						bActive = FALSE;
						if (bPageCounter == FALSE) 
						{
							pSc->Flip();
							bPageCounter = TRUE;
						}
						
						FARPROC lpBoxProc = MakeProcInstance(
							(FARPROC)BoxProc2, hInstance);
						DialogBox(hInstance, MAKEINTRESOURCE
							(IDD_DIALOG8), hWindow, lpBoxProc);
						FreeProcInstance (lpBoxProc);
						bActive = TRUE;
						
						if (bStatus == TRUE) 
							SendMessage(hWindow, WM_DESTROY, 0, 0);
					}
					break;
				}	//continue mode end

			}//CurCtrl switch block
			break;	// WM_KEYDOWN break;

		case WM_KEYUP:
			switch(wParam)
				{					
					case VK_DOWN:
						bSPEEDYDOWN = FALSE;
						break;
				}
			break;
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

void CompareBlock(short StartY)
{
	BOOL Comp = TRUE, NEXTOK=TRUE;
	int y, x, i,j;
	Exp1+=Level1;		//  
	for (y = StartY;y < StartY + NUMBEROFBLOCK;y++)
	{
		for(x = 0; x < BOARDWIDTH;x++)
			if(Board[y][x] == 0) Comp = FALSE;

		if (Comp == TRUE)
		{
			for (i = 0;i<BOARDWIDTH;i++)
				Board[y][i] = 0;
			DelLines++;					// lines of delete counter.
			LastLine = y;
			DeleteY[y] = 1;
			NEXTOK = FALSE;
			Exp1 += (Level1 * 10 * DelLines);		// Exp++
		} 
		Comp = TRUE;
	}
	if (NEXTOK) NextBlockSet();
	else 
	{
		for(i = 0; i < LastLine; i++)
		for (j = 0; j < BOARDWIDTH;j++)
			if (Board[i][j] > 0) Board[i][j] += 100;
			
		ADDDot = 1;					// After delete line, upper blocks down
		pEXPLO->m_Frame = 1;		// explo SPR Frame set zero.
		CurCtrl = DELETEMODE;
		PlaySound(0, EXPLO);
	}
}

BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;
	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(	hInst,MAKEINTRESOURCE(IDI_ICON1));
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "kocsys";
	RegisterClass(&WndClass);

	hWnd = CreateWindowEx(	WS_EX_WINDOWEDGE,
		"kocsys",	"TETRIS in Dungeon98",
		WS_VISIBLE|WS_SYSMENU,   CW_USEDEFAULT,  CW_USEDEFAULT  ,
		640, 480,
		NULL, NULL,	hInst,	NULL);

	int iBPP;
	RECT rc;
	DWORD dwStyle;
	HDC hdc = GetDC(hWnd);
	iBPP = GetDeviceCaps(hdc, BITSPIXEL);
		
	ReleaseDC(hWnd, hdc);
	if (iBPP != 16)		// if Screen is not 16 Bit mode, Create Full Screen
	{
		hWnd = CreateWindowEx(	WS_EX_TOPMOST,
			"kocsys",	"TETRIS in Dungeon98",
			WS_POPUP,	0,0,
			GetSystemMetrics(SM_CXSCREEN),
			GetSystemMetrics(SM_CYSCREEN),
			NULL,	NULL,	hInst,	NULL);
		
		if(!hWnd) return FALSE;

		ShowWindow(hWnd, nCmdShow);
		UpdateWindow(hWnd);

		pSc = new CDXScreen();
		pSc->CreateFullScreen(hWnd, 640, 480, 16);
	}
	else			// if Screen is 16 bit mode !!, Create Window
	{
		dwStyle = GetWindowStyle(hWnd);
		dwStyle &= ~WS_POPUP;
		dwStyle = WS_OVERLAPPEDWINDOW;
		SetWindowLong(hWnd, GWL_STYLE, dwStyle);
	
		SetRect(&rc, 0, 0, 640, 480);

		AdjustWindowRectEx(&rc,
			GetWindowStyle(hWnd),
			GetMenu(hWnd) != NULL,
			GetWindowExStyle(hWnd));

		SetWindowPos(hWnd, NULL, 0, 0, rc.right-rc.left, rc.bottom-rc.top,
			SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);

		SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0,
			SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);

		if(!hWnd) return FALSE;

		ShowWindow(hWnd, nCmdShow);
		UpdateWindow(hWnd);

		pSc = new CDXScreen();
		pSc->CreateWindowed(hWnd, 640, 480);
	}

	LPDIRECTDRAWSURFACE  pSurf = pSc->GetBack()->m_lpDDS;
	DDSURFACEDESC ddsd;

	ZeroMemory(&ddsd,sizeof(DDSURFACEDESC));
	ddsd.dwSize  = sizeof(DDSURFACEDESC);
	ddsd.dwFlags = DDSD_PIXELFORMAT;
	HRESULT hResult = pSurf->GetSurfaceDesc(&ddsd);
 
	if (hResult == DD_OK) 
		{
			if (ddsd.ddpfPixelFormat.dwRBitMask != 0x7C00)
			{	// if 16Bit 565 Mode, Change Some Display Control Variable
				RBitPos = 11;
				GREENDEEP = 1;
				BITGRIGHT = 10;
				BITGLEFT = 5;
				WHITE_COLOR = 0xFFFF;
				TEXT_COLORy = 0xFFE0;
				TEXT_COLORb = 0xC61F;
				TEXT_COLORg = 0xC7F8;
			}
		}
	else return FALSE;
	
	hInstance = hInst;			// For Err Dialog Box
	hWindow = hWnd;				// Make Extern Variable
	SetRect(&rcwin, 0, 0, 640, 480);	// windows clip rect.
	return TRUE;
}

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;
	DWORD lTime, sTime;
	short SysGap = 1;
	
	if(!InitApp(hInst, nCmdShow)) return FALSE;
	SoundInit();
	srand(GetTickCount());
	pKText = new KText();

	Sleep(700);
	lTime = GetTickCount();
	Title_Fade();
	SysGap = (GetTickCount() - lTime) / 1000;	// mosic size detect as system speed.
	if (SysGap == 3) SysGap = 4;		
	if (SysGap > 5) SysGap = 5;					// if SysGap is 3  or over 5: ERROR!!

	ReadSystemData();							// read hi-score and sys data
	InitTimer();
	if (bSound) MusicLoad("DATA088");
		
	while(sTime < 5500)							// wait 6 second, amount time fade
	{
		sTime = GetTickCount() - lTime;
	}
	
	Title_Mosaic(SysGap);

	if ((bMusic) && (bSound)) pMusic->Restart();

	CurCtrl = MENUSCROLLUP;

	while(GetMessage(&msg, NULL, 0, 0 ))
	{		
		TranslateMessage(&msg); 
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

void DrawBoardFI()
{
	int i, j;
	for( i = 0; i < BOARDHEIGHT ; i++)
	for(j = 0; j < BOARDWIDTH; j++)	// Draw E-block.(exept over 100 ID)
		if (Board[i][j] > 0) 
			FadeInSurface(3, j * BLOCKSIZE + BOARDxSTART, 
			 i * BLOCKSIZE + BOARDySTART, pBlockE[3], pSc->GetBack()); 
}

void CALLBACK TimerProc (UINT iTimerID, UINT iMsg, DWORD User, DWORD dw1, DWORD dw2)
{	
	SendMessage(hWindow, WM_USER, 0, 0);
}

void DrawNextFrame()
{			
	if (CurCtrl < DRAW_READY) 
		{	// if CurCtrl == menu || menuscroll || clearscreen )
			Animate_Title();
			
			if (CurCtrl == MENUSCROLLUP)
			{
				if (Wide > 1) Wide--;
				Ypos1-=Wide;
				Ypos2-=Wide;
				Ly-=Wide;
				Ly2-=Wide;
				
				p1Pmenu->SetPos(16, Ypos1);
				p2Pmenu->SetPos(16, Ypos2);
				pVsmenu->SetPos(233, Ypos1);
				pStmenu->SetPos(233, Ypos2);
				pOrmenu->SetPos(427, Ypos1);
				pOpmenu->SetPos(451, Ypos2);
				if (Ypos1 < 370 ) CurCtrl = MENU;
			}
		}

		if (CurCtrl == DRAW_SCREEN)
		{
			pFc5->Draw(pSc->GetBack());

			if ((Wide > 52 ) && (MLx < 310))
			{
				MagicLight(MLx, MLy, pSc->GetBack());
				MLx+=10;
				if (MLx > 300) MLx=575;
			}

			if (Wide > 53) 
				if (iCounter[0]++ < 31)
					FadeInSurface(0, 110, 17,temp1 , pSc->GetBack());
				else temp1->DrawTrans(110, 17, pSc->GetBack());

			if (Wide > 55 )
				if (iCounter[1]++ < 31)
					FadeInSurface(1, 128, 17,temp2 , pSc->GetBack());
				else temp2->DrawTrans(128, 17, pSc->GetBack());

			if (Wide > 57)
				if (iCounter[2]++ < 31)
					FadeInSurface(2, 160, 17,temp3 , pSc->GetBack());
				else temp3->DrawTrans(160, 17, pSc->GetBack());

			if (Wide > 59) 
				if (iCounter[3]++ < 31)
					FadeInSurface(3, 176, 17,temp4 , pSc->GetBack());
				else temp4->DrawTrans(176, 17, pSc->GetBack());

			if (Wide > 61) 
				if (iCounter[4]++ < 31)
					FadeInSurface(4, 232, 17,temp5 , pSc->GetBack());
				else temp5->DrawTrans(232, 17, pSc->GetBack());

			if (Wide > 65) 
				if (iCounter[5]++ < 31)
					FadeInSurface(5, 248, 17,temp6 , pSc->GetBack());
				else temp6->DrawTrans(248, 17, pSc->GetBack());

			if (Wide > 75)
			{
				if (iCounter[7] < 31) iCounter[7]++;
				FadeInSurface(7, 250, 12,pBlockS[NextBlock][0] , pSc->GetBack());
			}	// next block fade in

			if (Wide > 80) DrawPR();	

			if (Wide > 0 )
			{
				if (Wide == 3) PlaySound(-5000, LASER);
				HLine (11, 14 , pSc->GetBack(), CurFrame11);
				if (CurFrame11 < CurLASER) CurFrame11++;
			}

			if (Wide > 20 )
			{
				if (Wide == 23) PlaySound(10000, LASER);
				VLine(626, 629, pSc->GetBack(), CurFrame12);
				if (CurFrame12 < CurLASER) CurFrame12++;
			}

			if (Wide > 30 )
			{
				if (Wide == 33) PlaySound(5000, LASER);
				HLine(467, 470, pSc->GetBack(), CurFrame13);
				if (CurFrame13 < CurLASER) CurFrame13++;
			}

			if (Wide > 38 )
			{
				if (Wide == 41) PlaySound(-10000, LASER);
				VLine(BOARDxSTART-3, BOARDxSTART, pSc->GetBack(), CurFrame14);
				if (CurFrame14 < CurLASER) CurFrame14++;
			}

			if (Wide > 43 )
			{
				if (Wide == 46) PlaySound(-5000, LASER);

				HLine(BOARDySTART -3, BOARDySTART , pSc->GetBack(), CurFrame15);
				if (CurFrame15 < CurLASER) CurFrame15++;
			}

			if (Wide > 46 )
			{
				if (Wide == 49) PlaySound(0, LASER);
				VLine(316, 319, pSc->GetBack(), CurFrame16);
				if (CurFrame16 < CurLASER) CurFrame16++;
			}

			if ((Wide > 52 ) && (MLx == 575))
			{
				MagicLight(MLx, MLy, pSc->GetBack());
				MLy+=7;
				if (MLy > 440) NewGame();
			}
			pSc->Flip();bPageCounter = !bPageCounter;
			if (Wide < 254) Wide++; 
		}

		if (CurCtrl > READY)
		{		
			int i, j, k;
			char Lev[34];
			pFc5->Draw(pSc->GetBack());	// back ground draw.

			DrawPR();					// My PR Text scroll !
			DrawHISCORE();				// HiScore Scroll up
			pKText->PutFont(pSc->GetBack(),111,17,TEXT_COLORy, ":");
			pKText->PutFont(pSc->GetBack(),159,17,TEXT_COLORy, LevelStr);	//  ȭ.............
			pKText->PutFont(pSc->GetBack(),231,17,TEXT_COLORy, ":");
				
			pKText->PutFont(pSc->GetBack(),111,34,TEXT_COLORy, ":          :");
			pKText->PutFont(pSc->GetBack(),111,49,TEXT_COLORy, "EXP :");
			pKText->PutFont(pSc->GetBack(),159,49,TEXT_COLORy, ultoa(Exp1,Lev,10 ));	
			pKText->PutFont(pSc->GetBack(),231,49,TEXT_COLORy, "MP:");
			
			pKText->PutFontFrame(pSc->GetBack(),xPos12--,70,TEXT_COLORg, 
				"ҷ Ѹ̾, ѱ ӻ ǻ츮! ҹ  Ĵ 鿡 ϴ ְ......", 109, 316);

			if (xPos12 < -700) xPos12 = 320;

			if (iLevelUP > 0) 
			{
				MagicLight(140, 2, pSc->GetBack());
				
				if (++iLevelUP > (5000 / CurFPS)) iLevelUP = 0;
			}

			if (CurCtrl == NEXT)
			{
				if (iCounter[1] < 32) iCounter[1]++;
				FadeInSurface(1, 250, 12,pBlockS[NextBlock][0], pSc->GetBack());
			} else if (CurCtrl > CONTINUE) pBlockS[NextBlock][0]->DrawTrans(250,12, pSc->GetBack());
			
			if (CurCtrl == NEXT)
			{
				pBlockR[CurBlock]->SetPos(DXPosition, DYPosition);
				DXPosition -=3;
				DYPosition +=4;				// moving!! in rotate

				pBlockR[CurBlock]->DrawTrans(pSc->GetBack());
				if (pBlockR[CurBlock]->m_Frame++ > 14) 
				{
					DXPosition = BOARDxSTART - BLOCKSIZE + (BXPosition * BLOCKSIZE);
											// BLOCKSIZE is bmp's left space(15).
					DYPosition = BOARDySTART  +1 - 5 + (BYPosition * BLOCKSIZE); 
					CurCtrl = CGAME;
				}
			} else 	if (CurCtrl == ROTATE)
			{
				pBlockR[CurBlock]->m_Frame+=CurROTATE;

				if (pBlockR[CurBlock]->m_Frame > (TempDirection * 5 + 4)) 
				{
					pBlockR[CurBlock]->m_Frame = TempDirection * 5 + 5;
					CurCtrl = CGAME;
				}
				pBlockR[CurBlock]->SetPos(DXPosition, DYPosition);
				pBlockR[CurBlock]->DrawClipped(pSc->GetBack(), &rcwin);
			} else if ((CurCtrl != BUILD) && (CurCtrl != DELETEMODE)) 
				pBlockS[CurBlock][CurDirection]->DrawClipped
					(DXPosition,DYPosition, pSc->GetBack(), &rcwin);

			if (CurCtrl == BUILD)
			{					// landing block make Each stone block ID.
				for (i = 0; i<4; i++)
 					if ((CurPosition[i][1] > -1) && (CurPosition[i][1] < BOARDHEIGHT)) // upper board array zero or lower last line, no push position data !!
						Board[CurPosition[i][1]][CurPosition[i][0]] = rand() % 5+1;
				
				CompareBlock(CurPosition[0][1]);
			}

			if (CurCtrl != CONTINUE)	// if continue, Fade draw else where
			for( i = 0; i < BOARDHEIGHT ; i++)
				for(j = 0; j < BOARDWIDTH; j++)	// Draw E-block.(exept over 100 ID)
				if ((Board[i][j] > 0) && (Board[i][j] < 100))
					pBlockE[Board[i][j]-1]->DrawFast( j * BLOCKSIZE + BOARDxSTART, 
					i * BLOCKSIZE + BOARDySTART , pSc->GetBack());

			if (CurCtrl == DELETEMODE)
			{
				for (i = 0;i < BOARDHEIGHT;i++)
					if (DeleteY[i] == 1) 
					{		// Destroy sprite put if that line will deleted
						pEXPLO->SetPos(BOARDxSTART -BLOCKSIZE,
							BOARDySTART -15 + (i * BLOCKSIZE));
						pEXPLO->DrawClipped(pSc->GetBack(), &rcwin);
					}

				for (i = 0; i < BOARDHEIGHT; i++)
				for (j = 0; j < BOARDWIDTH; j++)
					if (Board[i][j] > 100)		// upper destroy block's ID change over 100 for down scroll
							pBlockE[Board[i][j] - 100 -1]->DrawFast	// over 100 (Block ID) scroll down
							 (j * BLOCKSIZE + BOARDxSTART , 
					i * BLOCKSIZE + BOARDySTART + ADDDot , pSc->GetBack());
			
				if(pEXPLO->m_Frame > 5)
				{				// since explusion blicks, down scroll upper ex-blocks
					ADDDot+=3;
					if (ADDDot > 15)
					{
						DelLines--;
						if (DelLines > 0)
						{
							for (k = LastLine-1; k > -1; k--)
							for (j = 0; j < BOARDWIDTH;j++)
								if (Board[k][j] > 100)
								{
									Board[k+1][j] = Board[k][j];
									Board[k][j] = 0;
								}			// one line down scrolling upper deleted block
							
							for (j = 0; j < BOARDWIDTH;j++)	
								if (Board[LastLine][j] > 100)
								{			// Last Line's block is scroll end.
									Board[LastLine][j] -= 100;
								}

							DeleteY[LastLine] = 0;				// reset processed line
							
							if (LastLine > 0)
								if (DeleteY[LastLine-1] == 0) LastLine--;
									//if last upper line is no blank step next last line
						}
						 else
						{			// Delete End
							for (i = BOARDHEIGHT-2; i > -1; i--)
							for (j = 0; j < BOARDWIDTH;j++)
								if (Board[i][j] > 100)
								{
									Board[i+1][j] = Board[i][j]-100;
									Board[i][j] = 0;									
								}
							NextBlockSet();
						}			// Firat 15 dot down scroll end

						ADDDot=1;
					}	
				
				}					// if (explo->frame > 1) down scroll
			}		// Delete mode

			if (CurCtrl == NINPUT)
			{
				short hFlag = 0;
				if ((int)Exp1 > atoi(HiExp[3])) hFlag=4;
				if ((int)Exp1 > atoi(HiExp[2])) hFlag=3;
				if ((int)Exp1 > atoi(HiExp[1])) hFlag=2;
				if ((int)Exp1 > atoi(HiExp[0])) hFlag=1;
				
				if (hFlag > 0)
				{
					PlayMusic("DATA092");
					
					bActive = FALSE;
					if (bPageCounter == FALSE) 
					{
						HLine(11, 14, pSc->GetBack(), 9);		// laser line draw.
						VLine(626, 629, pSc->GetBack(), 9);
						HLine(467, 470, pSc->GetBack(), 9);
						VLine(BOARDxSTART-3, BOARDxSTART, pSc->GetBack(), 9);
						HLine(BOARDySTART-3, BOARDySTART, pSc->GetBack(), 9);
						VLine(316, 319, pSc->GetBack(), 9);

						pSc->Flip();
						bPageCounter = TRUE;
					}

					FARPROC lpBoxProc = MakeProcInstance(
						(FARPROC)BoxProc3, hInstance);
					DialogBox(hInstance, MAKEINTRESOURCE
						(IDD_DIALOG9), hWindow, lpBoxProc);
					FreeProcInstance (lpBoxProc);
								
					if (hFlag < 4)	// push lower hiscore step by step
					{
						strncpy(HiLevel[3], HiLevel[2], 10);
						strncpy(HiName[3], HiName[2], 8);
						strncpy(HiExp[3], HiExp[2], 9);
					}
					if (hFlag < 3)
					{
						strncpy(HiLevel[2], HiLevel[1], 10);
						strncpy(HiName[2], HiName[1], 8);
						strncpy(HiExp[2], HiExp[1], 9);
					}
					if (hFlag < 2)
					{
						strncpy(HiLevel[1], HiLevel[0], 10);
						strncpy(HiName[1], HiName[0], 8);
						strncpy(HiExp[1], HiExp[0], 9);
					}
						
					strncpy(HiLevel[hFlag-1], LevelStr, 10);	// Write New Hiscore
					strncpy(HiName[hFlag-1],  InputName, 8);
					strncpy(HiExp[hFlag-1], ultoa(Exp1, Lev, 10), 9);
					PlaySound(0, NEXTSOUND);
					WriteHiScore();
				}   // if New Hiscore MAN !!

				bActive = TRUE;
				SetFocus(hWindow);

				PlayMusic("DATA093");
				CurCtrl = CONTINUE;
				iCounter[2] = 10;		// Count Down Number
				iCounter[3] = 0;		// Number block Fade level
				MLy = -230;		// Continue Question text X Position.
				MLx =  320;
				Wide = 23;		// continue text Xpos Moving point
			}

			if (CurCtrl == GAMEOVER)
			{
				if (iCounter[2]==1)
				{
					PlaySound(0, EXPLO);
					for(i = 0; i<4;i++)
						Board[CurPosition[i][1]][CurPosition[i][0]] = 101;
				}

				if (iCounter[2] < 9) iCounter[2]++;

				if (iCounter[2] == 6)
					MakeBlockRandom(102);
				if (iCounter[2] > 5)
					if (iCounter[3] < 9) iCounter[3]++;

				if (iCounter[3] == 6)
					MakeBlockRandom(103);
				if (iCounter[3] > 5)
					if (iCounter[4] < 9) iCounter[4]++;

				if (iCounter[4] == 6)
					MakeBlockRandom(104);
				if (iCounter[4] > 5)
					if (iCounter[5] < 9) iCounter[5]++;

				if (iCounter[5] == 6)
					MakeBlockRandom(105);
				if (iCounter[5] > 5)
					if (iCounter[6] < 9) iCounter[6]++;

				if (iCounter[6] == 8)	// Last All block Explo Init
				{
					PlaySound(-9000, EXPLO);

					for (i = 0;i<BOARDHEIGHT; i++)
					for (j = 0;j<BOARDWIDTH; j++)
						if ((Board[i][j] > 0) && (Board[i][j] < 101))
							Board[i][j] = 106;
					
					PlaySound(9000, EXPLO);
					PlaySound(0, EXPLO);
				}
				
				if (iCounter[6] > 7) iCounter[7]++;
				if (iCounter[7] > 8) CurCtrl = NINPUT;

				for(i = 0; i < BOARDHEIGHT;i++)
				for(j = 0; j < BOARDWIDTH;j++)
				{
					if (Board[i][j] == 101)
					{
						pBlockEE->SetPos( j * BLOCKSIZE + BOARDxSTART - BLOCKSIZE, 
							i * BLOCKSIZE + BOARDySTART - BLOCKSIZE );
						pBlockEE->m_Frame = iCounter[2];
						pBlockEE->DrawTrans(pSc->GetBack());
					}

					if (Board[i][j] == 102)
					{
						pBlockEE->SetPos( j * BLOCKSIZE + BOARDxSTART - BLOCKSIZE, 
							i * BLOCKSIZE + BOARDySTART - BLOCKSIZE );
						pBlockEE->m_Frame = iCounter[3];
						pBlockEE->DrawClipped(pSc->GetBack(), &rcwin);
					}

					if (Board[i][j] == 103)
					{
						pBlockEE->SetPos( j * BLOCKSIZE + BOARDxSTART - BLOCKSIZE, 
							i * BLOCKSIZE + BOARDySTART - BLOCKSIZE );
						pBlockEE->m_Frame = iCounter[4];
						pBlockEE->DrawClipped(pSc->GetBack(), &rcwin);
					}

					if (Board[i][j] == 104)
					{
						pBlockEE->SetPos( j * BLOCKSIZE + BOARDxSTART - BLOCKSIZE, 
							i * BLOCKSIZE + BOARDySTART - BLOCKSIZE );
						pBlockEE->m_Frame = iCounter[5];
						pBlockEE->DrawClipped(pSc->GetBack(), &rcwin);
					}

					if (Board[i][j] == 105)
					{
						pBlockEE->SetPos( j * BLOCKSIZE + BOARDxSTART - BLOCKSIZE, 
							i * BLOCKSIZE + BOARDySTART - BLOCKSIZE );
						pBlockEE->m_Frame = iCounter[6];
						pBlockEE->DrawClipped(pSc->GetBack(), &rcwin);
					}

					if (Board[i][j] == 106)
					{
						pBlockEE->SetPos( j * BLOCKSIZE + BOARDxSTART - BLOCKSIZE, 
							i * BLOCKSIZE + BOARDySTART - BLOCKSIZE );
						pBlockEE->m_Frame = iCounter[7];
						pBlockEE->DrawClipped(pSc->GetBack(), &rcwin);
					}
				} //ExploEE spr draw for context END
			}	//GAMEOVER Control End

			if (CurCtrl == CONTINUE)
			{
				if (iCounter[2] == 10)
				{
					MLx -=Wide;
					MLy +=Wide;
					if (MLx < BOARDxSTART ) 
					{
						iCounter[2]=9;
						PlaySound(0, COUNTDOWN);
					}
								
				} else MLy = MLx = BOARDxSTART ;

				if (Wide > 1) Wide--;
				pKText->PutFontFrame(pSc->GetBack(),MLx, BOARDySTART + 10, TEXT_COLORy,
					"  մϱ? [ENTER]", BOARDxSTART, 320);
				pKText->PutFontFrame(pSc->GetBack(),MLy, BOARDySTART + 30, TEXT_COLORy, 
					"ƴϸ ׸մϱ...[ESC]", BOARDxSTART, 320);
				switch(iCounter[2])
				{
				case 9:
					for (i = 0; i < BOARDHEIGHT; i++) // Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][4] = Board[9][8] = Board[10][4] = Board[10][8] = Board[11][4]
					  = Board[11][5] = Board[11][6] = Board[11][7] = Board[11][8] = Board[12][8]
					   = Board[13][8] = Board[14][4] = Board[14][5] = Board[14][6] = Board[14][7] 
					    = Board[14][8] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;

				case 8:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][4] = Board[9][8] = Board[10][4] = Board[10][8] = Board[11][4]
					  = Board[11][5] = Board[11][6] = Board[11][7] = Board[11][8] = Board[12][8]
					   = Board[13][8] = Board[14][4] = Board[14][5] = Board[14][6] = Board[14][7] 
					    = Board[14][8] = Board[12][4] = Board[13][4]= 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;

				case 7:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][8] = Board[10][8] = Board[11][8] = Board[12][8] = Board[13][8]
					  = Board[14][8] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}

					break;

				case 6:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][4] = Board[10][4] = Board[11][4] = Board[11][5] = Board[11][6]
					  = Board[11][7] = Board[11][8] = Board[12][8] = Board[13][8] = Board[14][4]
					   = Board[14][5] = Board[14][6] = Board[14][7] = Board[14][8] 
					    = Board[12][4] = Board[13][4] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;

				case 5:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][4] = Board[10][4] = Board[11][4] = Board[11][5] = Board[11][6]
					  = Board[11][7] = Board[11][8] = Board[12][8] = Board[13][8] = Board[14][4]
					   = Board[14][5] = Board[14][6] = Board[14][7] = Board[14][8] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;

				case 4:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][8] = Board[9][4] = Board[9][8] = Board[10][4]
					 = Board[10][8] = Board[11][4] = Board[11][5] = Board[11][6] = Board[11][7]
					  = Board[11][8] = Board[12][8] = Board[13][8] = Board[14][8] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;

				case 3:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][8] = Board[10][8] = Board[11][4] = Board[11][5] = Board[11][6]
					  = Board[11][7] = Board[11][8] = Board[12][8] = Board[13][8] = Board[14][4]
					   = Board[14][5] = Board[14][6] = Board[14][7] = Board[14][8] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;
				
				case 2:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][8] = Board[10][8] = Board[11][4] = Board[11][5] = Board[11][6]
					  = Board[11][7] = Board[11][8] = Board[12][4] = Board[13][4] = Board[14][4]
					   = Board[14][5] = Board[14][6] = Board[14][7] = Board[14][8] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}

					break;

				case 1:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][7] = Board[9][7] = Board[10][7] = Board[11][7] = Board[12][7]
					 = Board[13][7] = Board[14][7] = 1;
					
					DrawBoardFI();
					iCounter[3]++;
					if (iCounter[3] > 31)
					{
						iCounter[2]--;
						iCounter[3]=0;
						PlaySound(0, COUNTDOWN);
					}
					break;

				case 0:
					for (i = 0; i < BOARDHEIGHT; i++)	// Board array init
					for (j = 0; j < BOARDWIDTH; j++)
						Board[i][j] = 0;
					
					Board[8][4] = Board[8][5] = Board[8][6] = Board[8][7] = Board[8][8]
					 = Board[9][4] = Board[9][8] = Board[10][4] = Board[10][8] = Board[11][4]
					  = Board[11][8] = Board[12][8] = Board[13][8] = Board[14][4] 
					  = Board[14][5] = Board[14][6] = Board[14][7] = Board[14][8] 
					   = Board[12][4] = Board[13][4]= 1;
					
					DrawBoardFI();
					iCounter[3]++;

					if (iCounter[3] > 31) 
					{
						PlaySound(0, NOROTATE);
						SendMessage(hWindow, WM_DESTROY, 0, 0);
					}
					break;
				}
			}	// continue process end


			HLine(11, 14, pSc->GetBack(), CurLASER);		// laser line draw.
			VLine(626, 629, pSc->GetBack(), CurLASER);
			HLine(467, 470, pSc->GetBack(), CurLASER);
			VLine(BOARDxSTART-3, BOARDxSTART, pSc->GetBack(), CurLASER);
			HLine(BOARDySTART-3, BOARDySTART, pSc->GetBack(), CurLASER);
			VLine(316, 319, pSc->GetBack(), CurLASER);

			pSc->Flip();bPageCounter = !bPageCounter;
		}
}

BOOL APIENTRY BoxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{						// Simplay message box
	switch (message)
	{
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
			EndDialog(hDlg, TRUE);
		return TRUE;
	}
	return FALSE;
}

BOOL APIENTRY BoxProc2(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{						// Simplay message box
	switch (message)
	{
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			bStatus=TRUE;
			EndDialog(hDlg, TRUE);
		}
		if (LOWORD(wParam) == IDCANCEL)
				EndDialog(hDlg, TRUE);
		
		return TRUE;
	}
	return FALSE;
}

BOOL APIENTRY BoxProc3(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{						// Update Hiscore (INput name) Dialog bax
	HWND hCtrl;
	
	switch (message)
	{
	case WM_INITDIALOG:
		strncpy(InputName, " ", 1);
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			hCtrl = GetDlgItem(hDlg, IDC_EDIT1);				
			GetWindowText(hCtrl, InputName, 9);
						
			EndDialog(hDlg, TRUE);
		}

		if (LOWORD(wParam) == IDC_EDIT1)
		{			
		}
	}
	return FALSE;
}

BOOL APIENTRY StatusBoxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{						// Option Select Box
	HWND hCtrl;
	char temp[8];
	BOOL bFlag;

	switch (message)
	{
	case WM_INITDIALOG:
		{
			bFlag = FALSE;
			hCtrl = GetDlgItem(hDlg, IDC_SOUND);
			CheckDlgButton(hDlg, IDC_MUSIC,bMusic);
			SetScrollRange(hCtrl, SB_CTL, 0, 10000, TRUE);
			SetScrollPos(hCtrl, SB_CTL, CurVOLUME+10000, TRUE);
			SetDlgItemText(hDlg, IDC_CURFPS, itoa(CurFPS, temp, 10));
			
			switch(CurROTATE)
			{
			case 1:
				SendDlgItemMessage(hDlg, IDC_RADIO1, BM_SETCHECK, 1, 0L);
				break;
			case 2:
				SendDlgItemMessage(hDlg, IDC_RADIO2, BM_SETCHECK, 1, 0L);
				break;

			case 3:
				SendDlgItemMessage(hDlg, IDC_RADIO3, BM_SETCHECK, 1, 0L);
				break;

			case 4:
				SendDlgItemMessage(hDlg, IDC_RADIO4, BM_SETCHECK, 1, 0L);
				break;
			}

			switch(CurLASER)
			{
			case 9:
				SendDlgItemMessage(hDlg, IDC_RADIO9, BM_SETCHECK, 1, 0L);
				break;
			case 7:
				SendDlgItemMessage(hDlg, IDC_RADIO10, BM_SETCHECK, 1, 0L);
				break;
			case 5:
				SendDlgItemMessage(hDlg, IDC_RADIO11, BM_SETCHECK, 1, 0L);
				break;
			case 3:
				SendDlgItemMessage(hDlg, IDC_RADIO12, BM_SETCHECK, 1, 0L);
				break;
			case 1:
				SendDlgItemMessage(hDlg, IDC_RADIO13, BM_SETCHECK, 1, 0L);
				break;
			}

			switch(CurTURBO)
			{
			case 1:
				SendDlgItemMessage(hDlg, IDC_RADIO5, BM_SETCHECK, 1, 0L);
				break;
			case 2:
				SendDlgItemMessage(hDlg, IDC_RADIO6, BM_SETCHECK, 1, 0L);
				break;

			case 4:
				SendDlgItemMessage(hDlg, IDC_RADIO7, BM_SETCHECK, 1, 0L);
				break;

			case 8:
				SendDlgItemMessage(hDlg, IDC_RADIO8, BM_SETCHECK, 1, 0L);
				break;
			}

			switch(CurLASER)
			{
			case 9:
				SendDlgItemMessage(hDlg, IDC_RADIO9, BM_SETCHECK, 1, 0L);
				break;
			case 7:
				SendDlgItemMessage(hDlg, IDC_RADIO10, BM_SETCHECK, 1, 0L);
				break;

			case 5:
				SendDlgItemMessage(hDlg, IDC_RADIO11, BM_SETCHECK, 1, 0L);
				break;

			case 3:
				SendDlgItemMessage(hDlg, IDC_RADIO12, BM_SETCHECK, 1, 0L);
				break;
			case 1:
				SendDlgItemMessage(hDlg, IDC_RADIO13, BM_SETCHECK, 1, 0L);
				break;
			}
			
			if (bStatus == TRUE)
			{
				hCtrl = GetDlgItem(hDlg, IDC_LEVEL);
				SendMessage(hCtrl, LB_ADDSTRING, 0, (LPARAM)"");	//as hiscore residtor level control
				if (atoi(HiExp[3]) > LEVEL2SCORE) SendMessage(hCtrl, LB_ADDSTRING, 1, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL3SCORE) SendMessage(hCtrl, LB_ADDSTRING, 2, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL4SCORE) SendMessage(hCtrl, LB_ADDSTRING, 3, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL5SCORE) SendMessage(hCtrl, LB_ADDSTRING, 4, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL6SCORE) SendMessage(hCtrl, LB_ADDSTRING, 5, (LPARAM)"渶⺴");
				if (atoi(HiExp[3]) > LEVEL7SCORE) SendMessage(hCtrl, LB_ADDSTRING, 6, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL8SCORE) SendMessage(hCtrl, LB_ADDSTRING, 7, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL9SCORE) SendMessage(hCtrl, LB_ADDSTRING, 8, (LPARAM)"");
				if (atoi(HiExp[3]) > LEVEL10SCORE) SendMessage(hCtrl, LB_ADDSTRING, 9, (LPARAM)"õ󿵿");
				if (atoi(HiExp[3]) > LEVEL11SCORE) SendMessage(hCtrl, LB_ADDSTRING, 10, (LPARAM)"ǾƵ");
				if (atoi(HiExp[3]) > LEVEL12SCORE) SendMessage(hCtrl, LB_ADDSTRING, 11, (LPARAM)"");
				SendMessage(hCtrl, LB_SETCURSEL, CurLEVEL-1, TRUE);

				bStatus = FALSE;	// back it bStatus
				bFlag = TRUE;		// ޼ Ѵ.
			}
			
			tempMusic = bMusic;
			tempVolume = CurVOLUME;
			tempFps = CurFPS;
			tempRotate = CurROTATE;
			tempTurbo = CurTURBO;
			tempLevel = CurLEVEL;
			tempLaser = CurLASER;
			return TRUE;
		}
	case WM_COMMAND:
		if (LOWORD(wParam) == IDCANCEL)
		{
			CurVOLUME = tempVolume;
			CurLEVEL = tempLevel; 
			bStatus = FALSE;		// bStatus back it
			if (bMusic)
			{
				bMusic = tempMusic;
				if (!bMusic) pMusic->Pause();
			} 
			else {
				bMusic = tempMusic;
				if (bMusic) pMusic->Resume();
			} 
			
			EndDialog(hDlg, TRUE);
		}
		
		if (LOWORD(wParam) == IDABOUT)
		{
			FARPROC lpBoxProc = MakeProcInstance(
				(FARPROC)BoxProc, hInstance);
			DialogBox(hInstance, MAKEINTRESOURCE
				(IDD_DIALOG7), hWindow, lpBoxProc);
			FreeProcInstance (lpBoxProc);
		}
		
		if (LOWORD(wParam) == IDEXIT)
		{
			FARPROC lpBoxProc = MakeProcInstance(
				(FARPROC)BoxProc2, hInstance);
			DialogBox(hInstance, MAKEINTRESOURCE
				(IDD_DIALOG8), hWindow, lpBoxProc);
			FreeProcInstance (lpBoxProc);
			if (bStatus == TRUE) EndDialog(hDlg, TRUE);
		}

		if (LOWORD(wParam) == IDOK)
		{
			DWORD nOut;
			HANDLE hFile;
			char buffer[14];
			
			CurFPS = tempFps;
			CurROTATE = tempRotate;
			CurTURBO = tempTurbo;
			CurLASER = tempLaser;
			bStatus = FALSE;		
			
			hFile = CreateFile ("DATA001", GENERIC_WRITE , 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			if (hFile == INVALID_HANDLE_VALUE) CloseHandle (hFile);	//  ȭ 

			itoa(CurFPS, temp, 10);		// push fps to buffer
			buffer[0] = temp[0];
			buffer[1] = temp[1];

			itoa(CurLASER, temp, 10);	//   ⸦ 
			buffer[2] = temp[0];

			itoa(CurTURBO, temp, 10);		// push Turbo pitch to buffer
			buffer[3] = temp[0];

			itoa(CurROTATE, temp, 10);		// push rotate pitch to buffer
			buffer[4] = temp[0];

			if (bMusic) buffer[5] = '1'; else buffer[5] = '0'; //bMusic push to buffer

			itoa(CurVOLUME+10000, temp, 10);			// push volume
			buffer[6] = temp[0];
			buffer[7] = temp[1];
			buffer[8] = temp[2];
			buffer[9] = temp[3];
			buffer[10] = temp[4];
				
			itoa (CurLEVEL, temp, 10);			// push level
			buffer[11] = temp[0];
			buffer[12] = temp[1];

			SetFilePointer (hFile, 108,  NULL, FILE_BEGIN);	// jump hiscore part (108 byte)
			WriteFile(hFile, buffer,13 , &nOut, NULL);				
			
			CloseHandle (hFile);
			TIMECAPS caps;
			timeGetDevCaps ( &caps, sizeof(caps));
			timeEndPeriod(caps.wPeriodMin);

			timeKillEvent(TimerId);
			InitTimer();

			EndDialog(hDlg, TRUE);
		}
		
		if (LOWORD(wParam) == IDC_MUSIC)
		{			
			if (bMusic) {bMusic=FALSE;pMusic->Pause();}
			else {bMusic = TRUE;pMusic->Resume();}
		}
		
		if (LOWORD(wParam) == IDC_TEST)
		{
			PlaySound(0, TESTSOUND);
		}

		if (LOWORD(wParam) == IDC_RADIO1)
		{
			CheckRadioButton(hDlg, IDC_RADIO1, IDC_RADIO4, IDC_RADIO1);
			tempRotate = 1;			
		}

		if (LOWORD(wParam) == IDC_RADIO2)
		{
			CheckRadioButton(hDlg, IDC_RADIO1, IDC_RADIO4, IDC_RADIO2);
			tempRotate = 2;			
		}

		if (LOWORD(wParam) == IDC_RADIO3)
		{
			CheckRadioButton(hDlg, IDC_RADIO1, IDC_RADIO4, IDC_RADIO3);
			tempRotate = 3;
		}

		if (LOWORD(wParam) == IDC_RADIO4)
		{
			CheckRadioButton(hDlg, IDC_RADIO1, IDC_RADIO4, IDC_RADIO4);
			tempRotate = 4;			
		}

		if (LOWORD(wParam) == IDC_RADIO5)
		{
			CheckRadioButton(hDlg, IDC_RADIO5, IDC_RADIO8, IDC_RADIO5);
			tempTurbo = 1;			
		}

		if (LOWORD(wParam) == IDC_RADIO6)
		{
			CheckRadioButton(hDlg, IDC_RADIO5, IDC_RADIO8, IDC_RADIO6);
			tempTurbo = 2;			
		}

		if (LOWORD(wParam) == IDC_RADIO7)
		{
			CheckRadioButton(hDlg, IDC_RADIO5, IDC_RADIO8, IDC_RADIO7);
			tempTurbo = 4;			
		}

		if (LOWORD(wParam) == IDC_RADIO8)
		{
			CheckRadioButton(hDlg, IDC_RADIO5, IDC_RADIO8, IDC_RADIO8);
			tempTurbo = 8;			
		}

		if (LOWORD(wParam) == IDC_RADIO9)
		{
			CheckRadioButton(hDlg, IDC_RADIO9, IDC_RADIO13, IDC_RADIO9);
			tempLaser = 9;
		}

		if (LOWORD(wParam) == IDC_RADIO10)
		{
			CheckRadioButton(hDlg, IDC_RADIO9, IDC_RADIO13, IDC_RADIO10);
			tempLaser = 7;
		}


		if (LOWORD(wParam) == IDC_RADIO11)
		{
			CheckRadioButton(hDlg, IDC_RADIO9, IDC_RADIO13, IDC_RADIO11);
			tempLaser = 5;
		}

		if (LOWORD(wParam) == IDC_RADIO12)
		{
			CheckRadioButton(hDlg, IDC_RADIO9, IDC_RADIO13, IDC_RADIO12);
			tempLaser = 3;
		}

		if (LOWORD(wParam) == IDC_RADIO13)
		{
			CheckRadioButton(hDlg, IDC_RADIO9, IDC_RADIO13, IDC_RADIO13);
			tempLaser = 1;
		}

		if (LOWORD(wParam) == IDC_LEVEL)
		{
			if (bFlag)
			{
				hCtrl = GetDlgItem(hDlg, IDC_LEVEL);
				CurLEVEL = SendMessage(hCtrl, LB_GETCURSEL, 0, 1) +1;
			}
		}

		if (LOWORD(wParam) == IDC_CURFPS)
		{
			hCtrl = GetDlgItem(hDlg, IDC_CURFPS);
			GetWindowText(hCtrl, temp, 4);
			tempFps = atoi(temp);
			if (tempFps > 70) tempFps = 70;
			if (tempFps < 10) tempFps = 10;
		}

	case WM_HSCROLL:
	{
		switch(LOWORD(wParam))
	
		{
		case SB_LINEDOWN:
			CurVOLUME += 1000;
			if (CurVOLUME < -10000) CurVOLUME = -10000;
			break;
		case SB_LINEUP:
			CurVOLUME -= 1000;
			if (CurVOLUME > 0) CurVOLUME = 0;
			break;
		case SB_THUMBTRACK:
		case SB_THUMBPOSITION:
			CurVOLUME = HIWORD(wParam) - 10000;
			break;
		}

		if (bSound) pSBuffer[0]->SetVolume(CurVOLUME);
		hCtrl = GetDlgItem(hDlg, IDC_SOUND);
		SetScrollPos(hCtrl, SB_CTL, CurVOLUME + 10000, TRUE);
	}
		return TRUE;
	}
	return FALSE;
}

void HLine(int y, int y2, CDXSurface * lpDDS, int iw)
{
	int i, xx, yy, k, m, mk;
	WORD *ptr;
	WORD pixel, r, g, b;

	m = 24 << GREENDEEP;

	if (lpDDS->Lock() !=DD_OK) return ;
	ptr = (WORD*)lpDDS->m_DDSD.lpSurface;
	ptr += ((y - iw) * pSc->m_dwPixelWidth);	// x start point plus

	for(yy = (y - iw), k = 1, i = 1; yy < (y2 + iw) ; yy++)
	{
		mk = k << GREENDEEP;
		for(xx = 0; xx < (int)pSc->m_dwPixelWidth ; xx++)
		{
			pixel = *ptr;
			r = pixel >> RBitPos;
			g = pixel << BITGLEFT;
			g >>= BITGRIGHT;
			b = pixel << 11;
			b >>=11;
		
			if (r < 24) r+=k;
			if (r > 24) r = 24;
			if (g < m)	g+= mk;
			if ((g << GREENDEEP) > m) g = m;
			
				if (b < 31) b+= (k+1);
				if (b > 31) b = 31;	
								
			r <<= RBitPos;
			g <<= 5;  
													
			*ptr = (r | g | b);
			ptr++;
		}	
		
		if (yy < y) // if Not yet Original Line, Bright Strength plus
		{
			k+=(i/2);	
			i++;		
		}
		
		if (yy >= y2) // if over Original Line, Bright Strength Back
		{
			i--;
			k-=(i/2);
		}
	}
	lpDDS->UnLock();
}

void VLine(int x, int x2, CDXSurface * lpDDS, int iw)
{
	int xx, yy, k, i, m;
	WORD *ptr;
	WORD pixel, r, g, b;

	m = 24 << GREENDEEP;

	if (lpDDS->Lock() !=DD_OK) return ;
	ptr = (WORD*)lpDDS->m_DDSD.lpSurface + (x - iw);
			
	for(yy = 0; yy < (int)pSc->m_dwPixelHeight ; yy++)
	{
		k = 1;
		for(xx = (x - iw), i=1; xx < (x2 + iw); xx++)
		{
			pixel = *ptr;
			r = pixel >> RBitPos;
			g = pixel << BITGLEFT;
			g >>= BITGRIGHT;
			b = pixel << 11;
			b >>=11;

			if (r < 24)	r+=k;
			if (r >24) r = 24;
			if (g < m)	g+= k << GREENDEEP;
			if ((g << GREENDEEP) > m) g = m;
			
			if (b < 30) b+= (k+1);
			if (b> 30) b = 31;	
										
			r <<= RBitPos;
			g <<= 5;  
													
			*ptr = (r | g | b);
			ptr++;
			if (xx < x) 
			{
				k+=(i/2);
				i++;
			}
			if (xx > x2) 
			{
				i--;
				k-=(i/2);
			}
		}
		ptr += (pSc->m_dwPixelWidth - (x2-x+iw+iw));
	}
	lpDDS->UnLock();
}

void MagicLight(int x, int y, CDXSurface* lpDDS)
{
	int i, j, ys, xs, m;
	WORD *ptr;
	WORD pixel, r, g, b;
	WORD xx[4], yy[4], ss[4];
	m = 30 << GREENDEEP;
	
	xx[0] = (rand() % 50)+x;
	xx[1] = (rand() % 50)+x;
	xx[2] = (rand() % 50)+x;
	xx[3] = (rand() % 50)+x;
	yy[0] = (rand() % 50)+y;
	yy[1] = (rand() % 50)+y;
	yy[2] = (rand() % 50)+y;
	yy[3] = (rand() % 50)+y;
	ss[0] = (rand() % 20)+2;
	ss[1] = (rand() % 20)+2;
	ss[2] = (rand() % 20)+2;
	ss[3] = (rand() % 20)+2;

for (j = 0; j <4; j++)
	for (i = ss[j]; i>0; i--)
	{
		if (lpDDS->Lock() !=DD_OK) return ;
		ptr = (WORD*)lpDDS->m_DDSD.lpSurface +
			((yy[j] - i) * pSc->m_dwPixelWidth) + xx[j]-i;	// x start point plus

		for(ys = yy[j] - i; ys < yy[j] + i ; ys++)
		{
		for(xs = xx[j] - i; xs < xx[j] + i ; xs++)
		{
			if ((ys > 0) && (ys < (int)pSc->m_dwPixelHeight))
			if ((ys == yy[j]) || (ys == (yy[j] + i -1))
				|| (xs == xx[j]) || (xs == (xx[j] + i-1)))
			{			
			pixel = *ptr;
		
			r = pixel >> RBitPos;
			g = pixel << BITGLEFT;  // pick up color element
			g >>= BITGRIGHT;
			b = pixel << 11;
			b >>=11;

			if (r < 30)	r+=(ss[j] - i); // add brightness at element of color
			if (r >30) r = 30;
			if (b < 30) b+=(ss[j] - i);
			if (b> 30) b = 30;	
			if (g < m)	g+= (ss[j] - i) << GREENDEEP;
			if ((g << GREENDEEP) > m) g = m;
			
			r <<= RBitPos;		// Bit position, Move Back.
			g <<= 5;  
													
			*ptr = (r | g | b); //	Write calculated pixel to target pixel
			}
			ptr++;
		}

		ptr += (pSc->m_dwPixelWidth-i-i);
			
		}
		lpDDS->UnLock();
	}
}

void DrawPR()
{
		xPos1--;			// This mass of lines  draw my text PR !
		if (xPos1 < 145 ) xPos1 = 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos1,30,TEXT_COLORy , text1, 321, 625);

		xPos2--;
		if (xPos2 < -545 ) xPos2 = 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos2,60,TEXT_COLORy, text2, 321, 625);
			
		xPos3--;
		if (xPos3 < -402 ) xPos3= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos3,110,TEXT_COLORy, text3, 321, 625);

		xPos4--;
		if (xPos4 < -243 ) xPos4= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos4,150,TEXT_COLORy, text4, 321, 625);

		xPos5--;
		if (xPos5 < -659 ) xPos5= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos5,190,TEXT_COLORy, text5, 321, 625);

		xPos6--;
		if (xPos6 < 155 ) xPos6= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos6,230,TEXT_COLORy, text6, 321, 625);

		xPos7--;
		if (xPos7 < -378 ) xPos7= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos7,270,TEXT_COLORy, text7, 321, 625);

		xPos8--;
		if (xPos8 < -140 ) xPos8= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos8,310,TEXT_COLORy, text8, 321, 625);

		xPos9--;
		if (xPos9 < -160 ) xPos9= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos9,350,TEXT_COLORy, text9, 321, 625);

		xPos10--;
		if (xPos10 < -290 ) xPos10= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos10,390,TEXT_COLORy, text10, 321, 625);

		xPos11--;
		if (xPos11 < -186 ) xPos11= 624;
		pKText->PutFontFrame(pSc->GetBack(),xPos11,430,TEXT_COLORy, text11, 321, 625);
}

void DrawHISCORE()
{
	short j = 65;
	Ypos9--;
	if (Ypos9 < -700 ) Ypos9 = 480;

	pSign->SetPos(0, Ypos9);
	if ((Ypos9 % 3) == 0) pSign->m_Frame ++;
	if (pSign->m_Frame > 4) pSign->m_Frame =1;
	pSign->DrawClipped(pSc->GetBack(), &rcwin);

	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, "1ST", 1, 479);
	j += 20;								// 1st hiscore display !!
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiLevel[0], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiName[0], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiExp[0], 1, 479);
	j += 30;

	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, "2ND", 1, 479);
	j += 20;								// 2nd hiscore display !!
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiLevel[1], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiName[1], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiExp[1], 1, 479);
	j += 30;

	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, "3RD", 1, 479);
	j += 20;								// 2rd hiscore display !!
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiLevel[2], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiName[2], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiExp[2], 1, 479);
	j += 30;

	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, "4TH", 1, 479);
	j += 20;								// 4th hiscore display !!
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiLevel[3], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiName[3], 1, 479);
	j += 20;
	pKText->PutFontFrameVT(pSc->GetBack(),6,Ypos9+j,TEXT_COLORg, HiExp[3], 1, 479);
}

BOOL FadeInSurface(short Num, int x, int y, CDXSurface * lpDDS, CDXSurface * lpBack)
{
	int xx, yy, m, k=1, te = 0;
	WORD *ptr, *ptrS, *temps, *tempo;
	WORD pixel, pixel2, r, g, b, r2, g2, b2;

	if (iCounter[Num] > 31) 
	{
		iCounter[Num]=0; 
		return FALSE;
	}
	m = iCounter[Num] << GREENDEEP;

	if (lpDDS->Lock() !=DD_OK) return FALSE;
	tempo = (WORD*)lpDDS->m_DDSD.lpSurface;

	if (lpBack->Lock() !=DD_OK) return FALSE;
	temps = (WORD*)lpBack->m_DDSD.lpSurface + (y * pSc->m_dwPixelWidth);
			
	for(yy = 0; yy < (int)lpDDS->m_PixelHeight ; yy++)
	{
		ptr = tempo + (yy * lpDDS->m_DDSD.lPitch/2);
		ptrS = temps + (yy * pSc->m_dwPixelWidth) + x;

		for(xx = 0; xx < lpDDS->m_PixelWidth; xx++)
		{
			pixel = *ptr;
			pixel2 = *ptrS;

			if (pixel != 0)
			{
				r = pixel >> RBitPos;
				g = pixel << BITGLEFT;
				g >>= BITGRIGHT;
				b = pixel << 11;
				b >>=11;

				r2 = pixel2 >> RBitPos;
				g2 = pixel2 << BITGLEFT;
				g2 >>= BITGRIGHT;
				b2 = pixel2 << 11;
				b2 >>=11;

				if (r2 > r) 
				{
					if (iCounter[Num] > r2) r2 = 0;
						else r2-=iCounter[Num];
					if (r2 < r) r2 = r;
				
				}  else	if (r2 < r) 
					{
						r2+=iCounter[Num];
						if (r2 > r) r2 = r;
					}
				if (g2 > g) 
				{
					if (m > g2) g2 = 0;
						else g2-=m;
					if (g2 < g) g2 = g;
				
				}  else	if (g2 < g) 
					{
						g2+=m;
						if (g2 > g) g2 = g;
					}
				if (b2 > b) 
				{
					if (iCounter[Num] > b2) b2 = 0;
						else b2-=iCounter[Num];
					if (b2 < b) b2 = b;
				
				}  else	if (b2 < b) 
					{
						b2+=iCounter[Num];
						if (b2 > b) b2 = b;
					}
				r2 <<= RBitPos;
				g2 <<= 5;  
				*ptrS = (r2 | g2 | b2);
			}
			ptr++;
			ptrS++;
		}
	}
	lpDDS->UnLock();
	lpBack->UnLock();

	return TRUE;
}

void Fade_IN(CDXSurface *pSuf, CDXSurface *pBack)
{
	WORD *ptr;
	WORD *Srptr;
	WORD pixel, r, g, b;
	short i, m;
	int x, y;

	for(i = 0; i < 31 ; i++)
	{
		if (pSuf->Lock() !=DD_OK) return ;
		Srptr = (WORD*)pSuf->m_DDSD.lpSurface;	
		if (pBack->Lock() !=DD_OK) return ;
		ptr = (WORD*)pBack->m_DDSD.lpSurface;
									
		m = i << GREENDEEP; // precalucate Green Deep for 565 Mode
		
		for(y=0; y < pSuf->m_PixelHeight; y++)
		{
			for(x=0; x < pSuf->m_PixelWidth; x++)
			{
				pixel = *Srptr;

				r = pixel >> RBitPos;		// Pick up element of color
				g = pixel << BITGLEFT;
				g >>= BITGRIGHT;
				b = pixel << 11;
				b >>= 11;

				if (r > i) r = i; 			// Fade IN!!
				if (g > m ) g = m;
				if (b > i ) b = i; 

				r <<= RBitPos;				// Turn Back BitPos
				g <<= 5;

				*ptr = (r | g | b);			// Write Pixel
				ptr++; 
				Srptr++;
			}
		}
		pBack->UnLock();
		pSuf->UnLock();
		pSc->Flip();bPageCounter = !bPageCounter;
	}
}

void Fade_OUT(CDXSurface *pSuf, CDXSurface *pBack)
{
	WORD *ptr;
	WORD *Srptr;
	WORD pixel, r, g, b;
	short i, m;
	int x, y;

	for(i = 7; i > -1 ; i--)
	{
		if (pSuf->Lock() !=DD_OK) return ;
		Srptr = (WORD*)pSuf->m_DDSD.lpSurface;	
		if (pBack->Lock() !=DD_OK) return ;
		ptr = (WORD*)pBack->m_DDSD.lpSurface;
									
		m = i << GREENDEEP; // precalucate Green Deep for 565 Mode
		
		for(y=0; y < pSuf->m_PixelHeight; y++)
		{
			for(x=0; x < pSuf->m_PixelWidth; x++)
			{
				pixel = *Srptr;

				r = pixel >> RBitPos;		// Pick up element of color
				g = pixel << BITGLEFT;
				g >>= BITGRIGHT;
				b = pixel << 11;
				b >>= 11;

				if (r > i) r = i; 			// Fade out!!
				if (g > m ) g = m;
				if (b > i ) b = i; 

				r <<= RBitPos;				// Turn Back BitPos
				g <<= 5;
				*ptr = (r | g | b);			// Write Pixel
				ptr++; 
				Srptr++;
			}
		}
		pBack->UnLock();
		pSuf->UnLock();
		pSc->Flip();bPageCounter = !bPageCounter;
	}
}
