#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <malloc.h>
#include <string.h>

////////////////////////////////////////////////////////////////////////
//
//	Wave file loader & Multivoic Player
//
//	 Wave 8 bit/sample  ٲپ о̰, ش.
//
//	1:
//		ÿ Ҹ  Sampling Rate  о
//		Wave ȴ.  Ҹ   Wave
//		Sampling Rate ؾ Ұ̴. 
//	2:
//		Ʈ   8Ʈٰ ļ ϰ 
//		ǹǷ ʹ Ҹ Ѳ   ִ.
//		ռ..
//			 = (a+b+c+d+....)
//			 ִ,ּҰó .( 0,255 )
//			-> ׳ ϱ⺸   ...
//
//	 ִ Sampling Rate
//			- 44100, 22050, 11025, 8000 [Hz]
//	 ִ Bit/sample
//			- 8, 16
//		
//				Coded by Gamza @~..
//
//			dgPIX entertainment
//
//
//	ʱȭԼ 2
//  ==========================================
//	void _dgSounduninitVoc(void);	<-ϵ ʱȭ
//	int  _dgSoundInitVocMaxData( int num );	<-ѹ оϼ ִ Wav(Ҵ)
//
//	Wave file б Լ
//	========================================================	
//	int  _dgSoundLoadVocDatas( char *wavfname, int num );
//			<- ϸ ̺ȣ, ̹ ׹ȣ ִ ̺갡  
//				  ̺갡 εȴ. 
//				Լ Ҵ ȣ  ̺ , ϰԵȴ.
//
//	Wave Play Լ
//	=========================================================
//	void dgVoicePlay( int num );
//	void dgVoiceStop( int num );
//			<-  ̺  Ҽ ִ.
//
////////////////////////////////////////////////////////////////////////

void _dgSounduninitVoc(void);
int  _dgSoundInitVocMaxData( int num );
int  _dgSoundLoadVocDatas( char *wavfname, int num );
void dgVoicePlay( int num );
void dgVoiceStop( int num );

//////////////////////////////////////////////////////////////////////////////

void main()
{
	int i;
	char c;

	if( _dgSoundInitVocMaxData( 10 )==0 )
	{
		printf( "Sound Hardware Init ERROR!!\n" );
		return;
	}

	printf("now play\n");

	_dgSoundLoadVocDatas( "New1.wav", 0 );
	_dgSoundLoadVocDatas( "New2.wav", 1 );
	_dgSoundLoadVocDatas( "New3.wav", 2 );
	_dgSoundLoadVocDatas( "New4.wav", 3 );
	_dgSoundLoadVocDatas( "New5.wav", 4 );
	_dgSoundLoadVocDatas( "New6.wav", 5 );
	_dgSoundLoadVocDatas( "New7.wav", 6 );
	_dgSoundLoadVocDatas( "New8.wav", 7 );
	_dgSoundLoadVocDatas( "New9.wav", 8 );
	_dgSoundLoadVocDatas( "New10.wav", 9 );

	while(1)
	{
		if( kbhit() )
		{
			c = getch();
			if( c == 'q' || c == 'Q' ) goto end;
			else if( c >= '0' && c <= '9' )
			{
				c -= '0';
				printf("%d\n",c);
				dgVoicePlay( c );
			}
		}
	}
end:
	_dgSounduninitVoc();
}
////////////////////////////////////////////////////////////////////////////////////////


//**********  ⼭ ҽ Դϴ  ***********//


//  DMAҽ ޿ Ѱ...-ڷǿ ۿԽϴ(øźв 縦..)
/////////////////////////////////////////////////////////////////////////////////////
#define DMA_MASK                0x0A    // DMA 䱸 MASK 巹
#define DMA_MODE                0x0B    // DMA   巹
#define DMA_FF_CLR              0x0C    // DMA  (High/low Byte) Flip-Flop Clear 巹
#define CMD_DMA_MASK_SET        0x04    // DMA DREQ MASK SET ɾ
#define CMD_DMA_MASK_CLR        0x00    // DMA DREQ MASK CLEAR ɾ
#define CMD_DMA_SINGLE_WRITE    0x44    // ֺġ -> Memory   ɾ
#define CMD_DMA_SINGLE_READ     0x48    // Memory -> ֺġ  ɾ
static unsigned char _dgSoundDMAChannelPage[4] = { 0x87,0x83,0x81,0x82 };
int     _dgSoundsetDMA(unsigned long aptr, unsigned short length, char dmaChannel, char dir)
{
   char             page, low16Add, high16Add;
   unsigned short   DMAPort, cmd;
   long             avail;
   if (!length) return 1;
   if (dmaChannel > 3) return 1;
   page = (char)(aptr >> 16);
   low16Add  = (char)(aptr & 0xff);
   high16Add = (char)((aptr >> 8) & 0xff);
   avail = (unsigned long)((~aptr & 0xffff) + 1);
   if (avail < length) return 2;
   if (dir) cmd = CMD_DMA_SINGLE_READ;
   else     cmd = CMD_DMA_SINGLE_WRITE;
   cmd += dmaChannel;
   DMAPort = dmaChannel << 1;
   outp(_dgSoundDMAChannelPage[dmaChannel], page); // ä Page Address Set
   outp(DMA_FF_CLR, 0);                 // DMA  /  Flip-Flop Reset
   outp(DMAPort, low16Add);             // DMA Base Low  8 Bit Address Set
   outp(DMAPort, high16Add);            // DMA Base High 8 Bit Address Set
   DMAPort++;
   outp(DMAPort, (length & 0xff));      // DMA Base Low  8 Bit Counter Set
   outp(DMAPort, (length >> 8));        // DMA Base High 8 Bit Counter Set
   outp(DMA_MODE, cmd);                 // DMA Mode  Single Mode  
   outp(DMA_MASK, CMD_DMA_MASK_CLR + dmaChannel);  // DMA Request Enable
   return 0;
}
int     _dgSounddisableDMA(char dmaChannel)
{
   if (dmaChannel > 3) return 1;
   outp(DMA_MASK, CMD_DMA_MASK_SET + dmaChannel);
   return 0;
}
int     _dgSoundenableDMA(char dmaChannel)
{
   if (dmaChannel > 3) return 1;
   outp(DMA_MASK, CMD_DMA_MASK_CLR + dmaChannel);
   return 0;
}
unsigned short _dgSoundreadDMACounter(char dmaChannel)
{
   unsigned short   low, high, DMAPort;
   if (dmaChannel > 3) return -1;
   outp(DMA_FF_CLR, 0);             // DMA  /  Flip-Flop Reset
   DMAPort = (dmaChannel << 1) + 1; // I/O 巹 
   low  = inp(DMAPort);             // DMA ī  8 Ʈ
   high = inp(DMAPort);             // DMA ī  8 Ʈ
   return(low | (high << 8));
}
//	End of DMA Module
////////////////////////////////////////////////////////////////////////////////////////







//
//	Ƽ̽ ·ƾ.
//
//		ִ ù - _dgSound_MAX_VOICE 32
// 
//
//		:  ź...
//		ģ:  @~..
//
////////////////////////////////////////////////////////////////////////////////////////

#define DMA_8BIT_DAC    0x14  // DMA ̿ 8 Ʈ DAC
#define HALT_DMA        0xd0  // DMA  
#define FREQ_DIVISER    0x40  // ø ļ 
#define SBL_SPEAKER_ON  0xD1  //  Ŀ Ҵ.
#define SBL_SPEAKER_OFF 0xD3  //  Ŀ .
#define SBL_RESET       0x6   //  
#define SBL_RESET_CMD   0x1
#define SBL_DATA_AVAIL  0x0e  //  Ÿ м
#define SBL_READ_DATA   0xa   //  Ÿ б
#define SBL_READ_STATUS 0xc   //   б
#define SBL_WRITE_DATA  0xc   //  Ÿ 
#define MIXER_ADDRESS   0x4
#define MIXER_DATA      0x5

#define REAL_SEG(P)     ((((unsigned)(P)) >> 4) & 0xffff)
#define REAL_OFF(P)     (((unsigned)(P)) & 0xf)
#define MAKE_PTR(S, O)  (((S) & 0xffff) << 4) + ((O) & 0xffff)
//  DAC ɾ  ũ ƾ
//  κ  ¥  WC ȭ  . (^^;)
#define _dgSoundsbCommand(S)    { while(inp(_dgSoundsbIO + SBL_READ_STATUS) & 0x80); \
                          outp(_dgSoundsbIO + SBL_WRITE_DATA, (S)); }

//  Ŀ ũ
// S 1̸ Ŀ Ű, 0̸ .
#define _dgSoundsbSpeaker(S)    _dgSoundsbCommand((S) ? SBL_SPEAKER_ON : SBL_SPEAKER_OFF)

volatile int    _dgSoundvoiceBusy;                          // ̽ ϶ 1

static int     _dgSoundsbIO;                                //  IO Ʈ ȣ
static int     _dgSoundsbIRQ;                               //  IRQ ȣ
static int     _dgSoundsbDMA;                               //  DMA ä ȣ

#define _dgSound_MAX_VOICE	32
static char    *_dgSoundvoice[_dgSound_MAX_VOICE];
static long    _dgSoundrealSize[_dgSound_MAX_VOICE];
static long    _dgSoundvoicenumber[_dgSound_MAX_VOICE];
static long    _dgSoundrealDMASize=0;

static unsigned short  _dgSoundrealVocSel;                  //  忡 Ҵ  
static char    *_dgSoundrealVocBuf = NULL;                  //  忡 Ҵ ̽ 
static long    _dgSoundvBuf[2];                             // ̽  ּ
static int     _dgSoundvSize[2];                            //         "         κ ũ
static char    _dgSoundvFlag;                               //         "         迭 ȣ

static void    (__interrupt __far *_dgSoundoldSbInt)(void);

static void _dgSoundcheckDivide( long physical, long l);
static void    _dgSoundintSubFunc();

// ׷   
void SB_MixerStereo( void )
{
    outp( _dgSoundsbIO + MIXER_ADDRESS, 0xe );
    outp( _dgSoundsbIO + MIXER_DATA, inp( _dgSoundsbIO + MIXER_DATA ) | 2 );
}
//  ¸ 
void SB_MixerMono( void )
{
    outp( _dgSoundsbIO + MIXER_ADDRESS, 0xe );
    outp( _dgSoundsbIO + MIXER_DATA, inp( _dgSoundsbIO + MIXER_DATA ) & 0xfd );
}

////////////////////////////////////////////////////////////////////////
//
// ̽   ȣǴ ͷƮ ( ͷƮ)
//
static void    __interrupt __far _dgSoundnewSbInt(void)

{
	int i;
    _disable();
    if (_dgSoundreadDMACounter(_dgSoundsbDMA) != 0xffff) { _enable(); return; }
    inp(_dgSoundsbIO + 0xe);                            // acknowledge interrupt

    if (_dgSoundvFlag)
    {
        _dgSoundvFlag--;
		for( i=0; i<_dgSound_MAX_VOICE; i++ )
		{
			if( _dgSoundrealSize[i]>0 )
			{
				_dgSoundrealSize[i] -= _dgSoundrealDMASize;				
				_dgSoundvoice[i] += _dgSoundrealDMASize;
			}
		}
        _dgSoundputVoc(_dgSoundvBuf[_dgSoundvFlag], _dgSoundvSize[_dgSoundvFlag]);
    }
    else
	{
		_dgSoundRemakeVoice();
	}

    outp(0x20, 0x20);
    _enable();
}

//     ũ ޸𸮸 ҴѴ.
static char    *_dgSounddosMalloc(unsigned size, unsigned short *selector)
{
    union REGS r;

    r.w.ax = 0x0100;                            // DPMI allocate DOS memory
    r.w.bx = (size + 15) >> 4;                  // Number of paragraphs requested
    int386(0x31, &r, &r);

    if (r.x.cflag) return NULL;                 // Failed

    *selector = r.w.dx;                         // Ҵ ޸ 
    return (char *)(r.w.ax << 4);               //  ׸Ʈ linear  ٲ۴
}

//    Ҵ ޸𸮸 Ѵ.
static int      _dgSounddosFree(char *ptr, unsigned short selector)
{
    union REGS r;

    r.w.ax = 0x0101;                            // DPMI free DOS memory
    r.w.dx = selector;                          // Selector
    int386(0x31, &r, &r);

    if (r.x.cflag) return 1;                    // Failed

    return 0;
}

////////////////////////////////////////////////////////////////////////
//
//  Ѵ.
//  : 0 - 
//        1 -  ߰ߵ ʾҴ.
//
static int     _dgSoundsbReset(int ioAddr)
{
    volatile int     i, j, k;

    for (i = 0; i < 512; i++)
    {
        //   :  ڵ(1) , (ٸ), 0 .
        outp(ioAddr + SBL_RESET, SBL_RESET_CMD);              //   ڵ带 .
        for (j=0; j < 100; j++) k = inp(ioAddr + SBL_RESET);  // ٸ.
        outp(ioAddr + SBL_RESET, 0);                          // 0 .

        for (j = 0; j < 512; j++)
            if (inp(ioAddr + SBL_DATA_AVAIL) & 0x80) break;

        //  νİ AAh  Ȯ Ѵ.
        if (inp(ioAddr + SBL_READ_DATA) == 0xAA) return 0;  //  ִٸ 0 .
   }

   return 1;                                    // ,  ߰ߵ ʾ.
}
////////////////////////////////////////////////////////////////////////
//
//  ø ļ Ѵ.
// Է : rate -  ļ (8000 8KHz ļ Ѵ.)
//
void    _dgSoundsetSampleRate(unsigned rate)
{
    _dgSoundsbCommand(FREQ_DIVISER);                    //  ļ ְ 
    _dgSoundsbCommand((char)(256 - 1000000 / rate));    //  ļ 
}

////////////////////////////////////////////////////////////////////////
//
// _dgSoundrealVocBuf ġ μ size Ͽ Ÿ  κ
//  ˻ϰ,  Ѵ.
// Է : size -   ̽ 
//
static void _dgSoundcheckDivide( long physical, long l)
{
	long page, add16;
   page  = (physical&0xFF0000L) ; /* DMA ̱  */
   add16 = (physical&0xFFFFL) ;   /* 	 16 巹 */
   _dgSoundvFlag = 0;
   _dgSoundvBuf[0]=physical ;
   _dgSoundvSize[0] = l ;
   if (add16+l>0x10000L) /* ̱ ٷΰ ᳪ° ? */
   {
     _dgSoundvBuf[0] = page+0x10000L ; /* 孷 2 . */
     _dgSoundvSize[0]=((physical+l)&0xFFFF) ;
     _dgSoundvSize[1]=l-_dgSoundvSize[0] ;
     _dgSoundvBuf[1] = physical ;
	 _dgSoundvFlag = 1;
   }
}

////////////////////////////////////////////////////////////////////////
//
//  ۿ ũ⸸ŭ ̽ Ÿ DMA Ѵ.
// Է : buf - ̽ Ÿ  ּ
//                ּҴ    ġؾ Ѵ.
//        size - ̽ Ÿ ũ
//               DMA  ũ ̹Ƿ 64k  ʾƾ Ѵ.
//  : 0 - 
//        6 - DMAä   Ѿ. (ä = 0 ~ 3)
//            Ǵ _dgSoundsetDMA Ÿ ũⰡ 0̴.
//        7 - _dgSoundsetDMA Ÿ ũⰡ Ŀ DMA    .
//
int     _dgSoundputVoc(long buf, int size)
{
	_dgSoundrealDMASize = size;

    if (_dgSounddisableDMA(_dgSoundsbDMA)) return 6;
    switch(_dgSoundsetDMA((unsigned long)buf, size, _dgSoundsbDMA, 1))
    {
        case 1 : return 6;
        case 2 : return 7;
        default : break;
    }
    _dgSoundsbCommand(DMA_8BIT_DAC);// DMA  ̽ ũ⸦ Ѵ.
    _dgSoundsbCommand(size & 0xff);
    _dgSoundsbCommand((size >> 8) & 0xff);
    _dgSoundvoiceBusy = 1;

    return 0;
}

////////////////////////////////////////////////////////////////////////
//
// ̽ ۿ ִ ̽  Ѵ.
// Է : voiceNumber - ̽ ȣ
//  : 0 - 
//        3 - ̽ ȣ ִ ̽  Ѿ
//        5 - ε  ̽ ȣ
//        6 - DMAä   Ѿ. (ä = 0 ~ 3)
//            Ǵ _dgSoundsetDMA Ÿ ũⰡ 0̴.
//        7 - _dgSoundsetDMA Ÿ ũⰡ Ŀ DMA    .
//  : readyVoc, _dgSoundputVoc
//

void _dgSoundRemakeVoice()
{
	int		i,j, data;
	long	size;
	long    playlong;
	char	*playptr;
	char	*vocplayptr;

	playptr = _dgSoundrealVocBuf;
	playlong = ((long)_dgSoundrealVocBuf);

	if( _dgSoundrealDMASize>0 )
	{
		for( i=0; i<_dgSound_MAX_VOICE; i++ )
		{
			if( _dgSoundrealSize[i]>0 )
			{
				_dgSoundrealSize[i] -= _dgSoundrealDMASize;
				_dgSoundvoice[i] += _dgSoundrealDMASize;
			}
		}
	}
	memset( playptr, 128, 65536 );
	size=0;
	for( i=0; i<_dgSound_MAX_VOICE; i++ )
	{
		if( _dgSoundrealSize[i]>0 )
		{
			vocplayptr = _dgSoundvoice[i];
			for( j=0; j<_dgSoundrealSize[i] && j<65535; j++ )
			{
				data = ((long)vocplayptr[j]);
				data = ((long)playptr[j] + data - 128);
				if( data<0 ) data=0;
				else if( data>255 ) data=255;
				playptr[j] = data;
			}
			if( size<j ) size=j;
		}
	}
	if( size<=0 )
	{
		_dgSoundvoiceBusy = 0;
	}
	else
	{
		_dgSoundcheckDivide( playlong, size );
		_dgSoundputVoc(_dgSoundvBuf[_dgSoundvFlag], _dgSoundvSize[_dgSoundvFlag]);
	}
}

int _dgSoundMakeVoice( int num )
{
	int		i;
	long	passSize;

    if (_dgSoundvoiceBusy)                // Ƽ ̽ ռ
    {
        _dgSoundsbCommand(HALT_DMA);  // ϴ ̽  Ѵ.
		passSize = _dgSoundreadDMACounter(_dgSoundsbDMA);
		if( passSize!=0xffff )
		{
			passSize = _dgSoundrealDMASize-passSize;

			for( i=0; i<_dgSound_MAX_VOICE; i++ )
			{
				if( _dgSoundrealSize[i]>0 && num!=i )
				{
					_dgSoundrealSize[i] -= passSize;
					_dgSoundvoice[i] += passSize;
				}
			}
			_dgSoundrealDMASize = 0;
		}
	}
	else _dgSoundrealDMASize = 0;
	_dgSoundRemakeVoice();
    return 0;
}

int _dgSoundplayVoc( char *voc_data, long voc_size )
{
	int i;
	for( i=0; i<_dgSound_MAX_VOICE; i++ ) 
		if( _dgSoundrealSize[i]<=0 ) break;
	if( i>=_dgSound_MAX_VOICE ) return -1;
	_dgSoundvoice[i] = voc_data;
	_dgSoundrealSize[i] = voc_size;

	_dgSoundMakeVoice( i );
	return i;
}

void dgVoiceStop( int num )
{
	int i;
    if (_dgSoundvoiceBusy)
    {
		if( num<0 )
		{
			_dgSoundsbCommand(HALT_DMA);
			_dgSoundvoiceBusy = 0;
			for( i=0; i<_dgSound_MAX_VOICE;i++ ) _dgSoundrealSize[i]=0;
		}
		else
		{
			_dgSoundrealSize[num]=0;

			for( i=0; i<_dgSound_MAX_VOICE;i++ )
			{
				if( _dgSoundvoicenumber[i]==num ) _dgSoundrealSize[i]=0;
			}			
			_dgSoundMakeVoice( -1 );
		}
    }
}

////////////////////////////////////////////////////////////////////////
//                                                                    //
//                      Sound Blaster auto detecting                  //
//               Original programming : (Hitel;wd40)            //
//                                                                    //
////////////////////////////////////////////////////////////////////////
static void __interrupt __far _dgSoundint2(void)
{
   _disable();
   inp(_dgSoundsbIO + 0xe);
   outp(0x20, 0x20);
   _dgSoundsbIRQ = 2;
   _enable();
}

static void __interrupt __far _dgSoundint3(void)
{
   _disable();
   inp(_dgSoundsbIO + 0xe);
   outp(0x20, 0x20);
   _dgSoundsbIRQ = 3;
   _enable();
}

static void __interrupt __far _dgSoundint5(void)
{
   _disable();
   inp(_dgSoundsbIO + 0xe);
   outp(0x20, 0x20);
   _dgSoundsbIRQ = 5;
   _enable();
}

static void __interrupt __far _dgSoundint7(void)
{
   _disable();
   inp(_dgSoundsbIO + 0xe);
   outp(0x20, 0x20);
   _dgSoundsbIRQ = 7;
   _enable();
}

////////////////////////////////////////////////////////////////////////
//
//   и  ð  Ѵ. (AT ̻󿡼 )
//
//   Է : mSec - и (1000mSec -> 1)
//
static void _dgSoundwaitmSec(int mSec)
{
    long     tick;

    tick = (32768 * (long)mSec) / 1000;          // ʴ ޽  ٲ۴.
    //
    // |-| |-| |-| |-| |-| |-| |-| |-| |   <- 61h  Ʈ 4
    // | |_| |_| |_| |_| |_| |_| |_| |_|
    //          ֱ 32Khz
    //
    for (; tick > 0; tick--)
    {
        while(inp(0x61) & 0x10);
        while(!(inp(0x61) & 0x10));
    }
}

////////////////////////////////////////////////////////////////////////
//
//  IO , IRQ ȣ, DMA ä ڵ ˻Ͽ ãش.
//  : 0 -  ã
//            ioAddr, irqNum, dmaCh  .
//        1 -  ã ߴ.
//
int     _dgSoundDetect()
{
    int     i, found;
    int     old8259mask;
    void    (interrupt *oldInt2)(void);         // ͷƮ 2,3,5,7 
    void    (interrupt *oldInt3)(void);
    void    (interrupt *oldInt5)(void);
    void    (interrupt *oldInt7)(void);

    _dgSoundsbIO = _dgSoundsbIRQ = _dgSoundsbDMA = -1;

    // 210h  280h   ½Ű鼭  IO  ã´.
    found = 0;
    for (i = 0x210; i <= 0x280; i += 0x10)
    {
        if (!_dgSoundsbReset(i))
        {
            found = 1;
            _dgSoundsbIO = i;
            break;
        }
    }
    if (!found) return 0;

    _disable();
    oldInt2 = _dos_getvect(0x8 + 2); _dos_setvect(0x8 + 2, _dgSoundint2);
    oldInt3 = _dos_getvect(0x8 + 3); _dos_setvect(0x8 + 3, _dgSoundint3);
    oldInt5 = _dos_getvect(0x8 + 5); _dos_setvect(0x8 + 5, _dgSoundint5);
    oldInt7 = _dos_getvect(0x8 + 7); _dos_setvect(0x8 + 7, _dgSoundint7);
    _enable();

    //  ϴ IRQ 2,3,5,7 ͷƮ ϰ Ѵ.
    old8259mask = inp(0x21);
    outp(0x21, old8259mask & 0x53);             // 01010011 (Enable 2,3,5,7 interrupts on PIC)

    // ͷƮ ã ؼ  ͷƮ ߻Ű  .
    _dgSoundsbCommand(0xf2);                            // interrupt request
    _dgSoundwaitmSec(400);                              // ͷƮ ߻Ҷ 400 и ٸ.

    _dgSoundsbSpeaker(0);
    _dgSoundsetSampleRate(8000);

    // DMA ä ãؼ  ϴ DMA ä 1, 3 ̿  ߻
    _dgSoundsetDMA(0x30000L, 100, 1, 1);
    _dgSoundsetDMA(0x30000L, 100, 3, 1);
    _dgSoundsbCommand(DMA_8BIT_DAC);
    _dgSoundsbCommand(2);
    _dgSoundsbCommand(0);
    _dgSoundwaitmSec(400);

    _dgSoundsbDMA = 1;
    // ġ DMA ä īͰ 3 Ѵ.
    if (_dgSoundreadDMACounter(3) == 97)
	{
		_dgSoundsbDMA = 3;
//		printf("_dgSoundsbDMA = 3;\n");
	}
    if (_dgSoundreadDMACounter(1) == 97)
	{
		_dgSoundsbDMA = 1;
//		printf("_dgSoundsbDMA = 1;\n");
	}

    outp(0x21, old8259mask);
    _disable();
    _dos_setvect(0x8+2, oldInt2);
    _dos_setvect(0x8+3, oldInt3);
    _dos_setvect(0x8+5, oldInt5);
    _dos_setvect(0x8+7, oldInt7);
    _enable();

    if (_dgSoundsbIRQ == -1 || _dgSoundsbDMA == -1) return 0;       //  ã ߴ.

    _dgSoundvoiceBusy = 0;
    _dgSoundrealVocBuf = _dgSounddosMalloc(65536*2, &_dgSoundrealVocSel);
	if( _dgSoundrealVocBuf == NULL )return 0;

    _disable();
    _dgSoundoldSbInt = _dos_getvect(0x8 + _dgSoundsbIRQ);
    _dos_setvect(0x8 + _dgSoundsbIRQ, _dgSoundnewSbInt);        //  ͷƮ ƾ 
    outp(0x21, inp(0x21) & (~(1 << _dgSoundsbIRQ)));    // Enable interrupts on PIC
    _enable();

    _dgSoundsbSpeaker(1);
    _dgSoundsetSampleRate(8000);               // ø ļ ʱ 

	for( i=0; i<_dgSound_MAX_VOICE;i++ )
	{
		_dgSoundrealSize[i]=0;
	}

    return 1;
}

////////////////////////////////////////////////////////////////////////
//
//  ϵ ͷƮ  · ͽŲ.
// α׷   ȣѴ.
//
void    _dgSounduninit(void)
{
	_dgSounddosFree(_dgSoundrealVocBuf, _dgSoundrealVocSel);

    dgVoiceStop(-1);
    _dgSoundsbSpeaker(0);

    _disable();
    //_dos_setvect(0x8 + _dgSoundsbIRQ, _dgSoundoldSbInt);
    if (_dgSoundsbIRQ != 2) outp(0x21, inp(0x21) | (1 << _dgSoundsbIRQ));
    _enable();
    _dgSoundvoiceBusy = 0;
}

///////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
//
//	Wave file loader & Multivoic Player
//
//	޸𸮸 Ҵް Wave  εѴ.
//	 Wave 8 bit/sample  ٲپ оδ.
//
//	1:
//		ÿ Ҹ  Sampling Rate  о
//		Wave ȴ.  Ҹ   Wave
//		Sampling Rate ؾ Ұ̴. 
//	2:
//		Ʈ   8Ʈٰ ļ ϰ 
//		ǹǷ ʹ Ҹ Ѳ   ִ.
//		ռ..
//			 = (a+b+c+d+....)
//			 ִ,ּҰó .( 0,255 )
//
//	 ִ Sampling Rate
//			- 44100, 22050, 11025, 8000 [Hz]
//	 ִ Bit/sample
//			- 8, 16
//		
//				Coded by Gamza @~..
//
//			dgPIX entertainment
//
////////////////////////////////////////////////////////////////////////
typedef struct {
	char           chunkID[4];
	long           chunkSize;
} _dgSoundWavChunk;

typedef struct {  
	short          wFormatTag;  
	unsigned short wChannels;
	unsigned long  dwSamplesPerSec;  
	unsigned long  dwAvgBytesPerSec;
	unsigned short wBlockAlign;  
	unsigned short wBitsPerSample;
} _dgSoundFormatChunk;

typedef struct {
	unsigned short Channels;
	unsigned long  sps; // Samples per Sec
	unsigned short bps; // Bits per Sample
	unsigned long  datasize;
	unsigned char data[1];
} _dgSoundWav;

_dgSoundWav *_dgSoundloadVoc(char *filename)
{
    FILE    *fp;
    long    fSize;
	long	i;
	long	l;
	short int a,b;
	_dgSoundWav		*result;

	_dgSoundWavChunk	chunk;
	_dgSoundFormatChunk	format;
	char checkformat=0;
	char checkdata=0;

    fp = fopen(filename, "rb");
    if (fp == NULL) return NULL;

	fread( &chunk, sizeof( _dgSoundWavChunk ), 1, fp );
	fseek( fp, 4, SEEK_CUR );

	while( fread( &chunk, sizeof( _dgSoundWavChunk ), 1, fp )>0 )
	{
		if( chunk.chunkID[0]=='f' && 
			chunk.chunkID[1]=='m' && 
			chunk.chunkID[2]=='t' &&
			checkformat==0 )
		{
			fread( &format, sizeof( _dgSoundFormatChunk ), 1, fp );
			fseek( fp, chunk.chunkSize-sizeof(_dgSoundFormatChunk), SEEK_CUR );
			checkformat=1;
		}
		else if( chunk.chunkID[0]=='d' && 
				chunk.chunkID[1]=='a' && 
				chunk.chunkID[2]=='t' && 
				chunk.chunkID[3]=='a' &&
				checkdata==0 )
		{
			if( format.wChannels==1 )
			{
				if( format.wBitsPerSample==8 )
				{
					fSize = chunk.chunkSize;
					result = malloc(fSize+sizeof(_dgSoundWav)-1);
					if (result == NULL)
					{
						printf( "Memory allocation error!!\n" );
						fclose(fp);
						return NULL;
					}
					result->datasize = fSize;
					fread( result->data, fSize, 1, fp );
				}
				else if( format.wBitsPerSample==16 )
				{
					fSize = chunk.chunkSize/2;
					result = malloc(fSize+sizeof(_dgSoundWav)-1);
					if (result == NULL)
					{
						printf( "Memory allocation error!!\n" );
						fclose(fp);
						return NULL;
					}
					result->datasize = fSize;

					for( i=0; i<fSize; i++ )
					{
						fread( (void*)&(a), 2, 1, fp );
						l = a;
						l = (l>>8)+128;
						if( l<0 ) l=0;
						else if( l>255 ) l=255;
						result->data[i] = (unsigned char)l;
					}
				}				
				checkdata++;
			}
			else if( format.wChannels==2 )
			{
				if( format.wBitsPerSample==8 )
				{
					fSize = chunk.chunkSize/2;
					result = malloc(fSize+sizeof(_dgSoundWav)-1);
					if (result == NULL)
					{
						printf( "Memory allocation error!!\n" );
						fclose(fp);
						return NULL;
					}
					result->datasize = fSize;

					for( i=0; i<fSize; i++ )
					{
						fread( (void*)&(a), 1, 1, fp );
						fread( (void*)&(b), 1, 1, fp );						
						l = ( a + b )/2;
						if( l<0 ) l=0;
						else if( l>255 ) l=255;
						result->data[i] = (unsigned char)l;
					}
				}
				else if( format.wBitsPerSample==16 )
				{
					fSize = chunk.chunkSize/4;
					result = malloc(fSize+sizeof(_dgSoundWav)-1);
					if (result == NULL)
					{
						printf( "Memory allocation error!!\n" );
						fclose(fp);
						return NULL;
					}
					result->datasize = fSize;

					for( i=0; i<fSize; i++ )
					{
						fread( (void*)&(a), 2, 1, fp );
						fread( (void*)&(b), 2, 1, fp );						
						l = ( a + b )/2;
						l = (l>>8)+128;
						if( l<0 ) l=0;
						else if( l>255 ) l=255;
						result->data[i] = (unsigned char)l;
					}
				}
				checkdata++;
			}
			else 
			{
				fclose(fp);
				return NULL;
			}
		}
		else fseek( fp, chunk.chunkSize, SEEK_CUR );
		if( checkdata && checkformat ) break;
	}
    fclose(fp);

	if( checkdata==0 ) return NULL;
	if( checkformat==0 )
	{
		free( result );
		return NULL;
	}

	result->Channels = format.wChannels;
	result->sps = format.dwSamplesPerSec;
	result->bps = format.wBitsPerSample;

    return result;
}

//////////////////////////////////////////////////////////////
_dgSoundWav **_dgSoundWavDatas=NULL;
long _dgSoundMaxWavData=0;
long _dgSoundInitOK=0;

int  _dgSoundInitVocMaxData( int num )
{
	int i;
	if( num<=0 ) return 0;
	if( _dgSoundWavDatas!=NULL ) return 0;
	_dgSoundWavDatas = (_dgSoundWav**)malloc( num*4 );
	if( _dgSoundWavDatas==NULL ) return 0;
	if( _dgSoundDetect()==0 )
	{
		free(_dgSoundWavDatas);
		return 0;
	}
	_dgSoundMaxWavData = num;
	for( i=0; i<_dgSoundMaxWavData; i++ )
			_dgSoundWavDatas[i]=NULL;
	_dgSoundInitOK = 1;
	return 1;
}

void _dgSounduninitVoc(void)
{
	int i;
	if( _dgSoundInitOK==0 ) return;
	_dgSounduninit();
	if( _dgSoundWavDatas!=NULL )
	{
		for( i=0; i<_dgSoundMaxWavData; i++ )
		{
			if( _dgSoundWavDatas[i]!=NULL )
				free(_dgSoundWavDatas[i] );
		}
		free(_dgSoundWavDatas);
	}
	_dgSoundInitOK=0;
}

int  _dgSoundLoadVocDatas( char *wavfname, int num )
{
	if( _dgSoundInitOK==0 ) return 0;
	_dgSoundWavDatas[num] = _dgSoundloadVoc(wavfname);
	if( _dgSoundWavDatas[num] == NULL )
	{
		printf("LoadWav Failed.. %s\n", wavfname );
		return 0;
	}

	return 1;
}

void dgVoicePlay( int num )
{
	int i;
	if( _dgSoundInitOK==0 ) return;
	if( _dgSoundWavDatas[num]==NULL ) return;
	_dgSoundsetSampleRate(_dgSoundWavDatas[num]->sps);
	i = _dgSoundplayVoc( _dgSoundWavDatas[num]->data, _dgSoundWavDatas[num]->datasize );
	_dgSoundvoicenumber[i] = num;
}
//////////////////////////////////////////////////////////////
