#include "cPlasma.h"

#define dManWidth	*(pBODY->pSPR[pBODY->pANI[Action].pFRM[CurFrame].Sprite]  )
#define dManHeight	*(pBODY->pSPR[pBODY->pANI[Action].pFRM[CurFrame].Sprite]+1)

#define dManPosX1	(XPos + pBODY->pANI[Action].pFRM[CurFrame].XPos)
#define dManPosY1 	(YPos + pBODY->pANI[Action].pFRM[CurFrame].YPos)
#define dManPosX2	(dManPosX1 + dManWidth )
#define dManPosY2 	(dManPosY1 + dManHeight)


void
ClassACTER::Init(ClassPLASMA *Plasma,ClassSTAGE *Map,int x,int y,int roll,int interval,int movepoint)
{
	pBODY		=	Plasma	;
	pMAP		=	Map		;

	Roll		=	roll	;
	
	XPos		=	x		;
	YPos		=	y		;
	Action		=	0		;
	CurFrame	=	0		;

	Interval	=	interval;
	pInterval	=	0;
	MovePoint	=	movepoint;
}

ClassACTER::ClassACTER()
{
}

ClassACTER::~ClassACTER()
{
	pBODY	=	NULL;
	pMAP	=	NULL;
}

void ClassACTER::PutCurFrame()
{

	if (dManPosX1 + dManWidth				< pMAP->XPos					|| 
		dManPosY1 + dManHeight				< pMAP->YPos					||
		dManPosX1							> pMAP->XPos + pMAP->ScrWidth	||
		dManPosY1							> pMAP->YPos + pMAP->ScrHeight	) return;

	if (dManPosX1							> pMAP->XPos					&& 
		dManPosX1 - pMAP->XPos + dManWidth	< pMAP->ScrWidth - 1			&&
		dManPosY1							> pMAP->YPos					&& 
		dManPosY1 - pMAP->YPos + dManHeight	< pMAP->ScrHeight- 1			)
			pBODY->PutFrame(XPos-pMAP->XPos,YPos-pMAP->YPos,Action,CurFrame);
	else	pBODY->PutFrameClip(XPos-pMAP->XPos,YPos-pMAP->YPos,Action,CurFrame);

}

void ClassACTER::PutCurFrameTrans()
{

	if (dManPosX1 + dManWidth				< pMAP->XPos					|| 
		dManPosY1 + dManHeight				< pMAP->YPos					||
		dManPosX1							> pMAP->XPos + pMAP->ScrWidth	||
		dManPosY1							> pMAP->YPos + pMAP->ScrHeight	) return;

	if (dManPosX1							> pMAP->XPos					&& 
		dManPosX1 - pMAP->XPos + dManWidth	< pMAP->ScrWidth - 1			&&
		dManPosY1							> pMAP->YPos					&& 
		dManPosY1 - pMAP->YPos + dManHeight	< pMAP->ScrHeight- 1			)
			pBODY->PutFrameTrans(XPos-pMAP->XPos,YPos-pMAP->YPos,Action,CurFrame);
	else	pBODY->PutFrameClipTrans(XPos-pMAP->XPos,YPos-pMAP->YPos,Action,CurFrame);

}

void ClassACTER::MoveLeft()
{
int xpos=XPos-MovePoint;

	if (pMAP->GetAttr(xpos+ pBODY->CrashX,YPos	) == 1 )
	{
		if (pMAP->GetAttr(xpos+pBODY->CrashX, YPos-pMAP->TileHeight )!=1 ) YPos-=MovePoint;
		return;
	}

	if (pMAP->GetAttr(XPos+pBODY->CrashX , YPos+pBODY->CrashY) == 1  )
	{
		if (pMAP->GetAttr(xpos+ pBODY->CrashX,YPos+pBODY->CrashY+pMAP->TileHeight ) != 1 ) 	YPos+=MovePoint; 
		return; 
	}

	if (xpos + pBODY->CrashX < 0 ) xpos=Abs(pBODY->CrashX);
	
	XPos=xpos;
}

void ClassACTER::MoveRight()
{
int xpos=XPos+MovePoint;

	if (pMAP->GetAttr(xpos- pBODY->CrashX,YPos				) == 1 )
	{
		if (pMAP->GetAttr(xpos-pBODY->CrashX, YPos-pMAP->TileHeight )!=1 ) YPos-=MovePoint;
		return;
	}

	if (pMAP->GetAttr(XPos-pBODY->CrashX , YPos+pBODY->CrashY) == 1  )
	{
		if (pMAP->GetAttr(xpos- pBODY->CrashX,YPos+pBODY->CrashY+pMAP->TileHeight ) != 1 ) 	YPos+=MovePoint; 
		return; 
	}

	if (xpos - pBODY->CrashX > pMAP->WholeWidth) xpos = pMAP->WholeWidth-Abs(pBODY->CrashX);
	
	XPos=xpos;
}

void ClassACTER::MoveBackward()
{
int ypos=YPos-MovePoint;

	if (pMAP->GetAttr(XPos+pBODY->CrashX , ypos+pBODY->CrashY) == 1 )
	{
		if (pMAP->GetAttr(XPos-pBODY->CrashX , ypos+pBODY->CrashY) != 1  )
			if (pMAP->GetAttr(XPos+pBODY->CrashX+pMAP->TileWidth , ypos+pBODY->CrashY)!=1 ) XPos+=MovePoint;
		return;
	}
		
	if (pMAP->GetAttr(XPos-pBODY->CrashX , ypos+pBODY->CrashY) == 1  )
	{ 
		if (pMAP->GetAttr(XPos-pBODY->CrashX-pMAP->TileWidth , ypos+pBODY->CrashY)!=1 ) XPos-=MovePoint;
		return;
	}

	for (int i=XPos+pBODY->CrashX;i<XPos-pBODY->CrashX;i+=pMAP->TileWidth)
		if (pMAP->GetAttr(i , ypos+pBODY->CrashY) == 1 ) return;

	if (ypos + pBODY->CrashY < 0 ) ypos = Abs(pBODY->CrashY);

	YPos=ypos;
}

void ClassACTER::MoveForward()
{
int ypos=YPos+MovePoint;

	if (pMAP->GetAttr(XPos+pBODY->CrashX , ypos) == 1 )
	{
		if (pMAP->GetAttr(XPos-pBODY->CrashX , ypos) != 1  )
		if (pMAP->GetAttr(XPos+pBODY->CrashX+pMAP->TileWidth , ypos)!=1 ) XPos+=MovePoint;
		return;
	}
		
	if (pMAP->GetAttr(XPos-pBODY->CrashX , ypos) == 1  )
	{ 
		if (pMAP->GetAttr(XPos-pBODY->CrashX-pMAP->TileWidth , ypos)!=1 ) XPos-=MovePoint;
		return;
	}

	for (int i=XPos+pBODY->CrashX;i<XPos-pBODY->CrashX;i+=pMAP->TileWidth)
		if (pMAP->GetAttr(i , ypos) == 1 ) return;

	if (ypos > pMAP->WholeHeight ) ypos=pMAP->WholeHeight;

	YPos=ypos;
}

void ClassACTER::IncFrame()
{
	CurFrame++;
	if (CurFrame > pBODY->pANI[Action].TotalFrm - 1 ) CurFrame=0;
}

void ClassACTER::DecFrame()
{
	CurFrame--;
	if (CurFrame < 0 ) CurFrame=pBODY->pANI[Action].TotalFrm - 1;

}

void ClassACTER::MakeOverDrawTable()
{
int i,j,x1,y1,x2,y2,k;
BOOL put=FALSE;

	x1=(dManPosX1/pMAP->TileWidth ) * pMAP->TileWidth ;
	y1=(dManPosY1/pMAP->TileHeight) * pMAP->TileHeight;

	x2=((dManPosX2/pMAP->TileWidth ) +1) * pMAP->TileWidth ;
	y2=((dManPosY2/pMAP->TileHeight)+1) * pMAP->TileHeight;

	x1=Max(x1,0);
	y1=Max(y1,0);
	x2=Min(x2,pMAP->WholeWidth );
	y2=Min(y2,pMAP->WholeHeight);

	if (x2 > pMAP->XPos && 
		y2 > pMAP->YPos && 
		x1 < pMAP->XPos + pMAP->ScrWidth  &&
		y1 < pMAP->YPos + pMAP->ScrHeight   )

	for (k=x1;k<x2;k+=pMAP->TileWidth) 
		if (pMAP->GetAttr(k,YPos) == 2 || pMAP->GetAttr(k,YPos+pBODY->CrashY)==2)  put=TRUE;

	if (!put) return;

	for (i=x1;i<x2;i+=pMAP->TileWidth)
	{
		for (j=y1;j<y2;j+=pMAP->TileHeight)
		{
			switch(pMAP->GetAttr(i,j))
			{     
				case 2 :  //   Ʈ..
					pMAP->pOverDraw[pMAP->OverDraw].Method=dSPRITE;
					pMAP->pOverDraw[pMAP->OverDraw].Tile  =pMAP->GetTile(i/pMAP->TileWidth,j/pMAP->TileHeight)+1;
					pMAP->pOverDraw[pMAP->OverDraw].XPos  =i;
					pMAP->pOverDraw[pMAP->OverDraw].YPos  =j; 
					pMAP->OverDraw++; 
					break;

				default : 
					break;
			} 
		} 
	}
}

void ClassACTER::Working(eDIRECT direct)
{
int oldAction=Action;
static int stop=0;

	switch(direct)
	{
		case eLEFT		: 
			stop=0;
			Action=dWORKING_LEFT    ;                           // .. ϸ̼ ..
			if (oldAction!=Action) {CurFrame=0;pInterval=0;}	//  ƴϰ ϸ̼ ٲٸ..
			MoveLeft	();	                                    // ̵..
			break;

		case eRIGHT		: 
			stop=0;
			Action=dWORKING_RIGHT   ;
			if (oldAction!=Action) {CurFrame=0;pInterval=0;}	// ̰  ̰  ...
			MoveRight	();
			break;
		
		case eFORWARD	: 
			stop=0;
			Action=dWORKING_FORWARD ;
			if (oldAction!=Action) {CurFrame=0;pInterval=0;}	// ɸ ϴ..
			MoveForward	();
			break;

		case eBACKWARD	: 
			stop=0;
			Action=dWORKING_BACKWARD;
			if (oldAction!=Action) {CurFrame=0;pInterval=0;}	// ġ ..
			MoveBackward();
			break;

		case eSTAND		:
			stop++;
			break;
	}

	pInterval++;	// ͹ ī
	if (stop > 10 ) {stop=11;CurFrame=0;}
	else if (pInterval>Interval) {IncFrame();pInterval=0;}			//   ǰ.. 
	if (Roll==dHERO) pMAP->MoveTo(XPos-(pMAP->ScrWidth>>1),YPos-(pMAP->ScrHeight>>1));
	MakeOverDrawTable();
}