/*

   Ŭ   cCANVAS.H Ӹ  ϱ..
	
*/

#include "cCANVAS.h"

#include <stdarg.h>
#include <stdio.h>

WORD	PixelFormat;					// ȼ  RGB 5:6:5, RGB 5:5:5 , BGR 5:6:5

ClassGRADATIONCOLOR gCOL;

/***************************************************************************
WORD	RGBmix(BYTE r,BYTE g,BYTE b)
	ȼ ˿   ȷƮ ͽ ش.

Է°	:
BYTE r,BYTE g,BYTE b :
	ϴ R,G,B  5:6:5 Էش.

return value :
	WORD	R,G,B ͽ ..

***************************************************************************/

WORD
RGBmix(BYTE r,BYTE g,BYTE b)
{
	if (PixelFormat==RGB565) return RGB16(r,g,b);
	if (PixelFormat==RGB555) {g>>=1;return RGB15(r,g,b);}
	return RGB16(b,g,r); // BGR 565
}

/***************************************************************************
ClassCANVAS::ClassCANVAS(HWND hwnd,POINT *ss)
	

Է°	:
HWND	hwnd :
	 ڵ..
int		xs,ys:
	ȭ .. Ʈ  640*480 ..
***************************************************************************/

ClassCANVAS::ClassCANVAS(HWND hwnd,int xs,int ys)
{
	lpDDSFront		=	NULL;
	lpDDSBack		=	NULL;
	lpDD			=	NULL;
	pBACKSURFACE	=	NULL;
	pFRONTSURFACE	=	NULL;
	WIDTH			=	xs;
	HEIGHT			=	ys;
	hWINDOW			=	hwnd;
	ErrorMSG[0]		=	NULL;
}

/***************************************************************************
ClassCANVAS::~ClassCANVAS()
	Ҹ
***************************************************************************/

ClassCANVAS::~ClassCANVAS()
{
	FreeObjects();
}

/***************************************************************************
void ClassCANVAS::FreeObjects()
	 ͸  Ѵ.

return value:
	..

***************************************************************************/

void 
ClassCANVAS::FreeObjects()
{
    if( lpDD != NULL )
    {
		RELEASE(lpDDSFront);
		#ifndef FULLSCREEN
			RELEASE(lpDDSBack);
		#endif
		RELEASE(lpDD);
    }
}


/***************************************************************************
BOOL ClassCANVAS::InitTimer()
	ý QueryPerformanceCounter ϴ ȮѴ..

return value:
	   ޽ Բ FALSE ȯѴ.

***************************************************************************/

BOOL
ClassCANVAS::InitTimer()
{
LARGE_INTEGER time;

	if(!QueryPerformanceCounter( &time ))
	{
		MessageBox( NULL, "ýۿ QueryPerformanceCounter   ʽϴ.", "ERROR", MB_OK);
		return FALSE;
	}
	QueryPerformanceFrequency(&time);
	TPS=(time.LowPart>>2);

	Tick = 250000L / 83;

	curTIME = 0;
	newTime = 0;
	oldTime = GetCurTime();

/*	Tick = 18000L;
	SetTimer(); */
	return TRUE;
}
/*
ULONG
ClassCANVAS::GetCurTime()
{
LARGE_INTEGER time ;
	
	QueryPerformanceCounter( &time );
	return (ULONG)((DWORD)time.LowPart);
	return 0;
};
*/
long 
ClassCANVAS::GetCurTime()
{
LARGE_INTEGER time ;
	
	QueryPerformanceCounter( &time );

	return (long)((DWORD)time.LowPart>>2);
};


BOOL 
ClassCANVAS::FrameSkip()
{
long dt ;
	
	newTime = GetCurTime();
	
	dt = newTime - oldTime;
	if( dt < 0 ) dt += 0x40000000;
	
	curTIME += dt;

    while(curTIME<0)
	{
		newTime = GetCurTime();
	
		dt = newTime - oldTime;
		if( dt < 0 ) dt += 0x40000000;

		curTIME += dt;

		oldTime = newTime ;
	};
  
	curTIME -= Tick;
   
	oldTime = newTime ;

	return (curTIME<0)? TRUE: FALSE;

};


/***************************************************************************
BOOL ClassCANVAS::Failed()
	 ޽..

return value:
	޽ Բ FALSE  ȯ Ѵ.

***************************************************************************/

BOOL 
ClassCANVAS::Failed()
{
	if (ErrorMSG[0]==NULL) strcpy((char *)ErrorMSG,"Direct Draw Initialize FAILED!!\0");

    FreeObjects();
    MessageBox( hWINDOW,(char *)ErrorMSG,"Direct Draw Library Canvas", MB_OK );
	return FALSE;
}

/***************************************************************************
BOOL ClassCANVAS::Init()
	ĵ  Ѵ...

return value:
	 TRUE н FALSE  ȯ Ѵ.

***************************************************************************/

BOOL 
ClassCANVAS::Init()
{
	InitTimer();
	#ifdef FULLSCREEN
		if (!CreateFullScreen()) return FALSE;  // Ǯũ
	#else
		if (!CreateWindowed()) return FALSE; // ..
	#endif
	Lock();
	WIDTH=lpDDSD.lPitch/2;
	UnLock();

/***************************************************************************
		7 ׶̼ ..  밡ٷ ̾ƿ.. ^^
***************************************************************************/

BYTE yellow[16][3] = {{10,21, 0},{15,31, 2},{17,35, 4},{20,48, 6},{22,45, 9},{25,50,11},{27,55,14},{29,59,16}};
BYTE cyan  [16][3] = {{ 0,27,13},{ 4,36,18},{ 6,40,20},{ 9,45,22},{11,50,25},{14,55,27},{16,60,30},{18,63,31}};
BYTE red   [16][3] = {{31, 8, 0},{31,15, 0},{31,23, 0},{31,31, 0},{31,39, 0},{31,47, 0},{31,55, 0},{31,63, 0}};
BYTE green [16][3] = {{ 0,35, 8},{ 1,41,12},{ 3,46,15},{ 5,51,17},{ 8,56,20},{10,60,22},{14,63,24},{20,63,27}};
BYTE gray  [16][3] = {{ 9,18, 9},{14,28,14},{16,32,16},{18,37,18},{21,42,21},{23,46,23},{25,51,25},{27,55,27}};
BYTE blue  [16][3] = {{ 6,13,31},{11,23,31},{14,28,31},{17,34,31},{19,39,31},{22,44,31},{25,50,30},{29,54,31}};
BYTE purple[16][3] = {{17,13,17},{22,17,22},{24,21,24},{26,26,26},{29,31,29},{31,35,31},{31,43,31},{31,50,31}};

	// ׶̼ Į !!! ׷ ī ȼ ˿  ..  غ!!! ^^
	int i;
	for (i=0;i<8;i++) 
	{
		gCOL.YELLOW	[i]=RGBmix(yellow[i][0],yellow[i][1],yellow[i][2]);
		gCOL.CYAN	[i]=RGBmix(cyan  [i][0],cyan  [i][1],cyan  [i][2]);
		gCOL.RED	[i]=RGBmix(red   [i][0],red   [i][1],red   [i][2]);
		gCOL.GREEN 	[i]=RGBmix(green [i][0],green [i][1],green [i][2]);
		gCOL.GRAY  	[i]=RGBmix(gray  [i][0],gray  [i][1],gray  [i][2]);
		gCOL.BLUE  	[i]=RGBmix(blue  [i][0],blue  [i][1],blue  [i][2]);
		gCOL.PURPLE	[i]=RGBmix(purple[i][0],purple[i][1],purple[i][2]);
	}

	for (i=7;i>=0;i--)
	{
		gCOL.YELLOW	[15-i]=RGBmix(yellow[i][0],yellow[i][1],yellow[i][2]);
		gCOL.CYAN	[15-i]=RGBmix(cyan  [i][0],cyan  [i][1],cyan  [i][2]);
		gCOL.RED	[15-i]=RGBmix(red   [i][0],red   [i][1],red   [i][2]);
		gCOL.GREEN 	[15-i]=RGBmix(green [i][0],green [i][1],green [i][2]);
		gCOL.GRAY  	[15-i]=RGBmix(gray  [i][0],gray  [i][1],gray  [i][2]);
		gCOL.BLUE  	[15-i]=RGBmix(blue  [i][0],blue  [i][1],blue  [i][2]);
		gCOL.PURPLE	[15-i]=RGBmix(purple[i][0],purple[i][1],purple[i][2]);
	}

return TRUE;
}

/***************************************************************************
BOOL ClassCANVAS::CreateFullScreen()
	Ǯũ ĵ..

return value:
	 TRUE..
	н ޽ Բ FALSE  ȯ Ѵ.

***************************************************************************/

BOOL 
ClassCANVAS::CreateFullScreen()
{
DDSCAPS			ddscaps;
HRESULT			ddrval;

    // ̷Ʈ ο Ʈ 

	LPDIRECTDRAW tmplpDD;

	if (DirectDrawCreate( NULL, &tmplpDD, NULL ) !=DD_OK)
	{
		strcpy((char *)ErrorMSG,"Direct Draw Create ERROR!!\0");
		return Failed();
	}

	if (tmplpDD->QueryInterface(IID_IDirectDraw2, (LPVOID*)&lpDD))
	{
		strcpy((char *)ErrorMSG,"QueryInterface ERROR!!\0");
		return Failed();
	}
	RELEASE(tmplpDD);

	//   
    ddrval = lpDD->SetCooperativeLevel( hWINDOW, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
    if( ddrval != DD_OK )
	{
		strcpy((char *)ErrorMSG,"Set Coorperarion Level Error!!\0");
		return Failed();
	}

    // 16bit Width * Height  ..
    ddrval = lpDD->SetDisplayMode( WIDTH,HEIGHT, 16,0,0);
    
	if( ddrval != DD_OK )
	{
		strcpy((char *)ErrorMSG,"Set Display Mode Error!!\0");
		return Failed();
	}
    // ø ϳ  ϳ .. 
	
	lpDDSD.dwSize = sizeof( lpDDSD );
    lpDDSD.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    lpDDSD.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |  DDSCAPS_FLIP |  DDSCAPS_COMPLEX;
    lpDDSD.dwBackBufferCount = 1;
    
    LPDIRECTDRAWSURFACE lpDDSTemp;
    if (lpDD->CreateSurface(&lpDDSD, &lpDDSTemp, NULL) != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Create Surface\0");
		return Failed();
	}
    if (lpDDSTemp->QueryInterface(IID_IDirectDrawSurface3,(void**)&lpDDSFront) != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in QueryInterface\0");
		return Failed();
	}
    lpDDSTemp->Release();

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;  // ..
    ddrval = lpDDSFront->GetAttachedSurface(&ddscaps, &lpDDSBack);
    if( ddrval != DD_OK )
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Get Back Surface\0");
		return Failed();
	}


	// ȼ  ǵ..
	ZeroMemory(&lpDDSD,sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof( lpDDSD );
    lpDDSD.dwFlags = DDSD_PIXELFORMAT;
    ddrval = lpDDSBack->GetSurfaceDesc(&lpDDSD);
    if(ddrval==DD_OK)
	{
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0xF800) {PixelFormat=RGB565;FilterMask=0xf7de;}
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x7C00) {PixelFormat=RGB555;FilterMask=0x7bde;}
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x001F) {PixelFormat=BGR565;FilterMask=0xf7de;}
	}

	ColorKey(colWHITE);
	SetRect(&Client,0,0,WIDTH,HEIGHT);
	return TRUE;
}

/***************************************************************************
BOOL ClassCANVAS::CreateWindowed()
	  ĵ..

return value:
	 TRUE..
	н ޽ Բ FALSE  ȯ Ѵ.

***************************************************************************/

BOOL 
ClassCANVAS::CreateWindowed()
{
HRESULT rval;
DWORD	dwFlags;
HDC		hDC;
int		m_BPP;

	hDC = GetDC(NULL);
	m_BPP = GetDeviceCaps(hDC, PLANES) * GetDeviceCaps(hDC, BITSPIXEL);
	ReleaseDC(NULL, hDC);

	dwFlags = DDSCL_NORMAL;

	LPDIRECTDRAW tmplpDD;

	rval = DirectDrawCreate(NULL, &tmplpDD, NULL);
	if(rval != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Create Surface\0");
		return Failed();
	}

	rval = tmplpDD->QueryInterface(IID_IDirectDraw2, (LPVOID*)&lpDD);
	if(rval != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in QueryInterface\0");
		return Failed();
	}

	RELEASE(tmplpDD);

	rval = lpDD->SetCooperativeLevel(hWINDOW, dwFlags);
	if(rval != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Set CooperativeLevel\0");
		return Failed();
	}

	//  ǽ ..
	lpDDSD.dwSize = sizeof(lpDDSD);
	lpDDSD.dwFlags = DDSD_CAPS;
	lpDDSD.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

    LPDIRECTDRAWSURFACE lpDDSTemp;
    if (lpDD->CreateSurface(&lpDDSD, &lpDDSTemp, NULL) != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Create Surface\0");
		return Failed();
	}
    if (lpDDSTemp->QueryInterface(IID_IDirectDrawSurface3,(void**)&lpDDSFront) != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in QueryInterface\0");
		return Failed();
	}
    lpDDSTemp->Release();

	//  ǽ 
	lpDDSD.dwSize = sizeof( lpDDSD );
	lpDDSD.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	lpDDSD.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	lpDDSD.dwWidth = WIDTH;
	lpDDSD.dwHeight = HEIGHT;

    if (lpDD->CreateSurface(&lpDDSD, &lpDDSTemp, NULL) != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Create Back Surface\0");
		return Failed();
	}

    if (lpDDSTemp->QueryInterface(IID_IDirectDrawSurface3,(void**)&lpDDSBack) != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in QueryInterface\0");
		return Failed();
	}

    lpDDSTemp->Release();

	// Create the window clipper
	rval = lpDD->CreateClipper(0, &lpClipper, NULL);
	if(rval != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Create Clipper\0");
		return Failed();
	}

	rval = lpClipper->SetHWnd(0, hWINDOW);
	if(rval != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Set Clipper(Window) \0");
		return Failed();
	}

	rval = lpDDSFront->SetClipper(lpClipper);
	if(rval != DD_OK)
	{
		strcpy((char *)ErrorMSG,"ERROR!! in Set Clipper(Front)\0");
		return Failed();
	}

	
	// ȼ  ǵ..
	ZeroMemory(&lpDDSD,sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof( lpDDSD );
    lpDDSD.dwFlags = DDSD_PIXELFORMAT;
    rval = lpDDSBack->GetSurfaceDesc(&lpDDSD);
    if(rval==DD_OK)
	{
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0xF800) {PixelFormat=RGB565;FilterMask=0xf7de;}
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x7C00) {PixelFormat=RGB555;FilterMask=0x7bde;}
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x001F) {PixelFormat=BGR565;FilterMask=0xf7de;}
	}

	ColorKey(colWHITE);
	return TRUE;
}

/***************************************************************************
int ClassCANVAS::GetPixelFormat()
 ׷ ī 16Ʈ ȼ  о ´.

return value:
	RGB565,RGB555,BGR565

***************************************************************************/

int
ClassCANVAS::GetPixelFormat()
{
	ZeroMemory(&lpDDSD,sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof( lpDDSD );
    lpDDSD.dwFlags = DDSD_PIXELFORMAT;
	HRESULT rval = lpDDSBack->GetSurfaceDesc(&lpDDSD);
    if(rval==DD_OK)
	{
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0xF800) return RGB565;
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x7C00) return RGB555;
		if (lpDDSD.ddpfPixelFormat.dwRBitMask == 0x001F) return BGR565;
	}

	return 0;
}

/***************************************************************************
HRESULT ClassCANVAS::Lock(void)
 Lock .

return value:
	Direct Draw ..

***************************************************************************/

HRESULT 
ClassCANVAS::Lock()
{
HRESULT hResult;

	//	ZeroMemory(&lpDDSD, sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof(lpDDSD);
	hResult=lpDDSBack->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
	pBACKSURFACE = (WORD *) lpDDSD.lpSurface;
	return hResult;
}

/***************************************************************************
HRESULT ClassCANVAS::FrontLock(void)
 Lock .

return value:
	Direct Draw ..

***************************************************************************/

HRESULT 
ClassCANVAS::FrontLock()
{
HRESULT hResult;

	//	ZeroMemory(&lpDDSD, sizeof(lpDDSD));
	lpDDSD.dwSize = sizeof(lpDDSD);
	hResult=lpDDSFront->Lock(NULL, &lpDDSD, DDLOCK_WAIT, NULL);
	pFRONTSURFACE = (WORD *) lpDDSD.lpSurface;
	return hResult;
}

/***************************************************************************
HRESULT ClassCANVAS::UnLock(void)
 Lock .

return value:
	Direct Draw ..

***************************************************************************/

HRESULT 
ClassCANVAS::UnLock(void)
{
	return lpDDSBack->Unlock(&lpDDSD);
}

/***************************************************************************
HRESULT ClassCANVAS::Frontk(void)
 Lock .

return value:
	Direct Draw ..

***************************************************************************/

HRESULT 
ClassCANVAS::FrontUnLock(void)
{
	return lpDDSFront->Unlock(&lpDDSD);
}

/***************************************************************************
void ClassCANVAS::Restore(void)
     Ѵ.

return value:
	

***************************************************************************/

void 
ClassCANVAS::Restore(void)
{
	if(lpDDSFront != NULL && lpDDSFront->IsLost() != DD_OK)
		lpDDSFront->Restore();
}

/***************************************************************************
HRESULT ClassCANVAS::ColorKey(int col)
鿡 ÷Ű Ѵ.

Է°		:
int	col		:
	÷Ű..

return value:
	Direct Draw ..

***************************************************************************/

HRESULT 
ClassCANVAS::ColorKey(int col)
{
DDCOLORKEY ddck;

	ddck.dwColorSpaceLowValue = col;
	ddck.dwColorSpaceHighValue = col;

	return lpDDSBack->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

/***************************************************************************
HRESULT ClassCANVAS::(void)
 ũ ø ش.

return value:
	Direct Draw ..

***************************************************************************/

HRESULT 
ClassCANVAS::Flip(void)
{
HRESULT rval;

	#ifdef FULLSCREEN

//		rval=lpDDSFront->BltFast(0,0,lpDDSBack,&Client, DDBLTFAST_WAIT);
		rval = lpDDSFront->Flip(NULL,DDFLIP_WAIT);
		if(rval == DDERR_SURFACELOST) Restore();
	#else
		RECT Window;
		POINT pt;

		GetClientRect(hWINDOW, &Window);
		pt.x = pt.y = 0;
		ClientToScreen(hWINDOW, &pt);
		OffsetRect(&Window, pt.x, pt.y);

		rval = lpDDSFront->Blt(&Window, lpDDSBack, NULL, DDBLT_WAIT, NULL);
		if(rval == DDERR_SURFACELOST) Restore();
	#endif

	return rval;
}

/***************************************************************************
void ClassCANVAS::Fill(WORD FillColor)
ǽ ü ÷ ä.

WORD FillColor	:
	÷..

return value:
	.

***************************************************************************/

void 
ClassCANVAS::Fill(WORD FillColor)
{
DDBLTFX ddBltFx;

	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = FillColor;
	lpDDSBack->Blt(NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

void 
ClassCANVAS::FillF(WORD FillColor)
{
DDBLTFX ddBltFx;

	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = FillColor;
	lpDDSFront->Blt(NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

/***************************************************************************
void ClassCANVAS::Fill(WORD FillColor,int x,int y,int xs,int ys)
  ÷ ä.

WORD FillColor	:
	÷..

int x,int y,int xs,int ys :
	..

return value:
	..

***************************************************************************/

void 
ClassCANVAS::Fill(WORD FillColor,int x,int y,int xs,int ys)
{
DDBLTFX ddBltFx;
RECT tmp;

	SetRect(&tmp,x,y,x+xs,y+ys);
	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = FillColor;
	lpDDSBack->Blt(&tmp, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

/***************************************************************************
void ClassCANVAS::HorzLine(WORD color,int x1,int x2,int y,int thick)
鿡  ׾ ش.

int x1 ,  int x2	:
	  ۰  ǥ..

int y				:
	 y ǥ..

int thick			:
	 β..

return value:
	..

***************************************************************************/

void
ClassCANVAS::HorzLine(WORD color,int x1,int x2,int y,int thick)
{
DDBLTFX ddBltFx;
RECT tmp;

	SetRect(&tmp,x1,y,x2,y+thick);
	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = color;
	lpDDSBack->Blt(&tmp, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

/***************************************************************************
void ClassCANVAS::VertLine(WORD color,int y1,int y2,int x,int thick)
鿡  ׾ ش.

int x1 ,  int x2	:
	  ۰  ǥ..

int y				:
	 y ǥ..

int thick			:
	 β..

return value:
	..

***************************************************************************/

void
ClassCANVAS::VertLine(WORD color,int y1,int y2,int x,int thick)
{
DDBLTFX ddBltFx;
RECT tmp;

	SetRect(&tmp,x,y1,x+thick,y2);
	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = color;
	lpDDSBack->Blt(&tmp, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

/***************************************************************************
void ClassCANVAS::DrawBox(WORD color,int x,int y,int xs,int ys,int thick)
鿡 ڽ ׷ش.

int x ,int y,int xs,int ys	:
	ڽ ..

int thick			:
	ڽ β..

return value:
	..

***************************************************************************/

void
ClassCANVAS::DrawBox(WORD color,int x,int y,int xs,int ys,int thick)
{
	if (xs<0) {x+=xs;xs=-xs;}
	if (ys<0) {y+=ys;ys=-ys;}
	HorzLine(color,x,x+xs,y,thick);
	HorzLine(color,x,x+xs+1,y+ys-thick+1,thick);
	VertLine(color,y,y+ys,x,thick);
	VertLine(color,y,y+ys+1,x+xs-thick+1,thick);
}

/***************************************************************************
****************************************************************************
****************************************************************************

	!! : Ʒ Ŭ  ݵ Lock ɾ Ŀ Ѵ.

****************************************************************************
****************************************************************************
***************************************************************************/

/***************************************************************************
WORD ClassCANVAS::GetPixel(int x,int y)
鿡  ϳ о ´.

int x ,  int y	:
	ǥ..

return value:
	WORD ÷

***************************************************************************/

WORD 
ClassCANVAS::GetPixel(int x,int y)
{
	return (WORD)pBACKSURFACE[x+y*WIDTH];
}

WORD 
ClassCANVAS::GetPixelF(int x,int y)
{
	return (WORD)pFRONTSURFACE[x+y*WIDTH];
}

/***************************************************************************
void ClassCANVAS::SetPixel(int x,int y,WORD color)
鿡  ϳ  ش.

int x ,  int y	:
	ǥ..

WORD color	:
	÷.

return value:
	.

***************************************************************************/

void 
ClassCANVAS::SetPixel(int x,int y,WORD color)
{
	pBACKSURFACE[x+y*WIDTH]=color;
}

void 
ClassCANVAS::SetPixelF(int x,int y,WORD color)
{
	pFRONTSURFACE[x+y*WIDTH]=color;
}

/***************************************************************************
WORD ClassCANVAS::MatchColor(int x,int y,WORD color)
Է ÷  (ǽ) ´ ÷ ã ش.

int x ,  int y	:
	ǥ..

WORD color	:
	÷.

return value:
	WORD ÷

***************************************************************************/

WORD 
ClassCANVAS::MatchColor(int x,int y,WORD color)
{
	pBACKSURFACE[x+y*WIDTH]=color;
	return pBACKSURFACE[x+y*WIDTH];
}


/***************************************************************************
void ClassCANVAS::FilterBlue(int x,int y,int xs,int ys,BYTE color)
 ǽ  8Ʈ ǵ Ķ ͸ .

int x ,  int y	:
	ǥ..

int xs, int ys	:
	..

BYTE color		:
	 Į..

return value:
	

***************************************************************************/

void 
ClassCANVAS::FilterBlue(int x,int y,int xs,int ys,BYTE color)
{
BYTE *Bitmap = (BYTE*)lpDDSD.lpSurface;
int addr,plus=WIDTH<<1;

	addr=y*WIDTH<<1+x<<1;

	xs<<=1;	

	for( int j = 0; j < ys; j++ )	
	{
		for( int i = 0; i < xs; i+=2 )	Bitmap[i + addr]|= color;
		addr+=plus;
	}
}

/***************************************************************************
void ClassCANVAS::FilterRed(int x,int y,int xs,int ys,BYTE color)
 ǽ  8Ʈ ǵ Ķ ͸ .

int x ,  int y	:
	ǥ..

int xs, int ys	:
	..

BYTE color		:
	 Į..

return value:
	

***************************************************************************/

void 
ClassCANVAS::FilterRed(int x,int y,int xs,int ys,BYTE color)
{
BYTE *Bitmap = (BYTE*)lpDDSD.lpSurface;
int addr,plus=WIDTH<<1;

	addr=y*WIDTH<<1+x<<1;

	xs<<=1;	

	color=(BYTE)(color<<3);

	for( int j = 0; j < ys; j++ )	
	{
		for( int i = 1; i < xs; i+=2 )	Bitmap[i + addr] |= color;
		addr+=plus;
	}
}

/***************************************************************************
void ClassCANVAS::Filter(int x,int y,int xs,int ys,WORD color)
 ǽ  8Ʈ ǵ Ķ ͸ .

int x ,  int y	:
	ǥ..

int xs, int ys	:
	..

BYTE color		:
	 Į..

return value:
	

***************************************************************************/

void 
ClassCANVAS::Filter(int x,int y,int xs,int ys,WORD Color)
{
int addr;

	addr=y*WIDTH+x;

	Color=(Color&FilterMask);

	for(int j = 0; j < ys; j++ )
	{
		for( int i = 0; i < xs; i++ ) pBACKSURFACE[i+addr] = ((pBACKSURFACE[i + addr]&FilterMask) + Color)>>1;
		addr+=WIDTH;
	}
}

void 
ClassCANVAS::QuarterFilter(int x,int y,WORD Color)
{
int Table[31]={4,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,60,56,52,48,44,40,36,32,28,24,20,16,12,8,4};
int table[31]={-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2};
int addr,j=0,i;


	Color=(Color&FilterMask);
	addr=y*WIDTH;
	x+=30;
	for(j=y; j < 31+y; j++ )
	{
		if (j>=HEIGHT) return;
		if (j<0) {addr+=(WIDTH+table[j-y]);continue;}
		for(i = x; i < Table[j-y]+x; i++ )
		{
			if (i>=WIDTH) break;
			if (i>=0) pBACKSURFACE[i+addr] = ((pBACKSURFACE[i + addr]&FilterMask) + Color)>>1;
		}
		addr+=WIDTH;
		x+=table[j-y];
	}
}


/***************************************************************************
void ClassCANVAS::PutImage(int x,int y,int xs,int ys,WORD *src)
̹ 鿡 ٸ    ش..

int x ,  int y	:
	ǥ..

int xs,  int ys	:
	̹ ..

WORD *src		:
	̹..

return value:
	..

***************************************************************************/

void 
ClassCANVAS::PutImage(int x,int y,int xs,int ys,WORD *src)
{
int addr,size=xs<<1;

	addr=y*WIDTH+x;

	for( int i = 0; i < ys; i++ )	
	{
		memcpy(pBACKSURFACE+addr,src,size);
		addr+=WIDTH;src+=xs;
	}
}

/***************************************************************************
void ClassCANVAS::PutImageF(int x,int y,int xs,int ys,WORD *src)
̹ 鿡 óؼ  ش..  ȿ..

int x ,  int y	:
	ǥ..

int xs,  int ys	:
	̹ ..

WORD *src		:
	̹..

return value:
	..

***************************************************************************/

void 
ClassCANVAS::PutImageF(int x,int y,int xs,int ys,WORD *src)
{
int addr,size=xs<<1,pos=0;

	addr=y*WIDTH+x;

	for( int i = 0; i < ys; i++ )
	{
		for( int j = 0; j < xs; j++ ) 
			pBACKSURFACE[addr+j]=((pBACKSURFACE[j+addr]&FilterMask)+(src[pos+j]&FilterMask))>>1;
		addr+=WIDTH;pos+=xs;
	}
}

/***************************************************************************
void ClassCANVAS::PutImage(int x,int y,int xs,int ys,WORD *src,WORD trans)
̹ 鿡  ش.. trans ÷ ϰ..

int x ,  int y	:
	ǥ..

int xs,  int ys	:
	̹ ..

WORD trans		:
	 ÷..

WORD *src		:
	̹..

return value:
	..

***************************************************************************/

void 
ClassCANVAS::PutImage(int x,int y,int xs,int ys,WORD *src,WORD trans)
{
int addr,size=xs<<1,pos=0;

	addr=y*WIDTH+x;

	for( int i = 0; i < ys; i++ )	
	{
		for( int j = 0; j < xs; j++ )	
		{
			if (src[pos+j]==trans) continue;
			pBACKSURFACE[addr+j]=src[pos+j];
		}
		addr+=WIDTH;pos+=xs;
	}
}

/***************************************************************************
void 
ClassCANVAS::GetImage(int x,int y,int xs,int ys,WORD *dest)
鿡 ٸ   о ش..

int x ,  int y	:
	ǥ..

int xs,  int ys	:
	̹ ..

WORD *dest :
	̹ ޾ư ..

return value:
	..

***************************************************************************/


void 
ClassCANVAS::GetImage(int x,int y,int xs,int ys,WORD *dest)
{
int addr,size=xs<<1;

	addr=y*WIDTH+x;

	for( int i = 0; i < ys; i++ )	
	{
		memcpy(dest,pBACKSURFACE+addr,size);
		addr+=WIDTH;dest+=xs;
	}
}



/***************************************************************************
	 Ʈ ƾ

int		GetPSpriteSize(WORD *data,int xs, int ys,WORD ColorKey)
WORD*	EncodePSprite(WORD *data, int xs, int ys,WORD ColorKey)
WORD*	TransPSpriteDATA(WORD *Spr,int size,WORD srcmode)
void	PutSprite(int x,int y,WORD *Spr)
void	PutSpriteTrans(int x,int y,WORD *Spr)

***************************************************************************/

/***************************************************************************
int ClassCANVAS::GetPSpriteSize(WORD *data,int xs, int ys,WORD ColorKey)
Ϲ ̹  ̹   ´.

int xs, int ys	:
	̹ x,y..

WORD ColorKey	:
	 ÷Ű..

return value:
	Ʈ ..

***************************************************************************/

int 
ClassCANVAS::GetPSpriteSize(WORD *data,int xs, int ys,WORD ColorKey)
{
int size=2, i, j, m,addr=0,dp=0;

	for(i=0; i<ys; i++)
	{
		for (j=0;j<xs;)
		{
			m=0;
			while (data[dp] == ColorKey && j< xs) {j++;dp++;}
			while (data[dp] != ColorKey && j< xs) {m++;j++;dp++;}
			addr += 2 + m;      // Į(1 word) +  Į ƴ Ÿ  (1 word)
			                    // Į ƴ Ÿ (m word)
		}
	}
	size+=addr;

return size;
}

/***************************************************************************
WORD* ClassCANVAS::EncodePSprite(WORD *data, int xs, int ys,WORD ColorKey)
̹ ޾Ƽ ེƮ ش..

int xs,  int ys :
	̹ x,y..

WORD ColorKey	:
	 ÷Ű..

return value:
	 Ʈ..

***************************************************************************/

WORD* 
ClassCANVAS::EncodePSprite(WORD *data, int xs, int ys,WORD ColorKey)
{
int     i, j, n, m,addr=2,dp=0;
WORD	*spr;

	spr=new WORD [GetPSpriteSize(data,xs,ys,ColorKey)];
	spr[0]= xs;
	spr[1]= ys;

	for(i=0; i<ys; i++)
	{
		for (j=0;j<xs;)
		{
			n=0;m=0;
			while (data[dp] == ColorKey && j < xs ) {n++,j++;dp++;}
			while (data[dp] != ColorKey && j < xs ) {m++;j++;dp++;}
			spr[addr  ] = n  ;  // Į ..
			spr[addr+1] = m  ;  // Į ƴ  .. (byte..

			if (m != 0)	memcpy(spr+addr+2,data+(dp-m), m<<1);

			addr += 2 + m;      // Į(2 word) +  Į ƴ Ÿ  (2word)
			                    // Į ƴ Ÿ (m word)
		}
	}

return spr;
}

/***************************************************************************
WORD* ClassSAS::TransPSpriteDATA(WORD *Spr,int size,WORD srcmode)
̹ ޾Ƽ ེƮ ش..

WORD	*Spr	:
	ҽ  Ʈ..

int		size	:
	 Ʈ ũ..

WORD	srcmode	:
	ҽ  Ʈ Ÿ ȼ ..

return value:
	ȯ  Ʈ..

***************************************************************************/

WORD* 
ClassCANVAS::TransPSpriteDATA(WORD *Spr,int size,WORD srcmode)
{
WORD *result,pixel;
int   skipbyte, putbyte;
BYTE r,g,b;

	result=new WORD [size];

	for (int i=0;i<size;i++)
	{
		skipbyte= *(Spr+i	);
		putbyte	= *(Spr+i+1	);
		*(result+i	)=skipbyte;
		*(result+i+1)=putbyte;
		i+=2;
		for (int j=0;i<putbyte;j++,i++)
		{
			pixel=*(Spr+i);
			if (srcmode==RGB565)
			{
				r=(pixel>>11)&31;
				g=(pixel>>5)&63;
				b=pixel&31;
			}
			if (srcmode==RGB555)
			{
				r=(pixel>>10)&31;
				g=(pixel>>5)&31;
				b=pixel&31;
				g<<=1;
			}
			if (srcmode==BGR565)
			{
				b=(pixel>>11)&31;
				g=(pixel>>5)&63;
				r=pixel&31;
			}

			*(result+i)=RGBmix(r,g,b);
		}
	}

return result;
}

/***************************************************************************
void ClassCANVAS::PutSprite(int x,int y,WORD *Spr)
 Ʈ 鿡  ش.

int x ,  int y	:
	ǥ..

WORD *Spr	:
	Ʈ ̹..

return value:
	

***************************************************************************/

void 
ClassCANVAS::PutSprite(int x,int y,WORD *Spr)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(HEIGHT,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	int addr=y*WIDTH;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp,WIDTH);
				if (xb > xa)
					memcpy(pBACKSURFACE+addr+xa,Spr+(xa-(xp-putbyte)),(xb-xa)<<1);
				Spr+=putbyte;
			}
		}
		addr+=WIDTH;
	}
}

void
ClassCANVAS::PutSpriteSkip(int x,int y,WORD *Spr)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(HEIGHT,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	int addr=y*WIDTH;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp,WIDTH);
				if (xb > xa)
					if (y%2==0)	memcpy(pBACKSURFACE+addr+xa,Spr+(xa-(xp-putbyte)),(xb-xa)<<1);
				Spr+=putbyte;
			}
		}
		addr+=WIDTH;
	}
}

/***************************************************************************
void ClassCANVAS::PutSpriteTrans(int x,int y,WORD *Spr)
 Ʈ 鿡 ͷ  ش.(̹   Ѵ.)

int x ,  int y	:
	ǥ..

WORD *Spr	:
	Ʈ ̹..

return value:
	

***************************************************************************/

void 
ClassCANVAS::PutSpriteTrans(int x,int y,WORD *Spr)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(HEIGHT,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	int addr=y*WIDTH;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp, WIDTH);
				if (xb > xa) 
					for (int i=0;i<xb-xa;i++)
						*(pBACKSURFACE+addr+xa+i)=
							((*(pBACKSURFACE+addr+xa+i)&FilterMask)+(*(Spr+i+(xa-(xp-putbyte)))&FilterMask))>>1;
				Spr+=putbyte;
			}
		}
		addr+=WIDTH;
	}
}

void 
ClassCANVAS::PutSprite(int x,int y,WORD *Spr,int XS,int YS)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(YS,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	int addr=y*XS;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp,XS);
				if (xb > xa)
					memcpy(pBACKSURFACE+addr+xa,Spr+(xa-(xp-putbyte)),(xb-xa)<<1);
				Spr+=putbyte;
			}
		}
		addr+=XS;
	}
}

/***************************************************************************
void ClassCANVAS::PutSpriteTrans(int x,int y,WORD *Spr,int XS,int YS)
 Ʈ 鿡 ͷ  ش.(̹   Ѵ.)

int x ,  int y	:
	ǥ..

WORD *Spr	:
	Ʈ ̹..

return value:
	

***************************************************************************/

void 
ClassCANVAS::PutSpriteTrans(int x,int y,WORD *Spr,int XS,int YS)
{
int   x1, y1, x2, y2;
int   xs,ys;

	xs=*(Spr);
	ys=*(Spr+1);
	
	x1 = Max(x, 0);
	y1 = Max(y, 0);

	x2 =xs+x;
	y2 = Min(YS,ys+y);

	if (x2 <= x1 || y2 <= y1) return;

	Spr+=2;

	int addr=y*XS;

	for(; y<y2; y++)
	{
		for(int xp=x; xp<x2; )
		{
			int   skipbyte, putbyte;

			skipbyte= *(Spr  );
			putbyte	= *(Spr+1);
			xp      += skipbyte+putbyte;
			Spr		+=2;
			
			if (y<0) {Spr+=putbyte;continue;}

			if (putbyte != 0)
			{
				int   xa, xb;
				xa = Max(0, xp-putbyte);
				xb = Min(xp, XS);
				if (xb > xa) 
					for (int i=0;i<xb-xa;i++)
						*(pBACKSURFACE+addr+xa+i)=
							((*(pBACKSURFACE+addr+xa+i)&FilterMask)+(*(Spr+i+(xa-(xp-putbyte)))&FilterMask))>>1;
				Spr+=putbyte;
			}
		}
		addr+=XS;
	}
}


// LoadBitMap  CopyBitMap ddutil.cpp  Ȱ Խ~~
IDirectDrawSurface3* 
ClassCANVAS::LoadBitMap(IDirectDraw2 *pdd, LPCSTR szBitmap, int dx, int dy)
{
HBITMAP             hbm;
BITMAP              bm;
DDSURFACEDESC       ddsd;
IDirectDrawSurface3 *pdds;

    //
    //  try to load the bitmap as a resource, if that fails, try it as a file
    //
    hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, dx, dy, LR_CREATEDIBSECTION);

    if (hbm == NULL)
	hbm = (HBITMAP)LoadImage(NULL, szBitmap, IMAGE_BITMAP, dx, dy, LR_LOADFROMFILE|LR_CREATEDIBSECTION);

    if (hbm == NULL)
	return NULL;

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap

    //
    // create a DirectDrawSurface for this bitmap
    //
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = bm.bmWidth;
    ddsd.dwHeight = bm.bmHeight;

    LPDIRECTDRAWSURFACE lpDDSTemp;
    if (pdd->CreateSurface(&ddsd, &lpDDSTemp, NULL) != DD_OK)
    {
        OutputDebugString("CreateSurface failed");
        return NULL;
    }

    if (lpDDSTemp->QueryInterface(IID_IDirectDrawSurface3,(void**)&pdds) != DD_OK)
    {
        OutputDebugString("QueryInterface failed");
        return NULL;
    }

    lpDDSTemp->Release();
    CopyBitMap(pdds, hbm, 0, 0, 0, 0);
    DeleteObject(hbm);

    return pdds;
}

HRESULT 
ClassCANVAS::CopyBitMap(IDirectDrawSurface3 *pdds, HBITMAP hbm, int x, int y, int dx, int dy)
{
HDC                 hdcImage;
HDC                 hdc;
BITMAP              bm;
DDSURFACEDESC       ddsd;
HRESULT             hr;

    if (hbm == NULL || pdds == NULL)
	return E_FAIL;

    //
    // make sure this surface is restored.
    //
    pdds->Restore();

    //
    //  select bitmap into a memoryDC so we can use it.
    //
    hdcImage = CreateCompatibleDC(NULL);
    if (!hdcImage) OutputDebugString("createcompatible dc failed\n");
    SelectObject(hdcImage, hbm);

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);    // get size of bitmap
    dx = dx == 0 ? bm.bmWidth  : dx;    // use the passed size, unless zero
    dy = dy == 0 ? bm.bmHeight : dy;

    //
    // get size of surface.
    //
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
    pdds->GetSurfaceDesc(&ddsd);

    if ((hr = pdds->GetDC(&hdc)) == DD_OK)
    {
        StretchBlt(hdc, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, x, y, dx, dy, SRCCOPY);
        pdds->ReleaseDC(hdc);
    }

    DeleteDC(hdcImage);

    return hr;
}




/***************************************************************************
****************************************************************************
****************************************************************************
	
	Ʈ Ŭ..
	ⲯؾ ̹   ° .. --

****************************************************************************
****************************************************************************
***************************************************************************/

ClassDIB::ClassDIB()
{
    ptr=NULL;
}

ClassDIB::ClassDIB(const char* fileName)
{
    ptr=NULL;
	Load(fileName);
}

ClassDIB::~ClassDIB()
{
    if (ptr!=NULL) delete ptr;
}

//  ũ Ʈ о ̰  Ÿ ʱȭ Ѵ.
BOOL 
ClassDIB::Load(const char* fileName)
{
FILE *fp;
DWORD fileLength,dibSize;

	fp=fopen(fileName,"rb");
	if (fp==NULL) return FALSE;
	fread((void*)&bmFileHeader,sizeof(bmFileHeader),1,fp);

    if (bmFileHeader.bfType != 0x4d42)  // Ʈ ȮѴ.(BMPȭ..
    {
        Info = 0;
        InfoHd = 0;
        RGBTable = 0;
		Colors = 0;
		ptr=NULL;
        data = NULL;
    }
    else
    {
		// Ʈ Ÿ ũ⸦ ˾ . ȭ  -  ..

		fseek(fp,0L,SEEK_END);
		fileLength=ftell(fp);
		fseek(fp,sizeof(bmFileHeader),SEEK_SET);
        dibSize = fileLength - sizeof(bmFileHeader);

        ptr =new BYTE[dibSize];  // Ʈ ̹ о δ..
        fread((void*)ptr, dibSize,1,fp);
        fclose(fp);

        Info = (LPBITMAPINFO) ptr;
        InfoHd = (LPBITMAPINFOHEADER) ptr;

        // RGB Į ̺  ڿ(biSize)..
        RGBTable = (RGBQUAD*)(ptr + InfoHd->biSize); 

        // Get the number of colors in the bitmap.
        Colors = GetColors();

        // Calculate the bitmap image's size.
        InfoHd->biSizeImage =   GetImageSize();
	
        // Make sure the biClrUsed field is initialized properly.
        if (InfoHd->biClrUsed == 0)  InfoHd->biClrUsed = Colors;

        // Calculate a pointer to the bitmap's actual data.
        DWORD clrTableSize = Colors * sizeof(RGBQUAD);
        data =ptr + InfoHd->biSize + clrTableSize;
	}

return TRUE;
}

int 
ClassDIB::GetImageSize()
{
	// ̹  0̸ ̹ *  ȯ Ѵ..
	if (InfoHd->biSizeImage == 0)
        return (int)(GetWidth()*GetHeight());
    else  return (int)InfoHd->biSizeImage;
}

int 
ClassDIB::GetWidth()
{
    return (int)InfoHd->biWidth;
}

int 
ClassDIB::GetHeight()
{
    return (int)InfoHd->biHeight;
}

//  Į  ´..
int  
ClassDIB::GetColors()
{
    if ((InfoHd->biClrUsed == 0) && (InfoHd->biBitCount < 9))
        return (int)(1 << InfoHd->biBitCount);
    else
        return (int) InfoHd->biClrUsed;
}