#include <stdio.h>

#include "cCANVAS.h"
#include "windowsx.h"

ClassDIB::ClassDIB()
{
    ptr=NULL;
}

ClassDIB::ClassDIB(const char* fileName)
{
    ptr=NULL;
	Load(fileName);
}

ClassDIB::~ClassDIB()
{
    if (ptr!=NULL) delete ptr;
}

//  ũ Ʈ о ̰  Ÿ ʱȭ Ѵ.
BOOL 
ClassDIB::Load(const char* fileName)
{
FILE *fp;
DWORD fileLength,dibSize;

	fp=fopen(fileName,"rb");
	if (fp==NULL) return FALSE;
	fread((void*)&bmFileHeader,sizeof(bmFileHeader),1,fp);

    if (bmFileHeader.bfType != 0x4d42)  // Ʈ ȮѴ.(BMPȭ..
    {
        Info = 0;
        InfoHd = 0;
        RGBTable = 0;
		Colors = 0;
		ptr=NULL;
        data = NULL;
    }
    else
    {
		// Ʈ Ÿ ũ⸦ ˾ . ȭ  -  ..

		fseek(fp,0L,SEEK_END);
		fileLength=ftell(fp);
		fseek(fp,sizeof(bmFileHeader),SEEK_SET);
        dibSize = fileLength - sizeof(bmFileHeader);

        ptr =new BYTE[dibSize];  // Ʈ ̹ о δ..
        fread((void*)ptr, dibSize,1,fp);
        fclose(fp);

        Info = (LPBITMAPINFO) ptr;
        InfoHd = (LPBITMAPINFOHEADER) ptr;

        // RGB Į ̺  ڿ(biSize)..
        RGBTable = (RGBQUAD*)(ptr + InfoHd->biSize); 

        // Get the number of colors in the bitmap.
        Colors = GetColors();

        // Calculate the bitmap image's size.
        InfoHd->biSizeImage =   GetImageSize();
	
        // Make sure the biClrUsed field is initialized properly.
        if (InfoHd->biClrUsed == 0)  InfoHd->biClrUsed = Colors;

        // Calculate a pointer to the bitmap's actual data.
        DWORD clrTableSize = Colors * sizeof(RGBQUAD);
        data =ptr + InfoHd->biSize + clrTableSize;
	}

return TRUE;
}

int 
ClassDIB::GetImageSize()
{
	// ̹  0̸ ̹ *  ȯ Ѵ..
	if (InfoHd->biSizeImage == 0)
        return (int)(GetWidth()*GetHeight());
    else  return (int)InfoHd->biSizeImage;
}

int 
ClassDIB::GetWidth()
{
    return (int)InfoHd->biWidth;
}

int 
ClassDIB::GetHeight()
{
    return (int)InfoHd->biHeight;
}

//  Į  ´..
int  
ClassDIB::GetColors()
{
    if ((InfoHd->biClrUsed == 0) && (InfoHd->biBitCount < 9))
        return (int)(1 << InfoHd->biBitCount);
    else
        return (int) InfoHd->biClrUsed;
}