#include <windows.h>

#include "Quarter.h"
#include "cMainWnd.h"
#include "cTileWnd.h"
#include "cItemWnd.h"
#include "cwQMove.h"
#include "cBodyWnd.h"


ClassMAINWINDOW *pMAINWND;
ClassTILEWINDOW *pTILEWND;
ClassITEMWINDOW *pITEMWND;
ClassQUICKMOVE  *pQUICKMOVEWND;
ClassBODYWINDOW *pBODYWND;
ClassSAVEFILE	pSAVEFILE;
ClassLOADFILE	pLOADFILE;

HWND			MasterWNDHANDLE;
HINSTANCE		MasterINSTHANDLE;
BOOL			bActiveApp;

void WholeDraw()
{
	if (pMAINWND) pMAINWND->Draw();
	if (pTILEWND) pTILEWND->Draw();
	if (pITEMWND) pITEMWND->Draw();
	if (pBODYWND) pBODYWND->Draw();
}

BOOL
InitApp( HINSTANCE hInstance)
{
	pMAINWND=new ClassMAINWINDOW(hInstance);
	if (!pMAINWND->Init())  {delete pMAINWND;return FALSE;}
	pTILEWND=new ClassTILEWINDOW(hInstance);
	if (!pTILEWND->Init(pMAINWND->pQTILE)) {delete pTILEWND;return FALSE;} 
	pITEMWND=new ClassITEMWINDOW(hInstance);
	if (!pITEMWND->Init()) {delete pITEMWND;return FALSE;}
	pQUICKMOVEWND=new ClassQUICKMOVE(hInstance);
	if (!pQUICKMOVEWND->Init(pMAINWND->pMAP)) {delete pQUICKMOVEWND;return FALSE;}
	pBODYWND=new ClassBODYWINDOW(hInstance);
	if (!pBODYWND->Init(pMAINWND->pMAP)) {delete pBODYWND;return FALSE;}

return TRUE;
}

int PASCAL 
WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,LPTSTR lpCmdLine, int nCmdShow)
{
MSG msg;

	if (!InitApp(hInstance)) return FALSE;

	while(1)   
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if (bActiveApp) 
		{
			pMAINWND->Thread();
			pITEMWND->Thread();
			pQUICKMOVEWND->Thread();
		}
		else WaitMessage();
	}

	return( msg.wParam ); 
}