#include <string.h>

#include "cBLOCK.H"

BOOL
ClassBLOCK::Init(ClassCANVAS *Canvas,char *fn)
{
	pCANVAS		=	Canvas;
	strcpy((char *)FName,fn);
	if (!Load(fn)) return FALSE;

return TRUE;
}

ClassBLOCK::ClassBLOCK()
{
	ObjCount	=	0;
	for (int i=0;i<dMAXOBJECT;i++)
	{
		aOBJ[i].x=-1;
		aOBJ[i].y=-1;
		aOBJ[i].num=0;
	}
	strcpy(FName,"untitle.blk");
}

ClassBLOCK::ClassBLOCK(ClassCANVAS *canvas)
{
	pCANVAS		=	canvas;
	ObjCount	=	0;
	Name[0]		=	NULL;
	for (int i=0;i<dMAXOBJECT;i++)
	{
		aOBJ[i].x=-1;	
		aOBJ[i].y=-1;
		aOBJ[i].num=0;
	}
}

ClassBLOCK::~ClassBLOCK()
{
}


BOOL 
ClassBLOCK::Load(char *fn)
{
FILE *fp;

	fp=fopen(fn,"rb");
	if (fp==NULL) return FALSE;
	fclose(fp);

	if (!ClassSAS::Init(pCANVAS,fn,TRUE)) return FALSE;

return TRUE;
}

int
ClassBLOCK::GetDX(int num)
{
	return	pANI[num].pFRM[0].XPos;
}

int
ClassBLOCK::GetDY(int num)
{
	return	pANI[num].pFRM[0].YPos;
}

BOOL 
ClassBLOCK::Load(FILE *fp)
{
int i;
char name[20];

	fread((char *)name,20,1,fp);

	if (!Load(name))
	{
		fread(&i,1,sizeof(int),fp);
		return FALSE;
	}

	strcpy((char *)FName,name);

	fread(&ObjCount,1,sizeof(int),fp);
	for(i=0;i<ObjCount;i++)
	{
		fread(&aOBJ[i].x	,1,sizeof(int),fp);
		fread(&aOBJ[i].y	,1,sizeof(int),fp);
		fread(&aOBJ[i].num	,1,sizeof(int),fp);
	}

return TRUE;
}

BOOL
ClassBLOCK::Write(FILE *fp)
{
int i;

	fwrite(FName,20,1,fp);
	fwrite(&ObjCount,1,sizeof(int),fp);
	if (ObjCount==0) return FALSE;
	for(i=0;i<ObjCount;i++)
	{
		fwrite(&aOBJ[i].x	,1,sizeof(int),fp);
		fwrite(&aOBJ[i].y	,1,sizeof(int),fp);
		fwrite(&aOBJ[i].num	,1,sizeof(int),fp);
	}

return TRUE;
}

void
ClassBLOCK::AddObj(int x,int y,int num)
{
	for (int i=0;i<ObjCount;i++)
		if (x==aOBJ[i].x && y==aOBJ[i].y)
			return;

	aOBJ[ObjCount].x =x;
	aOBJ[ObjCount].y =y;
	aOBJ[ObjCount].num=num;
	ObjCount++;
}
//+(pSPR[pANI[aOBJ[i].num].pFRM[0].Sprite][1]+pANI[aOBJ[i].num].pFRM[0].YPos)
void
ClassBLOCK::DelObj(int x,int y)
{
int j;

	x+=32;y+=31;
	for (int i=0;i<ObjCount;i++)
	{
		if (x==aOBJ[i].x && y==aOBJ[i].y)
		{
			ObjCount--;
			for (j=i;j<ObjCount;j++)
			{
				aOBJ[j].x  =aOBJ[j+1].x  ;
				aOBJ[j].y  =aOBJ[j+1].y  ;
				aOBJ[j].num=aOBJ[j+1].num;
			}
			aOBJ[j].x  =-1;
			aOBJ[j].y  =-1;
			aOBJ[j].num= 0;
		}
	}
}

void 
ClassBLOCK::Put(int x,int y,int num)
{
	if (num >=	TotalAni || num < 0 ) return;
	ClassSAS::Put(x,y,num,0);
}

void 
ClassBLOCK::PutF(int x,int y,int num)
{
	if (num >=	TotalAni || num < 0 ) return;
	ClassSAS::PutF(x,y,num,0);
}