#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "cBodyWnd.h"
#include "cTEXT.H"
#include "cMainWnd.h"
#include "cENEMYDATA.H"

ClassMAPDATA *pMAP;

BOOL
ClassBODYWINDOW::InitWindow()
{
WNDCLASSEX	wc;
RECT tmp;
int menuthick;


	lpszRegister		=	"BodyWindow";						// ۾  ̸̰.. Ŭ ̸  ̸..

	SetRect(&tmp,100,100,200,200);
	AdjustWindowRect(&tmp,WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_HSCROLL,TRUE);

	menuthick	=	(100-tmp.top )+1;

	SetRect(&Border,0,0,451 ,170);

	Border.left=(GetSystemMetrics(SM_CXSCREEN)-Border.right )/2;
	Border.top =(GetSystemMetrics(SM_CYSCREEN)-Border.bottom)-50;

	wc.style			=	CS_DBLCLKS|CS_NOCLOSE;								//
	wc.lpfnWndProc		=	(WNDPROC)BodyWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hINST;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hINST, IDI_APPLICATION);		// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hINST, lpszRegister,	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR		);

	if (!RegisterClassEx( &wc )) return FALSE;        //  ..

	hWND = CreateWindowEx(WS_EX_TOPMOST,
						(LPTSTR)lpszRegister,
						"ĳ ..",WS_CLIPSIBLINGS|WS_CAPTION|WS_HSCROLL|WS_SYSMENU|WS_MINIMIZEBOX,
                        Border.left,Border.top,Border.right,Border.bottom, 
						NULL,NULL,hINST, 0L);

	if (hWND==NULL)	return FALSE;

	ShowWindow(hWND,SW_HIDE);
	UpdateWindow(hWND);

return TRUE;

}

ClassBODYWINDOW::ClassBODYWINDOW(HINSTANCE hinst)
{
	hINST				=	hinst;
	pCANVAS				=	NULL;
	Count				=	0;
	SPW					=	0;
	Select				=	0;
	MaxWidth			=	0;
	Pos.x				=	0;
	strcpy(EnemyFN,"untitle.enm");

}

ClassBODYWINDOW::~ClassBODYWINDOW()
{
	delete pCANVAS;
}

BOOL
ClassBODYWINDOW::Init(ClassMAPDATA *pmap)
{
	if (!InitWindow()) return FALSE;

	GetClientRect(hWND,&Client);
	pCANVAS=new ClassCANVAS(hWND,Client.right,Client.bottom);
	if (!pCANVAS->Init()) {delete pCANVAS;return FALSE;}
	pCANVAS->Fill(colBLACK);
	pCANVAS->Flip();
	ShowWindow(hWND,SW_MINIMIZE);
	UpdateWindow(hWND);

	pMAP	=	pmap;

return TRUE;
}

void
ClassBODYWINDOW::Active()
{
	ShowWindow(hWND,SW_NORMAL);
	UpdateWindow(hWND);
}

void
ClassBODYWINDOW::Close()
{
	ShowWindow(hWND,SW_MINIMIZE);
	UpdateWindow(hWND);
}


BOOL
ClassBODYWINDOW::SaveDATA(FILE *fp)
{
	if (Count==0)
	{
		fwrite("untitle.tmp",20,1,fp);
		return FALSE;
	}
	fwrite(EnemyFN,20,1,fp);

	for (int i=0;i<100;i++)
		if (_ENEMY[i].Sprite)
		{
			fwrite(&_ENEMY[i].x,4,1,fp);
			fwrite(&_ENEMY[i].y,4,1,fp);
			fwrite(&_ENEMY[i].mx,4,1,fp);
			fwrite(&_ENEMY[i].my,4,1,fp);
		}

return TRUE;
}

BOOL
ClassBODYWINDOW::ReadDATA(FILE *fp)
{
ClassENEMY cENEMY;
char fn[20];

	fread(fn,20,1,fp);
	if (cENEMY.Init(fn))
	{
		strcpy(EnemyFN,fn);
		Count=0;
		for (int i=0;i<100;i++)
			if (_ENEMY[Count].Sprite!=NULL)
			{
				_ENEMY[Count].xs=_ENEMY[Count].Sprite[0];
				_ENEMY[Count].ys=_ENEMY[Count].Sprite[1];
				fread(&_ENEMY[Count].x,4,1,fp);
				fread(&_ENEMY[Count].y,4,1,fp);
				fread(&_ENEMY[Count].mx,4,1,fp);
				fread(&_ENEMY[Count].my,4,1,fp);
				InitBODYWND(Count++);
			}
	}
	else return FALSE;

return TRUE;
}

void
ClassBODYWINDOW::UpLoadBODY()
{
ClassENEMY	cENEMY;

	Count=0;

	if (pLOADFILE.Load("*.set",(char *)EnemyFN," Ÿ ҷ..",hWND,hINST,WholeDraw))
	{
		if (cENEMY.Init(EnemyFN))
		{
			for (int i=0;i<100;i++)
				if (_ENEMY[Count].Sprite!=NULL)
				{
					_ENEMY[Count].xs=_ENEMY[Count].Sprite[0];
					_ENEMY[Count].ys=_ENEMY[Count].Sprite[1];
					InitBODYWND(Count++);
				}
		}
	}
	Draw();
}

void
ClassBODYWINDOW::InitBODYWND(int num)
{
	MaxWidth=Max(_ENEMY[num].Sprite[0]+6,MaxWidth);
	SPW=(Client.right-4)/MaxWidth;
	BodyWnd.left  = (Client.right-SPW*MaxWidth)/2;
	BodyWnd.right = SPW*MaxWidth;
	BodyWnd.top	  = 4;
	BodyWnd.bottom= Client.bottom-4-BodyWnd.top;

	if (Count>SPW )
	{
		SCROLLINFO si;
		si.cbSize	=	sizeof(SCROLLINFO);
		si.fMask	=	SIF_POS | SIF_RANGE | SIF_PAGE ;
		si.nMin		=	0;
		si.nMax		=	Count-1;
		si.nPage	=	SPW;
		si.nPos		=	Pos.x;
		EnableScrollBar(hWND,SB_HORZ,ESB_ENABLE_BOTH);
		SetScrollInfo(hWND,SB_HORZ,&si,TRUE);
	}
	else EnableScrollBar(hWND,SB_HORZ,ESB_DISABLE_BOTH);
}

void
ClassBODYWINDOW::SetTitleCaption()
{
char Text[255];

	sprintf((char *)Text," %d° ĳ [̸ : %s ]\0",Select,_ENEMY[Select].Name);
	SetWindowText(hWND,Text);
}

BOOL
ClassBODYWINDOW::IsNormal()
{
WINDOWPLACEMENT wp;

	if (Count==0) return FALSE;

	wp.length=sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWND,&wp);
	if (wp.showCmd!=SW_SHOWNORMAL) return FALSE;
	return TRUE;
}

void
ClassBODYWINDOW::Draw()
{
int i,c=0;

	if (!IsNormal()) return;

	pCANVAS->Fill(0);

	for(i=Pos.x;i<Min(Count,SPW)+Pos.x;i++)
	{
		while(_ENEMY[i+c].Sprite==NULL) c++;

		if (i==Select)
		{
			pCANVAS->Fill(255,(i-Pos.x)*MaxWidth+BodyWnd.left,4,MaxWidth-3,Client.bottom-8);
			pCANVAS->DrawBox(colWHITE,(i-Pos.x)*MaxWidth+BodyWnd.left,4,MaxWidth-3,Client.bottom-8,2);
		}

		pCANVAS->DrawBox(colWHITE,(i-Pos.x)*MaxWidth+BodyWnd.left,4,MaxWidth-4,Client.bottom-8);
		pCANVAS->Lock();
		if (_ENEMY[i+c].x != -1 && _ENEMY[i+c].y != -1)
			 pCANVAS->PutSpriteTrans((i-Pos.x)*MaxWidth+BodyWnd.left+2,Client.bottom-14-_ENEMY[i+c].ys,_ENEMY[i+c].Sprite);
		else pCANVAS->PutSprite((i-Pos.x)*MaxWidth+BodyWnd.left+2,Client.bottom-14-_ENEMY[i+c].ys,_ENEMY[i+c].Sprite);
		pCANVAS->UnLock();
	}
	pCANVAS->Flip();
	SetTitleCaption();
}

void
ClassBODYWINDOW::PutSprite(int x,int y,int num)
{
	if (_ENEMY[num].Sprite == NULL) return;
	pMAINWND->pCANVAS->PutSprite(x+_ENEMY[num].px,y+_ENEMY[num].py,_ENEMY[num].Sprite);
}

void
ClassBODYWINDOW::DrawInMap()
{
int x,y;
 
	if (!IsNormal() || Count==0) return;

	x=pMAINWND->mCPos.x+_ENEMY[Select].x+32;
	y=pMAINWND->mCPos.y+_ENEMY[Select].y+16;
	PutSprite(x,y,Select);
}

void
ClassBODYWINDOW::GetPos()
{
	GetCursorPos(&MPos);
	ScreenToClient(hWND,&MPos);
}

void
ClassBODYWINDOW::SetPos(int x,int y,int mx,int my)
{
	_ENEMY[Select].x=x;
	_ENEMY[Select].y=y;
	_ENEMY[Select].mx=mx;
	_ENEMY[Select].my=my;
	Draw();
}

void 
ClassBODYWINDOW::HScroll(WORD wScroll )
{
	SCROLLINFO si;
	// Use GetScrollInfo() to get information
	// about the scroll bar.
	//.......................................
	si.cbSize= sizeof( SCROLLINFO );
	si.fMask =SIF_ALL;
	GetScrollInfo( hWND, SB_HORZ, &si );

	switch( wScroll )
	{
		case SB_LINERIGHT :
			if ( Pos.x <= (int)(si.nMax - si.nPage))	Pos.x += 1;
			break;

		case SB_LINELEFT :
			if ( Pos.x > 0 ) Pos.x -= 1;
			break;

		case SB_THUMBTRACK :
			GetScrollInfo( hWND, SB_HORZ, &si );
			Pos.x=si.nTrackPos;
			break;
	}

	if (si.nPos != Pos.x)
	{
		Draw();
		pCANVAS->Flip();
		si.fMask = SIF_POS;
		si.nPos  = Pos.x;
		SetScrollInfo( hWND, SB_HORZ, &si, TRUE );
	} 
}

BOOL
ClassBODYWINDOW::SelectCharacter()
{
int i,tmp,c=0;

	GetPos();
	tmp=Select;
	Select=-1;
	for(i=0;i<Min(Count,SPW);i++)
	{
		while(_ENEMY[i+c].Sprite==NULL) c++;
		if (MPos.x > i*MaxWidth + BodyWnd.left && MPos.x < (i+1)*MaxWidth + BodyWnd.left &&
			MPos.y > 0 && MPos.y < Client.bottom)
		Select=i+c+Pos.x;
	}
	if (Select==-1) 
	{
		Select=tmp;
		return FALSE;
	}
	Draw();
	return TRUE;
}

LRESULT CALLBACK BodyWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_HSCROLL :
			pBODYWND->HScroll(LOWORD(wParam ));
            break;

		case WM_MOVE :
			WholeDraw();
			break;

		case WM_LBUTTONDOWN :
			pBODYWND->SelectCharacter();
			break;

		case WM_CLOSE :
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );

		case WM_QUERYOPEN :
			WholeDraw();
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );

		default :	return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
	}
	return 0L;
}