#ifndef _ClassBODYWINDOW_H
#define _ClassBODYWINDOW_H

#include <windows.h>
#include "cMAPDATA.H"
#include "cADATA.H"
#include "cSAS.H"
#include "dSTRINGS.H"

#define dMAXBODY 100

class ClassBODYWINDOW
{
public:
	HINSTANCE			hINST;
	HWND				hWND;
	ClassCANVAS			*pCANVAS;
	ClassDEFINESTRING	KEYWORD;
	char				EnemyFN[20];

public:
	LPCTSTR				lpszRegister;
	RECT				Border,Client,BodyWnd;
	POINT				Pos,MPos;
	int					YPos,MaxWidth,Count,SPW,Select,EnemyCount;

public:
	ClassBODYWINDOW(HINSTANCE hInst);
	~ClassBODYWINDOW();

	BOOL InitWindow();
	BOOL Init(ClassMAPDATA *pmap);
	void Active();
	void Close();

	void PutSprite(int x,int y,int num);
	void DrawInMap();
	void Draw();
	void Thread();
	void UpLoadBODY();
	void InitBODY(int num);
	void InitBODYWND(int num);

	BOOL SelectCharacter();
	BOOL DeleteCharacter();

	BOOL IsNormal();
	void HScroll(WORD wScroll );
	void GetPos();
	void SetPos(int x,int y,int mx,int my);

	void SetTitleCaption();
	BOOL PopUpMenu(UINT uMsg,WPARAM wParam,LPARAM lParam);

	void SetParameter();
	void SetDialogBox(HWND hDlg);
	void InitParameter(HWND hDlg,int num);
	void SettingParameter(HWND hDlg,int num);

	BOOL SaveDATA(FILE *fp);
	BOOL ReadDATA(FILE *fp);
};

extern ClassBODYWINDOW *pBODYWND;
LRESULT CALLBACK BodyWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ParameterBox(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm);

#endif