#include "cDLList.h"

DoubleLinkedList::DoubleLinkedList()
{
	pDATA=new DoubleLinkedListData();
	Count=0;
}

DoubleLinkedList::~DoubleLinkedList()
{
DoubleLinkedListData *tmp,*tmp2;

	pDATA=Tail();

	while (pDATA->pPRE!=NULL)
	{
		tmp->pPRE=pDATA->pPRE;
		tmp2=pDATA;
		delete tmp2;
		pDATA=tmp->pPRE;
	}
	delete tmp;
}

DoubleLinkedListData* DoubleLinkedList::Next()
{
	return pDATA->pNEXT;
}

DoubleLinkedListData* DoubleLinkedList::Pre ()
{
	return pDATA->pPRE;
}

DoubleLinkedListData* DoubleLinkedList::Head()
{
	while(pDATA->pPRE!=NULL) pDATA=pDATA->pPRE;
	return pDATA;
}

DoubleLinkedListData* DoubleLinkedList::Tail()
{
	while(pDATA->pNEXT!=NULL) pDATA=pDATA->pNEXT;
	return pDATA;
}

DoubleLinkedListData* DoubleLinkedList::Find(int index)
{
	if (index >= Count) return NULL;

	pDATA=Head();

	while(pDATA->Index!=index) pDATA=pDATA->pNEXT;
	return pDATA;
}

BOOL DoubleLinkedList::Add(DoubleLinkedListData *src)
{
	src->Index=Count;
	src->pNEXT=NULL;
	src->pPRE =Tail();

	Count++;

return TRUE;
}

BOOL DoubleLinkedList::Insert(DoubleLinkedListData *src,int index)
{
	if (index >= Count) return FALSE;
	Count++;

	src->Index=index;
	src->pNEXT=Find(index);
	src->pPRE =src->pNEXT->pPRE;

	src->pNEXT->pPRE =src;
	
	pDATA=src->pNEXT;
	while(pDATA!=NULL)
	{
		pDATA->Index++;
		pDATA=pDATA->pNEXT;
	}
return TRUE;
}

BOOL DoubleLinkedList::Delete(int index)
{
DoubleLinkedListData *tmp;

	if (index >= Count) return FALSE;
	Count--;

	pDATA=Find(index);
	pDATA->pNEXT->pPRE=pDATA->pPRE ;
	pDATA->pPRE->pNEXT=pDATA->pNEXT;

	tmp=pDATA;
	pDATA=pDATA->pNEXT;

	while(pDATA!=NULL)
	{
		pDATA->Index--;
		pDATA=pDATA->pNEXT;
	}

return TRUE;
}

BOOL DoubleLinkedList::Swap  (int l1,int l2)
{
DoubleLinkedListData *data1,*data2,*tmp;

	data1=Find(l1);
	data2=Find(l2);
	if (data1==NULL || data2==NULL) return FALSE;

	tmp=data1;
	data1=data2;
	data2=tmp;

return TRUE;
}