#include <string.h>
#include <stdio.h>

#include "cFileBox.H"

void (*ReDraw)();

typedef void (*PFUNC) ();

BOOL
ClassLOADFILE::Load(char *ext,char *FN,char *message,HWND hWnd,HINSTANCE hInstance,PFUNC redraw)
{
	FileName=FN;
	strcpy(Ext,ext);

	hDlg=hWnd;
	strcpy((char *)Caption,message);
	ReDraw=redraw;
	ReDraw();
	if (DialogBox(hInstance,"FILEBOX",hWnd,(DLGPROC)LoadFile)!=TRUE) return FALSE;
	return TRUE;
}

BOOL IsExist(char *fn)
{
FILE *fp;

	fp=fopen(fn,"rb");
	if (fp==NULL) return FALSE;
	fclose(fp);

	return TRUE;
}

LRESULT CALLBACK LoadFile(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int len,i;
static char szTmp[255];

	switch(uMsg)
	{
		case WM_MOVE :
			ReDraw();
			break;

		case WM_INITDIALOG : // ̾˷αװ Ǵ ޽..
			GetCurrentDirectory(sizeof(szTmp),szTmp); // szTmp   丮..
			strcat(szTmp,"\\");
			strcat(szTmp,pLOADFILE.Ext);
			DlgDirList(hDlg,szTmp,ID_FILELIST,ID_LOCATION,DDL_DIRECTORY|DDL_DRIVES); 
			SetWindowText(hDlg,pLOADFILE.Caption);
			break;
		
		case WM_COMMAND :  // ư̶ ޴.. 
			switch(LOWORD(wParam)) 
			{
				case ID_FILELIST :  // ȭϸƮ ڽ ȿ..
					if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
					{
						if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_FILELIST) ) // װ 丮̰ų ̸̺..
						{
							strcat(szTmp,pLOADFILE.Ext);
							DlgDirList(hDlg,szTmp,ID_FILELIST,ID_LOCATION,DDL_DIRECTORY|DDL_DRIVES);
						}
						else // ȭ̶..
						{
							strcpy(pLOADFILE.FileName,szTmp); 
							EndDialog(hDlg,IDOK); // ̾˷α ڽ ݴ´..
							return TRUE;
						}
					}
					break;

				case ID_FILEBOXOK	:
					GetDlgItemText(hDlg,ID_FILEBOXINPUT,(LPTSTR)szTmp,sizeof(szTmp));
					len=strlen(szTmp); // ̸ ̸ ϰ..

					for (i=0;i<len;i++)
						if (szTmp[i]=='.') szTmp[i]=NULL; // .. Ȯڸ ־ Ȯϴ ƾ.. ^^
					
					strcat(szTmp,&pLOADFILE.Ext[1]);  


					if (IsExist(szTmp)!=FALSE)
					{
						EndDialog(hDlg,IDCANCEL);
						strcpy(pLOADFILE.FileName,szTmp); 
						return TRUE;
					}
					MessageBox(hDlg,szTmp,"File Not Found!!",MB_OK);
					break;

					
				case ID_FILEBOXCANCEL :
					EndDialog(hDlg,IDCANCEL);
					return FALSE;
			}
			break;

		default :	return (FALSE);
	}
	return (TRUE);
}


BOOL 
ClassSAVEFILE::Save(char *ext,char *FN,char *message,HWND hWnd,HINSTANCE hInstance,PFUNC redraw)
{
	FileName=FN;
	strcpy(Ext,ext);

	hDlg=hWnd;
	strcpy((char *)Caption,message);
	ReDraw=redraw;
	if (DialogBox(hInstance,"FILEBOX",hWnd,(DLGPROC)SaveFile)!=TRUE) return FALSE;
	return TRUE;
}

LRESULT CALLBACK SaveFile(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParm)
{
int len,i;
static char szTmp[255];

	switch(uMsg)
	{
		case WM_MOVE :
			ReDraw();
			break;

		case WM_INITDIALOG : // ̾˷αװ Ǵ ޽..
			GetCurrentDirectory(sizeof(szTmp),szTmp); // szTmp   丮..
			strcat(szTmp,"\\");
			strcat(szTmp,pSAVEFILE.Ext);
			DlgDirList(hDlg,szTmp,ID_FILELIST,ID_LOCATION,DDL_DIRECTORY|DDL_DRIVES); 
			SetDlgItemText(hDlg,ID_FILEBOXINPUT,pSAVEFILE.FileName); 
			SetWindowText(hDlg,pSAVEFILE.Caption);
			break;
		
		case WM_COMMAND :  // ư̶ ޴.. 
			switch(LOWORD(wParam)) 
			{
				case ID_FILELIST :  // ȭϸƮ ڽ ȿ..
					if (HIWORD(wParam)==LBN_DBLCLK)  // Ŭ ϸ..
					{
						if ( DlgDirSelectEx(hDlg,szTmp,sizeof(szTmp),ID_FILELIST) ) // װ 丮̰ų ̸̺..
						{
							strcat(szTmp,pSAVEFILE.Ext);
							DlgDirList(hDlg,szTmp,ID_FILELIST,ID_LOCATION,DDL_DIRECTORY|DDL_DRIVES);
						}
						else // ȭ̶..
						{
							switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
							{
								case IDYES		:
									strcpy(pSAVEFILE.FileName,szTmp);
									EndDialog(hDlg,IDOK);
									return TRUE;
					
								case IDNO		:
									break;

								case IDCANCEL	:
									EndDialog(hDlg,IDCANCEL);
									return FALSE;
							}
						}
					}
					break;

				case ID_FILEBOXOK	:
					GetDlgItemText(hDlg,ID_FILEBOXINPUT,(LPTSTR)szTmp,sizeof(szTmp));
					len=strlen(szTmp); // ̸ ̸ ϰ..

					for (i=0;i<len;i++)
						if (szTmp[i]=='.') szTmp[i]=NULL; // .. Ȯڸ ־ Ȯϴ ƾ.. ^^
					
					strcat(szTmp,&pSAVEFILE.Ext[1]);  

					if (IsExist(szTmp)!=FALSE)
					{
						switch(MessageBox(hDlg,szTmp,"ȭ   ڽϱ?",MB_YESNOCANCEL))
						{
							case IDYES		:
								strcpy(pSAVEFILE.FileName,szTmp);
								EndDialog(hDlg,IDOK);
								return TRUE;
					
							case IDNO		:
								return FALSE;

							case IDCANCEL	:
								EndDialog(hDlg,IDCANCEL);
								ReDraw();
								return FALSE;
						}
					}
					strcpy(pSAVEFILE.FileName,szTmp);
					EndDialog(hDlg,IDOK);
					return TRUE;

					
				case ID_FILEBOXCANCEL :
					EndDialog(hDlg,IDCANCEL);
					ReDraw();
					return FALSE;
			}
			break;

		default :	return (FALSE);
	}
	return (TRUE);
}