#include <stdio.h>
#include "cItemWnd.h"
#include "cMainWnd.h"
#include "QUARTER.h"

char Help[10][80] = 
	{
		"0  : Ӽ..",
		"1  : .   .",
		"2  :  ׸. Ÿ   ",
		"3  :  ׸. ٷ  Ÿ  ..",
	};

BOOL 
ClassITEMWINDOW::Load(char *fn)
{
FILE *fp;
int i;

	fp=fopen(fn,"rb");

	if (fp==NULL) return FALSE;
	fread(&Count,1,sizeof(int),fp); 
	ICON=new WORD *[Count];
	for(i=0;i<Count;i++)
	{
  		int size;
		fread(&size,1,sizeof(int),fp);
  		ICON[i]=new WORD [size];
		fread(ICON[i],size,sizeof(WORD),fp);
	}

	fclose(fp);
	
return TRUE;
}

ClassITEMWINDOW::ClassITEMWINDOW(HINSTANCE hinst)
{
	hINST				=	hinst;
	bActive				=	TRUE;
	pCANVAS				=	NULL;
	Select				=	0;
	Count				=	0;
}

ClassITEMWINDOW::~ClassITEMWINDOW()
{
}

BOOL
ClassITEMWINDOW::InitWindow(HINSTANCE hInst)
{
WNDCLASSEX	wc;

	hWND				=	NULL;

	lpszRegister		=	"ItemWindow";		// ۾  ̸̰.. Ŭ ̸  ̸..

	SetRect(&Border,0,0,400 ,70);
	Border.left=(GetSystemMetrics(SM_CXSCREEN)-Border.right )/2;
	Border.top =(GetSystemMetrics(SM_CYSCREEN)-Border.bottom)-50;

	wc.style			=	CS_DBLCLKS|CS_NOCLOSE;								//
	wc.lpfnWndProc		=	(WNDPROC)ItemWndProc;					//  ν ..
	wc.cbClsExtra		=	0;										//  Ŭ..      
	wc.cbWndExtra		=	0;										//  ..
	wc.hInstance		=	hInst;									// νϽ ڵ..
	wc.hIcon			=	LoadIcon( hInst, IDI_APPLICATION);		// ..
	wc.hCursor			=	LoadCursor(NULL, IDC_ARROW);			// Ŀ.. 
	wc.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);	// Ŭ̾Ʈ  ..
	wc.lpszMenuName		=	lpszRegister;							// ޴ ̸.. ҽ..
	wc.lpszClassName	=	lpszRegister;							// Ŭ ̸..
	wc.cbSize			=	sizeof( WNDCLASSEX );					//
	wc.hIconSm			=	LoadImage(	hInst, "QUARTER",	// ..
										IMAGE_ICON, 16, 16,
										LR_DEFAULTCOLOR		);

	if (!RegisterClassEx( &wc )) return FALSE;        //  ..

	hWND = CreateWindowEx(WS_EX_TOPMOST,
						(LPTSTR)lpszRegister,
						" ..",WS_CLIPSIBLINGS|WS_CAPTION|WS_HSCROLL|WS_SYSMENU|WS_MINIMIZEBOX,
                        Border.left,Border.top,Border.right,Border.bottom, 
						NULL,NULL,hInst, 0L);

	if (!hWND)	return FALSE;

	ShowWindow(hWND,SW_SHOW);
	UpdateWindow(hWND);

return TRUE;
}

BOOL
ClassITEMWINDOW::Init()
{
	if (!InitWindow(hINST)) return FALSE;

	GetClientRect(hWND,&Client);
	pCANVAS=new ClassCANVAS(hWND,Client.right,Client.bottom);
	if (!pCANVAS->Init()) {delete pCANVAS;return FALSE;}
	ShowWindow(hWND,SW_MINIMIZE);

	if (!Load("icon.fnt"))
	{
		MessageBox(hWND,"Ÿ ȭ ϴ.!!","ȭ  !!",MB_OK);
		return FALSE;
	}

	Draw();

return TRUE;
}

void
ClassITEMWINDOW::Draw()
{
int tpw=Client.right/22,i,count=0,x;

	if (Count==0) return;

	x=(Client.right-tpw*22)/2;
	Mode=GetActiveCtrl();

	switch(Mode)
	{
		case IDM_ATTRIB :
			count=16;
			pCANVAS->Fill(255);
			SetWindowText(hWND,Help[Select]);
			pCANVAS->Lock();
			for (i=0;i<Min(tpw,Count-16);i++)
				pCANVAS->PutSprite(x+2+i*22,4,ICON[count++]);
			pCANVAS->UnLock();
			pCANVAS->DrawBox(colWHITE,x+Select*22,2,22,22,2);
			pCANVAS->Flip();
			break;

		default :
			ShowWindow(hWND,SW_MINIMIZE);
			break;
	}
}

void
ClassITEMWINDOW::GetPos()
{
	GetCursorPos(&mPos);
	ScreenToClient(hWND,&mPos);
}

void
ClassITEMWINDOW::Activate()
{
	ShowWindow(hWND,SW_NORMAL);
	SetForegroundWindow(hWND);
}

void
ClassITEMWINDOW::SetActiveCtrl(int item)
{
HMENU hMENU=GetMenu(MasterWNDHANDLE);

	if (GetMenuState(hMENU,item,MF_BYCOMMAND)&MFS_CHECKED)
	{
		CheckMenuItem(hMENU,item,MF_UNCHECKED);
		ShowWindow(hWND,SW_MINIMIZE);
	}
	else
	{
		CheckMenuItem(hMENU,IDM_ATTRIB,MF_UNCHECKED);
		CheckMenuItem(hMENU,item,MF_CHECKED);
		Activate();
	}

	Select=0;
	Draw();
}

int
ClassITEMWINDOW::GetActiveCtrl()
{
HMENU hMENU=GetMenu(MasterWNDHANDLE);

	if (GetMenuState(hMENU,IDM_ATTRIB,MF_BYCOMMAND)&MFS_CHECKED) return IDM_ATTRIB;

return -1;
}

void
ClassITEMWINDOW::SelectAttribute()
{
int tpw=Client.right/22,i,count=0,x;
int mode=GetActiveCtrl();

	x=(Client.right-tpw*22)/2;

	if(GetActiveCtrl()==IDM_ATTRIB)  count=Count-16;
	else count=16;

	GetPos();
	for (i=0;i<Min(tpw,count);i++)
		if (mPos.x > i * 22 +x +2 && mPos.y > 2 &&	mPos.x < (i+1)*22+x+2 && mPos.y < 24 )
			Select=i;
	Draw();
}

void
ClassITEMWINDOW::Thread()
{
int mode=GetActiveCtrl();
static BOOL press=FALSE;

	if (GetKeyState('Z')&0x0100)
	{
		if (press) return;
		Select--;
		if (Select<0) if (mode==IDM_ATTRIB) Select=Count-17;else Select=15;
		Draw();
		press=TRUE;
		return;
	}

	if (GetKeyState('X')&0x0100)
	{
		if (press) return;
		Select++;
		if ( Select > Count-17) if (mode==IDM_ATTRIB) Select=0;
		if ( Select > 15)  Select=0;
		Draw();
		press=TRUE;
		return;
	}
	press=FALSE;
}


LRESULT CALLBACK ItemWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_ACTIVATE :
			if (pITEMWND) pITEMWND->Draw();
			break;

		case WM_LBUTTONDBLCLK :
			break;

		case WM_RBUTTONDBLCLK :
			break;

		case WM_LBUTTONDOWN :
			pITEMWND->SelectAttribute();
			break;

		case WM_MOVE :
			WholeDraw();
			break;

		default :	
			return( DefWindowProc( hWnd, uMsg, wParam, lParam ));
	}
	return 0L;
}