#ifndef _ClassMAPDATA_H
#define _ClassMAPDATA_H

#include <windows.h>
#include <string.h>
#include "cGOOD.H"

#define dTW		64
#define dTH		31
#define dHTW	32
#define dHTH	16

class ClassMAPDATA
{
public:

	UINT	**DATA;
	int		WWIDTH,WHEIGHT,WIDTH,HEIGHT,TPH,TPW;
	POINT	Pos,Axis,Limit;

	//   Ÿ ũ..  11111111000000000000000000000000 (  8Ʈ  0x000000ff )
	void	SetTile(int x,int y,int tile)
			{
				if (y>=HEIGHT || y< 0 || x<0 || x>=WIDTH) return;
				DATA[y][x]&=0xffffff00;
				DATA[y][x]|=tile;
			}

	int		GetTile(int x,int y)
			{
				if (y>=HEIGHT || y< 0 || x<0 || x>=WIDTH) return 0;
				return (DATA[y][x]&0x000000ff);
			}

	//   Ӽ 00000000111100000000000000000000 (  4Ʈ  0x00000f00 )
	void	SetAttr(int x,int y,int attr)
			{
				if (y>=HEIGHT || y< 0 || x<0 || x>=WIDTH) return;
				DATA[y][x]&=0xfffff0ff;
				DATA[y][x]|=((UINT)attr<<8);
			}

	int		GetAttr(int x,int y)
			{
				if (y>=HEIGHT || y< 0 || x<0 || x>=WIDTH) return 0;
				return ((DATA[y][x]&0x00000f00)>>8);
			}



	BOOL	GetPos(POINT *pos1,POINT *pos2)
			{
				int X,Y;
				Y=pos1->y-Axis.y+Pos.y*dTH+(pos1->x-Axis.x)/2-dHTH+1;
				X=pos1->x-Axis.x+Pos.x*dTW-(pos1->y-Axis.y-dHTH+1)*2;
				if (X < 0 || X >= WWIDTH || Y < 0 || Y >= WHEIGHT)
				{
					pos1->x=-1;
					pos1->y=-1;
					return FALSE;
				}

				pos1->y=Y/dTH;
				pos1->x=X/dTW;
				pos2->x=(pos1->y+pos1->x)*dHTW+Axis.x-(Pos.y+Pos.x)*dHTW ;
				pos2->y=(pos1->y-pos1->x)*dHTH+Axis.y-(Pos.y-Pos.x)*dHTH;
				return TRUE;
			}

			ClassMAPDATA() {WIDTH=0;HEIGHT=0;DATA=NULL;}

			~ClassMAPDATA()
			{
				for (int i=0;i<HEIGHT;i++) 
				{
					if(DATA[i])
					{
						delete [] DATA[i];
						DATA[i]=NULL;
					}
				}
				delete [] DATA;
				DATA=NULL;
			}

};

#endif